#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Generic DMAKE startup makefile definitions file. Assumes
#               that the SCITECH environment variable has been set to point
#               to where all our stuff is installed. You should not need
#               to change anything in this file.
#
#               Symantec C++ 6.x/7.x 32 bit version. Supports the DOSX
#               extender, FlashTek X32 and Phar Lap's TNT DOS Extender
#               and 32 bit Windows development.
#
# $Id: sc32.mk 1.4 1995/09/26 12:37:11 kjb release $
#
#############################################################################

# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT       := $(.SILENT)
.SILENT         := yes

# File suffix definitions
   L            := .lib   # Libraries
   E            := .exe   # Executables
   O            := .obj   # Objects
   A            := .asm   # Assembler sources
   P            := .cpp   # C++ sources
   D            := .dll   # Dynamic Link Library file
   R            := .res   # Compiled resource file

# Import enivornment variables that we use
TMPDIR := $(ROOTDIR)/tmp
.IMPORT .IGNORE : TMPDIR COMSPEC INCLUDE LIB SCITECH DBG OPT OPT_SIZE SHW BETA
.IMPORT .IGNORE : USE_TNT USE_X32 USE_X32VM FPU BUILD_DLL IMPORT_DLL USE_WIN32

# We use the MSDOS shell at all times
   SHELL        := $(COMSPEC)
   GROUPSHELL   := $(SHELL)
   SHELLFLAGS   := $(SWITCHAR)c
   GROUPFLAGS   := $(SHELLFLAGS)
   SHELLMETAS   := *"?<>
   GROUPSUFFIX  := .bat
   DIRSEPSTR    := \\
   DIVFILE       = $(TMPFILE:s,/,\)

# Default commands for compiling, assembling linking and archiving
   CC           := sc       # C-compiler and flags
   CFLAGS       := -Jm
   AS           := tasm     # Assembler and flags
.IF $(USE_WIN32)
   ASFLAGS      := /mx /m /D__FLAT__ /i$(SCITECH)\INCLUDE
.ELSE
   ASFLAGS      := /mx /m /DES_NOT_DS /D__COMM__ /i$(SCITECH)\INCLUDE
.ENDIF
   LD           := sc       # Loader and flags
   LD_FLAGS      =
   RC           := rcc      # WIndows resource compiler
   RCFLAGS      := -32      # Mark as Win32 compatible resources
   LIB          := lib      # Librarian
   LIBFLAGS     := /N /B
   ILIB         := implib   # Import librarian
   ILIBFLAGS    :=

# Optionally turn on debugging information
.IF $(DBG)
   CFLAGS       += -g       # Turn on debugging for C compiler (FlashView)
.IF $(USE_TNT)
   LDFLAGS      += -fullsym # Turn on debugging for TNT 386link linker
.END
.IF $(USE_X32) or $(USE_X32VM)
   LDFLAGS      += -L/map   # Turn on debugging for FlashView debugger
.END
.ELSE
   ASFLAGS      += /q       # Suppress object records not needed for linking
.END

# Optionally turn on optimisations
.IF $(OPT)
   CFLAGS       += -5 -o+all
.ELIF $(OPT_SIZE)
   CFLAGS       += -5 -o+space
.END

# Optionally turn on direct i387 FPU instructions

.IF $(FPU)
   CFLAGS       += -ff -DFPU387
   ASFLAGS      += -DFPU387 -DFPU_REG_RTN
.END

# Optionally compile a shareware version of a product
.IF $(SHW)
   LIB_DIR      := LIBSW
   CFLAGS       += -DSHAREWARE
.ELSE
   LIB_DIR      := LIB
.END

# Optionally compile a beta release version of a product
.IF $(BETA)
   CFLAGS       += -DBETA
   ASFLAGS      += -DBETA
.END

# User a larger stack if requested

.IF $(STKSIZE)
    LDFLAGS     += =$(STKSIZE)
.ENDIF

.IF $(USE_TNT)                  # Use Phar Lap's TNT DOS Extender
   CFLAGS       += -mp
   DX_CFLAGS    += -DTNT
   ASFLAGS      += /D__FLAT__
   DX_ASFLAGS   += -DTNT
   LD           := 386link
   LDFLAGS      += @sc32.dos -exe $@
   LIB_OS       = DOS32
.ELIF $(USE_X32VM)              # Use FlashTek X-32VM DOS extender
   CFLAGS       += -mx
   DX_CFLAGS    += -DX32VM
   ASFLAGS      += /D__X386__
   DX_ASFLAGS   += -DX32VM
   LD           := sc
   LDFLAGS      += $(CFLAGS) x32v.lib
   LIB_OS       = DOS32
.ELIF $(USE_X32)                # Use FlashTek X-32 DOS extender
   CFLAGS       += -mx
   DX_CFLAGS    += -DX32VM
   ASFLAGS      += /D__X386__
   DX_ASFLAGS   += -DX32VM
   LD           := sc
   LDFLAGS      += $(CFLAGS) x32.lib
   LIB_OS       = DOS32
.ELIF $(USE_WIN32)              # Build 32 bit Windows NT app
.IF $(BUILD_DLL)
   CFLAGS       += -WD -mn
   ASFLAGS      += -DBUILD_DLL
.ELSE
   CFLAGS       += -WA -mn
.ENDIF
   DX_ASFLAGS   += -D__WINDOWS32__
   LIB_OS       = WIN32
.ELSE                           # Use default Symantec DOSX extender
   USE_DOSX     := 1
   CFLAGS       += -mx
   DX_CFLAGS    += -DDOSX
   ASFLAGS      += /D__X386__
   DX_ASFLAGS   += -DDOSX
   LD           := sc
   LDFLAGS      += $(CFLAGS)
   LIB_OS       = DOS32
.END

# Place to look for PMODE library files

.IF $(MK_PMODE)
.ELIF $(USE_TNT)
PMLIB           := tnt\pmode.lib
.ELIF $(USE_X32)
PMLIB           := x32\pmode.lib
.ELSE
PMLIB           := dosx\pmode.lib
.END

# Define where to install library files
   LIB_BASE     := $(SCITECH)\$(LIB_DIR)\$(LIB_OS)\SC
   LIB_DEST     := $(LIB_BASE)

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Macro to install a library file
   INSTALL      := cp

# Implicit generation rules for making object files
   %$O: %.c ; +$(CC) $(CFLAGS) -c $<
   %$O: %$P ; +$(CC) $(CFLAGS) -c $<
   .SWAP %$O: %$A ; +$(AS) $(ASFLAGS) $(<:s,/,\)

# Implicit rule for building resource files
   %$R: %.rc ; +$(RC) $(RCFLAGS) -r $<

# Implicit rule for building a DLL using a response file
   %$D: ; +$(LD) $(LDFLAGS) @$(mktmp,$*.lnk $(&:s/\/\\) $(EXELIBS) gdi32.lib kernel32.lib winmm.lib)

# Implicit rule for building a library file using response file
.IF $(BUILD_DLL)
   %$L: ; $(ILIB) $(ILIBFLAGS) $@ $?
.ELIF $(IMPORT_DLL)
   %$L: ; $(ILIB) $(ILIBFLAGS) $@ $?
.ELSE
   %$L: ; +$(LIB) $(LIBFLAGS) $@ @$(mktmp -+$(?:t" &\n-+")\n)
.ENDIF

# Implicit rule for building an executable file using response file
.IF $(USE_TNT)
   %$E: ; +$(LD) $(LDFLAGS) @$(mktmp,$*.lnk $(&:s/\/\\) $(PMLIB) $(EXELIBS))
.ELIF $(USE_WIN32)
   %$E: ; +$(LD) $(LDFLAGS) @$(mktmp,$*.lnk $(&:s/\/\\) $(EXELIBS) gdi32.lib kernel32.lib winmm.lib)
.ELSE
   %$E: ; +$(LD) $(LDFLAGS) @$(mktmp,$*.lnk $(&:s/\/\\) $(PMLIB) $(EXELIBS))
.ENDIF

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) -f $<

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# We dont use TABS in our makefiles
.NOTABS         := yes

# Define where the local include files are kept for dependencies in
# makefiles after this file is included.

RCSINC :=  $(SCITECH)\INCLUDE

