#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Common makefile targets used by all SciTech Software
#               makefiles. This file includes targets for cleaning the
#               current directory, and maintaining the source files with
#               RCS.
#
# $Id: common.mk 1.4 1995/09/26 12:37:11 kjb release $
#
#############################################################################

# Define where to install all compiled DLL files

.IF $(SHW)
DLL_DEST    := $(SCITECH)\DLLSW
.ELSE
DLL_DEST    := $(SCITECH)\DLL
.ENDIF

# Target to build the library and DLL file if specified

.IF $(LIBFILE)

lib: $(LIBFILE)

.IF $(DLLFILE)

# Build and install a DLL file, or simply build import library and install

.IF $(BUILD_DLL)

$(DLLFILE): $(OBJECTS)
$(LIBFILE): $(DLLFILE)
install: $(LIBFILE) $(DLLFILE)
    $(INSTALL) $(LIBFILE) $(LIB_DEST)$(LIB_EXTENDER)
    $(INSTALL) $(DLLFILE) $(DLL_DEST)
.ELSE

$(LIBFILE): $(DLL_DEST)\$(DLLFILE)
install: $(LIBFILE)
    $(INSTALL) $(LIBFILE) $(LIB_DEST)$(LIB_EXTENDER)

.ENDIF
.ELSE

# Build and install a normal library file

$(LIBFILE): $(OBJECTS)

.IF $(STKCALL)
install: $(LIBFILE)
    $(INSTALL) s$(LIBFILE) $(LIB_DEST)$(LIB_EXTENDER)
.ELSE
install: $(LIBFILE)
    $(INSTALL) $(LIBFILE) $(LIB_DEST)$(LIB_EXTENDER)
.ENDIF
.ENDIF
.ENDIF

# Clean up directory removing all files not needed to make the library.
# There seems to be a bug in the version of RM that we are using, that
# causes it to not delete all the files if there are lots of them, hence
# we issue the rm command twice which should solve the problem (until we
# get a fixed version of RM).

clean:
    -rm -f *.obj *.o *.sym *.bak *.tdk *.swp *.map *.err *.csm
    -rm -f *.obj *.o *.sym *.bak *.tdk *.swp *.map *.err *.csm
    -rm -f *.~* *.tr? *.td? *.rws *.res *.exp *.ilk *.pdb *.pch
.IF $(LIBFILE)
    -rm -f $(LIBFILE) $(LIBCLEAN)
.END

cleanexe:   clean
.IF $(UNIX)
    -rm -f $(EXEFILES)
.ELSE
    -rm -f *$E *.drv
.ENDIF

realclean:  cleanexe
.IF $(LIBFILE)
    -rm -f $(LIB_DEST)\$(LIBFILE)
.END

.IF $(LOCALRCS) == $(NULL)

# RCS Maintenance routines. Assumes the existence of the RCSFILES list
# to determine the files to apply the RCS commands to, and that the
# foreach.exe program is available on the path. For all files in the
# RCSFILES_H list we either copy the files from the standard include
# directory in order to check them in, or copy the checked out files back
# into the standard include directory (the -cf and -ct options of foreach).

stamp:
    @foreach "rcs -N$(VERSION): -srelease" $(mktmp $(RCSFILES:t" \n")\n)
    @foreach "rcs -N$(VERSION): -srelease" $(mktmp $(RCSFILES_H:t" \n")\n)

rcsit:
    @foreach "rcs $(RCSOPT)" $(mktmp $(RCSFILES:t" \n")\n)
    @foreach "rcs $(RCSOPT)" $(mktmp $(RCSFILES_H:t" \n")\n)

# Remove unchanged source files (public header files are not removed)

rcsclean:
    @foreach rcsclean $(mktmp $(RCSFILES:t" \n")\n)
    @foreach -cl $(RCSINC) rcsclean $(mktmp $(RCSFILES_H:t" \n")\n)

# Check in the latest revisions of source files with RCS

ci:
    @foreach "ci -q -u -mnone $(RCSOPT)" $(mktmp $(RCSFILES:t" \n")\n)
    @foreach -cf $(RCSINC) "ci -q -u -mnone $(RCSOPT)" $(mktmp $(RCSFILES_H:t" \n")\n)

# Check out the latest revisions of source files from RCS

co:
    @foreach "co -q $(RCSOPT)" $(mktmp $(RCSFILES:t" \n")\n)
    @foreach -ct $(RCSINC) "co -q $(RCSOPT)" $(mktmp $(RCSFILES_H:t" \n")\n)

.ENDIF

# Create the include file dependencies using the MKUTIL makedep program if
# the list of dependent object files is defined

.IF $(DEPEND_OBJ)
depend:
    @rm -f makefile.dep
.IF $(DEPEND_SRC)
    @makedep -amakefile.dep -r -s -S$(DEPEND_SRC:s/\/\\) @$(mktmp $(DEPEND_OBJ:t"\n")\n)
.ELSE
    @makedep -amakefile.dep -r -s @$(mktmp $(DEPEND_OBJ:t"\n")\n)
.ENDIF
    +@echo Object file dependency information generated.
.ENDIF

# Include file dependencies

.INCLUDE .IGNORE: "makefile.dep"

