#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Generic DMAKE startup makefile definitions file. Assumes
#               that the SCITECH environment variable has been set to point
#               to where all our stuff is installed. You should not need
#               to change anything in this file.
#
#               Borland C++ 4.x 16 bit version. Supports 16 bit DOS,
#               DPMI16 DOS extender and 16 bit Windows development.
#
# $Id: bc16.mk 1.4 1995/09/26 12:37:11 kjb release $
#
#############################################################################

# Define where the local include files are kept for dependencies in
# makefiles after this file is included.

INC :=  $(SCITECH)\INCLUDE

# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT       := $(.SILENT)
.SILENT         := yes

# File suffix definitions
   L            := .lib   # Libraries
   E            := .exe   # Executables
   O            := .obj   # Objects
   A            := .asm   # Assembler sources
   P            := .cpp   # C++ sources
   D            := .dll   # Dynamic Link Library file
   R            := .res   # Compiled resource file

# Import enivornment variables that we use
TMPDIR := $(ROOTDIR)/tmp
.IMPORT .IGNORE : TMPDIR COMSPEC INCLUDE LIB SCITECH DBG OPT OPT_SIZE SHW BETA
.IMPORT .IGNORE : USE_DPMI16 USE_WIN16 FPU BUILD_DLL IMPORT_DLL USE_TASMX

# We use the MSDOS shell at all times
   SHELL        := $(COMSPEC)
   GROUPSHELL   := $(SHELL)
   SHELLFLAGS   := $(SWITCHAR)c
   GROUPFLAGS   := $(SHELLFLAGS)
   SHELLMETAS   := *"?<>
   GROUPSUFFIX  := .bat
   DIRSEPSTR    := \\
   DIVFILE       = $(TMPFILE:s,/,\)

# Default commands for compiling, assembling linking and archiving
   CC           := bcc      # C-compiler and flags
   CFLAGS       := -ml -H=bcc.sym
.IF $(USE_TASMX)
   AS           := tasmx    # Assembler and flags
.ELSE
   AS           := tasm     # Assembler and flags
.ENDIF
   ASFLAGS      := /mx /m /i$(SCITECH)\INCLUDE
   LD           := bcc      # Loader and flags
   LDFLAGS       = $(CFLAGS)
   RC           := brc      # WIndows resource compiler
   RCFLAGS      :=
   LIBR         := tlib     # Librarian
   LIBFLAGS     := /C
   ILIB         := implib   # Import librarian
   ILIBFLAGS    := -c

# Optionally turn on debugging information
.IF $(DBG)
   CFLAGS       += -v       # Turn on debugging for C compiler
   ASFLAGS      += /zi      # Turn on debugging for assembler
   LIBFLAGS     += /P128    # Larger page size for libraries with debug info!
.ELSE
   ASFLAGS      += /q       # Suppress object records not needed for linking
.END

# Optionally turn on optimisations
.IF $(OPT)
   CFLAGS       += -4 -O2
.ELIF $(OPT_SIZE)
   CFLAGS       += -4 -O1
.END

# Optionally turn on direct i387 FPU instructions

.IF $(FPU)
   CFLAGS       += -f287 -DFPU387
   ASFLAGS      += -DFPU387
.END

# Optionally compile a shareware version of a product
.IF $(SHW)
   LIB_DIR      := LIBSW
   CFLAGS       += -DSHAREWARE
.ELSE
   LIB_DIR      := LIB
.END

# Optionally compile a beta release version of a product
.IF $(BETA)
   CFLAGS       += -DBETA
   ASFLAGS      += -DBETA
.END

# Optionally use the DOS Power Pack DPMI16 extender for protected mode
.IF $(USE_DPMI16)
   DX_CFLAGS    += -WX -DDPMI16
   DX_ASFLAGS   += -DDPMI16 -D__PM286__
   LIB_OS       = DOS16
.ELIF $(USE_WIN16)
.IF $(BUILD_DLL)
   CFLAGS       += -WD -DBUILD_DLL
   ASFLAGS      += -DBUILD_DLL
.ELSE
   CFLAGS       += -WS
.ENDIF
   DX_ASFLAGS   += -D__WINDOWS16__
   LIB_OS       = WIN16
.ELSE
   LIB_OS       = DOS16
.END

# Place to look for PMODE library files

.IF $(MK_PMODE)
.ELIF $(USE_DPMI16)
PMLIB           := dpmi16\pmode.lib
.ELSE
PMLIB           := pmode.lib
.END

# Define where to install library files
   LIB_BASE     := $(SCITECH)\$(LIB_DIR)\$(LIB_OS)\BC
   LIB_DEST     := $(LIB_BASE)

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Macro to install a library file
   INSTALL      := cp

# Implicit generation rules for making object files
   %$O: %.c ; +$(CC) @$(mktmp $(CFLAGS)) -c $<
   %$O: %$P ; +$(CC) @$(mktmp $(CFLAGS)) -c $<
   .SWAP %$O: %$A ; +$(AS) $(ASFLAGS) $(<:s,/,\)

# Implicit rule for building resource files
   %$R: %.rc ; +$(RC) $(RCFLAGS) -r $<

# Implicit rule for building a DLL using a response file
   %$D:      ; +rclink $(LD) $(RC) $@ $(mktmp $(LDFLAGS) -e$@\n$(&:t"\n":s/\/\\)\n$(EXELIBS))

# Implicit rule for building a library file using response file
.IF $(BUILD_DLL)
   %$L:      ; $(ILIB) $(ILIBFLAGS) $@ $?
.ELIF $(IMPORT_DLL)
   %$L:      ; $(ILIB) $(ILIBFLAGS) $@ $?
.ELSE
   %$L:      ; $(LIBR) $(LIBFLAGS) $@ @$(mktmp -+$(?:t" &\n-+")\n)
.ENDIF

# Implicit rule for building an executable file using response file
.IF $(USE_WIN16)
   %$E:      ; +rclink $(LD) $(RC) $@ $(mktmp $(LDFLAGS) -lC -e$@ $(&:s/\/\\) $(EXELIBS))
.ELSE
   %$E:      ; $(LD) @$(mktmp $(LDFLAGS) -e$@ $(&:s/\/\\) $(PMLIB) $(EXELIBS))
.ENDIF

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) -f $<

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# We dont use TABS in our makefiles
.NOTABS         := yes

# Define where the local include files are kept for dependencies in
# makefiles after this file is included.

RCSINC :=  $(SCITECH)\INCLUDE

