*** ../texinfo-3.6/makeinfo/makeinfo.c	Wed Jun 21 18:00:55 1995
--- makertf.c	Sun Oct  8 19:59:35 1995
***************
*** 30,33 ****
--- 30,41 ----
     Makeinfo is authored by Brian Fox (bfox@ai.mit.edu). */
  
+ /* Define RTF_OUTPUT, if you want to create RTF files. */
+ #define RTF_OUTPUT
+ 
+ #ifdef RTF_OUTPUT
+ /* Code in `RTF_OUTPUT' sections:
+    Copyright (C) 1994, 1995 Christian Schenk (cschenk@gs.detewe.de). */
+ #endif
+ 
  /* You can change some of the behaviour of Makeinfo by changing the
     following defines: */
***************
*** 61,64 ****
--- 69,87 ----
  #define HAVE_MACROS
  
+ #ifdef RTF_OUTPUT
+ #define _quarter_inch   (_1_inch/4)
+ #define _half_inch      (_1_inch/2)
+ #define _1_inch         1440
+ #define _2_inch         (2 * _1_inch)
+ 
+ #define RTF_FONT_NORMAL         0
+ #define RTF_FONT_FIXED_WIDTH    1
+ 
+ #define RTF_MENU_INDENTATION                    _2_inch
+ #define RTF_TABLE_INDENTATION_INCREMENT         _half_inch
+ #define RTF_ITEMIZE_INDENTATION_INCREMENT       _half_inch
+ #define RTF_ENUMERATE_INDENTATION_INCREMENT     _half_inch
+ #endif
+ 
  /* **************************************************************** */
  /*								    */
***************
*** 76,80 ****
--- 99,105 ----
  #include <ctype.h>
  #include <sys/stat.h>
+ #if ! defined (_WIN32)
  #include <pwd.h>
+ #endif
  #include <errno.h>
  
***************
*** 120,126 ****
--- 145,155 ----
  #include <alloca.h>
  #else /* !HAVE_ALLOCA_H */
+ #if defined (_WIN32)
+ #define alloca _alloca
+ #else
  #if !defined (_AIX)
  extern char *alloca ();
  #endif /* !_AIX */
+ #endif
  #endif /* !HAVE_ALLOCA_H */
  #endif /* !__GNUC__ */
***************
*** 236,240 ****
--- 265,273 ----
  #define SPLIT_SIZE_THRESHOLD 70000  /* What's good enough for Stallman... */
  #define DEFAULT_SPLIT_SIZE 50000    /* Is probably good enough for me. */
+ #ifdef RTF_OUTPUT
+ int splitting = 0;		    /* We want a single RTF file. */
+ #else
  int splitting = 1;		    /* Always true for now. */
+ #endif
  
  typedef void COMMAND_FUNCTION (); /* So I can say COMMAND_FUNCTION *foo; */
***************
*** 296,299 ****
--- 329,338 ----
  char *command_output_filename = (char *)NULL;
  
+ #ifdef RTF_OUTPUT
+ /* Name of the help project file that the user elected to pass on the
+    command line. */
+ char *command_hpj_filename = (char *)NULL;
+ #endif
+ 
  /* A colon separated list of directories to search for files included
     with @include.  This can be controlled with the `-I' option to makeinfo. */
***************
*** 333,341 ****
--- 372,396 ----
  
  /* The column at which long lines are broken. */
+ #ifdef RTF_OUTPUT
+ int fill_column = 30000;	/* Do not break lines. */
+ #else
  int fill_column = 72;
+ #endif
  
  /* The amount of indentation to apply at the start of each line. */
  int current_indent = 0;
  
+ #ifdef RTF_OUTPUT
+ int rtf_font = 0;               /* The font for the current paragraph. */
+ int rtf_current_font = 0;       /* The font we are using right now.  */
+ int rtf_li = 0;                 /* Current paragraph indentation. */
+ int rtf_fi = 0;                 /* Indentation of first line in paragraph. */
+ int rtf_fs = 20;                /* Font size. */
+ int rtf_tab_stops[10];          /* Tab stop positions. */
+ int rtf_n_tab_stops = 0;        /* Number of tab stop positions. */
+ int in_non_scrolling_region = 0; /* >0 means we are assembling the node line. */
+ int in_index_entry = 0; /* >0 means we are making an index entry. */
+ #endif
+ 
  /* The amount of indentation to add at the starts of paragraphs.
     0 means don't change existing indentation at paragraph starts.
***************
*** 615,618 ****
--- 670,677 ----
    cm_cartouche (), cm_ignore_sentence_ender ();
  
+ #ifdef RTF_OUTPUT
+ void cm_settitle (), cm_t ();
+ #endif
+ 
  /* Conditionals. */
  void cm_set (), cm_clear (), cm_ifset (), cm_ifclear ();
***************
*** 807,811 ****
--- 866,874 ----
    { "setchapterstyle", cm_ignore_line, NO_BRACE_ARGS },
    { "setfilename", cm_setfilename, NO_BRACE_ARGS },
+ #ifdef RTF_OUTPUT
+   { "settitle", cm_settitle, NO_BRACE_ARGS },
+ #else
    { "settitle", cm_ignore_line, NO_BRACE_ARGS },
+ #endif
    { "shortcontents", do_nothing, NO_BRACE_ARGS },
    { "shorttitlepage", cm_ignore_line, NO_BRACE_ARGS },
***************
*** 823,827 ****
--- 886,894 ----
    { "syncodeindex", cm_synindex, NO_BRACE_ARGS },
    { "synindex", cm_synindex, NO_BRACE_ARGS },
+ #ifdef RTF_OUTPUT
+   { "t", cm_t, BRACE_ARGS },
+ #else
    { "t", cm_title, BRACE_ARGS },
+ #endif
    { "table", cm_table, NO_BRACE_ARGS },
    { "tex", command_name_condition, NO_BRACE_ARGS },
***************
*** 874,877 ****
--- 941,949 ----
  int minor_version = 63;
  
+ #if defined (RTF_OUTPUT)
+ int rtf_major_version = 1;
+ int rtf_minor_version = 3;
+ #endif
+ 
  struct option long_options[] =
  {
***************
*** 879,883 ****
--- 951,957 ----
    { "fill-column", 1, 0, 'f' },			/* formerly -fc */
    { "footnote-style", 1, 0, 's' },		/* formerly -ft */
+ #ifndef RTF_OUTPUT
    { "no-headers", 0, &no_headers, 1 },		/* Do not output Node: foo */
+ #endif
    { "no-pointer-validate", 0, &validating, 0 }, /* formerly -nv */
    { "no-validate", 0, &validating, 0 },		/* formerly -nv */
***************
*** 893,896 ****
--- 967,973 ----
    { "reference-limit", 1, 0, 'r' },		/* formerly -rl */
    { "verbose", 0, &verbose_mode, 1 },		/* formerly -verbose */
+ #ifdef RTF_OUTPUT
+   { "hpj", 1, 0, 'J' },
+ #endif
    { "help", 0, 0, 'h' },
    { "version", 0, 0, 'V' },
***************
*** 929,935 ****
--- 1006,1020 ----
  	  (argc, argv,
  #if defined (HAVE_MACROS)
+ #if defined (RTF_OUTPUT)
+ 	   "D:E:U:I:J:f:o:p:e:r:s:V",
+ #else
  	   "D:E:U:I:f:o:p:e:r:s:V",
+ #endif
+ #else
+ #if defined (RTF_OUTPUT)
+ 	   "D:U:I:J:f:o:p:e:r:s:V",
  #else
  	   "D:U:I:f:o:p:e:r:s:V",
+ #endif
  #endif /* !HAVE_MACROS */
  	   long_options, &ind))
***************
*** 1009,1012 ****
--- 1094,1104 ----
  	  break;
  
+ #ifdef RTF_OUTPUT
+ 	  /* User specified help project file? */
+ 	case 'J':
+ 	  command_hpj_filename = strdup (optarg);
+ 	  break;
+ #endif
+ 
  	case 'h':
  	  usage (stdout, NO_ERROR);
***************
*** 1071,1076 ****
--- 1163,1174 ----
  print_version_info ()
  {
+ #ifdef RTF_OUTPUT
+   printf ("This is Makertf version %d.%d (GNU Makeinfo version %d.%d).\n",
+ 	  rtf_major_version, rtf_minor_version,
+ 	  major_version, minor_version);
+ #else
    printf ("This is GNU Makeinfo version %d.%d.\n",
  	  major_version, minor_version);
+ #endif
  }
  
***************
*** 1149,1152 ****
--- 1247,1286 ----
       int exit_value;
  {
+ #ifdef RTF_OUTPUT
+   fprintf (stream, "Usage: %s [options] texinfo-file...\n\
+ \n\
+ This program accepts as input files of texinfo commands and text\n\
+ and outputs a file in rich-text format (RTF).\n\
+ \n\
+ Options:\n\
+ `-I DIR'              add DIR to the directory search list for including\n\
+                       files with the `@include' command.\n\
+ -D VAR                define a variable, as with `@set'.\n\
+ -U VAR                undefine a variable, as with `@clear'.\n\
+ --no-validate         suppress node cross reference validation.\n\
+ --no-warn             suppress warning messages (errors are still output).\n\
+ --verbose             print information about what is being done.\n\
+ --version             print the version number of Makertf.\n\
+ --output FILE or -o FILE\n\
+                       specify the output file.  When you specify the\n\
+                       output file in this way, any `@setfilename' in the\n\
+                       input file is ignored.\n\
+ --paragraph-indent NUM\n\
+                       set the paragraph indent to NUM (default %d).\n\
+ --fill-column NUM     set the filling column to NUM (default %d).\n\
+ --error-limit NUM     set the error limit to NUM (default %d).\n\
+ --reference-limit NUM\n\
+                       set the reference warning limit to NUM (default %d).\n\
+ --footnote-style STYLE\n\
+                       set the footnote style to STYLE.  STYLE should\n\
+                       either be `separate' to place footnotes in their own\n\
+                       node (the default), or `end', to place the footnotes\n\
+                       at the end of the node in which they are defined.\n\
+ --hpj FILE or -J FILE\n\
+                       specify the help project file.\n\
+ --help                print this message and exit.\n\n",
+ 	   progname, paragraph_start_indent,
+ 	   fill_column, max_error_level, reference_warning_limit);
+ #else
    fprintf (stream, "Usage: %s [options] texinfo-file...\n\
  \n\
***************
*** 1184,1187 ****
--- 1318,1322 ----
  	   progname, paragraph_start_indent,
  	   fill_column, max_error_level, reference_warning_limit);
+ #endif
    exit (exit_value);
  }
***************
*** 1245,1249 ****
--- 1380,1388 ----
    file_size = (long) fileinfo.st_size;
  
+ #if defined (MSDOS) || defined (_WIN32)
+   file = open (filename, O_RDONLY | O_TEXT);
+ #else /* !MSDOS */
    file = open (filename, O_RDONLY);
+ #endif /* !MSDOS */
    if (file < 0)
      goto error_exit;
***************
*** 1256,1267 ****
       mysteries of VMS/RMS are too much to probe, so this hack
      suffices to make things work. */
! #if defined (VMS)
    while ((n = read (file, result + count, file_size)) > 0)
      count += n;
    if (n == -1)
! #else /* !VMS */
      count = file_size;
      if (read (file, result, file_size) != file_size)
! #endif /* !VMS */
    error_exit:
      {
--- 1395,1411 ----
       mysteries of VMS/RMS are too much to probe, so this hack
      suffices to make things work. */
! #if defined (VMS) || defined (MSDOS)
    while ((n = read (file, result + count, file_size)) > 0)
      count += n;
    if (n == -1)
! #else /* !VMS && !MSDOS */
! #if defined (_WIN32)
!   count = read (file, result + count, file_size);
!   if (count == -1)
! #else /* !_WIN32 */
      count = file_size;
      if (read (file, result, file_size) != file_size)
! #endif /* !_WIN32 */
! #endif /* !VMS && !MSDOS */
    error_exit:
      {
***************
*** 1487,1494 ****
--- 1631,1645 ----
  	i = strlen (filename);
  
+ #ifdef RTF_OUTPUT
+       if (i + 5 > (strlen (filename)))
+ 	filename = (char *)xrealloc (filename, i + 5);
+       strcpy (filename + i, ".rtf");
+       return (filename);
+ #else
        if (i + 6 > (strlen (filename)))
  	filename = (char *)xrealloc (filename, i + 6);
        strcpy (filename + i, ".info");
        return (filename);
+ #endif
      }
  	
***************
*** 1580,1583 ****
--- 1731,1735 ----
        else
  	{
+ #if ! defined (_WIN32)
  	  struct passwd *user_entry;
  	  int i, c;
***************
*** 1603,1606 ****
--- 1755,1759 ----
  	  strcpy (result, user_entry->pw_dir);
  	  strcat (result, &filename[i]);
+ #endif
  	}
      }
***************
*** 2207,2211 ****
--- 2360,2368 ----
  
    if (output_stream != stdout)
+ #ifdef RTF_OUTPUT
+     printf ("Making RTF file `%s' from `%s'.\n", output_filename, name);
+ #else
      printf ("Making info file `%s' from `%s'.\n", output_filename, name);
+ #endif
  
    if (output_stream == NULL)
***************
*** 2234,2237 ****
--- 2391,2397 ----
    }
  
+ #ifdef RTF_OUTPUT
+   start_rtf_file ();
+ #else
    if (!no_headers)
      {
***************
*** 2240,2243 ****
--- 2400,2404 ----
        add_word_args ("the input file %s.\n", input_filename);
      }
+ #endif
  
    close_paragraph ();
***************
*** 2260,2267 ****
--- 2421,2438 ----
  	{
  	  tag_table = (TAG_ENTRY *) reverse_list (tag_table);
+ #ifdef RTF_OUTPUT
+ 	  /* We do not need a tag table. */
+ #else
  	  if (!no_headers)
  	    write_tag_table ();
+ #endif
  	}
  
+ #ifdef RTF_OUTPUT
+       end_rtf_file ();
+       if (command_hpj_filename)
+ 	write_help_project_file (command_hpj_filename, real_output_filename);
+ #endif
+ 
        if (output_stream != stdout)
  	fclose (output_stream);
***************
*** 2394,2397 ****
--- 2565,2577 ----
  		 called with a non-zero argument. */
  	      tem = glean_node_from_menu (1);
+ #ifdef RTF_OUTPUT
+ 	      /* Process this menu entry... */
+ 	      /* add_char ('\n'); */
+ 	      input_text_offset++;
+ 	      process_menu_line ();
+ 
+ 	      /* ...then continue the reader loop. */
+ 	      continue;
+ #endif
  	    }
  	}
***************
*** 2746,2750 ****
--- 2926,2938 ----
        if (!filling_enabled)
  	{
+ #ifdef RTF_OUTPUT
+ 	  extern int printing_index;
+ 	  if (in_menu || in_non_scrolling_region || printing_index)
+ 	    inserts ("\\par\n");
+ 	  else
+ 	    inserts ("\\line\n");
+ #else
  	  insert ('\n');
+ #endif
  
  	  if (force_flush_right)
***************
*** 2856,2859 ****
--- 3044,3050 ----
  			}
  
+ #ifdef RTF_OUTPUT
+ 			/* We do not break lines. WinHelp does it. */
+ #else
  			/* Filled, but now indent if that is right. */
  			if (indented_fill && current_indent)
***************
*** 2889,2892 ****
--- 3080,3084 ----
  			    free (temp_buffer);
  			  }
+ #endif
  			output_column = 0;
  			while (temp < output_paragraph_offset)
***************
*** 2902,2906 ****
--- 3094,3114 ----
  	if (!suppress_insert)
  	  {
+ #ifdef RTF_OUTPUT
+ 	    /* Some characters have to be written as escape sequences since
+ 	       they have special meaning in RTF. */
+ 	    if (character == '{' || character == '}' || character == '\\'
+ 		|| (! isascii (character)
+ 		    && character != (unsigned char)(' ' | 0x80)
+ 		    && character != (unsigned char)('\t' | 0x80)
+ 		    && character != (unsigned char)('\n' | 0x80)
+ 		    && ! sentence_ender (UNMETA (character))))
+ 	      vinserts ("\\'%02X", (int) (character & 0xff));
+ 	    else if (character == '\f')	/* This can happen! */
+ 	      inserts ("^L");
+ 	    else
+ 	      insert (character);
+ #else
  	    insert (character);
+ #endif
  	    last_inserted_character = character;
  	  }
***************
*** 3089,3100 ****
--- 3297,3332 ----
  
        /* Break the line if that is appropriate. */
+ #ifdef RTF_OUTPUT      
+       if (paragraph_spacing >= 0) 
+ 	{
+ 	  if (output_paragraph_offset >= 5
+ 	      && strncmp (&output_paragraph[output_paragraph_offset-5],
+ 			  "\\line", 5) == 0)
+ 	    {
+ 	      output_paragraph_offset -= 5;
+ 	    }
+ 
+ 	  if (! in_non_scrolling_region)
+ 	    inserts ("\\par");
+ 	  insert ('\n');
+ 	}
+ #else
        if (paragraph_spacing >= 0)
  	insert ('\n');
+ #endif
  
        /* Add as many blank lines as is specified in PARAGRAPH_SPACING. */
        if (!force_flush_right)
  	{
+ #ifdef RTF_OUTPUT
+ 	  if (! in_non_scrolling_region)
+ 	    {
+ 	      for (i = 0; i < (paragraph_spacing - line_already_broken); i++)
+ 		inserts ("\\par\n");
+ 	    }
+ #else
  	  for (i = 0; i < (paragraph_spacing - line_already_broken); i++)
  	    insert ('\n');
+ #endif
  	}
  
***************
*** 3197,3200 ****
--- 3429,3466 ----
  	      output_column += amount_to_indent;
  	    }
+ 
+ #ifdef RTF_OUTPUT
+ 	  if (in_non_scrolling_region)
+ 	    {
+ 	      warning ("%cnode should be followed by a sectioning command",
+ 		       COMMAND_PREFIX);
+ 	      inserts ("\\par\n");
+ 	      in_non_scrolling_region = 0;
+ 	    }
+ 
+ 	  /* Set paragraph properties. */
+ 	  vinserts ("\\pard");
+ 	  if (! filling_enabled && in_fixed_width_font)
+ 	    inserts ("\\keep");
+ 	  if (rtf_fi != 0)
+ 	    vinserts ("\\fi%d", rtf_fi);
+ 	  if (rtf_li != 0)
+ 	    vinserts ("\\li%d", rtf_li);
+ 
+ 	  /* Set tab stops. */
+ 	  {
+ 	    int i;
+ 	    for (i=0; i<rtf_n_tab_stops; i++)
+ 	      vinserts ("\\tx%d", rtf_tab_stops[i]);
+ 	  }
+ 
+ 	  /* Set the current font. */
+ 	  if (rtf_current_font != rtf_font)
+ 	    {
+ 	      rtf_current_font = rtf_font;
+ 	      vinserts ("\\f%d", rtf_font);
+ 	    }
+ 	  inserts ("{}");
+ #endif
  	}
      }
***************
*** 3219,3224 ****
--- 3485,3494 ----
      }
  
+ #ifdef RTF_OUTPUT
+   /* We use tab stops. */
+ #else
    while (--amount >= 0)
      insert (' ');
+ #endif
  }
  
***************
*** 3244,3251 ****
--- 3514,3529 ----
  
  /* Case independent string compare. */
+ #if defined (_WIN32)
+ #define strcasecmp strcmpi
+ #define HAVE_STRCASECMP
+ #endif
  #if !defined (HAVE_STRCASECMP)
  int
  strcasecmp (string1, string2)
+ #ifdef RTF_OUTPUT
+      const char *string1, *string2;
+ #else
       char *string1, *string2;
+ #endif
  {
    char ch1, ch2;
***************
*** 3295,3298 ****
--- 3573,3584 ----
    enum insertion_type insertion;
    int inhibited;
+ #ifdef RTF_OUTPUT
+   int rtf_li;			/* Left indent */
+   int rtf_fi;			/* First indent */
+   int rtf_tab_stops[10];	/* Tab stops */
+   int rtf_n_tab_stops;		/* Number of tab stops */
+   int rtf_font;			/* Font */
+   int rtf_fs;			/* Font size */
+ #endif
  } INSERTION_ELT;
  
***************
*** 3376,3379 ****
--- 3662,3673 ----
    new->filename = strdup (input_filename);
    new->inhibited = inhibit_paragraph_indentation;
+ #ifdef RTF_OUTPUT
+   new->rtf_li = rtf_li;
+   new->rtf_fi = rtf_fi;
+   memcpy (new->rtf_tab_stops, rtf_tab_stops, sizeof (new->rtf_tab_stops));
+   new->rtf_n_tab_stops = rtf_n_tab_stops;
+   new->rtf_font = rtf_font;
+   new->rtf_fs = rtf_fs;
+ #endif
    new->next = insertion_stack;
    insertion_stack = new;
***************
*** 3394,3397 ****
--- 3688,3699 ----
    filling_enabled = temp->filling_enabled;
    indented_fill = temp->indented_fill;
+ #ifdef RTF_OUTPUT
+   rtf_li = temp->rtf_li;
+   rtf_fi = temp->rtf_fi;
+   memcpy (rtf_tab_stops, temp->rtf_tab_stops, sizeof (rtf_tab_stops));
+   rtf_n_tab_stops = temp->rtf_n_tab_stops;
+   rtf_font = temp->rtf_font;
+   rtf_fs = temp->rtf_fs;
+ #endif
    free_and_clear (&(temp->item_function));
    free_and_clear (&(temp->filename));
***************
*** 3515,3525 ****
--- 3817,3838 ----
  	  warning ("Lettering overflow, restarting at %c", current_enumval);
  	}
+ #ifdef RTF_OUTPUT
+       sprintf (temp, "%c.", current_enumval);
+ #else
        sprintf (temp, "%c. ", current_enumval);
+ #endif
      }
    else
+ #ifdef RTF_OUTPUT
+     sprintf (temp, "%d. ", current_enumval);
+ #else
      sprintf (temp, "%d. ", current_enumval);
+ #endif
  
    indent (output_column += (current_indent - strlen (temp)));
    add_word (temp);
+ #ifdef RTF_OUTPUT
+   inserts ("\\tab ");
+ #endif
    current_enumval++;
  }
***************
*** 3542,3545 ****
--- 3855,3862 ----
      push_insertion (type, get_item_function ());
  
+ #ifdef RTF_OUTPUT
+   inserts ("{");
+ #endif
+ 
    switch (type)
      {
***************
*** 3551,3556 ****
--- 3868,3881 ----
        inhibit_paragraph_indentation = 1;
  
+ #ifdef RTF_OUTPUT
+       rtf_li = RTF_MENU_INDENTATION;
+       rtf_fi = -RTF_MENU_INDENTATION;
+       rtf_n_tab_stops = 1;
+       rtf_tab_stops[0] = rtf_li;
+       add_word ("* Menu:\n");
+ #else
        if (!no_headers)
  	add_word ("* Menu:\n");
+ #endif
  
        in_menu++;
***************
*** 3585,3588 ****
--- 3910,3917 ----
  	current_indent += default_indentation_increment;
  
+ #ifdef RTF_OUTPUT
+       rtf_font = RTF_FONT_FIXED_WIDTH;
+ #endif
+ 
        break;
  
***************
*** 3616,3619 ****
--- 3945,3963 ----
  		      insertion_type_pname (type), COMMAND_PREFIX);
  	}
+ 
+ #ifdef RTF_OUTPUT
+       if (type == itemize)
+ 	{
+ 	  rtf_li += RTF_ITEMIZE_INDENTATION_INCREMENT;
+ 	  rtf_fi = -RTF_ITEMIZE_INDENTATION_INCREMENT;
+ 	  rtf_n_tab_stops = 1;
+ 	  rtf_tab_stops[0] = rtf_li;
+ 	}
+       else
+ 	{
+ 	  rtf_li += RTF_TABLE_INDENTATION_INCREMENT;
+ 	  rtf_fi = 0;
+ 	}
+ #endif
        break;
  
***************
*** 3634,3637 ****
--- 3978,3988 ----
        else
  	start_enumerating (*enumeration_arg, ENUM_ALPHA);
+ 
+ #ifdef RTF_OUTPUT
+       rtf_li += RTF_ENUMERATE_INDENTATION_INCREMENT;
+       rtf_fi = -RTF_ENUMERATE_INDENTATION_INCREMENT;
+       rtf_n_tab_stops = 1;
+       rtf_tab_stops[0] = rtf_li;
+ #endif
        break;
  
***************
*** 3790,3793 ****
--- 4141,4148 ----
        break;
      }
+ 
+ #ifdef RTF_OUTPUT
+   inserts ("}");
+ #endif
  }
  
***************
*** 3820,3823 ****
--- 4175,4181 ----
  	  input_filename = current_filename;
  	  pop_insertion ();
+ #ifdef RTF_OUTPUT
+ 	  inserts ("}");
+ #endif
  	}
      }
***************
*** 3857,3862 ****
--- 4215,4229 ----
       int arg;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     {
+       add_char ('*');
+       output_paragraph_offset--;
+       inserts ("{\\f2\\'B7}");
+     }
+ #else
    if (arg == START)
      add_char ('*');
+ #endif
  }
  
***************
*** 3923,3931 ****
--- 4290,4306 ----
      {
        in_fixed_width_font++;
+ #ifdef RTF_OUTPUT
+       vinserts ("{\\f%d{}", RTF_FONT_FIXED_WIDTH);
+ #else
        add_char ('`');
+ #endif
      }
    else
      {
+ #ifdef RTF_OUTPUT
+       inserts ("}");
+ #else
        add_word ("'");
+ #endif
        in_fixed_width_font--;
      }
***************
*** 3936,3940 ****
--- 4311,4337 ----
       int arg;
  {
+ #ifdef RTF_OUTPUT
+   extern int printing_index;
+ 
+   if (printing_index)
+     return;
+ 
+   if (arg == START)
+     {
+       if (! in_index_entry)
+ 	inserts ("'");
+       in_fixed_width_font++;
+       vinserts ("{\\f%d{}", RTF_FONT_FIXED_WIDTH);
+     }
+   else
+     {
+       inserts ("}");
+       in_fixed_width_font--;
+       if (! in_index_entry)
+ 	inserts ("'");
+     }
+ #else
    cm_code (arg);
+ #endif
  }
  
***************
*** 3943,3947 ****
--- 4340,4348 ----
       int arg;
  {
+ #ifdef RTF_OUTPUT
+   cm_samp (arg);
+ #else
    cm_code (arg);
+ #endif
  }
  
***************
*** 3950,3954 ****
--- 4351,4362 ----
       int arg;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     inserts ("{^");
+   else
+     inserts ("}");
+ #else
    cm_code (arg);
+ #endif
  }
  
***************
*** 3964,3967 ****
--- 4372,4379 ----
       int arg, start, end;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     inserts ("{^");
+ #endif
    /* Should we allow multiple character arguments?  I think yes. */
    if (arg == END)
***************
*** 3978,3984 ****
--- 4390,4404 ----
  	    character = output_paragraph[i];
  
+ #ifdef RTF_OUTPUT
+ 	    if (isletter (character))
+ 	      output_paragraph[i] = coerce_to_upper (character);
+ #else
  	    if (isletter (character))
  	      output_paragraph[i] = CTL (coerce_to_upper (character));
+ #endif
  	  }
+ #ifdef RTF_OUTPUT
+       inserts ("}");
+ #endif
      }
  }
***************
*** 3989,3992 ****
--- 4409,4423 ----
       int arg, start_pos, end_pos;
  {
+ #ifdef RTF_OUTPUT
+   extern int printing_index;
+ 
+   if (printing_index)
+     return;
+ 
+   if (arg == START)
+     vinserts ("{\\scaps\\fs16{}"); /* FIXME */
+   else
+     inserts ("}");
+ #else
    if (arg == END)
      {
***************
*** 3998,4001 ****
--- 4429,4433 ----
  	}
      }
+ #endif
  }
  
***************
*** 4005,4008 ****
--- 4437,4446 ----
       int arg, start_pos, end_pos;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     inserts ("{\\i ");
+   else
+     inserts ("}");
+ #else
    if (arg == END)
      {
***************
*** 4014,4017 ****
--- 4452,4456 ----
  	}
      }
+ #endif
  }
  
***************
*** 4027,4031 ****
--- 4466,4474 ----
       int arg;
  {
+ #ifdef RTF_OUTPUT
+   cm_var (arg);
+ #else
    add_char ('*');
+ #endif
  }
  
***************
*** 4052,4055 ****
--- 4495,4501 ----
       int arg, start, end;
  {
+ #ifdef RTF_OUTPUT
+   cm_emph (arg, start, end);
+ #endif
  }
  
***************
*** 4067,4072 ****
--- 4513,4537 ----
       int arg, start, end;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     vinserts ("{\\f%d{}", RTF_FONT_NORMAL);
+   else
+     inserts ("}");
+ #endif
  }
  
+ #ifdef RTF_OUTPUT
+ /* Current text is in fixed-width font. */
+ void
+ cm_t (arg, start, end)
+      int arg, start, end;
+ {
+   if (arg == START)
+     vinserts ("{\\f%d{}", RTF_FONT_FIXED_WIDTH);
+   else
+     inserts ("}");
+ }
+ #endif
+ 
  /* Current text is in roman font. */
  void
***************
*** 4074,4077 ****
--- 4539,4545 ----
       int arg, start, end;
  {
+ #ifdef RTF_OUTPUT
+   cm_roman (arg, start, end);
+ #endif
  }
  
***************
*** 4123,4127 ****
--- 4591,4613 ----
    char *temp;
  
+ #ifdef RTF_OUTPUT
+   int big_heading = in_non_scrolling_region;
+ 
+   /* Get the topic title. */
+   get_rest_of_line (&temp);
+   if (in_non_scrolling_region)
+     {
+       /* Now that we have the topic title, we can create an index entry for it. */
+       in_non_scrolling_region = 0;
+       inserts ("${\\footnote ");
+       execute_string ("%s", temp);
+       inserts ("}\n");
+       close_paragraph_with_lines (0);
+     }
+   else
+     close_paragraph ();
+ #else
    close_paragraph ();
+ #endif
    filling_enabled =  indented_fill = 0;
    old_no_indent = no_indent;
***************
*** 4133,4137 ****
--- 4619,4634 ----
  #endif /* HAVE_MACROS */
  
+ #ifdef RTF_OUTPUT
+   /* We already have the rest of the line. */
+ #else
    get_rest_of_line (&temp);
+ #endif
+ 
+ #ifdef RTF_OUTPUT
+   if (big_heading)
+     inserts ("\\pard{\\fs24\\b "); /* choose big bold font for topic title */
+   else
+     inserts ("\\pard{\\b ");	/* bold font for subtopic title */
+ #endif
  
    starting_pos = output_position + output_paragraph_offset;
***************
*** 4149,4153 ****
--- 4646,4654 ----
    else
  #endif /* HAVE_MACROS */
+ #ifdef RTF_OUTPUT
+   execute_string ("%s", temp);
+ #else
    execute_string ("%s\n", temp);
+ #endif
  
    ending_pos = output_position + output_paragraph_offset;
***************
*** 4155,4161 ****
--- 4656,4666 ----
  
    len = (ending_pos - starting_pos) - 1;
+ #ifdef RTF_OUTPUT
+   inserts ("}");
+ #else
    for (i = 0; i < len; i++)
      add_char (with_char);
    insert ('\n');
+ #endif
    close_paragraph ();
    filling_enabled = 1;
***************
*** 4705,4708 ****
--- 5210,5215 ----
  
    no_indent = 1;
+ #ifdef RTF_OUTPUT
+ #else
    if (!no_headers)
      {
***************
*** 4717,4720 ****
--- 5224,5228 ----
        filling_enabled = indented_fill = 0;
      }
+ #endif
  
    /* Check for defaulting of this node's next, prev, and up fields. */
***************
*** 4917,4920 ****
--- 5425,5431 ----
  #endif /* HAVE_MACROS */
  
+ #ifdef RTF_OUTPUT
+   start_topic (node, next, prev, up);
+ #else
    if (!no_headers)
      {
***************
*** 4946,4949 ****
--- 5457,5461 ----
  #endif /* HAVE_MACROS */
      }
+ #endif
  
    close_paragraph ();
***************
*** 5556,5559 ****
--- 6068,6170 ----
  }
  
+ #ifdef RTF_OUTPUT
+ process_menu_line ()
+ {
+   int i, j;
+   char *nodename;
+ 
+   if (strncmp (&input_text[input_text_offset],
+ 	       menu_starter,
+ 	       strlen (menu_starter)) != 0)
+     {
+       /* This line only contains descriptive text. */
+       skip_whitespace ();
+      
+       if (curchar() == '\n')
+ 	{
+ 	  /* Correction. This line is empty. */
+ 	  add_char ('\n');
+ 	  add_char ('\n');
+ 	}
+       add_char (' ');
+       return (0);
+     }
+   else
+     {
+       /* This line begins with "* ". It's now time to begin a new paragraph. */
+       if (! last_char_was_newline)
+ 	add_char ('\n');
+       input_text_offset += strlen (menu_starter);
+     }
+ 
+   get_until_in_line (":", &nodename);
+   if (curchar () == ':')
+     input_text_offset++;
+   canon_white (nodename);
+ 
+   add_char ('i');
+   output_paragraph_offset--;
+ 
+   inserts ("{\\uldb ");
+   execute_string ("%s", nodename);
+   inserts ("}{\\v ");
+ 
+   if (curchar () == ':')
+     {
+       input_text_offset++;
+       i = strlen (nodename);
+       if (i && nodename[i - 1] == ':')
+ 	nodename[i - 1] = '\0';
+       insert_context_string (nodename);
+       free (nodename);
+       inserts ("}\\tab ");
+       skip_whitespace ();
+     }
+   else
+     {
+       free (nodename);
+       get_rest_of_line (&nodename);
+       i = strlen (nodename);
+       backup_input_pointer ();
+       isolate_nodename (nodename);
+       if (*nodename == '(')
+ 	{
+ 	  char *filename = strdup(nodename+1);
+ 	  char *cp = filename+1;
+ 	  while (*cp && *cp != ')')
+ 	    cp++;
+ 	  if (*cp == ')')
+ 	    {
+ 	      char *nodename_in_info_file = cp+1;
+ 	      size_t fnlen;
+ 	      *cp++ = 0;
+ 	      fnlen = strlen(filename);
+ 	      if (fnlen >= 5 && (strcmp(filename+fnlen-5, ".info") == 0))
+ 		filename[fnlen-5] = 0;
+ 	      if (*nodename_in_info_file)
+ 		insert_context_string (nodename_in_info_file);
+ 	      else
+ 		insert_context_string ("Top");
+ 	      vinserts (" @%s.hlp", filename);
+ 	    }
+ 	  else
+ 	    insert_context_string (nodename);
+ 	  free (filename);
+ 	}
+       else
+ 	insert_context_string (nodename);
+       inserts ("}\\tab ");
+       j = strlen (nodename);      
+       if (i > j)
+ 	{
+ 	  char *description = nodename + j + 1;
+ 	  canon_white (description);
+ 	  execute_string ("%s", description);
+ 	}
+       free (nodename);
+     }
+ }
+ #endif
+ 
  static void
  isolate_nodename (nodename)
***************
*** 5651,5655 ****
--- 6262,6270 ----
        arg5 = get_xref_token ();
  
+ #ifdef RTF_OUTPUT
+       add_word_args ("%s", px_ref_flag ? "see " : "See ");
+ #else
        add_word_args ("%s", px_ref_flag ? "*note " : "*Note ");
+ #endif
  
        if (*arg5 || *arg4)
***************
*** 5667,5671 ****
--- 6282,6303 ----
  	    node_name = arg2;
  
+ #ifdef RTF_OUTPUT
+ 	  inserts ("{\\uldb ");
+ 	  execute_string ("%s", node_name);
+ 	  inserts ("}{\\v ");
+ 	  insert_context_string (arg1);
+ 
+ 	  {
+ 	    char *filename = strdup(arg4);
+ 	    size_t fnlen;
+ 	    fnlen = strlen(filename);
+ 	    if (fnlen >= 5 && (strcmp(filename+fnlen-5, ".info") == 0))
+ 	      filename[fnlen-5] = 0;
+ 	    vinserts (" @%s.hlp}", filename);
+ 	    free (filename);
+ 	  }
+ #else
  	  execute_string ("%s: (%s)%s", node_name, arg4, arg1);
+ #endif
  	  return;
  	}
***************
*** 5675,5689 ****
--- 6307,6359 ----
        if (*arg3)
  	{
+ #ifdef RTF_OUTPUT
+ 	  if (!*arg2)
+ 	    {
+ 	      inserts ("{\\uldb ");
+ 	      execute_string ("%s", arg3);
+ 	      inserts ("}{\\v ");
+ 	      insert_context_string (arg1);
+ 	      inserts ("}");
+ 	    }
+ 	  else
+ 	    {
+ 	      inserts ("{\\uldb ");
+ 	      execute_string ("%s", arg2);
+ 	      inserts ("}{\\v ");
+ 	      insert_context_string (arg1);
+ 	      inserts ("}");
+ 	    }
+ #else
  	  if (!*arg2)
  	    execute_string ("%s: %s", arg3, arg1);
  	  else
  	    execute_string ("%s: %s", arg2, arg1);
+ #endif
  	}
        else
  	{
+ #ifdef RTF_OUTPUT
+ 	  if (*arg2)
+ 	    {
+ 	      inserts ("{\\uldb ");
+ 	      execute_string ("%s", arg2);
+ 	      inserts ("}{\\v ");
+ 	      insert_context_string (arg1);
+ 	      inserts ("}");
+ 	    }
+ 	  else
+ 	    {
+ 	      inserts ("{\\uldb ");
+ 	      execute_string ("%s", arg1);
+ 	      inserts ("}{\\v ");
+ 	      insert_context_string (arg1);
+ 	      inserts ("}");
+ 	    }
+ #else
  	  if (*arg2)
  	    execute_string ("%s: %s", arg2, arg1);
  	  else
  	    execute_string ("%s::", arg1);
+ #endif
  	}
  
***************
*** 5736,5741 ****
--- 6406,6413 ----
        px_ref_flag--;
      }
+ #ifndef RTF_OUTPUT
    else
      add_char ('.');
+ #endif
  }
  
***************
*** 5752,5756 ****
--- 6424,6433 ----
        file = get_xref_token ();
  
+ #ifdef RTF_OUTPUT
+       execute_string ("%cxref{%s, %s,, %s}", COMMAND_PREFIX,
+ 		      node, pname, file);
+ #else
        execute_string ("*note %s: (%s)%s", pname, file, node);
+ #endif
      }
  }
***************
*** 6451,6455 ****
--- 7128,7136 ----
  			execute_string ("%s", item_func);
  		    }
+ #ifdef RTF_OUTPUT
+ 		  inserts ("\\tab ");
+ #else
  		  insert (' ');
+ #endif
  		  output_column++;
  		}
***************
*** 6477,6480 ****
--- 7158,7165 ----
  	case vtable:
  	  {
+ #ifdef RTF_OUTPUT
+ 	    int old_rtf_li = rtf_li;
+ 	    rtf_li -= RTF_TABLE_INDENTATION_INCREMENT;
+ #endif
  	    /* Get rid of extra characters. */
  	    kill_self_indent (-1);
***************
*** 6524,6527 ****
--- 7209,7215 ----
  	    close_single_paragraph ();
  	    indented_fill = filling_enabled = 1;
+ #ifdef RTF_OUTPUT
+ 	    rtf_li = old_rtf_li;
+ #endif
  	  }
  	}
***************
*** 7362,7365 ****
--- 8050,8060 ----
  cm_bye ()
  {
+ #ifdef RTF_OUTPUT
+   if (insertion_level > 0)
+     {
+       discard_insertions ();
+       flush_output ();
+     }
+ #endif
    input_text_offset = size_of_input_text;
  }
***************
*** 7638,7641 ****
--- 8333,8343 ----
        new->defining_line = line_number - 1;
        the_indices[which] = new;
+ #ifdef RTF_OUTPUT
+       inserts ("K{\\footnote K ");
+       in_index_entry++;
+       execute_string ("%s", index_entry);
+       in_index_entry--;
+       inserts ("}\n");
+ #endif
      }
  }
***************
*** 7934,7938 ****
--- 8636,8642 ----
    inhibit_paragraph_indentation = 1;
    close_paragraph ();
+ #ifndef RTF_OUTPUT
    add_word ("* Menu:\n\n");
+ #endif
  
    printing_index = 1;
***************
*** 7950,7959 ****
--- 8654,8677 ----
        line_number = index->defining_line;
  
+ #ifdef RTF_OUTPUT
+       inserts ("{");
+       vinserts ("\\fi%d", -RTF_MENU_INDENTATION);
+       vinserts ("\\li%d", RTF_MENU_INDENTATION);
+       vinserts ("\\tx%d", RTF_MENU_INDENTATION);
+ #endif
+ 
        /* If this particular entry should be printed as a "code" index,
  	 then wrap the entry with "@code{...}". */
+ #ifdef RTF_OUTPUT
+       if (index->code)
+ 	execute_string ("%ccode{%s}:", COMMAND_PREFIX, index->entry);
+       else
+ 	execute_string ("%s:", index->entry);
+ #else
        if (index->code)
  	execute_string ("* %ccode{%s}: ", COMMAND_PREFIX, index->entry);
        else
  	execute_string ("* %s: ", index->entry);
+ #endif
  
        /* Pad the front of the destination nodename so that
***************
*** 7962,7966 ****
--- 8680,8690 ----
  	indent (40 - output_column);
  
+ #ifdef RTF_OUTPUT
+       inserts ("\\tab ");
+       execute_string ("%cref{%s}.\n", COMMAND_PREFIX, index->node);
+       inserts ("}");
+ #else
        execute_string ("%s.\n", index->node);
+ #endif
  
        line_number = real_line_number;
***************
*** 8071,8075 ****
--- 8795,8803 ----
  #define EndNode 1
  
+ #ifdef RTF_OUTPUT
+ int footnote_style = SeparateNode;
+ #else
  int footnote_style = EndNode;
+ #endif
  int first_footnote_this_node = 1;
  int footnote_count = 0;
***************
*** 8227,8241 ****
--- 8955,8988 ----
      {
      case SeparateNode:
+ #ifndef RTF_OUTPUT
        add_word_args ("(%s)", marker);
        if (first_footnote_this_node)
+ #endif
  	{
  	  char *temp_string;
  
+ #ifdef RTF_OUTPUT
+ 	  temp_string = (char *)
+ 	    xmalloc ((strlen (current_node)) + 1 + (strlen (marker)) + 1);
+ #else
  	  temp_string = (char *)
  	    xmalloc ((strlen (current_node)) + (strlen ("-Footnotes")) + 1);
+ #endif
  
+ #ifndef RTF_OUTPUT
  	  add_word_args (" (*note %s-Footnotes::)", current_node);
+ #endif
  	  strcpy (temp_string, current_node);
+ #ifdef RTF_OUTPUT
+ 	  strcat (temp_string, "-");
+ 	  strcat (temp_string, marker);
+ 	  inserts ("({\\ul ");
+ 	  save_insert (marker);
+ 	  inserts ("}{\\v ");
+ 	  insert_context_string (temp_string);
+ 	  inserts ("})");
+ #else
  	  strcat (temp_string, "-Footnotes");
+ #endif
  	  remember_node_reference (temp_string, line_number, followed_reference);
  	  free (temp_string);
***************
*** 8271,8274 ****
--- 9018,9022 ----
      {
  
+ #ifndef RTF_OUTPUT
      case SeparateNode:
        {
***************
*** 8285,8288 ****
--- 9033,9037 ----
        }
        break;
+ #endif
  
      case EndNode:
***************
*** 8315,8318 ****
--- 9064,9085 ----
  	  {
  	  case SeparateNode:
+ #ifdef RTF_OUTPUT
+ 	    {
+ 	      char *old_current_node = current_node;
+ 	      char *old_command = strdup (command);
+ 	      
+ 	      already_outputting_pending_notes++;
+ 	      execute_string ("%cnode %s-%s,,,%s\n",
+ 			      COMMAND_PREFIX, old_current_node, footnote->marker,
+ 			      old_current_node);
+ 	      already_outputting_pending_notes--;
+ 	      current_node = old_current_node;
+ 	      free (command);
+ 	      command = old_command;
+ 	    }
+ 	    execute_string ("%s", footnote->note);
+ 	    close_paragraph ();
+ 	    break;
+ #endif
  	  case EndNode:
  	    execute_string ("(%s)  %s", footnote->marker, footnote->note);
***************
*** 9257,9258 ****
--- 10024,10297 ----
    return ((char *)NULL);
  }
+ 
+ #ifdef RTF_OUTPUT
+ /* **************************************************************** */
+ /*                                                                  */
+ /*                           RTF-Stuff                              */
+ /*                                                                  */
+ /* **************************************************************** */
+ 
+ inserts (s)
+      char *s;
+ {
+   while (*s)
+     insert (*s++);
+ }
+ 
+ #if defined (HAVE_VARARGS_H) && defined (HAVE_VSPRINTF)
+ 
+ vinserts (va_alist)
+      va_dcl
+ {
+   char buffer[1000];
+   char *format;
+   va_list args;
+ 
+   va_start (args);
+   format = va_arg (args, char *);
+   vsprintf (buffer, format, args);
+   va_end (args);
+   inserts (buffer);
+ }
+ 
+ #else /* !(HAVE_VARARGS_H && HAVE_VSPRINTF) */
+ 
+ vinserts (format, arg1, arg2, arg3, arg4, arg5)
+      char *format;
+ {
+   char buffer[1000];
+   sprintf (buffer, format, arg1, arg2, arg3, arg4, arg5);
+   inserts (buffer);
+ }
+ 
+ #endif /* !(HAVE_VARARGS_H && HAVE_VSPRINTF) */
+ 
+ save_insert (s)
+      char *s;
+ {
+   while (*s)
+     {
+       if (*s == '{' || *s == '}' || *s == '\\' || ! isascii (*s))
+ 	vinserts ("\\'%02X", (int) (*s & 0xff));
+       else
+ 	insert (*s);
+       s++;
+     }
+ }
+ 
+ make_context_string (context_string, text)
+      char *context_string;
+      char *text;
+ {
+   char *cp = context_string;
+   if (text)
+     {
+       while (*text)
+ 	{
+ 	  if (*text == '\n')
+ 	    {
+ 	      *cp++ = '_';
+ 	      text++;
+ 	      while (*text && isspace(*text))
+ 		text++;
+ 	      if (*text == 0)
+ 		break;
+ 	    }
+ 	  if (!isalnum (*text) || !isascii(*text))
+ 	    *cp = '_';
+ 	  else
+ 	    *cp = *text;
+ 	  cp++;
+ 	  text++;
+ 	}
+     }
+   *cp = 0;
+ }
+ 
+ insert_context_string (text)
+      char *text;
+ {
+   char context_string[ 8192 ];
+   make_context_string (context_string, text);
+   save_insert (context_string);
+ }
+ 
+ insert_hot_spot (text, node)
+      char *text;
+      char *node;
+ {
+   char context_string[ 8192 ];
+   if (node == 0)
+     make_context_string (context_string, text);
+   else
+     make_context_string (context_string, node);
+   inserts ("{\\uldb ");
+   if (text == 0 || *text == 0)
+     {
+       if (node)
+ 	save_insert (node);
+     }
+   else
+     save_insert (text);
+   inserts ("}{\\v ");
+ 
+   if (node && *node == '(')
+     {
+       char *filename = strdup(node+1);
+       char *cp = filename+1;
+       while (*cp && *cp != ')')
+ 	cp++;
+       if (*cp == ')')
+ 	{
+ 	  char *nodename_in_info_file = cp+1;
+ 	  size_t fnlen;
+ 	  *cp++ = 0;
+ 	  fnlen = strlen(filename);
+ 	  if (fnlen >= 5 && (strcmp(filename+fnlen-5, ".info") == 0))
+ 	    filename[fnlen-5] = 0;
+ 	  if (*nodename_in_info_file)
+ 	    insert_context_string (nodename_in_info_file);
+ 	  else
+ 	    insert_context_string ("Top");
+ 	  vinserts (" @%s.hlp", filename);
+ 	}
+       else
+ 	insert_context_string (node);
+       free (filename);
+     }
+   else
+     insert_context_string (node);
+   inserts ("}");
+ }
+ 
+ /* Start the RTF file. Select a code table and a font. Define the font
+    table. */
+ start_rtf_file ()
+ {
+   fprintf (output_stream, "\
+ {\\rtf1\\windows \\deff0{\\fonttbl\n\
+ {\\f0\\fswiss MS Sans Serif;}{\\f1\\fmodern Courier New;}{\\f2\\ftech Symbol;}}\\fs20\n");
+ }
+ 
+ /* End up the RTF file. */
+ end_rtf_file ()
+ {
+   fprintf (output_stream, "}\n");
+ }
+ 
+ /* Start a new help topic. The node line is formatted as a
+    non-scrolling region. */
+ start_topic (node, next, prev, up)
+      char *node;
+      char *next;
+      char *prev;
+      char *up;
+ {
+   char context_string[ 8192 ];
+ 
+   inserts ("\\page\\pard");
+   if (already_outputting_pending_notes == 0)
+     {
+       in_non_scrolling_region = 1;
+       inserts (" Node: {\\b ");
+       save_insert (node);
+       inserts ("}, \\keepn Next: ");
+       insert_hot_spot (0, next);
+       inserts (", Prev: ");
+       insert_hot_spot (0, prev);
+       inserts (", Up: ");
+       insert_hot_spot (0, up);
+       inserts ("\\line\n");
+       make_context_string (context_string, node);
+       inserts ("K{\\footnote K ");
+       save_insert (node);
+       inserts ("}\n");
+       inserts ("#{\\footnote ");
+       save_insert (context_string);
+       inserts ("}\n");
+     }
+   else
+     {
+       make_context_string (context_string, node);
+       inserts ("#{\\footnote ");
+       save_insert (context_string);
+       inserts ("}\n");
+     }
+ }
+ 
+ char *help_window_title;
+ 
+ /* Set the title for the help file. */
+ void
+ cm_settitle ()
+ 
+ {
+   get_rest_of_line (&help_window_title);
+ }
+ 
+ /* Write the HPJ file for the help compiler. */
+ write_help_project_file (hpj_filename, rtf_filename)
+      char *hpj_filename;
+      char *rtf_filename;
+ {
+   FILE *hpj_stream = fopen(hpj_filename, "w");
+   if (!hpj_stream)
+     perror (hpj_filename);
+   else
+     {
+       fprintf (hpj_stream, "[OPTIONS]\n");
+       fprintf (hpj_stream, "CONTENTS=TOP\n");
+       fprintf (hpj_stream, "COMPRESS=YES\n");
+       if (help_window_title)
+ 	{
+ #define MAX_TITLE_LEN 50	/* Window titles shouldn't be longer than this. */
+ 	  static char buf[ MAX_TITLE_LEN + 1 ];
+ 	  static char search[] = {COMMAND_PREFIX,
+ 				  'v', 'a', 'l', 'u', 'e', '{', '\0'};
+ 	  size_t search_len = strlen(search);
+ 	  char *cp=help_window_title, *cp1=buf;
+ 	  size_t len = 0;
+ 	  while (*cp && len < MAX_TITLE_LEN)
+ 	    {
+ 	      if (strncmp(cp, search, search_len) == 0)
+ 		{
+ 		  char *var;
+ 		  char *cp2;
+ 		  cp2 = cp + search_len;
+ 		  var = cp2;
+ 		  while (*cp2 && *cp2 != '}')
+ 		    cp2++;
+ 		  if (*cp2 == '}')
+ 		    {
+ 		      char *value;
+ 		      size_t vlen;
+ 		      *cp2++ = 0;
+ 		      value = set_p(var);
+ 		      if (value && (vlen=strlen(value))+len < MAX_TITLE_LEN)
+ 			{
+ 			  strcpy (cp1, value);
+ 			  cp1 += vlen;
+ 			  len += vlen;
+ 			  cp = cp2;
+ 			  continue;
+ 			}
+ 		    }
+ 		}
+ 	      *cp1++ = *cp++;
+ 	      len++;
+ 	    }
+ 	  *cp1 = 0;
+ 	  fprintf (hpj_stream, "TITLE=%s\n", buf);
+ 	}
+       else
+ 	{
+ 	  warning ("Missing %csettitle command", COMMAND_PREFIX);
+ 	  fprintf (hpj_stream, "TITLE=Fixme: missing @settitle command!\n");
+ 	}
+       fprintf (hpj_stream, "\n");
+       fprintf (hpj_stream, "[FILES]\n");
+       fprintf (hpj_stream, "%s\n", rtf_filename);
+       fclose (hpj_stream);
+     }
+ }
+ #endif
