#ifndef MIDKIT_H
#define MIDKIT_H
#include <stdio.h>
#include "mtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

// use these defines when checking for setero, or 16 bit sound.
// look at midwav.c for an example....
#define STEREO    1
#define BITS16    2

// use these defines, when initiating the MID-KIT system
// MK_Init variables...
#define MK_AUTO 1
#define MK_DIGI 2
#define MK_MIDI 4


// this is the structure, for a MID-KIT .MKI  ( Mid-Kit Instrument)
typedef struct 
{
  char            ibk_header[4];         // a  general midi .ibk 
  unsigned char   inst[129][16]; 
  char            perc_header[4];        // the percsussion .ibk
  unsigned char   perc[4][16]; 
} mki_file;

// this structure is for .MKS files (Mid-Kit Song).
typedef struct 
{ char   header[14];
  char   track_header[30][8];
  char   *track[30];
  int    num_tracks;
  long   delta_ticks;
} mks_file;

// this is the structure for the digital samples, study it careflly.
typedef struct GHOLD{
        UBYTE kick;                     // =1 -> sample has to be restarted
        UBYTE active;                   // =1 -> sample is playing
        UWORD flags;                    // 16/8 bits looping/one-shot
        WORD  handle;                   // identifies the sample
        ULONG start;                    // start index
        ULONG size;                     // samplesize
        ULONG reppos;                   // loop start
        ULONG repend;                   // loop end
        ULONG frq;                      // current frequency
        UBYTE vol;                      // current volume
        UBYTE pan;                      // current panning position

        UWORD iter;                     // iteration variabele
        ULONG current;                  // current index in the sample
        ULONG increment;                // fixed-point increment value
        void *lvoltab;                  // left volume table
        void *rvoltab;                  // right volume table
} GHOLD;
// access this array, for changing the flag bits (defined in mtypes.h).
// also controls the looping etc.  Depends on what flags are set for each
// voice (0-31)
extern GHOLD ghld[32];

extern UWORD mk_mixfreq;
extern UWORD mk_dmabufsize;
extern UWORD mk_mode;
extern UBYTE mk_numchn;        // number of channels mid-kit is open at...
extern BYTE midi_playing;      // variable set, when song is playing
extern BYTE digi_playing;
extern WORD MK_MusicVol;
extern ULONG MK_Timer;         // updates every 72.8 timer per second
                               // use it for timing in your games...

extern UWORD sb_int;           // interrupt vector that belongs to sb_irq
extern UWORD sb_ver;           // DSP version number
extern UWORD sb_port;          // sb base port
extern UBYTE sb_irq;           // sb irq
extern UBYTE sb_lodma;         // 8 bit dma channel (1.0/2.0/pro)
extern UBYTE sb_hidma;         // 16 bit dma channel (16/16asp)
extern UBYTE sb_dma;           // current dma channel
extern UWORD fm_addr;          // current fm port
extern UBYTE MK_AutoDetect;
extern BYTE MK_fm_found;       // This variable is set, if found FM cap..
extern BYTE MK_digi_found;     // This variable is set if found DIGITAL cap...



// Sample load routines
WORD MK_SampleLoad(FILE *fp,ULONG size,ULONG reppos,ULONG repend,UWORD flags);
void MK_SampleUnLoad(WORD handle);

BOOL MK_Init(UBYTE flag,int num_voices);
void MK_Exit(void);
void MK_PlayStart(void);
void MK_PlayStop(void);
void MK_Update(void);
// timer routines
void MK_StartTimer(void);
void MK_StopTimer(void);

//  Wave play routines
void MK_VoiceSetVolume(UBYTE voice,UBYTE ivol);
void MK_VoiceSetFrequency(UBYTE voice,ULONG frq);
void MK_VoiceSetPanning(UBYTE voice,ULONG pan);
void MK_VoiceStop(UBYTE voice);
BOOL MK_VoiceActive(UBYTE voice);
void MK_VoicePlay(UBYTE voice,
                  WORD handle,
                  ULONG start,
                  ULONG size,
                  ULONG reppos,
                  ULONG repend,
                  UWORD flags);

void SL_Init(FILE *fp,UWORD infmt,UWORD outfmt);
void SL_Load(void *buffer,ULONG length);

// mki, and mks routines
int  MK_LoadMKI(mki_file *file2);
int  MK_LoadMKS(char *name, mks_file *mks);
void MK_PlayMKS(mks_file *mks, mki_file *mki);
int  MK_SetMusicVol(WORD vol);
int  MK_FreeMKS(mks_file *mks);
void MK_StopMKS(void);
void MK_UpdateTick(void);  
void MK_UserHandler(void);                      // you must define this
                                                // function in yuor program.    
                                                // it's called every 72.8 time/s

#ifdef __cplusplus
}
#endif
#endif

