#include <stdio.h>
#include <stdlib.h>
#include "mytypes.h"
#include "forte.h"
#include "gf1proto.h"
#include "extern.h"
#include "ultraerr.h"
#include "ultraext.h"

ULTRA_CFG config;


int UltraGetCfg(ULTRA_CFG *config)
{
	char *ptr;

	config->base_port = 0x220;
	config->dram_dma_chan = 1;
	config->adc_dma_chan = 1;
	config->gf1_irq_num = 11;
	config->midi_irq_num = 5;

	if((ptr=getenv("ULTRASND"))==NULL) return FALSE;

	if(sscanf(ptr,"%x,%d,%d,%d,%d"
				,&config->base_port,
				&config->dram_dma_chan,
				&config->adc_dma_chan,
				&config->gf1_irq_num,
				&config->midi_irq_num)!=5) return FALSE;

	return(TRUE);
}




void UltraDownloadX(UBYTE *data_ptr,UBYTE control,ULONG dram_loc,UWORD len,int wait)
/*
	Identical to UltraDownLoad() except this one handles
	dram_loc's that	aren't on a 32-byte boundary.
*/
{
	/* Dram location not on a 32 byte boundary ? */

	while(len>0 && (dram_loc&31)){

		/* Slowly 'poke' the odd
		   samples into gus dram */

		UltraPokeData(config.base_port,dram_loc,*data_ptr);

		data_ptr++;
		dram_loc++;
		len--;
	}

	// The rest goes fast...

	if(len>0) UltraDownload(data_ptr,control,dram_loc,len,wait);
}





ULONG UltraFileload(FILE *fp,UBYTE control,ULONG dram_loc,ULONG size)
/*
	This function directly loads data from a file into gus dram.
	returns the number of bytes actually loaded.
*/
{
	ULONG todo,total=0,done;
	char *buffer;

	if((buffer=malloc(8000))==NULL) return 0;

	do{
		todo=(size>8000)?8000:size;

		done=fread(buffer,1,todo,fp);

		UltraDownloadX(buffer,control,dram_loc,done,TRUE);

		total+=done;
		dram_loc+=done;
		size-=done;

	} while( size>0 && (done==todo) );

	free(buffer);

	return total;
}


UBYTE UltraPeek(ULONG address)
{
	return(UltraPeekData(config.base_port,address));
}


void UltraPoke(ULONG address,UBYTE val)
{
	UltraPokeData(config.base_port,address,val);
}
