#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mtypes.h"
#include "mloader.h"


BOOL UNI_Test(void)
{
	char id[4];

	rewind(modfp);
	if(!fread(id,4,1,modfp)) return 0;
	if(!memcmp(id,"UN02",4)) return 1;
	return 0;
}


BOOL UNI_Init(void)
{
	return 1;
}


void UNI_Cleanup(void)
{
	;
}


char *StrRead(void)
{
	char *s;
	int len=0;

	fread(&len,sizeof(int),1,modfp);

	if(!len) return NULL;

	s=malloc(len+1);
	fread(s,len,1,modfp);
	s[len]=0;

	return s;
}


UBYTE *TrkRead(void)
{
	UBYTE *t;
	UWORD len;

	fread(&len,sizeof(int),1,modfp);
	t=malloc(len);
	fread(t,len,1,modfp);
	return t;
}




BOOL UNI_Load(void)
{
	int t;

	if(!UNI_Init()) return 0;

	fseek(modfp,4,SEEK_SET);

	// try to read module header

	if(!fread(&of,sizeof(UNIHEADER),1,modfp)){
		myerr=ERROR_LOADING_HEADER;
		return 0;
	}

	of.songname=StrRead();
	of.modtype=StrRead();
	of.comment=StrRead();   // <- new since UN01

	if(!AllocSampleInfo()) return 0;

	if(!AllocTracks()) return 0;
	if(!AllocPatterns()) return 0;

	// Read sampleinfos

	for(t=0;t<of.numsmp;t++){
		fread(&of.samples[t],sizeof(UNISAMPLE),1,modfp);
		of.samples[t].samplename=StrRead();
		of.samples[t].seekpos=0;
	}

	// Read patterns

	fread(of.pattrows,sizeof(UWORD),of.numpat,modfp);
	fread(of.patterns,sizeof(UWORD),of.numpat*of.numchn,modfp);

	// Read tracks

	for(t=0;t<of.numtrk;t++){
		of.tracks[t]=TrkRead();
	}

	return 1;
}





LOADER uniload={
	NULL,
	"UNI",
	"UNI loader v0.1",
	UNI_Test,
	UNI_Load,
	UNI_Cleanup
};
