#ifndef MTYPES_H
#define MTYPES_H





/*
	MikMod atomic types:
	====================
*/

typedef char            BYTE;		// has to be 1 byte signed
typedef unsigned char   UBYTE;		// has to be 1 byte unsigned
typedef short           WORD;		// has to be 2 bytes signed
typedef unsigned short  UWORD;		// has to be 2 bytes unsigned
typedef long            LONG;		// has to be 4 bytes signed
typedef unsigned long   ULONG;		// has to be 4 bytes unsigned
typedef int				BOOL;		// doesn't matter.. 0=FALSE, <>0 true



/*
	error variables:
	===============
*/

extern char *ERROR_ALLOC_STRUCT;
extern char *ERROR_LOADING_PATTERN;
extern char *ERROR_LOADING_TRACK;
extern char *ERROR_LOADING_HEADER;
extern char *ERROR_NOT_A_MODULE;
extern char *ERROR_LOADING_SAMPLEINFO;
extern char *ERROR_OUT_OF_HANDLES;
extern char *ERROR_SAMPLE_TOO_BIG;
extern char *myerr;



/*
	MikMod sample types:
	====================
*/

#define SF_16BITS	1
#define SF_SIGNED   4
#define SF_LOOP		8
#define SF_DELTA	16


typedef struct SAMPLEINFO{	// new sample info with some converted types
	UWORD c2spd;        	// finetune frequency
	BYTE  transpose;		// transpose value
	UBYTE volume;			// volume 0-64
	ULONG length;			// length of sample (in samples!)
	ULONG loopstart;		// repeat position (relative to start, in samples)
	ULONG loopend;			// repeat end
	UWORD flags;
	ULONG seekpos;
	char *samplename;		// name of the sample
	WORD  handle;			// handle <- NEW since 0.4
} SAMPLEINFO;


// UNISAMPLE has the same first members as the head of a SAMPLEINFO sample

typedef struct UNISAMPLE{       // new sample info with some converted types
	UWORD c2spd;        	// finetune frequency
	BYTE  transpose;		// transpose value
	UBYTE volume;			// volume 0-64
	ULONG length;			// length of sample (in samples!)
	ULONG loopstart;		// repeat position (relative to start, in samples)
	ULONG loopend;			// repeat end
	UWORD flags;
} UNISAMPLE;






/*
	MikMod UNImod types:
	====================
*/

typedef struct UNIMOD{
	UBYTE  		numchn;				// number of channels
	UWORD	    numpos;				// number of positions in this song
	UWORD  		numpat;				// number of patterns in this song
	UWORD 		numtrk;				// number of tracks
	UWORD  		numsmp;				// number of samples
	UBYTE		initspeed;			//
	UBYTE		inittempo;          //
	UBYTE 		positions[256];		// all positions
	UBYTE		panning[32];		// 32 panning positions
	char 	   *songname;			// name of the song
	char  	   *modtype;			// string type of module
	char	   *comment;			// module comments
	SAMPLEINFO *samples;			// all samples
	UWORD	   *patterns;			// array of PATTERN
	UWORD	   *pattrows;			// array of number of rows for each pattern
	UBYTE	  **tracks;				// array of pointers to tracks
} UNIMOD;


// UNIHEADER has the same first members as the head of a UNIMOD

typedef struct UNIHEADER{
	UBYTE  		numchn;				// number of channels
	UWORD	    numpos;				// number of positions in this song
	UWORD 		numpat;				// number of patterns in this song
	UWORD 		numtrk;				// number of tracks
	UWORD		numsmp;				// number of samples
	UBYTE		initspeed;			//
	UBYTE		inittempo;          //
	UBYTE 		positions[256];		// all positions
	UBYTE		panning[32];		// 32 panning positions
} UNIHEADER;


#endif
