#include <stdlib.h>
#include "mtypes.h"
#include "munitrk.h"
#include "mdriver.h"
#include "mloader.h"
#include "mplayer.h"


UNIMOD *pf;			// <- this modfile is being played
UWORD reppos;			// patternloop position
UWORD repcnt;			// times to loop
UWORD vbtick;			// tick counter
UWORD patbrk;			// position where to start a new pattern
UBYTE patdly;			// patterndelay counter
UBYTE patdly2;			// patterndelay counter
int   numrow;			// number of rows on current pattern
int   posjmp;			/* 	flag to indicate a position jump is needed...
							changed since 1.00: now also indicates the
							direction the position has to jump to:

							0: Don't do anything
							1: Jump back 1 position
							2: Restart on current position
							3: Jump forward 1 position
						*/
int   forbid;			// forbidflag


/*
	Set forbid to 1 when you want to modify any of the mp_sngpos, mp_patpos etc.
	variables and clear it when you're done. This prevents getting strange
	results due to intermediate interrupts.
*/


AUDTMP mp_audio[32];	// max 32 channels
UBYTE  mp_bpm;			// beats-per-minute speed
UWORD  mp_patpos;		// current row number (0-255)
int    mp_sngpos;		// current song position
UWORD  mp_sngspd;		// current songspeed
int	   mp_channel;		// channel it's working on
BOOL   mp_extspd=1;		// extended speed flag, default enabled
BOOL   mp_panning=1;	// panning flag, default enabled
BOOL   mp_loop=0;		// loop module ?
AUDTMP *a;				// current AUDTMP it's working on


UWORD mytab[12]={
	1712*16,1616*16,1524*16,1440*16,1356*16,1280*16,
	1208*16,1140*16,1076*16,1016*16,960*16,907*16
};

static UBYTE VibratoTable[32]={
	0,24,49,74,97,120,141,161,
	180,197,212,224,235,244,250,253,
	255,253,250,244,235,224,212,197,
	180,161,141,120,97,74,49,24
};



UWORD GetPeriod(BYTE note,BYTE transpose,UWORD c2spd)
{
	UBYTE n,o;
	ULONG period;

	if(!c2spd) return 4242;		// <- prevent divide overflow.. (42 eheh)

	note+=transpose;
	n=note%12;
	o=note/12;
	period=((8363L*mytab[n]) >> o )/c2spd;

	return period;
}



void DoEEffects(UBYTE dat)
{
	UBYTE nib;

	nib=dat&0xf;

	switch(dat>>4){

		case 0x0:	// filter toggle, not supported
				break;

		case 0x1:	// fineslide up
				if(!vbtick) a->tmpperiod-=(nib<<2);
				break;

		case 0x2:	// fineslide dn
				if(!vbtick) a->tmpperiod+=(nib<<2);
				break;

		case 0x3:	// glissando ctrl
				a->glissando=nib;
				break;

		case 0x4:	// set vibrato waveform
				a->wavecontrol&=0xf0;
				a->wavecontrol|=nib;
				break;

		case 0x5:	// set finetune
				a->c2spd=finetune[nib];
				a->tmpperiod=GetPeriod(a->note,pf->samples[a->sample].transpose,a->c2spd);
				break;

		case 0x6:	// set patternloop

				if(vbtick) break;

				/* hmm.. this one is a real kludge. But now it
				   works. */

				if(nib){		// set reppos or repcnt ?

					/* set repcnt, so check if repcnt already is set,
					   which means we are already looping */

					if(repcnt>0)
						repcnt--;		// already looping, decrease counter
					else
						repcnt=nib;		// not yet looping, so set repcnt

					if(repcnt)			// jump to reppos if repcnt>0
						mp_patpos=reppos;
				}
				else{
					reppos=mp_patpos-1;	// set reppos
				}
				break;


		case 0x7:	// set tremolo waveform
				a->wavecontrol&=0x0f;
				a->wavecontrol|=nib<<4;
				break;

		case 0x8:	// not used
				if(mp_panning) pf->panning[mp_channel]=nib<<4;
				break;

		case 0x9:	// retrig note

				/* only retrigger if
				   data nibble > 0 */

				if(nib>0){
					if(a->retrig==0){

						/* when retrig counter reaches 0,
						   reset counter and restart the sample */

						a->kick=1;
						a->retrig=nib;
					}
					a->retrig--; // countdown
				}
				break;

		case 0xa:	// fine volume slide up
				if(vbtick) break;

				a->tmpvolume+=nib;
				if(a->tmpvolume>64) a->tmpvolume=64;
				break;

		case 0xb:	// fine volume slide dn
				if(vbtick) break;

				a->tmpvolume-=nib;
				if(a->tmpvolume<0) a->tmpvolume=0;
				break;

		case 0xc:	// cut note

				/* When vbtick reaches the cut-note value,
				   turn the volume to zero ( Just like
				   on the amiga) */

				if(vbtick>=nib){
					a->tmpvolume=0;			// just turn the volume down
				}
				break;

		case 0xd:	// note delay

				/* delay the start of the
				   sample until vbtick==nib */

				if(vbtick==nib){
					a->kick=1;
				}
				else a->kick=0;
				break;

		case 0xe:	// pattern delay
				if(vbtick) break;
				if(!patdly2) patdly=nib+1;				// only once (when vbtick=0)
				break;

		case 0xf:	// invert loop, not supported
				break;
	}
}


void DoVibrato(void)
{
	UBYTE q;
	UWORD temp;

	q=(a->vibpos>>2)&0x1f;

	switch(a->wavecontrol&3){

		case 0:	// sine
			temp=VibratoTable[q];
			break;

		case 1:	// ramp down
			q<<=3;
			if(a->vibpos<0) q=255-q;
			temp=q;
			break;

		case 2:	// square wave
			temp=255;
			break;
	}

	temp*=a->vibdepth;
	temp>>=7;
	temp<<=2;

	if(a->vibpos>=0)
		a->period=a->tmpperiod+temp;
	else
		a->period=a->tmpperiod-temp;

	if(vbtick) a->vibpos+=a->vibspd;	// do not update when vbtick==0
}



void DoTremolo(void)
{
	UBYTE q;
	UWORD temp;

	q=(a->trmpos>>2)&0x1f;

	switch((a->wavecontrol>>4)&3){

		case 0:	// sine
			temp=VibratoTable[q];
			break;

		case 1:	// ramp down
			q<<=3;
			if(a->trmpos<0)	q=255-q;
			temp=q;
			break;

		case 2:	// square wave
			temp=255;
			break;
	}

	temp*=a->trmdepth;
	temp>>=6;

	if(a->trmpos>=0){
		a->volume=a->tmpvolume+temp;
		if(a->volume>64) a->volume=64;
	}
	else{
		a->volume=a->tmpvolume-temp;
		if(a->volume<0) a->volume=0;
	}

	if(vbtick) a->trmpos+=a->trmspd;	// do not update when vbtick==0
}


void DoVolSlide(UBYTE dat)
{
	if(!vbtick) return;		// do not update when vbtick==0

	a->tmpvolume+=dat>>4;        	// volume slide
	a->tmpvolume-=dat&0xf;
	if(a->tmpvolume<0) a->tmpvolume=0;
	if(a->tmpvolume>64) a->tmpvolume=64;
}



void DoS3MVolSlide(UBYTE inf)
{
	UBYTE lo,hi;

	if(inf){
		a->s3mvolslide=inf;
	}
	inf=a->s3mvolslide;

	lo=inf&0xf;
	hi=inf>>4;

	if(hi==0){
		a->tmpvolume-=lo;
	}
	else if(lo==0){
		a->tmpvolume+=hi;
	}
	else if(hi==0xf){
		if(!vbtick) a->tmpvolume-=lo;
	}
	else if(lo==0xf){
		if(!vbtick) a->tmpvolume+=hi;
	}

	if(a->tmpvolume<0) a->tmpvolume=0;
	if(a->tmpvolume>64) a->tmpvolume=64;
}



void DoS3MSlideDn(UBYTE inf)
{
	UBYTE hi,lo;

	if(inf!=0) a->slidespeed=inf;
	else inf=a->slidespeed;

	hi=inf>>4;
	lo=inf&0xf;

	if(hi==0xf){
		if(!vbtick) a->tmpperiod+=(UWORD)lo<<2;
	}
	else if(hi==0xe){
		if(!vbtick) a->tmpperiod+=lo;
	}
	else{
		if(vbtick) a->tmpperiod+=(UWORD)inf<<2;
	}
}



void DoS3MSlideUp(UBYTE inf)
{
	UBYTE hi,lo;

	if(inf!=0) a->slidespeed=inf;
	else inf=a->slidespeed;

	hi=inf>>4;
	lo=inf&0xf;

	if(hi==0xf){
		if(!vbtick) a->tmpperiod-=(UWORD)lo<<2;
	}
	else if(hi==0xe){
		if(!vbtick) a->tmpperiod-=lo;
	}
	else{
		if(vbtick) a->tmpperiod-=(UWORD)inf<<2;
	}
}



void DoS3MTremor(UBYTE inf)
{
	UBYTE on,off;

	on=(inf>>4)+1;
	off=(inf&0xf)+1;

	a->s3mtremor%=(on+off);
	a->volume=(a->s3mtremor < on ) ? a->tmpvolume:0;
	a->s3mtremor++;
}



void DoS3MRetrig(UBYTE inf)
{
	UBYTE hi,lo;

	hi=inf>>4;
	lo=inf&0xf;

	if(lo){
		a->s3mrtgslide=hi;
		a->s3mrtgspeed=lo;
	}

	if(hi){
		a->s3mrtgslide=hi;
	}

	/* only retrigger if
	   lo nibble > 0 */

	if(a->s3mrtgspeed>0){
		if(a->retrig==0){

			/* when retrig counter reaches 0,
			   reset counter and restart the sample */

			a->kick=1;
			a->retrig=a->s3mrtgspeed;

			if(vbtick){			// don't slide on first retrig
				switch(a->s3mrtgslide){

					case 1:
					case 2:
					case 3:
					case 4:
					case 5:
						a->tmpvolume-=(1<<(a->s3mrtgslide-1));
						break;

					case 6:
						a->tmpvolume=(2*a->tmpvolume)/3;
						break;

					case 7:
						a->tmpvolume=a->tmpvolume>>1;
						break;

					case 9:
					case 0xa:
					case 0xb:
					case 0xc:
					case 0xd:
						a->tmpvolume+=(1<<(a->s3mrtgslide-9));
						break;

					case 0xe:
						a->tmpvolume=(3*a->tmpvolume)/2;
						break;

					case 0xf:
						a->tmpvolume=a->tmpvolume<<1;
						break;
				}
				if(a->tmpvolume<0) a->tmpvolume=0;
				if(a->tmpvolume>64) a->tmpvolume=64;
			}
		}
		a->retrig--; // countdown
	}
}


void DoS3MSpeed(UBYTE speed)
{
	if(vbtick || patdly2) return;

	if(speed){			// <- v0.44 bugfix
		mp_sngspd=speed;
		vbtick=0;
	}
}


void DoS3MTempo(UBYTE tempo)
{
	if(vbtick || patdly2) return;
	mp_bpm=tempo;
}


void DoToneSlide(void)
{
	int dist,t;

	if(!vbtick) return;

	/* We have to slide a->period towards a->wantedperiod, so
	   compute the difference between those two values */

	dist=a->period-a->wantedperiod;

	if( dist==0 ||           		// if they are equal
		a->portspeed>abs(dist) ){	// or if portamentospeed is too big

		a->period=a->wantedperiod;	// make tmpperiod equal tperiod
	}
	else if(dist>0){				// dist>0 ?
		a->period-=a->portspeed;	// then slide up
	}
	else
		a->period+=a->portspeed;	// dist<0 -> slide down

/*	if(a->glissando){

		 If glissando is on, find the nearest
		   halfnote to a->tmpperiod

		for(t=0;t<60;t++){
			if(a->tmpperiod>=npertab[a->finetune][t]) break;
		}

		a->period=npertab[a->finetune][t];
	}
	else
*/
	a->tmpperiod=a->period;
}


void DoPTEffect(UBYTE eff,UBYTE dat)
{
	UBYTE note;
	WORD temp,hi,lo;

	note=a->note;

	switch(eff){
		case 0x0:	// arpeggio
				if(dat!=0){
					switch(vbtick%3){
						case 1:
							note+=(dat>>4); break;
						case 2:
							note+=(dat&0xf); break;
					}
					a->period=GetPeriod(note,pf->samples[a->sample].transpose,a->c2spd);
					a->ownper=1;
				}
				break;

		case 0x1:	// portamento up
				if(dat!=0) a->slidespeed=(UWORD)dat<<2;
				if(vbtick) a->tmpperiod-=a->slidespeed;
				break;

		case 0x2:	// portamento dn
				if(dat!=0) a->slidespeed=(UWORD)dat<<2;
				if(vbtick) a->tmpperiod+=a->slidespeed;
				break;

		case 0x3:	// toneportamento (toneslide)
				a->kick=0;
				if(dat!=0){
					a->portspeed=dat;
					a->portspeed<<=2;
				}
				DoToneSlide();
				a->ownper=1;
				break;

		case 0x4:	// vibrato
				if(dat&0x0f) a->vibdepth=dat&0xf;
				if(dat&0xf0) a->vibspd=(dat&0xf0)>>2;
				DoVibrato();
				a->ownper=1;
				break;

		case 0x5:	// tone+volume slide
				a->kick=0;
				DoToneSlide();
				DoVolSlide(dat);
				a->ownper=1;
				break;

		case 0x6:	// vibrato + volslide
				DoVibrato();
				DoVolSlide(dat);
				a->ownper=1;
				break;

		case 0x7:	// tremolo
				if(dat&0x0f) a->trmdepth=dat&0xf;
				if(dat&0xf0) a->trmspd=(dat&0xf0)>>2;
				DoTremolo();
				a->ownvol=1;
				break;

		case 0x8:	// unused
				if(mp_panning) pf->panning[mp_channel]=dat;
				break;

		case 0x9:	// set sampleoffset
				if(dat) a->soffset=(UWORD)dat<<8;	// <- 0.43 fix..
				a->start=a->soffset;
				if(a->start>a->size) a->start=a->size;
				break;

		case 0xa:   // volume slide
				DoVolSlide(dat);
				break;

		case 0xb:	// position jump
				if(patdly2) break;
				patbrk=0;
				mp_sngpos=dat-1;
				posjmp=3;
				break;

		case 0xc:	// set volume

				if(dat>64) dat=64;
				a->tmpvolume=dat;
				break;

		case 0xd:	// patternbreak
				if(patdly2) break;

				hi=(dat&0xf0)>>4;
				lo=(dat&0xf);
				patbrk=(hi*10)+lo;
				if(patbrk>64) patbrk=64;	// <- v0.42 fix
				posjmp=3;
				break;

		case 0xe:	// extended effects
				DoEEffects(dat);
				break;

		case 0xf:	// set speed
				if(vbtick || patdly2) break;

				if(mp_extspd && dat>=0x20){
					mp_bpm=dat;
				}
				else{
					if(dat){			// <- v0.44 bugfix
						mp_sngspd=dat;
						vbtick=0;
					}
				}
				break;

	}
}



void PlayNote(void)
{
	UWORD period;
	UBYTE inst,c;
	BYTE note;

	if(a->row==NULL) return;

	UniSetRow(a->row);

	while(c=UniGetByte()){

		switch(c){

			case UNI_NOTE:
				note=UniGetByte();

				a->note=note;

				period=GetPeriod(note,pf->samples[a->sample].transpose,pf->samples[a->sample].c2spd);

				a->wantedperiod=period;
				a->tmpperiod=period;

				a->kick=1;
				a->start=0;

				// retrig tremolo and vibrato waves ?

				if(!(a->wavecontrol&0x80)) a->trmpos=0;
				if(!(a->wavecontrol&0x08)) a->vibpos=0;
				break;

			case UNI_INSTRUMENT:
				inst=UniGetByte();
				if(inst>=pf->numsmp) break;		// <- safety valve

				a->sample=inst;
				a->handle=pf->samples[inst].handle;
				a->tmpvolume=pf->samples[inst].volume;
				a->volume=pf->samples[inst].volume;
				a->size=pf->samples[inst].length;
				a->c2spd=pf->samples[inst].c2spd;
				a->flags=pf->samples[inst].flags;
				a->retrig=0;
				a->s3mtremor=0;
				a->reppos=pf->samples[inst].loopstart;
				a->repend=pf->samples[inst].loopend;
				break;

//			case UNI_S3MVOLUME:
//				a->tmpvolume=UniGetByte();
//				a->volume=a->tmpvolume;
//				break;

			default:
				UniSkipOpcode(c);
				break;
		}
	}
}


void PlayEffects(void)
{
	UBYTE c;

	if(a->row==NULL) return;

	UniSetRow(a->row);

	a->ownper=0;
	a->ownvol=0;

	while(c=UniGetByte()){

		switch(c){

			case UNI_NOTE:
			case UNI_INSTRUMENT:
				UniSkipOpcode(c);
				break;

			case UNI_PTEFFECT0:
			case UNI_PTEFFECT1:
			case UNI_PTEFFECT2:
			case UNI_PTEFFECT3:
			case UNI_PTEFFECT4:
			case UNI_PTEFFECT5:
			case UNI_PTEFFECT6:
			case UNI_PTEFFECT7:
			case UNI_PTEFFECT8:
			case UNI_PTEFFECT9:
			case UNI_PTEFFECTA:
			case UNI_PTEFFECTB:
			case UNI_PTEFFECTC:
			case UNI_PTEFFECTD:
			case UNI_PTEFFECTE:
			case UNI_PTEFFECTF:
				DoPTEffect(c-UNI_PTEFFECT0,UniGetByte());
				break;

			case UNI_S3MEFFECTD:
				DoS3MVolSlide(UniGetByte());
				break;

			case UNI_S3MEFFECTE:
				DoS3MSlideDn(UniGetByte());
				break;

			case UNI_S3MEFFECTF:
				DoS3MSlideUp(UniGetByte());
				break;

			case UNI_S3MEFFECTI:
				DoS3MTremor(UniGetByte());
				a->ownvol=1;
				break;

			case UNI_S3MEFFECTQ:
				DoS3MRetrig(UniGetByte());
				break;

			case UNI_S3MEFFECTA:
				DoS3MSpeed(UniGetByte());
				break;

			case UNI_S3MEFFECTT:
				DoS3MTempo(UniGetByte());
				break;

			default:
				UniSkipOpcode(c);
				break;
		}
	}

	if(!a->ownper){
		a->period=a->tmpperiod;
	}

	if(!a->ownvol){
		a->volume=a->tmpvolume;
	}
}




void MP_HandleTick(void)
{
	int z,t,tr;

	if(forbid) return;	// don't go any further when forbid is true

	if(MP_Ready()) return;

	if(++vbtick>=mp_sngspd){

		mp_patpos++;
		vbtick=0;

		if(patdly){
			patdly2=patdly;
			patdly=0;
		}

		if(patdly2){

			// patterndelay active

			if(--patdly2){
				mp_patpos--;	// so turn back mp_patpos by 1
			}
		}

		/* Do we have to get a new patternpointer ?
		   (when mp_patpos reaches 64 or when
		   a patternbreak is active) */

		if( mp_patpos == numrow ) posjmp=3;


		if( posjmp ){
			mp_patpos=patbrk;
			mp_sngpos+=(posjmp-2);
			patbrk=posjmp=0;
			if(mp_sngpos>=pf->numpos){
				if(!mp_loop) return;
				mp_sngpos=0;
			}
			if(mp_sngpos<0) mp_sngpos=pf->numpos-1;
		}


		if(!patdly2){

			for(t=0;t<pf->numchn;t++){

				tr=pf->patterns[(pf->positions[mp_sngpos]*pf->numchn)+t];
				numrow=pf->pattrows[pf->positions[mp_sngpos]];

				mp_channel=t;
				a=&mp_audio[t];
				a->row=(tr<pf->numtrk) ? UniFindRow(pf->tracks[tr],mp_patpos) : NULL;

				PlayNote();
			}
		}
	}

	// Update effects

	for(t=0;t<pf->numchn;t++){
		mp_channel=t;
		a=&mp_audio[t];
		PlayEffects();
	}

	for(t=0;t<pf->numchn;t++){
		a=&mp_audio[t];

		if(a->period<40) a->period=40;
		if(a->period>8000) a->period=8000;

		if(a->kick){
			MD_VoicePlay(t,a->handle,a->start,a->size,a->reppos,a->repend,a->flags);
			a->kick=0;
		}

		MD_VoiceSetVolume(t,a->volume);
		MD_VoiceSetPanning(t,pf->panning[t]);
		MD_VoiceSetFrequency(t,(3579546UL<<2)/a->period);
	}
}



void MP_Init(UNIMOD *m)
{
	int t;

	pf=m;
	reppos=0;
	repcnt=0;
	mp_sngpos=0;
	mp_sngspd=m->initspeed;

	vbtick=mp_sngspd;
	patdly=0;
	patdly2=0;
	mp_bpm=m->inittempo;

	forbid=0;
	mp_patpos=0;
	posjmp=2;		// <- make sure the player fetches the first note
	patbrk=0;

	/* Make sure the player doesn't start with garbage: */

	for(t=0;t<pf->numchn;t++){
		mp_audio[t].kick=0;
		mp_audio[t].tmpvolume=0;
		mp_audio[t].retrig=0;
		mp_audio[t].wavecontrol=0;
		mp_audio[t].glissando=0;
		mp_audio[t].soffset=0;
	}
}



int MP_Ready(void)
{
	return(mp_sngpos>=pf->numpos);
}


void MP_NextPosition(void)
{
	forbid=1;
	posjmp=3;
	patbrk=0;
	vbtick=mp_sngspd;
	forbid=0;
}


void MP_PrevPosition(void)
{
	forbid=1;
	posjmp=1;
	patbrk=0;
	vbtick=mp_sngspd;
	forbid=0;
}
