#ifndef MLOADER_H
#define MLOADER_H

#include <stdio.h>
#include "mtypes.h"



typedef struct LOADER{
	struct LOADER *next;
	char	*type;
	char 	*version;
	BOOL	(*Test)(void);
	BOOL	(*Load)(void);
	void	(*Cleanup)(void);
} LOADER;



// Function prototypes:

void ML_InfoLoader(void);
void ML_RegisterLoader(LOADER *ldr);


UNIMOD	*ML_LoadFP(FILE *fp);
UNIMOD	*ML_LoadFN(char *filename);
void 	ML_Free(UNIMOD *mf);
BOOL 	AllocSampleInfo(void);
BOOL 	InitTracks(void);
void 	AddTrack(UBYTE *tr);
BOOL 	ReadComment(UWORD len);
BOOL 	AllocPatterns(void);
BOOL 	AllocTracks(void);
char 	*DupStr(UBYTE *s,UWORD len);
void 	*MyMalloc(size_t size);
void 	*MyCalloc(size_t nitems,size_t size);

extern UNIMOD of;
extern FILE *modfp;

extern UWORD finetune[16];

#endif
