@echo off
if %1. == . goto commandLineError
if %2. == . goto noSecondParam

set MEX_INCLUDE=%2
if exist %MEX_INCLUDE%\max.mh goto maxOk
echo Can't find file: %MEX_INCLUDE%\max.mh
goto maxMhError
:noSecondParam
if exist ..\m\max.mh BUILD %1 ..\m
goto maxMhError


:maxOk
if exist %1\mex.exe goto mexOk
echo Can't find file: %1\mex.exe
goto done
:mexOk
if exist callinfo.mh goto callInfoOk
echo Can't find file: callinfo.mh
goto done
:callInfoOk

%1\mex calljump
if errorlevel 1 goto compileError
%1\mex calllist
if errorlevel 1 goto compileError
%1\mex callhdr
if errorlevel 1 goto compileError
%1\mex callindi
if errorlevel 1 goto compileError
%1\mex calldir
if errorlevel 1 goto compileError
%1\mex listdays
if errorlevel 1 goto compileError
%1\mex callstat
if errorlevel 1 goto compileError

%1\mex crithdr
if errorlevel 1 goto compileError
%1\mex critname
if errorlevel 1 goto compileError
%1\mex critcity
if errorlevel 1 goto compileError
%1\mex critgkey
if errorlevel 1 goto compileError
%1\mex critbkey
if errorlevel 1 goto compileError
%1\mex crittask
if errorlevel 1 goto compileError
%1\mex critdef
if errorlevel 1 goto compileError
%1\mex critcall
if errorlevel 1 goto compileError
%1\mex critlsec
if errorlevel 1 goto compileError
%1\mex crithsec
if errorlevel 1 goto compileError
%1\mex critbflg
if errorlevel 1 goto compileError
%1\mex critgflg
if errorlevel 1 goto compileError
%1\mecca *.mec
if errorlevel 1 goto compileError

echo.
echo Compilation completed successfully.
echo.

goto done

:commandLineError

if exist ..\mex.EXE goto clefmex
goto :nodefault
:clefmex
BUILD ..

:nodefault
echo Compiles all files necessary to run MaxHistory.
echo.
echo Syntax:
echo.
echo    BUILD [maximus directory] [mex include directories]
echo.
echo Where [maximus directory] is the name of the directory containing mecca.EXE
echo and mex.EXE, and [mex include directories] includes the directory containing
echo the file MAX.MH.
echo.
goto done

:maxMhError
echo Please pass the directory containing max.mh as the second parameter
echo to this batch file or type:
echo.
echo SET MEX_INCLUDE=[directory name]
echo.
echo before running this batch file, where [directory name] is the name
echo of the directory containing max.mh. Usually, this file is located
echo in a subdirectory of your main max directory called "m".
echo.
goto done

:compileError
echo.
echo Compilation errors were detected. These errors must be corrected
echo before you can use MaxHistory. This may indicate that your copy
echo of MaxHistory has been tampered with. For more information on
echo compile time errors, see section 14.3 of your Maximus documentation.
echo.
:done

if %2. == . goto end

set MEX_INCLUDE=

:end
