/*
 * 	File clipform.c
 */

#include <stdio.h>

#include "mgui.h"

void CloseDialogCB(MOBJECT p, void *s, void *v);

extern MTColor black, white, darkblue, cadetblue, seagreen;

MOBJECT lab1;

/*****************************************************
 *	Increments the clipping X coord by 50 pixels
 *****************************************************/
void ClipXIncCB(MOBJECT o, void *o_data, void *cform)
{
	MFormSetClipX((MOBJECT )cform, MFormGetClipX((MOBJECT )cform) + 50);
}

/*****************************************************
 *	Decrements the clipping X coord by 50 pixels
 *****************************************************/
void ClipXDecCB(MOBJECT o, void *o_data, void *cform)
{
	MFormSetClipX((MOBJECT )cform, MFormGetClipX((MOBJECT )cform) - 50);
}

/*****************************************************
 *	Increases the clipping Y coord by 50 pixels
 *****************************************************/
void ClipYIncCB(MOBJECT o, void *o_data, void *cform)
{
	MFormSetClipY((MOBJECT )cform, MFormGetClipY((MOBJECT )cform) + 100);
}

/*****************************************************
 *	Decreases the clipping Y coord by 50 pixels
 *****************************************************/
void ClipYDecCB(MOBJECT o, void *o_data, void *cform)
{
	MFormSetClipY((MOBJECT )cform, MFormGetClipY((MOBJECT )cform) - 100);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void ClippedFormCB(MOBJECT o, void *o_data, void *a_data)
{
	MOBJECT shell, form, form0, form1, cform;
	MOBJECT pbutton, sfile;

	shell = MCreateShell("Clipped Form", 0);

	form0 = MCreateColForm(shell);
	form1 = MCreateRowForm(form0);

	sfile = MCreateSFile(form0, __FILE__, FIXED_MEDIUM, 15, 54);
	MObjectSetColor(sfile, darkblue, white);

	cform = MCreateClippedForm(form1, 100, 200);

	MCreateLabel(cform, "Label inside the clipped form", TIMES_MEDIUM);
	MCreatePixmapFromFile(cform, "paulina1.bmp");

	form = MCreateColForm(form1);

	pbutton = MCreatePButton(form, "Clip_X +", TIMES_MEDIUM);
	MPButtonSetCallback(pbutton, ClipXIncCB, cform);
	pbutton = MCreatePButton(form, "Clip_X -", TIMES_MEDIUM);
	MPButtonSetCallback(pbutton, ClipXDecCB, cform);

	form = MCreateColForm(form1);

	pbutton = MCreatePButton(form, "Clip_Y +", TIMES_MEDIUM);
	MPButtonSetCallback(pbutton, ClipYIncCB, cform);
	pbutton = MCreatePButton(form, "Clip_Y -", TIMES_MEDIUM);
	MPButtonSetCallback(pbutton, ClipYDecCB, cform);

	pbutton = MCreatePButton(shell, "Close", TIMES_MEDIUM);
	MPButtonSetCallback(pbutton, CloseDialogCB, 0L);
	MObjectSetResize(pbutton, False, False);

	MShellRealize(shell);
}
