/**************************************************************************
**      METAPARSE()                                                      **
**      Version: 2.0 (06/10/93 08:30pm)                                  **
**              Parses the parameter cStr to determine seperation for    **
**      the LOCATE Procedures for Character fields. Parse() returns a    **
**      string which contains the Macro contents to be expanded via      **
**      LOCATE or FILTER.                                                **
**                                                                       **
**  Compile: clipper metapars /n                                         **
**                                                                       **
**  Author: Rod Cushman                                                  **
**          4773 S. Breton Court SE #213                                 **
**          Kentwood, MI  49508                                          **
**                  phone:  (616) 554-9563  ( leave message )            **
**                  Compuserve: 71212,1243                               **
**                                                                       **
**     Copyright notice:                                                 **
**     Copyright (c) 1992, Roderick Jay Cushman.  All rights reserved.   **
**     ----------------------------------------------------------------- **
**              You may use these functions freely so long as this and   **
**      the function headers remain intact.  You may use these functions **
**      as part of your applications so long as the functions in this    **
**      file are not sold for profit.                                    **
**                              Author        : Rod Cushman              **
**                                                                       **
**  Revision History:                                                    **
**  07/18/92 05:46pm    Rod     Upgraded code to Clipper 5.01            **
**  03/10/93 05:45pm    Rod     Submitted to CompuServe                  **
**  06/10/93 08:31pm    Rod     Submitted to PD/Shareware.               **
**************************************************************************/
Function METAPARSE
  Parameter cStr, cFName
  Local cTmp

  If cStr = NIL .or. cFName = NIL               // No string,field to expand.
     Return(".t.")
  EndIf
  cTmpStr := cStr
  If Empty(cStr) .or. Type("cStr") != "C"       // Assure Non-blank String
     Return(".t.")                              // Set Macro to default
  EndIf
  Do Case
       Case At("*",cStr) = 0      // cStr occurs at first Char,no Meta-Char
            cTmp := "At('&cStr.'"+",&cFName.) = 1"
       Case At("*",cStr) = 1           // Meta-Character at begin of string
            If Len(cStr) = 1           // User entered "*" only always true
               Return(".t.")
            EndIf
            If At("*",SubStr(cStr,2)) > 1                  // Disallow "**"
               cTmp := "At('"+SubStr(cStr,2,At("*",SubStr(cStr,2))-1) +   ;
                                             "',&cFName.)<>0"

               cTmp += If(At("*",SubStr(cStr,3)) = Len(cStr)-2,"",        ;
                       ".and.At('"+SubStr(cStr,At("*",SubStr(cStr,2))+2)  ;
                       + "',&cFName.)>" +                                 ;
                       "At('"+SubStr(cStr,2,At("*",SubStr(cStr,2))-1) +   ;
                       "',&cFName.)")
            Else
               cTmp := "At('" +SubStr(cStr,2) + "',&cFName.)<>0"
            EndIf
       Case At("*",cStr) > 1                    // A*, A*B
            cTmp := "At('"+SubStr(cStr,1,At("*",cStr)-1)+"',&cFName.)=1"
                                                     // Metachar Str = "A*"
                                               // Else Metachar Str = "A*B"
            cTmp += If(At("*",cStr) = Len(cStr),"",                      ;
                     ".and.At('"+SubStr(cStr,At("*",cStr)+1)+"',&cFName.)";
                     + ">"+ LTrim(Str( Len( SubStr(cStr, 1,               ;
                                                  At("*", cStr) - 1)))) )
       OtherWise
            cTmp := ".t."                       // Who Knows ..????
  EndCase
Return(cTmp)
