/* REXX *****/
/* trace ?r */

ret_code = RxFuncQuery( 'Load' )
if ret_code \= 0 then do
    ret_code = RxFuncAdd( 'Load', 'MERXUtil', 'Load' );
    if ret_code \= 0 then do
        say 'RxAddFunc( Load ) Failed RC='||ret_code
        exit
    end
    else
        rc=Load()
end
else
    rc=Load()

say
say 'first, we''ll test RxNTEnvSize()'
say '    there are' RxNTEnvSize() 'bytes occupying the current environment'

say
say 'press <ENTER> to continue...'
pull response

say
say 'next, we''ll list the environment variables, names only, using the'
say 'RxNTEnvKeys() function'
say
rc=RxNTEnvKeys( junk. )
do i=1 to junk.0
    say '    'junk.i
end

say
say 'press <ENTER> to continue...'
pull response

say
say 'next, we''ll list the each environment variable, name and value, using'
say 'the RxNTEnvStrs() function (just like typing "SET" at the "c" prompt)'
say
rc=RxNTEnvStrs( junk. )
do i=1 to junk.0
    say '    'junk.i
end

say
say 'press <ENTER> to continue...'
pull response

say
say 'next we''ll test the RxNTEnvVal function.  this function retrieves the'
say 'value of all environmental variables which have "PATH" in their name.'
say 'next, for each of those variables, we''re going to retrieve the value'
say 'with the RxNTEnvVal function and feed that to our ParseLine function'
say 'finally, we''ll display each of the directories that we''ve found'
say

j=0
rc=RxNTEnvKeys( junk. )
do i=1 to junk.0
    if pos( 'PATH', upper( junk.i )) > 0 then do
        j = j + 1
        save.j = junk.i
    end
end

save.0 = j

say
say 'the following environmental variables have the work "path" in them'
do i=1 to save.0
    say '    'save.i
end

say
say 'press <ENTER> to continue...'
pull response

say
say 'now we''ll look at each directory assigned to each variable'

do j=1 to save.0
    rc=ParseLine( RxNTEnvVal( save.j ), ";", junk. )
    say
    say '    env variable 'save.j':'
    do i=1 to junk.0
        say '        directory #'format( i, 2 ) '->' junk.i
    end
end

say
say 'vtest EXEC complete... BYE, NOW!!!'

exit
   b_           M  T   )    
   R]R    
   R]E    N]
  [ 
  8 ]8  $  O O]88 ]87
 ]88 
    ] ]  
  ^
  N]8  8 ]87! 8
    ] ]  
 ^
  N]8  8 ]87! 8 ]8 ]8
	  
    ] ]U 
 ^  (  
	 

 T 
 8 ]8  ] ] 
 ^
 
 N]8 8 ]87! 8 ]8	  
 '   
  8
 N N]8  ] ] 
> ^      N! O O]8  8" ]8   Load                           $    
   C    '   P       w           A                                 
      	      MERXUtilRxAddFunc( Load ) Failed RC=first, we'll test RxNTEnvSize()    there arebytes occupying the current environmentpress <ENTER> to continue...	     next, we'll list the environment variables, names only, using theRxNTEnvKeys() f
xt, we'll list the each environment variable, name and value, usingthe RxNTEnvStrs() function (just like typing "SET" at the "c" prompt)next we'll test the RxNTEnvVal function.  this function retrieves thevalue of all environmental variables which have "PATH"
 in their name.next, for each of those variables, we're going to retrieve the valuewith the RxNTEnvVal function and feed that to our ParseLine functionfinally, we'll display each of the directories that we've found 	   the following environmental
iables have the work "path" in them  now we'll look at each directory assigned to each variable    env variable         directory #vtest EXEC complete... BYE, NOW!!!RXNTENVSIZERXNTENVKEYSRXNTENVSTRSRXNTENVVALPARSELINE   RC                        SI
       J            '           -            2           8        RESULTRET_CODERESPONSEJUNK.JUNK.0JUNK.ISAVE.JSAVE.SAVE.0SAV

   A       A       E   
 
    N        N      
 R        [       & ]       K b        q       " s       
 x        |       H ~                                                 
 > & ( n  ? ?   n  @ @   y
   F F      G G   H   H H      I I     J J      L L      M M   "   N N   
   P P      Q Q   A   S S    
