/* compile as follows: cl sample1.c graphics.lib                        */

#include <stdio.h>
#include <graph.h>

#define WHITE   7
#define GRAY    8
#define YELLOW  14

/* define function prototypes                                           */                                      
int  main (void);
void DrawPlate (int d, int x, int y, int lx, int ly); 
void WaitForEntry1(void);   

int main(  )
{  
   /* let's check for Hardware....   First: VGA card...                 */
   /* this program will ONLY work with VGA cards, but you may           */
   /* _setvideomode() to another resolution if desired. The best way    */
   /* is to test for available modes, then set as desired, that will be */
   /* an exercise 'left for the reader'. Actually, contact the author if*/
   /* you need help in that area.                                       */
   
   if ( !_setvideomode( _VRES16COLOR )) 
   {          
     printf("\nSorry, could not set VGA graphics mode!!");
     printf("\nprogram requires a VGA card/monitor.");
     exit (1);
   }
   
   /* Draw the 'desktop' and place title,                               */                                        
   /* first set the background color and text windoe dimensions.        */
   _setbkcolor( _WHITE );
   _settextwindow(1,1,44,80);

   DrawPlate(0, 2, 2, 636, 476);           
   
   /* Now let's write some text.... Define color, position & text.      */
   _settextcolor( YELLOW ); 
   _settextposition( 3, 23 );
   _outtext("SAMPLE DESKTOP PROGRAM");

   /* Wait for any key to be pressed.                                   */
   WaitForEntry1();

   /* Restore video mode to default....Then quit.                       */
   _setvideomode( _DEFAULTMODE );   
   return (0);             
}


/************************************************************************/
/************************************************************************/
/*      The function DrawPlate is the key to the menu tools,            */
/*      with it, we can draw areas that appear raised or                */
/*      indented, such as buttons or 'plates'.                          */
/*      A 'button' can be drawn as raised, then indented                */
/*      when selected.                                                  */
/************************************************************************
 *  DrawPlate          3.13.94 crd     Last Mod Date:                   *
 *  Copyright Carlos R. Diaz 1994                                       *
 *  Purpose:    Draws a screen area, raised or indented.                *
 *  Calls:                                                              *
 *  Parameters: d, direction, 0 = indented                              *
 *              upper-left corner (x,y) and lengths: lx, ly             *
 *  Returns:                                                            *
 *  Includes: graph.h                                                   *
 ************************************************************************/
void DrawPlate(int d, int x, int y, int lx, int ly)
{
	short c1, c2;
	if (d) {
	c1 = 8 ;
	c2 = 15;
	} else {
	c1 = 15;
	c2 = 8 ;
	}
	_setcolor(c1);
	_moveto( x+lx, y    );
	_lineto( x   , y    );
	_lineto( x   , y+ly );
	_moveto( x+lx-1, y+1  );
	_lineto( x+1 , y+1  );
	_lineto( x+1 , y+ly-1 );
	_setcolor(c2);
	_lineto( x+lx-1, y+ly-1 );
	_lineto( x+lx-1, y+1  );
	_moveto( x+lx, y+1  );
	_lineto( x+lx, y+ly );
	_lineto( x+1 , y+ly );
}
/*######################################################################*/



/************************************************************************
 *  WaitForEntry1       3.21.94 crd     Last Mod Date:                  *
 *  Purpose: Waits for a key press                                      *                                                  
 *  Calls:                                                              *
 *  Parameters:                                                         *
 *                                                                      *
 *  Returns: key pressed (getch)                                        *
 *  Includes:                                                           *
 ************************************************************************/
void WaitForEntry1()
{
    do
    {
    } while ( !_kbhit() ) ;
}
/*#####################################################################*/


