//
//	Windows NT Console support for MicroEMACS 3.xx
//
//	April 18th, 1993 - by J. Oklamcak
//

#include <windows.h>

#define termdef 1

#include <stdio.h>
#include "estruct.h"
#include "eproto.h"
#include "edef.h"
#include "elang.h"

#if NTCON

#define NUMCOL 80	// Current columns
#define NUMROW 25	// Current rows

#define MAXCOL 256	// Maximum columns
#define MAXROW 256	// Maximum rows

#define	MARGIN 8	// size of minimim margin and
#define	SCRSIZ 64	// scroll size for extended lines
#define	NPAUSE 100	// # times thru update to pause

#define OBUFSIZE 512	// Output buffer size

//
//	Function prototypes
//

VOID PASCAL NEAR ttopen(VOID);
VOID PASCAL NEAR ttclose(VOID);
VOID PASCAL NEAR ttkopen(VOID);
VOID PASCAL NEAR ttkclose(VOID);
int PASCAL NEAR ttgetc(VOID);
VOID PASCAL NEAR ttputc(int);
VOID PASCAL NEAR ttflush(VOID);
VOID PASCAL NEAR ttmove(int, int);
VOID PASCAL NEAR tteeol(VOID);
VOID PASCAL NEAR tteeop(VOID);
VOID PASCAL NEAR ttbeep(VOID);
VOID PASCAL NEAR ttrev(int);
int PASCAL NEAR ttrez(int);
#if COLOR
VOID PASCAL NEAR ttfcol(int);
VOID PASCAL NEAR ttbcol(int);
#endif

//
//	Dispatch table for console I/O
//

TERM term =
{
	MAXROW-1,
	NUMROW-1,
	MAXCOL,
	NUMCOL,
	0, 0,
	MARGIN,
	SCRSIZ,
	NPAUSE,
	&ttopen,
	&ttclose,
	&ttkopen,
	&ttkclose,
	&ttgetc,
	&ttputc,
	&ttflush,
	&ttmove,
	&tteeol,
	&tteeop,
	&tteeop,
	&ttbeep,
	&ttrev,
	&ttrez,
#if COLOR
	&ttfcol,
	&ttbcol,
#endif
};

#define KEYTBLSIZE 22	// Keyboard table size

static WORD KeyTbl[KEYTBLSIZE][3] =
{
	{VK_LEFT,	CTRL|'B',	SPEC|'L'},
	{VK_RIGHT,	CTRL|'F',	SPEC|'R'},
	{VK_UP,		CTRL|'P',	SPEC|'U'},
	{VK_DOWN,	CTRL|'N',	SPEC|'D'},
	{VK_PRIOR,	CTRL|'Z',	CTRL|'Z'},
	{VK_NEXT,	CTRL|'V',	CTRL|'V'},
	{VK_END,	CTRL|'E',	SPEC|'E'},
	{VK_HOME,	CTRL|'A',	SPEC|'H'},
	{VK_INSERT,	CTRL|'O',	CTRL|'O'},
	{VK_DELETE,	CTRL|'D',	CTRL|'D'},
	{VK_F1,		SPEC|'1',	SPEC|'1'},
	{VK_F2,		SPEC|'2',	SPEC|'2'},
	{VK_F3,		SPEC|'3',	SPEC|'3'},
	{VK_F4,		SPEC|'4',	SPEC|'4'},
	{VK_F5,		SPEC|'5',	SPEC|'5'},
	{VK_F6,		SPEC|'6',	SPEC|'6'},
	{VK_F7,		SPEC|'7',	SPEC|'7'},
	{VK_F8,		SPEC|'8',	SPEC|'8'},
	{VK_F9,		SPEC|'9',	SPEC|'9'},
	{VK_F10,	SPEC|'0',	SPEC|'0'},
	{VK_F11,	SPEC|':',	SPEC|':'},
	{VK_F12,	SPEC|';',	SPEC|';'},
};

static int obIndex = 0;

static HANDLE hStdInp = INVALID_HANDLE_VALUE;
static HANDLE hStdOut = INVALID_HANDLE_VALUE;

static char OutBuf[OBUFSIZE];

static DWORD InpConMode;
static DWORD OutConMode;

static CONSOLE_CURSOR_INFO OutCurInfo;

VOID PASCAL NEAR ttopen(VOID)			// Open the console
{
	CONSOLE_CURSOR_INFO curInfo;
	CONSOLE_SCREEN_BUFFER_INFO conInfo;

		hStdInp = GetStdHandle(STD_INPUT_HANDLE);
		hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);

		GetConsoleMode(hStdInp, &InpConMode);
		GetConsoleMode(hStdOut, &OutConMode);

		GetConsoleCursorInfo(hStdOut, &OutCurInfo);

		SetConsoleMode(hStdInp, ENABLE_WINDOW_INPUT);
		SetConsoleMode(hStdOut, ENABLE_PROCESSED_OUTPUT);

		curInfo.dwSize = 20; // thin cursor
		curInfo.bVisible = TRUE;

		SetConsoleCursorInfo(hStdOut, &curInfo);

		GetConsoleScreenBufferInfo(hStdOut, &conInfo);

		term.t_ncol = conInfo.dwSize.X;
		term.t_nrow = conInfo.dwSize.Y-1;
}

VOID PASCAL NEAR ttclose(VOID)			// Close the console
{
		SetConsoleMode(hStdInp, InpConMode);
		SetConsoleMode(hStdOut, OutConMode);

		SetConsoleCursorInfo(hStdOut, &OutCurInfo);

		hStdInp = INVALID_HANDLE_VALUE;
		hStdOut = INVALID_HANDLE_VALUE;
}

VOID PASCAL NEAR ttkopen(VOID)			// Open keyboard
{
		// everything is done in one spot; see ttopen()
}

VOID PASCAL NEAR ttkclose(VOID)			// Close keyboard
{
		// everything is done in one spot; see ttclose()
}

int PASCAL NEAR ttgetc(VOID)			// Get character from console
{
	BOOL loopy=TRUE;
	INPUT_RECORD inRec;
	COORD winSize;
	DWORD dwCount;
	DWORD cKS;
	WORD vKC;
	BOOL ok;
	int i, ch;

		ttflush();

		while (loopy)
		{
			ok = ReadConsoleInput(hStdInp, &inRec, 1, &dwCount);

			if (ok && dwCount)
			{
				switch (inRec.EventType)
				{
					case WINDOW_BUFFER_SIZE_EVENT:

						winSize = inRec.Event.WindowBufferSizeEvent.dwSize;

						newwidth(TRUE, winSize.X);
						newsize(TRUE, winSize.Y);

						ch = (CTRL | 'L');	// force refresh

						loopy = FALSE;

						break;

					case KEY_EVENT:

						if (inRec.Event.KeyEvent.bKeyDown)
						{
							ch = inRec.Event.KeyEvent.uChar.AsciiChar;
							cKS = inRec.Event.KeyEvent.dwControlKeyState;
							vKC = inRec.Event.KeyEvent.wVirtualKeyCode;

							if (ch)
							{
								if (cKS & (LEFT_ALT_PRESSED|RIGHT_ALT_PRESSED))
								{
									ch |= ALTD;
								}

								loopy = FALSE;
							}
							else
							{
								for (i=0; i<KEYTBLSIZE; i++)
								{
									if (KeyTbl[i][0] == vKC)
									{
										if (cKS & (LEFT_CTRL_PRESSED|RIGHT_CTRL_PRESSED))
											ch = KeyTbl[i][2];
										else
											ch = KeyTbl[i][1];

										if (ch) loopy = FALSE;

										break;
									}
								}
							}
						}

						break;
				}
			}
		}

		return (ch);
}

VOID PASCAL NEAR ttputc(int ch)			// Put character into output buffer
{
		OutBuf[obIndex++] = ch;

		if (obIndex >= OBUFSIZE)
		{
			ttflush();
		}
}

VOID PASCAL NEAR ttflush(VOID)			// Flush console output buffer
{
	DWORD cWrite;

		if (obIndex)
		{
			WriteConsole(hStdOut, &OutBuf, obIndex, &cWrite, NULL);

			obIndex = 0;
		}
}

VOID PASCAL NEAR ttmove(int r, int c)	// Move to row and column
{
	COORD xyCursor;

		ttflush();

		xyCursor.X = c;
		xyCursor.Y = r;

		SetConsoleCursorPosition(hStdOut, xyCursor);
}

VOID PASCAL NEAR tteeol(VOID)			// Clear to end of line
{
	const TCHAR fillChar = ' ';
	const WORD Attrib = (FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
	CONSOLE_SCREEN_BUFFER_INFO conInfo;
	DWORD cWrite;
	int cBlank;

		GetConsoleScreenBufferInfo(hStdOut, &conInfo);

		cBlank = conInfo.dwSize.X - conInfo.dwCursorPosition.X;

		FillConsoleOutputCharacter(hStdOut, fillChar, cBlank, conInfo.dwCursorPosition, &cWrite);

		FillConsoleOutputAttribute(hStdOut, Attrib, cBlank, conInfo.dwCursorPosition, &cWrite);
}

VOID PASCAL NEAR tteeop(VOID)			// Clear to end of page
{
	const TCHAR fillChar = ' ';
	const WORD Attrib = (FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
	CONSOLE_SCREEN_BUFFER_INFO conInfo;
	DWORD cWrite;
	int cBlank;

		GetConsoleScreenBufferInfo(hStdOut, &conInfo);

		cBlank = conInfo.dwSize.X * conInfo.dwSize.Y;

		FillConsoleOutputCharacter(hStdOut, fillChar, cBlank, conInfo.dwCursorPosition, &cWrite);

		FillConsoleOutputAttribute(hStdOut, Attrib, cBlank, conInfo.dwCursorPosition, &cWrite);
}

VOID PASCAL NEAR ttbeep(VOID)			// Beep the speaker
{
		Beep(750, 250);
}

VOID PASCAL NEAR ttrev(int status)		// Set reverse status
{
	WORD Attribs;

		ttflush();

		if (status)
			Attribs = (BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE);
		else
			Attribs = (FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);

		SetConsoleTextAttribute(hStdOut, Attribs);
}

int PASCAL NEAR ttrez(int rez)			// Change screen resolution
{
		return (FALSE);
}

#if COLOR

VOID PASCAL NEAR ttfcol(int color)		// Set foreground color
{
}

VOID PASCAL NEAR ttbcol(int color)		// Set background color
{
}

#endif

#if TYPEAH

int PASCAL NEAR typahead(VOID)			// Check for type-ahead
{
//	DWORD cEvents;
//
//	Dosen't work...may need to see only keyboard events.
//
//		GetNumberOfConsoleInputEvents(hStdInp, &cEvents);
//
//		return (cEvents);

		return (0);
}

#endif

int PASCAL NEAR spal(char *pstr)		// Change palette string
{
		return (0);
}

#if FLABEL

int PASCAL NEAR fnclabel(int f, int n)	// Label a function key
{
		return (0);
}

#endif

int PASCAL NEAR execprg(int f, int n)	// Not done...
{
		return (FALSE);
}

int PASCAL NEAR filter(int f, int n)	// Not done...
{
		return (FALSE);
}

int PASCAL NEAR pipecmd(int f, int n)	// Not done...
{
		return (FALSE);
}

int PASCAL NEAR spawn(int f, int n)		// Not done...
{
		return (FALSE);
}

int PASCAL NEAR spawncli(int f, int n)	// Not done...
{
		return (FALSE);
}

char *PASCAL NEAR timeset(VOID)			// Not done...
{
		return (NULL);
}

char *PASCAL NEAR getffile(char *fspec)	// Not done...
{
		return (NULL);
}

char *PASCAL NEAR getnfile(VOID)		// Not done...
{
		return (NULL);
}

#endif
