/******************************************************************** ITEMS.H
 *                                                                          *
 *                     Display Item Class Definition                        *
 *                                                                          *
 ****************************************************************************/

#ifndef ITEMS_H
#define ITEMS_H

class Item
{
  private:
    USHORT Id ;                  // Item ID.
    BOOL   Flag ;                // Flag: Show this item at this time?
    BYTE   Name [80] ;           // Text for items profile name.
    BYTE   Label [80] ;          // Text to display on left part of line.
    BYTE   MenuOption [80] ;     // Text to display in system menu.

  protected:
    ULONG  Value ;               // Current value.

  public:
    Item ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption )
    {
      Id = id ;
      Flag = TRUE ;
      strcpy ( PCHAR(Name), PCHAR(pName) ) ;
      strcpy ( PCHAR(Label), PCHAR(pLabel) ) ;
      strcpy ( PCHAR(MenuOption), PCHAR(pMenuOption) ) ;
      Value = 0 ;
    }

    USHORT QueryId     ( void ) { return ( Id   ) ; }
    BOOL   QueryFlag   ( void ) { return ( Flag ) ; }
    PBYTE  QueryName   ( void ) { return ( Name ) ; }
    PBYTE  QueryLabel  ( void ) { return ( Label ) ; }
    PBYTE  QueryOption ( void ) { return ( MenuOption ) ; }
    ULONG  QueryValue  ( void ) { return ( Value ) ; }

    VOID SetFlag   ( void ) { Flag = TRUE ; }
    VOID ResetFlag ( void ) { Flag = FALSE ; }

    VOID Paint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      PSZ Text,
      ULONG NewValue
    ) ;

    virtual VOID Measure ( HPS hPS, RECTL &Rectangle ) ;

    virtual ULONG NewValue ( void )
    {
      return ( 0 ) ;
    }

    virtual VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    )
    {
      return ;
    }
} ;

class Clock : public Item
{
  private:
    COUNTRYINFO CountryInfo ;
    char szAm [3] ;
    char szPm [3] ;
    ResourceString *DaysOfWeek ;
    BOOL ShowSeconds ;

  public:
    Clock ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO &countryinfo, char *szam, char *szpm, class ResourceString *daysofweek, BOOL showseconds )
      : Item ( id, pName, pLabel, pMenuOption ), DaysOfWeek(daysofweek), ShowSeconds(showseconds)
    {
      CountryInfo = countryinfo ;
      strcpy ( szAm, szam ) ;
      strcpy ( szPm, szpm ) ;
    }

    VOID SetShowSeconds ( BOOL showseconds ) { ShowSeconds = showseconds ; }

    VOID Measure ( HPS hPS, RECTL &Rectangle ) ;

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class ElapsedTime : public Item
{
  private:
    COUNTRYINFO CountryInfo ;
    ResourceString *Day ;
    ResourceString *Days ;
    BOOL ShowSeconds ;

  public:
    ElapsedTime ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO &countryinfo, class ResourceString *day, class ResourceString *days, BOOL showseconds )
      : Item ( id, pName, pLabel, pMenuOption ), Day(day), Days(days), ShowSeconds(showseconds)
    {
      CountryInfo = countryinfo ;
    }

    VOID SetShowSeconds ( BOOL showseconds ) { ShowSeconds = showseconds ; }

    VOID Measure ( HPS hPS, RECTL &Rectangle ) ;

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class SwapFree : public Item
{
  private:
    COUNTRYINFO CountryInfo ;
    PSZ SwapPath ;
    ULONG MinFree ;

  public:
    SwapFree ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO &countryinfo, PSZ swappath, ULONG minfree )
      : Item ( id, pName, pLabel, pMenuOption )
    {
      CountryInfo = countryinfo ;
      SwapPath = new BYTE [ strlen(PCHAR(swappath)) + 1 ] ;
      strcpy ( PCHAR(SwapPath), PCHAR(swappath) ) ;
      MinFree = minfree ;
    }

    ~SwapFree ( void )
    {
      delete [] SwapPath ;
    }

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class MemoryFree : public Item
{
  private:
    COUNTRYINFO CountryInfo ;
    APIRET (APIENTRY *EP_get_general_info) ( struct os20memu_general_info *Buffer ) ;

  public:
    MemoryFree ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO &countryinfo )
      : Item ( id, pName, pLabel, pMenuOption ), EP_get_general_info(0)
    {
      CountryInfo = countryinfo ;
      HMODULE MemuHandle ( 0 ) ;
      if ( DosLoadModule ( 0, 0, PSZ("OS20MEMU"), &MemuHandle ) == 0 )
         DosQueryProcAddr ( MemuHandle, 0, PSZ("EP_get_general_info"), (PFN*)&EP_get_general_info ) ;
    }

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class VirtualFree : public Item
{
  private:
    COUNTRYINFO CountryInfo ;

  public:
    VirtualFree ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO &countryinfo )
      : Item ( id, pName, pLabel, pMenuOption )
    {
      CountryInfo = countryinfo ;
    }

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class SwapSize : public Item
{
  private:
    COUNTRYINFO CountryInfo ;
    PSZ SwapPath ;

  public:
    SwapSize ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO countryinfo, PSZ swappath )
      : Item ( id, pName, pLabel, pMenuOption )
    {
      CountryInfo = countryinfo ;
      SwapPath = new BYTE [ strlen(PCHAR(swappath)) + 1 ] ;
      strcpy ( PCHAR(SwapPath), PCHAR(swappath) ) ;
    }

    ~SwapSize ( void )
    {
      delete [] SwapPath ;
    }

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class SpoolSize : public Item
{
  private:
    COUNTRYINFO CountryInfo ;
    PSZ SpoolPath ;

  public:
    SpoolSize ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO &countryinfo, PSZ spoolpath )
      : Item ( id, pName, pLabel, pMenuOption )
    {
      CountryInfo = countryinfo ;
      SpoolPath = new BYTE [ strlen(PCHAR(spoolpath)) + 1 ] ;
      strcpy ( PCHAR(SpoolPath), PCHAR(spoolpath) ) ;
    }

    ~SpoolSize ( void )
    {
      delete [] SpoolPath ;
    }

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class CpuLoad : public Item
{
  private:
    PULONG IdleCount ;
    ULONG MaxCount ;

  public:
    CpuLoad ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, ULONG maxcount, PULONG idlecount )
      : Item ( id, pName, pLabel, pMenuOption )
    {
      MaxCount = maxcount ;
      IdleCount = idlecount ;
    }

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class TaskCount : public Item
{
  private:
    HAB Anchor ;

  public:
    TaskCount ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, HAB anchor )
      : Item ( id, pName, pLabel, pMenuOption )
    {
      Anchor = anchor ;
    }

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class DriveFree : public Item
{
  private:
    COUNTRYINFO CountryInfo ;
    class ResourceString *DriveError ;
    USHORT DriveNumber ;
    BOOL Error ;
    BOOL ShowFileSystemName ;
    BYTE FileSystem [80] ;
    BOOL ShowDiskLabel ;
    BYTE DiskLabel [12] ;

  public:
    DriveFree ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO &countryinfo, USHORT drivenumber, class ResourceString *driveerror, BOOL showfilesystemname, PSZ filesystem, BOOL showdisklabel, PSZ disklabel )
      : Item ( id, pName, pLabel, pMenuOption )
    {
      CountryInfo = countryinfo ;
      DriveError = driveerror ;
      DriveNumber = drivenumber ;
      Error = FALSE ;
      ShowFileSystemName = showfilesystemname ;
      strcpy ( PCHAR(FileSystem), PCHAR(filesystem) ) ;
      ShowDiskLabel = showdisklabel ;
      strcpy ( PCHAR(DiskLabel), PCHAR(disklabel) ) ;
    }

    VOID SetShowFileSystemName ( BOOL showfilesystemname ) { ShowFileSystemName = showfilesystemname ; }

    VOID SetShowDiskLabel ( BOOL showdisklabel ) { ShowDiskLabel = showdisklabel ; }

    VOID Measure ( HPS hPS, RECTL &Rectangle ) ;

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class TotalFree : public Item
{
  private:
    COUNTRYINFO CountryInfo ;
    ULONG Drives ;

  public:
    TotalFree ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO &countryinfo, ULONG drives )
      : Item ( id, pName, pLabel, pMenuOption )
    {
      CountryInfo = countryinfo ;
      Drives = drives ;
    }

    VOID ResetMask ( ULONG drives ) { Drives = drives ; }

    ULONG NewValue ( void ) ;

    VOID Repaint
    (
      HPS hPS,
      RECTL &Rectangle,
      COLOR TextColor,
      COLOR BackColor,
      BOOL Mandatory
    ) ;
} ;

class SwapSlack : public Item {
   private:
      COUNTRYINFO CountryInfo ;
      VirtualFree *pVirtualFree ;
      SwapFree    *pSwapFree ;
      MemoryFree  *pMemFree ;

   public:
      SwapSlack ( USHORT id, PSZ pName, PSZ pLabel, PSZ pMenuOption, COUNTRYINFO &countryinfo, VirtualFree *pvf, SwapFree *psf, MemoryFree *pmf )
         : Item ( id, pName, pLabel, pMenuOption ) {
         CountryInfo = countryinfo ;
         pVirtualFree = pvf ;
         pSwapFree = psf ;
         pMemFree = pmf ;
      }

      ULONG NewValue ( void ) ;

      VOID Repaint (
         HPS hPS,
         RECTL &Rectangle,
         COLOR TextColor,
         COLOR BackColor,
         BOOL Mandatory
      ) ;
} ;

#endif
