/****************************************************************** SUPPORT.H
 *                                                                          *
 *                Presentation Manager Support Functions                    *
 *                                                                          *
 ****************************************************************************/

#ifndef SUPPORT_H
#define SUPPORT_H

#define TRUE  1
#define FALSE 0

#define NOT !
#define OR  ||
#define AND &&

typedef MRESULT (APIENTRY METHODFUNCTION) ( HWND, USHORT, MPARAM, MPARAM ) ;
typedef METHODFUNCTION FAR *PMETHODFUNCTION ;

typedef struct Method
{
  USHORT Action ;
  PMETHODFUNCTION pFunction ;
}
METHOD, *PMETHOD ;

extern MRESULT DispatchMessage
(
  HWND    hwnd,
  USHORT  msg,
  MPARAM  mp1,
  MPARAM  mp2,
  PMETHOD MethodTable,
  USHORT  MethodCount,
  PFNWP   DefaultProcessor
) ;

extern VOID AddSysMenuItem ( HWND hwndFrame, MENUITEM *Item, PSZ Text ) ;

extern VOID AddSysSubMenuItem
(
  HWND hwndFrame,
  USHORT SubMenuID,
  MENUITEM *Item,
  PSZ Text
) ;

extern VOID AddMenuItem
(
  HWND hwndFrame,
  USHORT MenuID,
  MENUITEM *Item,
  PSZ Text
) ;

extern VOID AddSubMenuItem
(
  HWND hwndFrame,
  USHORT MenuID,
  USHORT SubMenuID,
  MENUITEM *Item,
  PSZ Text
) ;

extern VOID EnableMenuItem
(
  HWND hwndFrame,
  USHORT MenuID,
  USHORT Item,
  BOOL Enable
) ;

extern VOID CheckMenuItem
(
  HWND hwndFrame,
  USHORT MenuID,
  USHORT Item,
  BOOL Check
) ;

extern VOID Add2TaskList ( HWND hwnd, PSZ Name ) ;

extern METHODFUNCTION Exit ;
extern METHODFUNCTION HelpForHelp ;
extern METHODFUNCTION ExtendedHelp ;
extern METHODFUNCTION KeysHelp ;
extern METHODFUNCTION HelpIndex ;

#endif
