PROJ = MEMSIZE
PROJFILE = MEMSIZE.MAK
DEBUG = 0

PWBRMAKE  = pwbrmake
NMAKEBSC1  = set
NMAKEBSC2  = nmake
CC  = cl
CFLAGS_G  = /Alfw /W3 /G2 /D_MT /Zp /MT /BATCH
CFLAGS_D  = /qc /Gs /Gi$(PROJ).mdt /Zr /Zi /Od
CFLAGS_R  = /Ot /Oi /Ol /Oe /Og /Gs
MAPFILE_D  = NUL
MAPFILE_R  = NUL
LFLAGS_G  = /NOI /STACK:8192  /BATCH
LFLAGS_D  = /CO /INC /FAR /PACKC /PACKD /PMTYPE:PM
LFLAGS_R  = /EXE /FAR /PACKC /PACKD /PMTYPE:PM
LINKER	= link
ILINK  = ilink
LRF  = echo > NUL
RC  = rc
LLIBS_R  =  /NOD:LLIBCE LLIBCMT
LLIBS_D  =  /NOD:LLIBCE LLIBCMT
CVFLAGS  = /50

DEF_FILE  = memsize.def
OBJS  = MEMSIZE.obj SUPPORT.obj ABOUT.obj SETTIMER.obj DEBUG.obj
RESS  = MEMSIZE.res
SBRS  = MEMSIZE.sbr SUPPORT.sbr ABOUT.sbr SETTIMER.sbr DEBUG.sbr

all: $(PROJ).exe

.SUFFIXES:
.SUFFIXES: .sbr .obj .res .c .rc

MEMSIZE.obj : MEMSIZE.C debug.h support.h about.h settimer.h memsize.h\
	hrtimer.h

MEMSIZE.sbr : MEMSIZE.C debug.h support.h about.h settimer.h memsize.h\
	hrtimer.h

MEMSIZE.res : MEMSIZE.RC memsize.h

SUPPORT.obj : SUPPORT.C support.h

SUPPORT.sbr : SUPPORT.C support.h

ABOUT.obj : ABOUT.C support.h about.h

ABOUT.sbr : ABOUT.C support.h about.h

SETTIMER.obj : SETTIMER.C support.h settimer.h

SETTIMER.sbr : SETTIMER.C support.h settimer.h

DEBUG.obj : DEBUG.C debug.h hrtimer.h

DEBUG.sbr : DEBUG.C debug.h hrtimer.h


$(PROJ).bsc : $(SBRS)
	$(PWBRMAKE) @<<
$(BRFLAGS) $(SBRS)
<<

$(PROJ).exe : $(DEF_FILE) $(OBJS) $(RESS)
!IF $(DEBUG)
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
!IF $(DEBUG)
	$(ILINK) -a -e "$(LINKER) @$(PROJ).lrf" $@
!ELSE
	$(LINKER) @$(PROJ).lrf
!ENDIF
	$(RC) $(RESS) $@


.c.sbr :
!IF $(DEBUG)
	$(CC) /Zs $(CFLAGS_G) $(CFLAGS_D) /FR$@ $<
!ELSE
	$(CC) /Zs $(CFLAGS_G) $(CFLAGS_R) /FR$@ $<
!ENDIF

.c.obj :
!IF $(DEBUG)
	$(CC) /c $(CFLAGS_G) $(CFLAGS_D) /Fo$@ $<
!ELSE
	$(CC) /c $(CFLAGS_G) $(CFLAGS_R) /Fo$@ $<
!ENDIF

.rc.res :
	$(RC) /r $< $@


run: $(PROJ).exe
	$(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
	CVP $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
