:userdoc.
:title.'System Resources' Help
:body.

:h1 res=1.Introduction
:i1.Introduction
:artwork name='memsize.bmp' align=center.
:p.
This program displays several items related to system resources,
and updates the display once per second, providing it is given
CPU time to do so.  The items displayed are:
:p.
:hp2.Date/Time:ehp2. - The current date and time, in the format called for
in the default country information for your system, as specified in
the COUNTRY= entry of your CONFIG.SYS file.
:p.
:hp2.Available Memory:ehp2. - The amount of system memory
available, according to the :hp1.DosMemAvail:ehp1. function.
Under OS/2 1.x, this function supposedly reports the size of the largest
single block of free memory, although some have said that with the MEMMOVE
option turned on, that's the same as the total free memory.
Under OS/2 2.0, the true amount of unused physical memory is reported,
or 512K, whichever is larger.
There is a new function under the 32-bit API which reports how much
physical memory exists, how much is committed to the resident system
and how much is free, but since this program is a 16-bit application,
I don't have access to the function.
:p.
:hp2.Swap File Size:ehp2. - The current size of the system
virtual memory swap file, SWAPPER.DAT.
To locate the file, the file CONFIG.SYS is scanned for its SWAPPATH entry.
That entry provides the full name of the swap-file's directory and
indicates the minimum free space that must be left on the swap-file's
disk drive.
:p.
:hp2.Available Swap Space:ehp2. - The amount of free disk space on the
logical disk drive where the system swap file resides, less the mininum
free space.  This is how much more the swap file could expand, if necessary.
:p.
:hp2.Spool File Size:ehp2. - The amount of disk space consumed by spool files.
:p.
:hp2.CPU Load (%):ehp2. - The approximate percentage of the CPU's available
horsepower that's being used at the moment.  It is averaged over the previous
second.
:note.This function and PULSE do not get along with each other.
:p.
:hp2.Active Task Count:ehp2. - The number of entries in the system switch list,
which is the list displayed when you press CTRL+ESC.
:p.
:hp2.Drive X Free:ehp2. - The amount of free space on drive X.
:p.
The help facility is active, as you've already seen, and those program
commands that exist may be accessed via the window's system menu.  The
following commands are available:
:sl compact.
:li.:hpt.Save Defaults:ehpt.:hdref res=11.
:li.:hpt.Reset Defaults:ehpt.:hdref res=12.
:li.:hpt.Hide Controls:ehpt.:hdref res=13.
:li.:hpt.Set Timer Interval...:ehpt.:hdref res=14.
:li.:hpt.Display Items :ehpt.:hdref res=15.
:li.:hpt.Show Date/Time:ehpt.:hdref res=150.
:li.:hpt.Show Memory Free:ehpt.:hdref res=151.
:li.:hpt.Show Swapfile Size:ehpt.:hdref res=152.
:li.:hpt.Show Swapdisk Free:ehpt.:hdref res=153.
:li.:hpt.Show Spoolfile Size:ehpt.:hdref res=154.
:li.:hpt.Show CPU Load:ehpt.:hdref res=155.
:li.:hpt.Show Active Task Count:ehpt.:hdref res=156.
:li.:hpt.Show C: Free Space:ehpt.:hdref res=53.
:li.:hpt.About:ehpt.:hdref res=16.
:esl.:p.
In addition to those features already described, this program accepts
commands from the OS/2 2.0 Font and Color Palette programs.

:h1 res=11.Save Defaults (Menu Option)
:i1.Save Defaults (Menu Option)
When you select this menu option, the program saves its current position
and the status of the Hide Controls option.  The next time the program
is started, it will be started with that position and with the controls
hidden (or not) according to the saved state.
:p.
The short-cut key for this command is F2.

:h1 res=12.Reset Defaults (Menu Option)
:i1.Reset Defaults (Menu Option)
Selecting this menu option will reset the program's font and color
attributes to their default values.

:h1 res=13.Hide Controls (Menu Option)
:i1.Hide Controls (Menu Option)
This menu option, when selected, will cause the program's frame controls
(the system menu, the titlebar and the minimize button) to be hidden.
This option can be toggled with a double-click on either mouse button.
Also, since I saw it as very useful to be able to move the window while
the controls were hidden, the window has been set up so that you can
drag it with either mouse button.
.br
The key combination Alt+H will perform this function also.

:h1 res=14.Set Timer Interval (Menu Option)
:i1.Set Timer Interval (Menu Option)
Selecting this option will call up a dialog wherein you may set the refresh
timer interval (in tenths of a second).  The timer may be set anywhere from
10 to 300 (1-30 seconds).

:h1 res=140.Set Timer Interval (Dialog)
:i1.Set Timer Interval (Dialog)
Using the up and down buttons of the spin-button control, it is possible
here to change the screen update timer interval to anywhere from 1 second
to 30 seconds, at 1/10th second intervals.  Once you've set the interval
to your liking, either press the ENTER key or click on the OK button.  If
you have second thoughts and decide to abort the change, either press the
ESCAPE key or click on the cancel button.  Help is available by either
pressing the F1 key or by clicking on the HELP button.

:h1 res=15.Display Items  (Menu Option)
:i1.Display Items  (Menu Option)
This menu option calls up a submenu from which the different available
display items can be selected for display or de-selected from display.

:h1 res=150.Show Date/Time (Menu Option)
:i1.Show Date/Time (Menu Option)
Selecting this option will toggle whether or not the current time and date
will be displayed.  If the option is check-marked, the digital time is
currently being displayed.  When the option's state is changed, the program
window will automatically resize itself to suit the new number of displayed
items.

:h1 res=151.Show Memory Free (Menu Option)
:i1.Show Memory Free (Menu Option)
Selecting this option will toggle whether or not the amount of system memory
free is displayed.  If the option is check-marked, the free memory is being
displayed currently.  When the option's state is changed, the program window
will automatically resize itself to suit the new number of displayed items.

:h1 res=152.Show Swapfile Size (Menu Option)
:i1.Show Swapfile Size (Menu Option)
Selecting this option will toggle whether or not the swap-file's current size
is displayed.  If the option is check-marked, the file size is being displayed
currently.  When the option's state is changed, the program window will
automatically resize itself to suit the new number of displayed items.

:h1 res=153.Show Swap Space Free (Menu Option)
:i1.Show Swap Space Free (Menu Option)
Selecting this option will toggle whether or not the available swap space
is displayed.  If the option is check-marked, the free space is being
displayed at this time.  When the option's state is changed, the program
window will automatically resize itself to suit the new number of displayed
items.

:h1 res=154.Show Spoolfile Size (Menu Option)
:i1.Show Spoolfile Size (Menu Option)
Selecting this option will toggle whether or not the amount of disk space
consumed by the spooler is displayed.  If the option is check-marked, the
amount is being displayed at this time.  When the option's state is changed,
the program window will automatically resize itself to suit the new number
of displayed items.

:h1 res=155.Show CPU Load (Menu Option)
:i1.Show CPU Load (Menu Option)
Selecting this option will toggle whether or not the current CPU load is
displayed.  If the option is check-marked, the CPU load is being displayed
at this time.  When the option's state is changed, the program
window will automatically resize itself to suit the new number of displayed
items.

:h1 res=156.Show Active Task Count (Menu Option)
:i1.Show Active Task Count (Menu Option)
Selecting this option will toggle whether or not the count of active tasks is
displayed.  If the option is check-marked, the active task count is being displayed
at this time.  When the option's state is changed, the program
window will automatically resize itself to suit the new number of displayed
items.

:h1 res=16.About (Menu Option)
:i1.About (Menu Option)
This menu option, when selected, will cause the program's About dialog
to be displayed.

:h1 res=160.About (Dialog)
:i1.About (Dialog)
This dialog box displays the program name, icon and copyright information.
To exit the dialog, press the ENTER key, the SPACE bar or the ESCAPE key,
or click on the OK button with the mouse.

:h1 res=53.Show C: Free Space (Menu Option)
:i1.Show C: Free Space (Menu Option)
Selecting this option will toggle whether or not the free space on drive C:
is displayed.  If the option is check-marked, the free space is being
displayed at this time.  When the option's state is changed, the program
window will automatically resize itself to suit the new number of displayed
items.

:h1 res=99.Keys Help
:i1.Keys Help
The following function keys have been defined for this program:
:sl compact.
:li.F1 - Help
:li.F2 - Save Defaults
:li.F3 - Exit
:li.Alt+H - Hide Controls
:esl.:p.

:euserdoc.

