/******************************************************************** DEBUG.C
 *									    *
 *  Debugging Aids							    *
 *									    *
 ****************************************************************************/

#define INCL_WIN
#include <os2.h>

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "debug.h"

extern HFILE Timer = 0 ;
extern BOOL Trace = FALSE ;


/****************************************************************************
 *									    *
 *			 Display Debug Message				    *
 *									    *
 ****************************************************************************/

extern VOID Debug ( HWND hwnd, char *Message, ... )
{
 /***************************************************************************
  * Local Declarations							    *
  ***************************************************************************/

  va_list Marker ;
  char Text [500] ;

 /***************************************************************************
  * Format the debug message.						    *
  ***************************************************************************/

  va_start ( Marker, Message ) ;
  vsprintf ( Text, Message, Marker ) ;
  va_end ( Marker ) ;

 /***************************************************************************
  * Display the log message and wait for the user to press ENTER.	    *
  ***************************************************************************/

  WinMessageBox ( HWND_DESKTOP, hwnd, Text, "Debug", 0, MB_ENTER ) ;
}

/****************************************************************************
 *									    *
 *			   Log Debug Message				    *
 *									    *
 ****************************************************************************/

extern VOID Log ( char *Message, ... )
{
 /***************************************************************************
  * Local Declarations							    *
  ***************************************************************************/

  FILE *Log ;
  va_list Marker ;

 /***************************************************************************
  * Try to open the log file.  If unsuccessful, just return.		    *
  ***************************************************************************/

  Log = fopen ( "LOG", "at" ) ;

  if ( Log == NULL )
    return ;

 /***************************************************************************
  * Format and write the message to the log file.			    *
  ***************************************************************************/

  va_start ( Marker, Message ) ;
  vfprintf ( Log, Message, Marker ) ;
  va_end ( Marker ) ;

 /***************************************************************************
  * Close the log file and return.					    *
  ***************************************************************************/

  fclose ( Log ) ;
}

/****************************************************************************
 *									    *
 *			    Open Timer for Use				    *
 *									    *
 ****************************************************************************/

extern BOOL OpenTimer ( VOID )
{
  USHORT Action ;

  if ( Timer )
    DosClose ( Timer ) ;

  if ( DosOpen ( "TIMER$", &Timer, &Action, 0, FILE_NORMAL, FILE_OPEN, OPEN_SHARE_DENYNONE, 0 ) )
  {
    return ( FALSE ) ;
  }

  return ( TRUE ) ;
}

/****************************************************************************
 *									    *
 *				Close Timer				    *
 *									    *
 ****************************************************************************/

extern VOID CloseTimer ( VOID )
{
  DosClose ( Timer ) ;
}

/****************************************************************************
 *									    *
 *			 Read Time from HRTIMER.SYS			    *
 *									    *
 ****************************************************************************/

extern BOOL GetTime ( PTIMESTAMP pts )
{
  USHORT ByteCount ;

  if ( DosRead ( Timer, pts, sizeof(*pts), &ByteCount ) )
    return ( FALSE ) ;

  return ( TRUE ) ;
}

/****************************************************************************
 *									    *
 *			   Calculate Elapsed Time			    *
 *									    *
 ****************************************************************************/

extern ULONG ElapsedTime ( PTIMESTAMP ptsStart, PTIMESTAMP ptsStop, PULONG pulNs )
{
  ULONG ulMsecs, ulNsecs;
  TIMESTAMP tsStart, tsStop ;

  tsStart = *ptsStart ; 		      // De-reference timestamp
					      //     structures for speed
  tsStop  = *ptsStop ;

  ulMsecs = tsStop.ulMs - tsStart.ulMs ;      // Elapsed milliseconds

  if( tsStart.ulNs > tsStop.ulNs )	      // If nanosecond overflow ...
  {
    ulNsecs = (1000000 + tsStop.ulNs) - tsStart.ulNs; // Adjust nanoseconds
    ulMsecs--;					      // Adjust milliseconds
  }
  else
    ulNsecs = tsStop.ulNs - tsStart.ulNs ;    // No overflow..Elapsed nanos

  *pulNs = ulNsecs ;

  return ( ulMsecs ) ;
}

/****************************************************************************
 *									    *
 *  Allocate Memory							    *
 *									    *
 ****************************************************************************/

extern PVOID AllocateMemory ( USHORT ByteCount )
{
  #ifdef ALLOCATE_THROUGH_DOS
  {
    SEL Selector ;
    DosAllocSeg ( ByteCount, &Selector, SEG_NONSHARED ) ;
    return ( MAKEP ( Selector, 0 ) ) ;
  }
  #else
  {
    return ( malloc ( ByteCount ) ) ;
  }
  #endif
}

/****************************************************************************
 *									    *
 *  Free Memory 							    *
 *									    *
 ****************************************************************************/

extern VOID FreeMemory ( PVOID Memory )
{
  #ifdef ALLOCATE_THROUGH_DOS
  {
    DosFreeSeg ( SELECTOROF ( Memory ) ) ;
  }
  #else
  {
    free ( Memory ) ;
  }
  #endif
}
