// MemoGET.prg
//
// Date   : 7/31/93
// Author : Shaun Botha (CompuServe ID: 70043, 2641)
// Purpose: Provide 'GET'ting of memo field
// Compile: Clipper MEMOGET /n/m/w/l
//
// Notes  : The 'GET' displays only the first thirteen characters of the memo
//          field - actually it's 15 but I put delimiters ("<>") around the
//          field.
//
//          I'm using ALT_ENTER to indicate that we wish to edit the
//          memo but you can easily change this by modifying the '#define'
//
//          By default the reader uses it's own editor function for editing
//          the memo.  You can set your own by including the 'editor ...'
//          statement as part of the GET.  Note that the editor function
//          receives parameters as follows:
//              cMemo     : The memo
//              t, l, b, r: Coordinates of the window as specified in the
//                          GET statement
//          The editor function _must_ return the memo - it is not passed by
//          reference !
//
// Should you make modifications to this please let me know so that I and
// others can be kept updated

#include "inkey.ch"
#include "getexit.ch"
#include "memoget.ch"


// Provide a reader for the 'ghost' field (representation of the memo)
// Pretty much the same as Clipper's 'GetReader'
procedure memoReader(get)
    if ( getPreValidate(get) )
		get:SetFocus()

		while ( get:exitState == GE_NOEXIT )
			if ( get:typeOut )
				get:exitState := GE_ENTER
			end

			while ( get:exitState == GE_NOEXIT )
                memoRdrApplyKey( get, Inkey(0) )
			end

			if ( !GetPostValidate(get) )
				get:exitState := GE_NOEXIT
			end
		end
		get:KillFocus()
    end
return


// Apply keystrokes to the 'ghost' field
procedure memoRdrApplyKey(get, key)
    local bKeyBlock, cMemo

    if ( (bKeyBlock := setKey(key)) <> NIL )
        getDoSetKey(bKeyBlock, get)
        return
    end

	do case
        case ( key == K_UP )
            get:exitState := GE_UP

        case ( key == K_SH_TAB )
            get:exitState := GE_UP

        case ( key == K_DOWN )
            get:exitState := GE_DOWN

        case ( key == K_TAB )
            get:exitState := GE_DOWN

        case ( key == K_ENTER )
            get:exitState := GE_ENTER

        case ( key == K_ESC )
            if ( Set(_SET_ESCAPE) )
                get:undo()
                get:exitState := GE_ESCAPE
            end

        case ( key == K_PGUP )
            get:exitState := GE_WRITE

        case ( key == K_PGDN )
            get:exitState := GE_WRITE

        case ( key == K_CTRL_HOME )
            get:exitState := GE_TOP


    #ifdef CTRL_END_SPECIAL

        // both ^W and ^End go to the last GET
        case (key == K_CTRL_END)
            get:exitState := GE_BOTTOM

    #else

        // both ^W and ^End terminate the READ (the default)
        case (key == K_CTRL_W)
            get:exitState := GE_WRITE

    #endif
    
        case (key == K_INS)
            Set( _SET_INSERT, !Set(_SET_INSERT) )

        // This is where it all takes place
        case (key == K_ACT_MEMO)
            // Grab current value of memo field
            cMemo := eval(get:cargo[1])

            // Edit the memo
            if( empty(get:cargo[3]) )
                // Use default editor
                cMemo := defMemoEditor(cMemo, get:cargo[2,1], get:cargo[2,2],;
                                              get:cargo[2,3], get:cargo[2,4])
            else
                // Use custom editor
                cMemo := eval(get:cargo[3],;
                                    cMemo, get:cargo[2,1], get:cargo[2,2],;
                                    get:cargo[2,3], get:cargo[2,4])
            endif

            // Assign edited memo back to variable
            eval(get:cargo[1], cMemo)

            // Redisplay the 'ghost' field
            // In order to display properly we'll need to remove focus, display
            // and then redisplay again - try commenting out the '..focus'
            // lines to see what happens <g>!!
            get:killFocus()
            get:display()
            get:setFocus()
    endcase
return


// Default editor for 'GET'ted (or is that 'GOT') memos
static function defMemoEditor(cMemo,t,l,b,r)
    local s
    local row, col, clr, curs

    // Save screen environment
    s := saveScreen(t,l,b,r)
    row := row()
    col := col()
    clr := setColor()
    curs := setCursor()

    cMemo := memoEdit(cMemo, t, l, b, r)

    // Restore screen environment
    setPos(row, col)
    setColor(clr)
    setCursor(curs)
    restScreen(t,l,b,r, s)
return cMemo
