/*
 * This file is part of the M-Edit program (Copyright 1996 by Vincenzo Morello)
 * Permission to use is hereby granted for any purpose.
 */

#if !defined UNIX
#include <sys\stat.h>
#include <dir.h>
#define MAXPATHLEN	MAXPATH
#define MAXFNAMELEN	(MAXFILE+MAXEXT)
#define EXT		"*.*"
#else
#include <sys/stat.h>
#define MAXPATHLEN	128
#define MAXFNAMELEN	64
#define EXT		"*"
#endif

#define MEDIT_TITLE	"MEdit 1.2"
#define MAX_N_WINDOW	8
#define UNDO_DEPTH	4

typedef struct _undo_data {
	char	*oldtext;
	char	*newtext;
	int	start;
	int	oldlen;
	int	newlen;
	struct _undo_data *next;
	struct _undo_data *prev;
} UNDO_DATA;

typedef struct {
	char		filename[MAXFNAMELEN];
	char		pathname[MAXPATHLEN];
	char		*search_text;
	char		*replace_text;
	MOBJECT		curs_x_label;
	MOBJECT		curs_y_label;
	MOBJECT		fname_label;
	MOBJECT		modified_label;
	MOBJECT		edit;
	UNDO_DATA	*first_undo;
	UNDO_DATA	*curr_undo;
	PULLDOWN_ITEM	selected_font;
	int		undo_level;
	int		read_only;
	unsigned char	modified;
	unsigned char	ignore_case;
} FILE_DATA;
