//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
//
#include "mdl.h"

// NOTE: the unknowns here may be now found out by looking at some of
// carmack's utilities source
// ALSO: This doesn't read flame mld's yet

void read_mdl(FILE *in, MDL_FILE *m)
{
	int i,j,k;

	fread(&mdl.filetype,4,1,in);
	fread(&mdl.version,4,1,in);
	fread(&mdl.xscale,4,1,in);
	fread(&mdl.yscale,4,1,in);
	fread(&mdl.zscale,4,1,in);
	fread(&mdl.xoffset,4,1,in);
	fread(&mdl.yoffset,4,1,in);
	fread(&mdl.zoffset,4,1,in);
	fread(&mdl.radius,4,1,in);
	fread(&mdl.f1,4,1,in);
	fread(&mdl.f2,4,1,in);
	fread(&mdl.f3,4,1,in);
	fread(&mdl.num_items,4,1,in);
	fread(&mdl.bitmapw,4,1,in);
	fread(&mdl.bitmaph,4,1,in);
	fread(&mdl.num_vertices,4,1,in);
	fread(&mdl.num_triangles,4,1,in);
	fread(&mdl.num_frames,1,4,in);
	fread(&mdl.blank,1,4,in);
	printf("v:%d t:%d f:%d b:%d\n",mdl.num_vertices,mdl.num_triangles,mdl.num_frames,mdl.blank);
	fread(&mdl.unkn1,4,1,in);
	fread(&mdl.unkn2,4,1,in);
	printf("reading bitmap\n");
	mdl.bitmap = new (unsigned char)[mdl.bitmapw*mdl.bitmaph*mdl.num_items];

	for(k=0;k<mdl.num_items;k++)
	{
		fseek(in,4,SEEK_CUR);

		for(j=0;j<mdl.bitmaph;j++)
		{
			for(i=0;i<mdl.bitmapw;i++)
			{
				fread(mdl.bitmap+(i+mdl.bitmapw*(j+k*mdl.bitmaph)),1,1,in);
			}
		}
	}

	mdl.vertex = new (unsigned)[mdl.num_vertices*3];

	for(i=0;i<mdl.num_vertices;i++)
	{
		fread(mdl.vertex+i*3,4,1,in);
		fread(mdl.vertex+i*3+1,4,1,in);
		fread(mdl.vertex+i*3+2,4,1,in);
	}
	mdl.triangle = new (unsigned)[mdl.num_triangles*4];

	for(i=0;i<mdl.num_triangles;i++)
	{
		fread(mdl.triangle+i*4,4,1,in);
		fread(mdl.triangle+i*4+1,4,1,in);
		fread(mdl.triangle+i*4+2,4,1,in);
		fread(mdl.triangle+i*4+3,4,1,in);

	}
	mdl.frame = new (struct vframe)[mdl.num_frames];
	printf("reading frame data...\n");
// note:: this section does not 100% correctly work yet, wait till next version
	fread(&mdl.frame[0].atype,4,1,in);
	if(mdl.frame[0].atype!=0)
		{
			fread(&mdl.frame[0].anims,4,1,in);
			printf("anims %d \n",mdl.frame[j].anims);
			fread(&mdl.frame[0].n1,4,1,in);
			printf("n1 %d \n",mdl.frame[j].n1);
			fread(&mdl.frame[0].n2,4,1,in);
			printf("n2 %d \n",mdl.frame[j].n2);
			mdl.frame[0].n3=new (unsigned char)[mdl.frame[0].anims*4];
			for(i=0;i<mdl.num_vertices;i++)
			{
				fread(mdl.frame[0].n3+i*4  ,1,1,in);
				fread(mdl.frame[0].n3+i*4+1,1,1,in);
				fread(mdl.frame[0].n3+i*4+2,1,1,in);
				fread(mdl.frame[0].n3+i*4+3,1,1,in);

			}

		fread(&mdl.frame[0].atype,4,1,in);
		}

	for(j=0; j<mdl.num_frames;  j++)
	{
		//fread(type,4,1,in);
		if(j!=0) fread(&mdl.frame[j].atype,4,1,in);
//		printf("type %d \n",mdl.frame[j].atype);
		fread(mdl.frame[j].minbound,1,3,in);
		fread(&mdl.frame[j].unknown1,1,1,in);
		fread(mdl.frame[j].maxbound,1,3,in);
		fread(&mdl.frame[j].unknown2,1,1,in);
		fread(&mdl.frame[j].name,16,1,in);
		mdl.frame[j].v = new (unsigned char)[mdl.num_vertices*4];
		for(i=0;i<mdl.num_vertices;i++)
		{
			fread(mdl.frame[j].v+i*4  ,1,1,in);
			fread(mdl.frame[j].v+i*4+1,1,1,in);
			fread(mdl.frame[j].v+i*4+2,1,1,in);
			fread(mdl.frame[j].v+i*4+3,1,1,in);
		}

	}
//	getch();

}



void write_mdl(FILE *out, MDL_FILE *m)
{
	unsigned i,j,k;
	unsigned empty=0;

	fwrite(mdl.filetype,4,1,out);
	fwrite(&mdl.version,4,1,out);
	fwrite(&mdl.xscale,4,1,out);
	fwrite(&mdl.yscale,4,1,out);
	fwrite(&mdl.zscale,4,1,out);
	fwrite(&mdl.xoffset,4,1,out);
	fwrite(&mdl.yoffset,4,1,out);
	fwrite(&mdl.zoffset,4,1,out);
	fwrite(&mdl.radius,4,1,out);
	fwrite(&mdl.f1,4,1,out);
	fwrite(&mdl.f2,4,1,out);
	fwrite(&mdl.f3,4,1,out);

	fwrite(&mdl.num_items,4,1,out);
	fwrite(&mdl.bitmapw,4,1,out);
	fwrite(&mdl.bitmaph,4,1,out);
	fwrite(&mdl.num_vertices,4,1,out);
	fwrite(&mdl.num_triangles,4,1,out);
	fwrite(&mdl.num_frames,4,1,out);
	fwrite(&mdl.blank,4,1,out);
	fwrite(&mdl.unkn1,4,1,out);
	fwrite(&mdl.unkn2,4,1,out);

	for(k=0;k<mdl.num_items;k++)
	{
		fputc(0,out);
		fputc(0,out);
		fputc(0,out);
		fputc(0,out);

		for(j=0;j<mdl.bitmaph;j++)
		{
			for(i=0;i<mdl.bitmapw;i++)
			{
				fputc(mdl.bitmap[(i+mdl.bitmapw*(j+k*mdl.bitmaph))],out);
			}
		}
	}


	for(i=0;i<mdl.num_vertices;i++)
	{
		fwrite(mdl.vertex+i*3L,4,1,out);
		fwrite(mdl.vertex+i*3L+1L,4,1,out);
		fwrite(mdl.vertex+i*3L+2L,4,1,out);

	}

	for(i=0;i<mdl.num_triangles;i++)
	{
		fwrite(mdl.triangle+i*4L,4,1,out);
		fwrite(mdl.triangle+i*4L+1L,4,1,out);
		fwrite(mdl.triangle+i*4L+2L,4,1,out);
		fwrite(mdl.triangle+i*4L+3L,4,1,out);
	}


	for(j=0; j<mdl.num_frames;  j++)
	{

		fwrite(&mdl.frame[j].atype,4,1,out);
		if(mdl.frame[j].atype!=0)
		{
			fwrite(&mdl.frame[j].anims,4,1,out);
			fwrite(&mdl.frame[j].n1,4,1,out);
			fwrite(&mdl.frame[j].n2,4,1,out);
			for(i=0;i<mdl.num_vertices;i++)
			{
				fwrite(mdl.frame[j].n3+i*4  ,1,1,out);
				fwrite(mdl.frame[j].n3+i*4+1,1,1,out);
				fwrite(mdl.frame[j].n3+i*4+2,1,1,out);
				fwrite(mdl.frame[j].n3+i*4+3,1,1,out);

			}
		}
		fwrite(mdl.frame[j].minbound,1,3,out);
		fwrite(&mdl.frame[j].unknown1,1,1,out);
		fwrite(mdl.frame[j].maxbound,1,3,out);
		fwrite(&mdl.frame[j].unknown2,1,1,out);
		fwrite(mdl.frame[j].name,16,1,out);
		for(i=0;i<mdl.num_vertices;i++)
		{
			fwrite(mdl.frame[j].v+i*4,1,1,out);
			fwrite(mdl.frame[j].v+i*4+1,1,1,out);
			fwrite(mdl.frame[j].v+i*4+2,1,1,out);
			fwrite(mdl.frame[j].v+i*4+3,1,1,out);
		}
	}

}

// this routine puts quake data into a format that I like for my
// matrix routines

void setup_3d_data(MDL_FILE *m)
{
	int blocks;
	int i,j,k;
	BG_3pt vect1, vect2;
	int maxn;
	// block is like a cube. a single object.
	// since each mdl frame is a single object, it is a block
	blocks=mdl.num_frames;

	block= new (BG_Block)[blocks];
	if(block==NULL) exit(1);

	for(i=0; i<blocks; i++)
	{
		block[i].num_pts=mdl.num_vertices;
		block[i].ptlist=new (BG_3pt)[block[i].num_pts+8];
		block[i].nindex=new (unsigned char)[block[i].num_pts];
		if(block[i].ptlist==NULL) exit(1);
		maxn=0;
		// read all points
		for(j=0;j<block[i].num_pts;j++)
		{
			block[i].ptlist[j].x=mdl.xscale*(mdl.frame[i].v[j*4])+mdl.xoffset;//+mdl.f1;//+mdl.f1)+mdl.xoffset;
			block[i].ptlist[j].y=mdl.yscale*(mdl.frame[i].v[j*4+1])+mdl.yoffset;//+mdl.f2;//+mdl.f2)+mdl.yoffset;
			block[i].ptlist[j].z=mdl.zscale*(mdl.frame[i].v[j*4+2])+mdl.zoffset;//+mdl.f3;//+mdl.f3)+mdl.zoffset;
			block[i].nindex[j]=mdl.frame[i].v[j*4+3];
		}
		block[i].ptlist[block[i].num_pts].x= mdl.xscale*mdl.frame[i].minbound[0]+mdl.xoffset;
		block[i].ptlist[block[i].num_pts].y= mdl.yscale*mdl.frame[i].minbound[1]+mdl.yoffset;
		block[i].ptlist[block[i].num_pts].z= mdl.zscale*mdl.frame[i].minbound[2]+mdl.zoffset;

		block[i].ptlist[block[i].num_pts+1].x= mdl.xscale*mdl.frame[i].maxbound[0]+mdl.xoffset;
		block[i].ptlist[block[i].num_pts+1].y= mdl.yscale*mdl.frame[i].maxbound[1]+mdl.yoffset;
		block[i].ptlist[block[i].num_pts+1].z= mdl.zscale*mdl.frame[i].maxbound[2]+mdl.zoffset;

		block[i].ptlist[block[i].num_pts+2].x= mdl.xscale*mdl.frame[i].minbound[0]+mdl.xoffset;
		block[i].ptlist[block[i].num_pts+2].y= mdl.yscale*mdl.frame[i].minbound[1]+mdl.yoffset;
		block[i].ptlist[block[i].num_pts+2].z= mdl.zscale*mdl.frame[i].maxbound[2]+mdl.zoffset;

		block[i].ptlist[block[i].num_pts+3].x= mdl.xscale*mdl.frame[i].minbound[0]+mdl.xoffset;
		block[i].ptlist[block[i].num_pts+3].y= mdl.yscale*mdl.frame[i].maxbound[1]+mdl.yoffset;
		block[i].ptlist[block[i].num_pts+3].z= mdl.zscale*mdl.frame[i].minbound[2]+mdl.zoffset;

		block[i].ptlist[block[i].num_pts+4].x= mdl.xscale*mdl.frame[i].minbound[0]+mdl.xoffset;
		block[i].ptlist[block[i].num_pts+4].y= mdl.yscale*mdl.frame[i].maxbound[1]+mdl.yoffset;
		block[i].ptlist[block[i].num_pts+4].z= mdl.zscale*mdl.frame[i].maxbound[2]+mdl.zoffset;

		block[i].ptlist[block[i].num_pts+5].x= mdl.xscale*mdl.frame[i].maxbound[0]+mdl.xoffset;
		block[i].ptlist[block[i].num_pts+5].y= mdl.yscale*mdl.frame[i].minbound[1]+mdl.yoffset;
		block[i].ptlist[block[i].num_pts+5].z= mdl.zscale*mdl.frame[i].minbound[2]+mdl.zoffset;

		block[i].ptlist[block[i].num_pts+6].x= mdl.xscale*mdl.frame[i].maxbound[0]+mdl.xoffset;
		block[i].ptlist[block[i].num_pts+6].y= mdl.yscale*mdl.frame[i].minbound[1]+mdl.yoffset;
		block[i].ptlist[block[i].num_pts+6].z= mdl.zscale*mdl.frame[i].maxbound[2]+mdl.zoffset;

		block[i].ptlist[block[i].num_pts+7].x= mdl.xscale*mdl.frame[i].maxbound[0]+mdl.xoffset;
		block[i].ptlist[block[i].num_pts+7].y= mdl.yscale*mdl.frame[i].maxbound[1]+mdl.yoffset;
		block[i].ptlist[block[i].num_pts+7].z= mdl.zscale*mdl.frame[i].minbound[2]+mdl.zoffset;



		block[i].num_sides=mdl.num_triangles;
		block[i].side=new (BG_Side)[block[i].num_sides];
		if(block[i].side==NULL) exit(1);

		for(j=0;j<block[i].num_sides; j++)
		{
			block[i].side[j].num_pts=3;
			if((block[i].side[j].pt=new(word)[3])==NULL) exit(1);

			block[i].side[j].pt[0]=mdl.triangle[j*4L+1L];
			block[i].side[j].pt[1]=mdl.triangle[j*4L+2L];
			block[i].side[j].pt[2]=mdl.triangle[j*4L+3L];
			// calc surface normals
			vect1=BG_SubtractPts(&block[i].ptlist[block[i].side[j].pt[1]],&block[i].ptlist[block[i].side[j].pt[0]]);
			vect2=BG_SubtractPts(&block[i].ptlist[block[i].side[j].pt[2]],&block[i].ptlist[block[i].side[j].pt[1]]);
			block[i].side[j].normal=BG_CrossProduct(&vect2,&vect1);
			BG_Normalize(&block[i].side[j].normal);
		}
	}
}
// clean up data
void delete_3d_data(MDL_FILE *m)
{
	int i,j,blocks;

	blocks=mdl.num_frames;

	for(i=0; i<blocks; i++)
	{
		delete [] block[i].ptlist;

		for(j=0;j<block[i].num_sides; j++)
		{
			delete [] block[i].side[j].pt;
		}
		delete [] block[i].side;
	}

	delete [] block;

}
