//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
//
#include "mdl.h"

GrContext *BitMapContext;


int mdl_2d(MDL_FILE *m)
{
	FILE *out;
	int i,j,k,l;
	unsigned p1,p2,p3,p4;
	int ontopof=0;
	int selectedx, selectedy, selectedindex;
	int madechanges=0;
	int loop;
	int draw_triangles=1,draw_vertices=1;
	int draw_3d=0;
	int goto_3d=0;
	int zoom_factor=2;



	BG_ClearScreen(0);
		// make room for bitmap of skins
		BitMapContext = GrCreateContext(mdl.bitmapw,mdl.bitmaph*mdl.num_items,NULL,NULL);
		GrSetContext(BitMapContext);
		for(k=0;k<mdl.num_items;k++)
		{
			for(j=0;j<mdl.bitmaph;j++)
			{
				for(i=0;i<mdl.bitmapw;i++)
				{
					BG_PutPixel(i,j+k*mdl.bitmaph,mdl.bitmap[i+(j+k*mdl.bitmaph)*mdl.bitmapw]);
				}
			}
		}
		GrSetContext(NULL);
		// draw bitmap
		GrBitBlt(NULL,0,0,BitMapContext,0,0,mdl.bitmapw-1,mdl.bitmaph-1,GrWRITE);
		BG_MouseStatus();
		//draw color map
//		for(i=0; i<256; i++)
//		{
//			for(j=0; j<32; j++) BG_PutPixel(i,j+400,cmap[i+j*256]);
//		}
		int update=1;
		int refresh=1;
		int oldx=BG_MouseX,oldy=BG_MouseY,oldr=BG_MouseRight,oldl=BG_MouseLeft;
		BG_MouseShow();
		loop=1;
		char cur_key;
		int selected=0;
		while(loop)
		{
			BG_MouseStatus();

			if(kbhit())
			{
				if((cur_key=getch())==0x0) cur_key=getch();
				 //	cur_key=getch();
				switch(cur_key)
				{
				case 27:	       	loop=0; draw_3d=0; break;
				case '3':			loop=0; draw_3d=1; break;
				case '1':			loop=0; draw_3d=2; break;
				case 'w':case 'W':  if(draw_triangles==0)draw_triangles=1;
									else draw_triangles=0; break;
				case 'v':case 'V':  if(draw_vertices==0)draw_vertices=1;
									else draw_vertices=0; break;
				case 's':case 'S':
						BG_Text("Saving",0,0,250,0);

						if((out=fopen(mdl.filename,"wb"))==NULL)
						{
							fprintf(stderr,"can't open mdl file... bye\n");
							exit(1);
						}
						rewind(out);
						//disable file saving, but it works if uncommented
						//write_mdl(out, &mdl);
						fclose(out);
						break;

				case ARROW_DOWN:    if(BG_MouseY<(BG_ScreenHeight-1)) {BG_MouseY++; BG_MouseToXY(BG_MouseX,BG_MouseY); BG_MouseStatus();} break;
				case ARROW_UP:	    if(BG_MouseY>0) {BG_MouseY--;BG_MouseToXY(BG_MouseX,BG_MouseY); BG_MouseStatus();} break;
				case ARROW_LEFT:    if(BG_MouseX>0) {BG_MouseX--;BG_MouseToXY(BG_MouseX,BG_MouseY); BG_MouseStatus();} break;
				case ARROW_RIGHT:   if(BG_MouseX<(BG_ScreenWidth-1)) {BG_MouseX++; BG_MouseToXY(BG_MouseX,BG_MouseY); BG_MouseStatus();} break;
				}
				update=1;
				refresh=1;
			}

			if((BG_MouseLeft==1)||(BG_MouseX!=oldx)||(BG_MouseY!=oldy))
			{
				oldx=BG_MouseX;
				oldy=BG_MouseY;
				oldr=BG_MouseLeft;
				update=1;
			}
			// if something changed udate changes and redraw
			if(update==1)
			{
				BG_MouseHide();
				// if moving point
				if(BG_MouseLeft==1)
				{
					//point was already selected..
					if(selected==1)
					{
						refresh=1;
						// draw over old position  (and seemed pos)
						BG_PutPixel(mdl.vertex[selectedindex*3+1],mdl.vertex[selectedindex*3+2],mdl.bitmap[mdl.vertex[selectedindex*3+1]+mdl.vertex[selectedindex*3+2]*mdl.bitmapw]);
						if(mdl.vertex[selectedindex*3]==32)
							BG_PutPixel(mdl.bitmapw/2+mdl.vertex[selectedindex*3+1],mdl.vertex[selectedindex*3+2],mdl.bitmap[mdl.bitmapw/2+mdl.vertex[selectedindex*3+1]+mdl.vertex[selectedindex*3+2]*mdl.bitmapw]);
						// store the new position
						// if on seem store..
						if((mdl.vertex[selectedindex*3]==32)&&(BG_MouseX>mdl.bitmapw/2))
						{
							mdl.vertex[selectedindex*3+1]=BG_MouseX-mdl.bitmapw/2;
							mdl.vertex[selectedindex*3+2]=BG_MouseY;
						}
						// if not on seem...
						else
						{
							mdl.vertex[selectedindex*3+1]=BG_MouseX;
							mdl.vertex[selectedindex*3+2]=BG_MouseY;
						}
					}
				}
				else selected=0;
				// redraw skin
				if(refresh)
				GrBitBlt(NULL,0,0,BitMapContext,0,0,mdl.bitmapw-1,mdl.num_items*(mdl.bitmaph-1),GrWRITE);
				//draw 2d polgon mesh
				if(draw_triangles)
				{
					int x1,x2,x3;
					for(i=0;i<mdl.num_triangles;i++)
					{
						p1=mdl.triangle[i*4+1];
						p2=mdl.triangle[i*4+2];
						p3=mdl.triangle[i*4+3];
						p4=mdl.triangle[i*4];

						x1=x2=x3=0;
						if((mdl.vertex[3*p1]==32)&&(p4==0)) x1=mdl.bitmapw/2;
						if((mdl.vertex[3*p2]==32)&&(p4==0)) x2=mdl.bitmapw/2;
						if((mdl.vertex[3*p3]==32)&&(p4==0)) x3=mdl.bitmapw/2;

						BG_Line(mdl.vertex[p1*3+1]+x1,mdl.vertex[p1*3+2],mdl.vertex[p2*3+1]+x2,mdl.vertex[p2*3+2],8);
						BG_Line(mdl.vertex[p2*3+1]+x2,mdl.vertex[p2*3+2],mdl.vertex[p3*3+1]+x3,mdl.vertex[p3*3+2],8);
						BG_Line(mdl.vertex[p3*3+1]+x3,mdl.vertex[p3*3+2],mdl.vertex[p1*3+1]+x1,mdl.vertex[p1*3+2],8);

					}
				}
				// check all vertices, if mouse is ontop of one and left
				// button is pushed, select point
				for(i=0;i<mdl.num_vertices;i++)
				{
					// not on seem
					if(mdl.vertex[i*3]!=32)
					{
						if((BG_MouseX==mdl.vertex[i*3+1])&&(BG_MouseY==mdl.vertex[i*3+2]))
						{
							if(selected==0)
							{
								ontopof=1;
								if(BG_MouseLeft){selectedindex=i;selected=1;}
							}
						}
						else ontopof=0;

					}
					//else if on seem, check back of skin too
					else
					{
						if((BG_MouseX==mdl.bitmapw/2+mdl.vertex[i*3+1])&&(BG_MouseY==mdl.vertex[i*3+2])
						||(BG_MouseX==mdl.vertex[i*3+1])&&(BG_MouseY==mdl.vertex[i*3+2]))
						{
							if(selected==0)
							{
								ontopof=1;
								if(BG_MouseLeft){selectedindex=i;selected=1; }
							}
						}
						else ontopof=0;

					}
					// draw vertices
					if(draw_vertices)
					{
						BG_PutPixel(mdl.vertex[i*3+1],mdl.vertex[i*3+2],254-4*ontopof);
						// if seemed draw here too
						if(mdl.vertex[i*3]==32)
						BG_PutPixel(mdl.bitmapw/2+mdl.vertex[i*3+1],mdl.vertex[i*3+2],254-4*ontopof);
					}


				}

				BG_MouseShow();
				update=0;
				refresh=0;
			}

		}


	GrDestroyContext(BitMapContext);



	if(draw_3d==0) return 0;
	else if(draw_3d==1) return 1;
	else return 2;  // show help screen


}