//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
#include<stdio.h>
#include<stdlib.h>
#include<conio.h>
#include<dos.h>
#include<string.h>
#include<limits.h>
#include"bg_grx.h"
//#include"bg_3d.h"
#include"bg_mouse.h"
#include<grx20.h>

struct vframe{
	int atype;
	int anims;
	int n1,n2;
	unsigned char *n3;
	unsigned char minbound[3];
	unsigned char unknown1;
	unsigned char maxbound[3];
	unsigned char unknown2;
	char name[16];
	unsigned char *v;
};

struct MDL_FILE{
	char filetype[4];
	int version;
	float xscale,yscale,zscale;
	float xoffset,yoffset,zoffset;
	float radius;
	float f1,f2,f3;
	unsigned num_items;
	unsigned bitmapw;
	unsigned bitmaph;
	unsigned num_vertices;
	unsigned num_triangles;
	unsigned num_frames;
	unsigned blank;
	float unkn1;
				unsigned unkn2;
	unsigned char *bitmap;
	unsigned int *vertex;
	unsigned int *triangle;
	struct vframe *frame;
	char filename[128];
};

extern struct MDL_FILE mdl;
extern unsigned char pal[256*3];
extern unsigned char cmap[256*32];

extern int mdl_3d(MDL_FILE *);
extern int mdl_2d(MDL_FILE *);
extern void write_mdl(FILE *out, MDL_FILE *m);
extern void read_mdl(FILE *in, MDL_FILE *m);
extern void setup_3d_data(MDL_FILE *m);
extern void delete_3d_data(MDL_FILE *m);


#define win_width 3.20
#define win_height 2.40
#define focus 2.00


#define FLAT_SHADING	0x1     // constant colour polygon
#define GOURAUD_SHADED  0x2     // Gouraud shaded polygon
#define TEXTURED        0x3  	// texture mapped polygon
#define ARROW_LEFT  75
#define ARROW_RIGHT 77
#define ARROW_UP    72
#define ARROW_DOWN  80
#define KEY_ENTER       13
#define KEY_SPACE       32
#define KEY_TAB          9               /* all i can think of */

typedef struct situation {
	BG_3pt pos;
	BG_Matrix pos_matrix;
	BG_Matrix dir_matrix;
	unsigned int ix, iy;
	};

extern BG_Block *block;
extern BG_Object *object;




