//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
//
#include "mdl.h"

// our good old mdl file data (it's extern)
// I pass the MDL_FILE to most functions, but it isn't implemented yet
// may someday be useful to have multiple mdls open
struct MDL_FILE mdl;
int mdl_keys(MDL_FILE *);

// use this stuff for command line options
#define NUM_CFG_OPTIONS 3
char *cfg_option[NUM_CFG_OPTIONS] = {"mode","driver","progspath"};
char driver[128], progspath[128];
unsigned char pal[256*3];
unsigned char cmap[256*32];
//GrContext *BitMapContext;
void OpenColorMap(char *,unsigned char *);

//----------------------------------------------------------------------

int main (int argc, char *argv[])
{
	FILE *in, *out, *qpal;
	char *in_filename,*out_filename,*filename;
	char str[256];
	char ch;
	short cur_key;
	short draw_3d=1;
	short draw_triangles=0;
	short draw_vertices=0;
	short import_file=0;
	short export_file=0;
	short show_info=0;
	unsigned i,j,k,l;
	unsigned p1,p2,p3,p4;
	int video_mode=0;
	int update=0;
	int refresh=0;
	int oldx,oldy,oldr,oldl,oldm;
	int selected=0;
	int ontopof=0;
	int selectedx, selectedy, selectedindex;
	int madechanges=0;
	int loop;
	int goto_3d=0;
	float zoom_factor=2;

	// set default values
	driver[0]=NULL;
	progspath[0]=NULL;

	clrscr();
	printf("MedDLe by Brian Martin version 1.3\n\n");

	// get config file settings
	if((in=fopen("mdl.cfg","rt"))==NULL)
	{
		fprintf(stderr,"Can't open mdl.cfg, using defaults... \n");
		fprintf(stderr,"Things probably won't work. Hit a key. \n");
		getch();
	}
	else
	{
		fprintf(stderr,"Reading mdl.cfg ...\n");
		ch=0;
		do
		{
			fscanf(in,"%s", str);
			if(feof(in)) break;
			if(str[0]=='#') {while(fgetc(in)!=0x0A);}
			else
			{
				k=0;
				for(i=0; i<NUM_CFG_OPTIONS; i++)
				{
					j=0;
					while(*(cfg_option[i]+j)!=NULL)
					{
						k=i+1;
						if(str[j]!=*(cfg_option[i]+j)) {k=0;break;}
						j++;
					}
					if(k!=0) break;
				}
				if(k==0) fprintf(stderr,"Don't understand option \"%s\" in config file. \n",str);
				else
				{
					fscanf(in,"%s", str);
					switch (k)
					{
						case 1: video_mode=atoi(str); fprintf(stderr," - setting video mode = %d\n",video_mode); break;
						case 2: strcpy(driver,str); fprintf(stderr," - setting driver = %s\n",driver);break;
						case 3: strcpy(progspath,str); fprintf(stderr," - setting progspath = %s\n",progspath);break;
					}
				}
			}
		}while(!feof(in));
		fclose(in);
	}


	// get command line options
	for (argv++, argc--; argc && **argv == '-'; argv++, argc--)
	{
		if ((*argv)[1] == 'e' && argc-- > 1)
		{
			out_filename = *++argv;
			export_file=1;
		}
		else if ((*argv)[1] == 'i' && argc-- > 1)
		{
			in_filename = *++argv;
			import_file=1;
		}

		else if ((*argv)[1] == 'm' && argc-- > 1)
			video_mode= atoi( *(++argv));

		else if ((*argv)[1] == '2')
			draw_3d = 0;

		else if ((*argv)[1] == 's')
			show_info = 1;

		else if ((*argv)[1] == 'h')
		{
			fprintf(stderr, "Usage: mdl [-h] [-2] [-s] [-e <file.bmp>] [-i <file.bmp>] [-m #] file.mdl \n");
			fprintf(stderr, "       -h  -- help screen\n");
			fprintf(stderr, "       -2  -- start in 2d view\n");
//			fprintf(stderr, "       -s  -- show header information\n");
			fprintf(stderr, "       -e  -- extract BMP file\n");
			fprintf(stderr, "       -i  -- insert BMP file\n");
			fprintf(stderr, "       -m  -- video mode\n");
			fprintf(stderr, "              0 = 320x200 (default)\n");
			fprintf(stderr, "              1-4 hi res modes\n");
			exit(1);
		}
		else
		{
			fprintf(stderr, "What is %s?  mdl -h will help you", *argv);
			exit(1);
		}
	}

	if (argc > 0)
		filename = *argv;
	else
	{
		fprintf(stderr, "mdl -h will help you", *argv);
		exit(1);
	}

	// read in mdl file

	strcpy(str,progspath);
	strcat(str,filename);
	if((in=fopen(str,"rb"))==NULL)
	{
		printf("can't open mdl file \"%s\" ...exiting\n",str);
		exit(1);
	}
	read_mdl(in, &mdl);
	strcpy(mdl.filename,filename);
	fclose(in);

	// setup 3d stuff
	setup_3d_data(&mdl);


	// read in quake colors
	BG_OpenPalette("mdl.pal",pal);
	//read color map
	OpenColorMap("mdl.map",cmap);

	// intiate graphics mode
	BG_GraphicsMode(driver,video_mode);
	// change the screen colors to the quake palette
	BG_SetPalette(pal);
	// initiate mouse
	BG_InitMouse();
	BG_MouseStatus();
	oldx=BG_MouseX;
	oldy=BG_MouseY;
	// intiate math tables
	BG_InitMath();

	BG_ClearScreen(0);
	// loop through the 3 modes (3d,2d,help)
	while(1)
	{
		if(draw_3d==1)
		{
			if((i=mdl_3d(&mdl))==0) break;
			if(i==2) draw_3d=2;
			else draw_3d=0;
		}
		if(draw_3d==2)
		{
			if((i=mdl_keys(&mdl))==0) break;
			if(i==1) draw_3d=0;
			else draw_3d=1;
		}
		else
		{
			if((i=mdl_2d(&mdl))==0) break;
			if(i==2) draw_3d=2;
			else draw_3d=1;
		}


	}
	// go back to text mode
	GrSetModeRestore(0);
	BG_TextMode();

	clrscr();



	delete [] mdl.bitmap;
	delete[] mdl.vertex;
	delete [] mdl.triangle;
	for(j=0; j<mdl.num_frames;  j++)
	{
		if(mdl.frame[j].atype!=0) delete [] mdl.frame[j].n3;
		delete [] mdl.frame[j].v;
	}
	delete [] mdl.frame;
	delete_3d_data(&mdl);

	fprintf(stderr,"\nMedDLe v1.6 1996\n  by Brian Martin\n  brian@phyast.pitt.edu\n  irc: ZombyWoof\n");
	return(0);
}

// read in the color map needed for shading
void OpenColorMap(char *mapfile,unsigned char *cm)
{
	FILE *in;
	in=fopen(mapfile,"rb");

	fread(cm,1,256*32,in);
	fclose(in);

}
// help file
int mdl_keys(MDL_FILE *m)
{
	 int loop=1;
	 int draw_3d=2;
	 int cur_key;
	 static int page=0;
	 int MAXPAGE=5;
	 int update =1;
	 BG_ClearScreen(0);


		while(loop)
		{

			if(kbhit())
			{
				if((cur_key=getch())==0x0) cur_key=getch();
			 //	cur_key=getch();
				switch(cur_key)
				{
				case 27:	       	loop=0; draw_3d=2; break;
				case '3':			loop=0; draw_3d=1; break;
				case '2':			loop=0; draw_3d=0; break;

				case ARROW_RIGHT: case ARROW_DOWN:    if(page<MAXPAGE) page+=1;
														else page=0;
														break;
				case ARROW_LEFT: case ARROW_UP:	    if(page>0) page-=1;
														else page=MAXPAGE;
														break;

				}
				update=1;
			}

		 if(update==1)
		 {
				 BG_ClearScreen(0);
				update=0;

			if(page==0)
			{
				// page 0
				BG_Text("..About MedDLe..",BG_ScreenWidth/2-60,2,250,0);

				BG_Text("MedDLe was written by Brian Martin",5,30,253,0);
				BG_Text("   (on quake/irc I am the ZombyWoof!)",5,45,253,0);
				BG_Text("",5,60,253,0);
				BG_Text("It is free-ware and the source is included.",5,75,253,0);
				BG_Text("This is NOT an id software product! ",5,90,253,0);
				BG_Text("Questions or whatever go to:",5,105,253,0);
				BG_Text("brian@phayst.pitt.edu ",5,120,253,0);
				BG_Text("http://www.phyast.pitt.edu/~brian",5,135,253,0);
				BG_Text("",5,150,253,0);
				BG_Text("I will program for food. (i.e. hire me)",5,155,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}

			else if(page==1)
			{
						// page 1
				BG_Text("..MedDLe Useful Keys..",BG_ScreenWidth/2-70,2,250,0);
				BG_Text("Key  Action",5,15,250,0);
				BG_Text("1    Brings up Help",5,30,253,0);
				BG_Text("2    Brings up (2D) Skin Editor",5,45,253,0);
				BG_Text("3    Brings up (3D) Frame Editor",5,60,253,0);
				BG_Text("Esc  Exits",5,75,253,0);
				BG_Text("These keys always work. For specifics, read on.",5,90,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}
			else if(page==2)
			{
				// page 2
				BG_Text("..MedDLe Useful Keys..",BG_ScreenWidth/2-70,2,250,0);
				BG_Text("Keys for 2D Mode",5,15,250,0);
				BG_Text("1    Brings up Help",5,30,253,0);
				BG_Text("3    Brings up (3D) Frame Editor",5,45,253,0);
				BG_Text("w    Show wireframe (triangles)",5,60,253,0);
				BG_Text("v    Show vertices",5,75,253,0);
				BG_Text("s    Saves changes",5,90,253,0);
				BG_Text("Esc  Exits",5,105,253,0);
				BG_Text("Mouse and arrow keys move cursor",5,120,253,0);
				BG_Text("Mouse Left Button grabs vertex",5,135,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}
			else if(page==3)
			{
				// page 3
				BG_Text("..MedDLe Useful Keys..",BG_ScreenWidth/2-70,2,250,0);
				BG_Text("Keys for 3D Mode",5,15,250,0);
				BG_Text("1/2    Brings up Help/(2D) Skin Editor",5,30,253,0);
				BG_Text("r    Reset View",5,45,253,0);
				BG_Text("s    Save View to file 'pic#.bmp'",5,60,253,0);
				BG_Text("l    Toggle 'move light source' mode",5,75,253,0);
				BG_Text("w    Toggle Wire Frame",5,90,253,0);
				BG_Text("f    Toggle Flat Shading",5,105,253,0);
				BG_Text("g    Toggle Gouraud Shading",5,120,253,0);
				BG_Text("t    Toggle Texture Mapping",5,135,253,0);
				BG_Text("q    Toggle Quake View (Texture & Shading)",5,150,253,0);
				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}

			else if(page==4)
			{
				// page 4
				BG_Text("..MedDLe Useful Keys..",BG_ScreenWidth/2-70,2,250,0);
				BG_Text("..MORE Keys for 3D Mode",5,15,250,0);

				BG_Text("h    Show Frame Header Info",5,30,253,0);
				BG_Text("c    Cycle Through Frames",5,45,253,0);
				BG_Text("b    Change Background Color",5,60,253,0);
				BG_Text("Up/Down    Move View Up or Down",5,75,253,0);
				BG_Text("Left/Right    Cycle Frames Forward/Backward",5,90,253,0);
				BG_Text("Esc  Exits",5,105,253,0);
				BG_Text("Move Mouse front/back + Right Button Zooms in/out",5,120,253,0);
				BG_Text("Move Mouse + Left Button Rotates Object",5,135,253,0);
				BG_Text("In 'light source mode' Move Mouse Rotates Light",5,150,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}

			else if(page==5)
			{
				// page 5
				BG_Text("..MedDLe Other Info..",BG_ScreenWidth/2-70,2,250,0);

				BG_Text("Import bitmap by command line:",5,30,253,0);
				BG_Text("mdl -i player.bmp player.mdl",5,45,253,0);
				BG_Text("Export bitmaps by command line:",5,60,253,0);
				BG_Text("mdl -e player.bmp player.mdl",5,75,253,0);
				BG_Text("Other (useless) options can be seen by typing:",5,105,253,0);
				BG_Text("mdl -h",5,120,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}


		 }


		}


	if(draw_3d==2) return 0;
	else if(draw_3d==1) return 2;
	else return 1;

}
