//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//

/*typedefs */
typedef unsigned char byte;
typedef unsigned short int  word;

#define BG_CopyInt(src,dst,lng)  asm("movl  %0,%%esi \n"             \
                            "movl  %1,%%edi \n"             \
                            "movl  %2,%%ecx \n"             \
                            "cld \n"                        \
                            "rep \n"                        \
                            "movsl (%%esi),(%%edi) \n"      \
                            : :"g" (src),"g" (dst),"g" (lng) \
                            :"esi","edi","ecx"              \
                         )
#define BG_SetInt(dst,lng,val)   asm("movl  %0,%%eax \n"             \
                            "movl  %1,%%edi \n"             \
                            "movl  %2,%%ecx \n"             \
                            "cld \n"                        \
                            "rep \n"                        \
                            "stosl %%eax,(%%edi) \n"        \
                            : :"g" (val),"g" (dst),"g" (lng) \
                            :"eax","edi","ecx"              \
                         )
#define BG_SetChar(dst,lng,val)  asm("movb  %0,%%al  \n"             \
                    "movl  %1,%%edi \n"             \
                    "movl  %2,%%ecx \n"             \
                    "cld \n"                        \
                    "rep \n"                        \
                        "stosb %%al,(%%edi) \n"         \
                    : :"g" (val),"g" (dst),"g" (lng) \
                    :"al","edi","ecx"               \
                    )


/*
#define PACKED __attribute__((packed))
typedef struct {
	char VbeSignature[4] PACKED; //should be VESA when returned
	short VbeVersion PACKED;    //0x0200=ver2; 0x0102=ver1.2
	unsigned int OemStringPtr PACKED;  //real mode address
	char Capabilities[4] PACKED;
	unsigned int VideoModePtr PACKED;
	short TotalMemory PACKED;
	short OemSoftwareRev PACKED;
	unsigned int OemVendorNamePtr PACKED;
	unsigned int OemProductNamePtr PACKED;
	unsigned int OemProductRevPtr PACKED;
	char DataSpace[222] PACKED;
	char OemData[256] PACKED;

} Vbe_InfoBlock;
typedef struct {
	//All VBE
	short ModeAttributes PACKED;
	char WinAAttributes PACKED;
	char WinBAttributes PACKED;
	short WinGranularity PACKED;
	short WinSize PACKED;
	short WinASegment PACKED;
	short WinBSegment PACKED;
	unsigned int WinFuncPtr PACKED;
    short BytesPerScanLine PACKED;
    // VBE1.2 and above
    short XResolution PACKED;
    short YResolution PACKED;
    char XCharSize PACKED;
    char YCharSize PACKED;
    char NumberOfPlanes PACKED;
    char BitsPerPixel PACKED;
    char NumberOfBanks PACKED;
    char MemoryModel PACKED;
    char BankSize PACKED;
    char NumberOfImagePages PACKED;
    char Reserved PACKED;
    // Direct Color Fields
    char RedMaskSize PACKED;
    char RedFieldPosition PACKED;
    char GreenMaskSize PACKED;
    char GreenFieldPosition PACKED;
    char BlueMaskSize PACKED;
    char BlueFieldPosition PACKED;
    char RsvdMaskSize PACKED;
    char RsvdFieldPosition PACKED;
    char DirectColorModeInfo PACKED;
    //VBE2.0 and above
    unsigned int PhysBasePtr PACKED;
    unsigned int OffScreenMemOffset PACKED;
    short OffScreenMemSize PACKED;
    char StringSpace[206] PACKED;
} Vbe_ModeInfoBlock;
*/

typedef struct {
  unsigned ModeAttributes;
  unsigned granularity,startseg,farfunc;
  short bscanline;
  short XResolution;
  short YResolution;
  short charpixels;
  unsigned bogus1,bogus2,bogus3,bogus4;
  unsigned PhysBasePtr;
  char bogus[228];
} ModeInfoBlock;

int enum {
    Std_320x200x256,
    Vesa_320x200x256,
    Vesa_360x200x256,
    Vesa_320x240x256,
    Vesa_360x240x256,
    Vesa_320x400x256,
    Vesa_360x400x256,
    Vesa_640x350x256,
    Vesa_640x400x256,
    Vesa_640x480x256,
    Vesa_800x600x256,
    Vesa_1024x768x256
    };


typedef struct BG_ScreenCoor {
  int x,y;
};
typedef struct BG_Polygon {
  int x[48];
};

//#define BG_X_SIZE         320
//#define BG_Y_SIZE         200        /* number of pixels total */
//#define BG_X_MAX          319
//#define BG_Y_MAX          199        /* number of maximum pixel */
//#define BG_X_CENTER       160
//#define BG_Y_CENTER       100        /* middle of the screen */
//#define BG_SCREEN_SIZE_CHAR 64000L       /* bytes in the colourmap */
//#define BG_SCREEN_SIZE_INT  32000L       /* ints in the colourmap */

extern unsigned BG_ScreenWidth;
extern unsigned BG_ScreenHeight;
extern unsigned BG_ScreenSize;

extern unsigned char *BG_ScreenBuffer;

typedef struct xy_point {
  int x,y;
};

extern int *BG_Start;              /* polygon's */
extern int *BG_End;                /* horizontal boundaries */

extern int BG_2DClipping;                          /* type of performed clipping */
extern int BG_TempMinY,BG_TempMaxY;                          /* vertical boundaries */

extern int *BG_0Start;  /* contains [32-G_P].[G_P] values */
extern int *BG_0End;    /* this thingie is to work faster */
extern int *BG_1Start;  /* then multidimensional array */
extern int *BG_1End;    /* hope so, */
extern int *BG_2Start;
extern int *BG_2End;

extern int *BG_RestStart[5];//={BG_0Start,BG_1Start,BG_2Start};
extern int *BG_RestEnd[5];//={BG_0End,BG_1End,BG_2End};

// FUNCTIONS

extern void BG_GraphicsMode(char *drv, int mode );
extern void BG_TextMode(void);

extern void BG_Blit(void);
extern void BG_ClearScreen(byte color);
//extern void BG_Text(word x, word y,char *string,register unsigned char color);
extern void BG_Text(char *buff, int x, int y, int front, int back);
extern void MDL_Text(word x,word y,char *string,register unsigned char color);
extern void BG_PutPixel(word X, word Y, byte color );
extern void BG_Line(int, int, int, int, int);
extern void BG_WriteBMP(FILE *, unsigned char *pal, unsigned char *pic, unsigned w, unsigned h);
extern void BG_ReadBMP(FILE *, unsigned char *pal, unsigned char *pic, unsigned *w, unsigned *h);
extern void BG_SetPalette(byte *pal);
extern void BG_OpenPalette(char *palname, unsigned char *pal);


extern void BG_Clip (int , int , int , int );

extern int BG_LineXClip(int **,int **,int);
extern int BG_LineYClip(int **,int **,int);
extern int BG_PolyXClip(int *,int *,int, int);

extern void BG_ScanLine(int *edges,int dimension,int skip);
extern void BG_InitBoarderArray(void);
extern void BG_Poly(int *edges,int length, unsigned char color);
extern void BG_GPoly(int *edges,int length);
extern void BG_TPoly(int *x,int length,unsigned char color);








/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
#define T_LOG_FOCUS 8                       /* log perspective foreshortening */
#define C_MAX_DIMENSIONS          5         /* dims in N-dimensional lines */
#define C_Z_CLIPPING_MIN         10         /* where viewing plane is */
#define C_X_CLIPPING_MIN          0         /* clipping cube */
#define C_X_CLIPPING_MAX   HW_SCREEN_X_MAX
#define C_Y_CLIPPING_MIN          0
#define C_Y_CLIPPING_MAX   HW_SCREEN_Y_MAX

int C_volume_clipping(int *from,int *to,int *vertex,int dimension,int length);

int C_line_z_clipping(int **vertex1,int **vertex2,int dimension);
int C_polygon_z_clipping(int *from,int *to,int dimension,int length);

int C_line_x_clipping(int **vertex1,int **vertex2,int dimension);
int C_line_y_clipping(int **vertex1,int **vertex2,int dimension);
int C_polygon_x_clipping(int *from,int *to,int dimension,int length);

#define M_AMBIENT              0x3          /* constant colour polygon */
#define M_SHADED               0x4          /* Gouraud shaded polygon */
#define M_TEXTURED             0x5          /* texture mapped polygon */
#define M_POLYGON_LENGTH_LIMIT  50          /* length of tmp arrays */

#define M_SIZE_EDGE_ARRAY       15          /* coordinates + colours + etc */

#define G_MAX_TUPLES            50          /* big enough? */
#define G_MAX_SHADED_TUPLES    100
#define G_MAX_TEXTURED_TUPLES  120

extern unsigned char *G_buffer;                    /* the bitmap's bits */

unsigned char *G_init_graphics(void);
void G_clear(int c);
void G_dot(int *vertex,unsigned char colour);
void G_line(int *vertex1,int *vertex2,unsigned char colour);

void G_text(int x,int y,char *string,unsigned char colour);

void G_ambient_polygon(int *edges,int length,unsigned char colour);
void G_shaded_polygon(int *edges,int length);
//void G_textured_polygon(int *edges,int length,int *O,int *u,int *v,
//                      unsigned char *texture,int log_texture_size,
//                                             int log_texture_scale
//                     );
void G_textured_polygon(int *edges,int length,
    unsigned char *texture);
void G_gtex_poly(int *edges,int length,
    unsigned char *texture);

/*********************************************************/
typedef short signed_16_bit;                /* compiler/mashine dependent */
typedef int   signed_32_bit;
typedef unsigned short unsigned_16_bit;
typedef unsigned int   unsigned_32_bit;


#define HW_SCREEN_X_SIZE         320
#define HW_SCREEN_Y_SIZE         200        /* number of pixels total */

#define HW_SCREEN_X_MAX          319
#define HW_SCREEN_Y_MAX          199        /* number of maximum pixel */

#define HW_SCREEN_X_CENTRE       160
#define HW_SCREEN_Y_CENTRE       100        /* middle of the screen */

#define HW_COLOURMAP_SIZE_CHAR 64000        /* bytes in the colourmap */
#define HW_COLOURMAP_SIZE_INT  16000        /* ints in the colourmap */


void HW_blit(void);
void HW_close_screen(void);

#define HW_KEY_ARROW_LEFT  331
#define HW_KEY_ARROW_RIGHT 333
#define HW_KEY_ARROW_UP    328
#define HW_KEY_ARROW_DOWN  336

#define HW_KEY_PLUS         43
#define HW_KEY_MINUS        45

#define HW_KEY_ENTER        13
#define HW_KEY_SPACE        32
#define HW_KEY_TAB           9              /* all i can think of */


/**********************************************************/

// 3d stuff
typedef struct BG_ZScreenCoor {
  int x,y;
  unsigned z;
};

typedef struct BG_3pt{
  double x,y,z;
  };

typedef struct BG_i3pt{
  int x,y,z;
  };

typedef struct BG_Matrix{
  double m[4][4];
  };

typedef struct BG_Side {
  word num_pts;
  word *pt;
  BG_3pt normal;
  };

typedef struct BG_Block {
  word num_pts;
  BG_3pt *ptlist;
  word num_sides;
  BG_Side *side;
  byte *nindex;
  };

typedef struct BG_OSide {
  byte type;
  byte color;
  byte *texture;
  int log_texture_size;    // log base 2 of texture size
  int log_texture_scale;   // log base 2 texture scaling
  int u_index;             // indexes of texture
  int v_index;             // orientation vectors
  BG_3pt u_vect;
  BG_3pt v_vect;
  word num_pts;
  word *pt;
  BG_3pt normal;
  };

typedef struct BG_OBlock {
  word num_sides;
  BG_OSide *side;
  word num_pts;
  BG_3pt *ptlist;
  BG_Matrix pos_matrix;
  BG_Matrix dir_matrix;
  };

typedef struct BG_Object {
  word num_blocks;
  BG_OBlock *block;

  BG_Matrix pos_matrix;
  BG_Matrix dir_matrix;
  };

extern double BG_sin[256],BG_cos[256];                /* precalculated */
extern unsigned short * BG_ZBuffer;


/*
Ŀ
                                                               
                      Misc Operations                          
                                                               

*/

extern void BG_InitZBuffer(void);
extern void BG_KillZBuffer(void);
extern void BG_ResetZBuffer(void);
extern void BG_ZPoly(BG_ZScreenCoor *,int,unsigned char);

/*
Ŀ
                                                               
                      Vector Operations                        
                                                               

*/

extern double   BG_Magnitude( BG_3pt *);        // returns mag of vector
extern double   BG_DotProduct( BG_3pt *, BG_3pt *);// returns dot prod.
extern BG_3pt   BG_CrossProduct( BG_3pt *,  BG_3pt * );
extern BG_3pt   BG_AddPts( BG_3pt *,  BG_3pt * );
extern BG_3pt   BG_SubtractPts( BG_3pt *,  BG_3pt * );
extern BG_3pt   BG_MultiplyPts( BG_3pt *,  BG_3pt * );
extern void     BG_Normalize( BG_3pt *);           // normalizes vect

/*
Ŀ
                                                               
                      Matrix Operations                        
                                                               

*/

extern void BG_IdentityMatrix( BG_Matrix * );
extern void BG_ZeroMatrix( BG_Matrix * );
extern BG_3pt BG_MatrixVector3( BG_Matrix *, BG_3pt *);
extern BG_3pt BG_VectorMatrix3( BG_3pt *,BG_Matrix * );
extern BG_3pt BG_MatrixVector4( BG_Matrix *, BG_3pt *);
extern BG_Matrix BG_MatrixMult( BG_Matrix *, BG_Matrix *);

/*
Ŀ
                               
                      3D Math Stuffs                           
                               

*/

extern void BG_InitMath(void);
extern BG_Matrix BG_Fix_Eye_Pos(BG_3pt);
extern BG_Matrix BG_Fix_Thing_Pos(BG_3pt);
extern BG_Matrix BG_Set_Trans(BG_3pt *);
extern BG_Matrix BG_CalcRx(byte);
extern BG_Matrix BG_CalcRy(byte);
extern BG_Matrix BG_CalcRz(byte);
extern BG_Matrix BG_Rotate_about(BG_Matrix *,BG_3pt *);

//*********************** 3D CLASSES ***********************************
/*
class EYE {
  double view_angle;
  double win_width;
  double win_height;
  double win_distance;
  double win_scaleX;
  double win_scaleY;
  xyz_point pos;
  xyz_point *temp_pt;
  BG_3pt *temp_vect;
  BG_Matrix *POS;
  BG_Matrix *ORI;
  BG_Matrix *SCALE;
  BG_Matrix *E_TM;
  BG_Matrix *TM;
  BG_Matrix *TEMP;

public:
  EYE()
  {
    temp_pt=(xyz_point *) new xyz_point;
    temp_vect=(BG_3pt *) new BG_3pt;
    POS=(BG_Matrix *) new BG_Matrix;
    ORI=(BG_Matrix *) new BG_Matrix;
    SCALE=(BG_Matrix *) new BG_Matrix;
    E_TM=(BG_Matrix *) new BG_Matrix;
    TM=(BG_Matrix *) new BG_Matrix;
    TEMP=(BG_Matrix *) new BG_Matrix;
  }
 ~EYE()
  {
    delete temp_pt;
    delete temp_vect;
    delete POS;
    delete ORI;
    delete SCALE;
    delete E_TM;
    delete TM;
    delete TEMP;
  }
  void set_pos(double,double,double);
  void set_ori(BG_3pt *, BG_3pt *, BG_3pt *);
  void set_window(double,double,double);
  void calc_eye_TM(void);
  void calc_TM(BG_Matrix *);
  BG_3pt *transform_pt(xyz_point *);
  void transform_pt_list(xyz_point *, word, BG_3pt *);
  void draw_side(SIDE *side, BG_3pt *pt_list, word);
};
  */
