//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//

// NOTE: much of this file comes from the great 3d tutorial 3gdpl.
// go get it and learn it.
// other stuff might be from the vga trainers
// some stuff is original
// It  used to all be original, but I ran into some bugs so copied
// and pasted from everywhere. That means the zbuffer stuff is gone,
// but shaded texture mapping is here.
//

#include <dpmi.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<dos.h>
#include<grdriver.h>
//#include<grx20.h>
#include"mdl.h"
#include<math.h>
#include<limits.h>

////grx stuff
GrFont *BG_Font;
GrContext *w1;
GrTextOption opt;

int G_start[1024];              /* polygon's */
int G_end[1024];                /* horizontal boundaries */
int G_miny,G_maxy;                          /* vertical boundaries */

#define G_P      10                         /* fixed point math prcision */
#define G_LINEAR 32                         /* linearely interpolate for */

signed_32_bit G_0_start[1024];  /* contains [32-G_P].[G_P] values */
signed_32_bit G_0_end[1024];    /* this thingie is to work faster */
signed_32_bit G_1_start[1024];  /* then multidimensional array */
signed_32_bit G_1_end[1024];    /* hope so, */
signed_32_bit G_2_start[1024];
signed_32_bit G_2_end[1024];

unsigned BG_ScreenWidth;
unsigned BG_ScreenHeight;
int BG_ClipXMin, BG_ClipYMin, BG_ClipXMax, BG_ClipYMax;       // clipping
int BG_2DClipping;                          /* type of performed clipping */


int BG_TempMinY,BG_TempMaxY;                          /* vertical boundaries */


byte MDL_Font[354]=
{
 0x00,0x00,0x00,0x00,0x00,0x00, 0x30,0x30,0x30,0x00,0x30,0x00,
 0xd8,0x90,0x00,0x00,0x00,0x00, 0x6c,0xfe,0x6c,0xfe,0x6c,0x00,
 0x7e,0xd0,0x7c,0x16,0xfc,0x00, 0xcc,0x18,0x30,0x60,0xcc,0x00,
 0x60,0x90,0x74,0xd8,0x6c,0x00, 0x30,0x20,0x00,0x00,0x00,0x00,
 0x60,0xc0,0xc0,0xc0,0x60,0x00, 0x18,0x0c,0x0c,0x0c,0x18,0x00,
 0x6c,0x38,0xfe,0x38,0x6c,0x00, 0x00,0x30,0xfc,0x30,0x00,0x00,
 0x00,0x00,0x00,0x30,0x20,0x00, 0x00,0x00,0x7c,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xc0,0x00, 0x0c,0x18,0x30,0x60,0xc0,0x00,
 0x78,0x84,0x84,0x84,0x78,0x00, 0x04,0x0c,0x14,0x04,0x04,0x00,
 0x78,0x84,0x18,0x20,0x7c,0x00, 0x78,0x04,0x38,0x04,0x78,0x00,
 0x84,0x84,0xfc,0x04,0x04,0x00, 0xfc,0x80,0xf8,0x04,0xf8,0x00,
 0x30,0x40,0xf8,0x84,0x78,0x00, 0xfc,0x04,0x08,0x10,0x10,0x00,
 0x78,0x84,0x78,0x84,0x78,0x00, 0x78,0x84,0x7c,0x08,0x30,0x00,
 0x00,0x30,0x00,0x30,0x00,0x00, 0x00,0x30,0x00,0x30,0x20,0x00,
 0x30,0x60,0xc0,0x60,0x30,0x00, 0x00,0x7c,0x00,0x7c,0x00,0x00,
 0x30,0x18,0x0c,0x18,0x30,0x00, 0x78,0xcc,0x18,0x00,0x18,0x00,
 0x78,0xcc,0xdc,0xc0,0x7c,0x00, 0x30,0x48,0x84,0xfc,0x84,0x00,
 0xf8,0x84,0xf8,0x84,0xf8,0x00, 0x7c,0x80,0x80,0x80,0x7c,0x00,
 0xf8,0x84,0x84,0x84,0xf8,0x00, 0xfc,0x80,0xf0,0x80,0xfc,0x00,
 0xfc,0x80,0xf0,0x80,0x80,0x00, 0x7c,0x80,0x84,0x84,0x7c,0x00,
 0x84,0x84,0xfc,0x84,0x84,0x00, 0x10,0x10,0x10,0x10,0x10,0x00,
 0x04,0x04,0x04,0x84,0x78,0x00, 0x84,0x88,0xf0,0x88,0x84,0x00,
 0x80,0x80,0x80,0x80,0xfc,0x00, 0x82,0xc6,0xaa,0x92,0x82,0x00,
 0x84,0xc4,0xa4,0x94,0x8c,0x00, 0x78,0x84,0x84,0x84,0x78,0x00,
 0xf8,0x84,0xf8,0x80,0x80,0x00, 0x78,0x84,0x84,0x78,0x1c,0x00,
 0xf8,0x84,0xf8,0x90,0x88,0x00, 0x7c,0x80,0x78,0x04,0xf8,0x00,
 0xfe,0x10,0x10,0x10,0x10,0x00, 0x84,0x84,0x84,0x84,0x78,0x00,
 0x84,0x84,0x84,0x48,0x30,0x00, 0x82,0x82,0x92,0xaa,0x44,0x00,
 0x84,0x48,0x30,0x48,0x84,0x00, 0x88,0x88,0x50,0x20,0x20,0x00,
 0xf8,0x10,0x20,0x40,0xf8,0x00
};



int BG_MaxX, BG_MaxY;


void BG_InitFonts(void);

#define BG_Z_MIN         10         /* where viewing plane is */
#define BG_Z_MAX         64000         /* where viewing plane is */
#define BG_RADS                  40.7436654  /* pseudo-grads into rads */
#define BG_LOG_FOCUS 8                       /* log perspective foreshortening */
#define G_LINEAR 32                         /* linearely interpolate for */

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////



// turn off graphics mode
void BG_TextMode(void)
{
//  GrDestroyContext(w1);
    GrSetMode(GR_default_text);
//  __dpmi_regs r;
//  r.x.ax=0x0003;
//  __dpmi_int(0x10, &r);

//delete G_start;              /* polygon's */
//delete G_end;                /* horizontal boundaries */
//delete G_0_start;  /* contains [32-G_P].[G_P] values */
//delete G_0_end;    /* this thingie is to work faster */
//delete G_1_start;  /* then multidimensional array */
//delete G_1_end;    /* hope so, */
//delete G_2_start;
//delete G_2_end;


}

//start graphics mode
void BG_GraphicsMode(char *drv, int a)
{

    GrSetDriver(drv);
    if(GrCurrentVideoDriver() == NULL)
    {
        printf("No graphics driver found\n");
        exit(1);
    }
    switch(a)
    {
    case 0: GrSetMode(GR_width_height_color_graphics,320,200,256); break;
    case 1: GrSetMode(GR_width_height_color_graphics,640,350,256); break;
    case 2: GrSetMode(GR_width_height_color_graphics,640,480,256); break;
    case 3: GrSetMode(GR_width_height_color_graphics,800,600,256); break;
    case 4: GrSetMode(GR_width_height_color_graphics,1024,768,256); break;
    exit(1);
    }
    BG_ScreenWidth = GrMaxX()+1;
    BG_ScreenHeight = GrMaxY()+1;
	BG_InitFonts();
    BG_ClipXMin = 0;
    BG_ClipYMin = 0;
    BG_ClipXMax = BG_ScreenWidth-1;
    BG_ClipYMax = BG_ScreenHeight-1;


}
//load in fonts


void BG_InitFonts(void)
{
	BG_Font=GrLoadFont("mdl");
//  LDVFont_big=GrLoadFont("helv38b");
//  LDVFont_sym=GrLoadFont("symb16");
    memset(&opt,0,sizeof(opt));
    opt.txo_font   = BG_Font;
    opt.txo_xalign = GR_ALIGN_LEFT;
    opt.txo_yalign = GR_ALIGN_TOP;
    opt.txo_direct    = GR_TEXT_RIGHT;
    opt.txo_fgcolor.v = GrBlack();
    opt.txo_bgcolor.v = 0;
    return;
}


//draw text
void BG_Text(char *buff, int x, int y, int front, int back)
{
    int l;
    opt.txo_fgcolor.v = front;
    opt.txo_bgcolor.v = back;
    l=strlen(buff);
    GrDrawString(buff,l,x,y,&opt);
    return;
}


void MDL_Text(word x,word y,char *string,register unsigned char color)
{
  int nm,i,j;
  unsigned char  cur;
  unsigned char  *adr,*l_adr;

  adr=G_buffer+BG_ScreenWidth*y+x;
  while(*string!='\0')
  {
    nm=((*string++)-' ');
    if(nm>58) nm-=' ';
    nm*=6;
    for(i=0,l_adr=adr;i<6;i++,l_adr+=BG_ScreenWidth)
    {
      cur=MDL_Font[nm++];
      for(j=0;j<8;j++)
      if(cur&(0x80>>j)) *(l_adr+j)=color;
    }
	adr+=8;                                   /* Next word */
  }
}



void BG_ClearScreen(byte color)
{
    GrClearScreen(color);
}
void BG_OpenPalette(char *palname, unsigned char *pal)
{
    FILE *p;
    int i,j;
    char ch;

    if((p=fopen(palname,"rt"))==NULL)
    {
        fprintf(stderr,"can't open %s ... exiting\n",palname);
		exit(1);
    }

    while(fgetc(p)!=0x0A); // read some header
    while(fgetc(p)!=0x0A); // smore header
    while(fgetc(p)!=0x0A); // this line is for # colors (better be 256)

    for(i=0;i<256;i++)
    {
        fscanf(p,"%d",&j); pal[i*3]=(unsigned char)j;
        fscanf(p,"%d",&j); pal[i*3+1]=(unsigned char)j;
        fscanf(p,"%d",&j); pal[i*3+2]=(unsigned char)j;

    }
	fclose(p);

}

void BG_PutPixel(word x, word y, byte c )
{
    GrPlot(x,y,c);
}


void BG_Line(int x1, int y1, int x2, int y2, int c)
{
    GrLine(x1,y1,x2,y2,c);
}


void BG_SetPalette(unsigned char *pal)
{
    int i;

    for(i=0;i<256;i++)
    {
        outportb(0x3c8,(byte)i);
        outportb(0x3c9,(byte)pal[i*3]/4);
        outportb(0x3c9,(byte)pal[i*3+1]/4);
        outportb(0x3c9,(byte)pal[i*3+2]/4);
    }

}


struct BMP_HEADER{

	unsigned filesize;
    short int reserved1;
    short int reserved2;
    int headersize;
    int infosize;
    int width;
    int height;
    short int planes;
    short int bits;
    int compression;
    int sizeimage;
    int xpelspermeter;
    int ypelspermeter;
    int colorsused;
    int colorsimportant;

}bmpfile;


void BG_WriteBMP(FILE *out, unsigned char *pal, unsigned char *pic, unsigned w, unsigned h)
{
    unsigned i, j;
    unsigned size;

    unsigned char *temp;
    int readsize;


    bmpfile.filesize = w*h + sizeof(bmpfile) + 1024L+2L;
    bmpfile.reserved1 = 0;
		bmpfile.reserved2 = 0;
    bmpfile.headersize =  sizeof(bmpfile) + 1024L + 2L;
    bmpfile.infosize = 40;

    bmpfile.width = w;
    bmpfile.height = h;

    bmpfile.planes = 1;
    bmpfile.compression = 0;
    bmpfile.bits = 8;
    bmpfile.xpelspermeter = 1181L;
    bmpfile.ypelspermeter = 1181L;
    bmpfile.colorsused = 256;
	bmpfile.colorsimportant = 256;

	bmpfile.sizeimage = w*h;

    fwrite("BM",2,1, out);
    fwrite(((char *)(&bmpfile)), sizeof(bmpfile), 1L, out);

    for (i = 0; i < 256; i++)
    {
        fputc(pal[i*3 + 2], out);
        fputc(pal[i*3 + 1], out);
        fputc(pal[i*3 + 0], out);
        fputc(0, out);
    }
    for(j=h;j>0;j--)
    {
        for(i=0;i<w;i++)
        {
            fwrite(pic+i+w*(j-1),1,1,out);
        }
    }

}

void BG_ReadBMP(FILE *in, unsigned char *pal, unsigned char *pic, unsigned *w, unsigned *h)
{
    unsigned i, j;
    unsigned size;
    unsigned x,y;

    char t[2];
    int readsize;
    unsigned char ch;

    rewind(in);
	fseek(in,18,SEEK_SET);
    fread(&x,4,1,in);
    fread(&y,4,1,in);
    fseek(in,28,SEEK_CUR);

    w[0]=x;
    h[0]=y;

    for (i = 0; i < 256; i++)
    {
        fread(pal+i*3 + 2,1,1,in);
        fread(pal+i*3 + 1,1,1,in);
        fread(pal+i*3 + 0,1,1,in);
        fseek(in,1,SEEK_CUR);
    }

    for(j=y;j>0;j--)
    {
        for(i=0;i<x;i++)
        {
						fread(pic+i+x*(j-1),1,1,in);
        }
    }

}


double BG_sin[256],BG_cos[256];                /* precalculated */



/*
Ŀ
                                                               
                      Misc Operations                          
                                                               

*/
int sgn (int a)
{
    if (a > 0)  return +1;
    if (a < 0)  return -1;
    return 0;
}


/*
Ŀ
                                                               
                      Vector Operations                        
                                                               

*/


double BG_DotProduct( BG_3pt *a,  BG_3pt *b )
{
    double c;
    c=a->x*b->x+a->y*b->y+a->z*b->z;
    return c;
}


BG_3pt BG_CrossProduct( BG_3pt *a,  BG_3pt *b )
{
    BG_3pt c;
	c.x=(a->y*b->z) - (a->z*b->y);
    c.y=(a->z*b->x) - (a->x*b->z);
    c.z=(a->x*b->y) - (a->y*b->x);
    return c;
}


BG_3pt BG_AddPts( BG_3pt *a,  BG_3pt *b )
{
    BG_3pt c;
    c.x=a->x + b->x;
    c.y=a->y + b->y;
    c.z=a->z + b->z;
    return c;
}

BG_3pt BG_SubtractPts( BG_3pt *a,  BG_3pt *b )
{
    BG_3pt c;
    c.x=a->x - b->x;
    c.y=a->y - b->y;
    c.z=a->z - b->z;
		return c;
}

BG_3pt BG_MultiplyPts( BG_3pt *a,  BG_3pt *b )
{
    BG_3pt c;
    c.x=a->x * b->x;
    c.y=a->y * b->y;
    c.z=a->z * b->z;
	return c;
}

double BG_Magnitude( BG_3pt *a )
{
    double mag;
    mag = BG_DotProduct(a,a);
    mag = sqrt(mag);
    return mag;
}

void BG_Normalize( BG_3pt *a )
{
    double b, c;

    b = BG_Magnitude( a );
    if ( b != 0.0 )
    {
        c = 1.0/b;
        a->x*=c;
        a->y*=c;
        a->z*=c;
    }
}


/*
Ŀ
                                                               
                      Matrix Operations                        
                                                               

*/



void BG_IdentityMatrix( BG_Matrix *a )
{
    int i, j;

    for (i=0; i<4; i++)
    {
        for (j=0; j<4; j++)
        {
            if (i==j) a->m[i][j]=1.0;
            else a->m[i][j]=0.0;
        }
    }
}

void BG_ZeroMatrix( BG_Matrix *a )
{
    int i, j;

    for (i=0; i<4; i++)
    {
        for (j=0; j<4; j++)
        {
            a->m[i][j]=0.0;
				}
    }
}

BG_3pt BG_MatrixVector3( BG_Matrix *m, BG_3pt *v )
{
    BG_3pt a;
	a.x=m->m[0][0]*v->x+m->m[0][1]*v->y+m->m[0][2]*v->z;
    a.y=m->m[1][0]*v->x+m->m[1][1]*v->y+m->m[1][2]*v->z;
	a.z=m->m[2][0]*v->x+m->m[2][1]*v->y+m->m[2][2]*v->z;
    return a;
}

BG_3pt BG_VectorMatrix3( BG_3pt *v,BG_Matrix *m )
{
    BG_3pt a;
    a.x=m->m[0][0]*v->x+m->m[1][0]*v->y+m->m[2][0]*v->z;
    a.y=m->m[0][1]*v->x+m->m[1][1]*v->y+m->m[2][1]*v->z;
    a.z=m->m[0][2]*v->x+m->m[1][2]*v->y+m->m[2][2]*v->z;
    return a;
}


BG_3pt BG_MatrixVector4( BG_Matrix *m, BG_3pt *v )
{
    BG_3pt a;
    a.x=m->m[0][0]*v->x+m->m[0][1]*v->y+m->m[0][2]*v->z+m->m[0][3];
    a.y=m->m[1][0]*v->x+m->m[1][1]*v->y+m->m[1][2]*v->z+m->m[1][3];
    a.z=m->m[2][0]*v->x+m->m[2][1]*v->y+m->m[2][2]*v->z+m->m[2][3];
    return a;
}

BG_Matrix BG_MatrixMult( BG_Matrix *a, BG_Matrix *b)
{
		int i, j, k;
    BG_Matrix c;

	for (i=0; i<4; i++)
	{
		for (j=0; j<4; j++)
		{
            c.m[i][j]=0;
			for (k=0; k<4; k++)
            {
                c.m[i][j]+=a->m[i][k]*b->m[k][j];
            }
        }
    }
    return c;
}




/*
Ŀ
                                                               
                      3D Math Stuffs                           
                                                               

*/

void BG_InitMath(void)
{
    int i;

    for(i=0;i<256;i++)
    {
				BG_sin[i]=sin(i/BG_RADS);
		BG_cos[i]=cos(i/BG_RADS);
	}
}

BG_Matrix BG_CalcRx(byte i)
{
	BG_Matrix x;
	BG_IdentityMatrix(&x);
	x.m[1][1]=BG_cos[i];
	x.m[1][2]=BG_sin[i];
	x.m[2][1]=-BG_sin[i];
	x.m[2][2]=BG_cos[i];
	return x;
}

BG_Matrix BG_CalcRy(byte i)
{
	BG_Matrix y;
	BG_IdentityMatrix(&y);
	y.m[0][0]=BG_cos[i];
	y.m[0][2]=-BG_sin[i];
	y.m[2][0]=BG_sin[i];
	y.m[2][2]=BG_cos[i];
	return y;
}
BG_Matrix BG_CalcRz(byte i)
{
	BG_Matrix z;
	BG_IdentityMatrix(&z);
	z.m[0][0]=BG_cos[i];
	z.m[0][1]=BG_sin[i];
	z.m[1][0]=-BG_sin[i];
	z.m[1][1]=BG_cos[i];
		return z;
}

//********************************************************
BG_Matrix BG_Rotate_about(BG_Matrix *A,BG_3pt *a)
{
  BG_Matrix B;

  B.m[0][0]=A->m[0][0];
  B.m[0][1]=A->m[0][1];
  B.m[0][2]=A->m[0][2];
  B.m[0][3]=-a->x*(A->m[0][0]-1)-a->y*A->m[0][1]-a->z*A->m[0][2];

  B.m[1][0]=A->m[0][0];
  B.m[1][1]=A->m[0][1];
  B.m[1][2]=A->m[0][2];
  B.m[1][3]=-a->x*A->m[0][0]-a->y*(A->m[0][1]-1)-a->z*A->m[0][2];

  B.m[2][0]=A->m[0][0];
  B.m[2][1]=A->m[0][1];
  B.m[2][2]=A->m[0][2];
  B.m[2][3]=-a->x*A->m[0][0]-a->y*A->m[0][1]-a->z*(A->m[0][2]-1);

  B.m[3][0]=0.0;
  B.m[3][1]=0.0;
  B.m[3][2]=0.0;
  B.m[3][3]=1.0;
  return B;
}

BG_Matrix BG_Set_Trans(BG_3pt *A)
{
  BG_Matrix B;
  B.m[0][0]=1;
	B.m[0][1]=0;
  B.m[0][2]=0;
  B.m[0][3]=A->x;
  B.m[1][0]=0;
  B.m[1][1]=1;
  B.m[1][2]=0;
  B.m[1][3]=A->y;
  B.m[2][0]=0;
  B.m[2][1]=0;
  B.m[2][2]=1;
  B.m[2][3]=A->z;
  B.m[3][0]=0;
  B.m[3][1]=0;
  B.m[3][2]=0;
  B.m[3][3]=1;
  return B;
}

BG_Matrix BG_Fix_Thing_Pos(BG_3pt *A)
{
  BG_Matrix B;
  B.m[0][0]=1;
  B.m[0][1]=0;
  B.m[0][2]=0;
  B.m[0][3]=A->x;  //cx
  B.m[1][0]=0;
  B.m[1][1]=1;
  B.m[1][2]=0;
  B.m[1][3]=A->y;  //-cy
  B.m[2][0]=0;
  B.m[2][1]=0;
  B.m[2][2]=1;
  B.m[2][3]=A->z;  //-cz
  B.m[3][0]=0;
	B.m[3][1]=0;
  B.m[3][2]=0;
  B.m[3][3]=1;
  return B;
}



void BG_Clip (int x1, int y1, int x2, int y2)
{
	BG_ClipXMin = x1;
	BG_ClipYMin = y1;
	BG_ClipXMax = x2;
	BG_ClipYMax = y2;
}

/*
void BG_Text(word x,word y,char *string,register unsigned char color)
{
  int nm,i,j;
  unsigned char  cur;
  unsigned char  *adr,*l_adr;

  adr=BG_ScreenBuffer+BG_ScreenWidth*y+x;         /* Where in the screen buffer */

//  while(*string!='\0')                       /* until the end of the string */
//  {
//  nm=((*string++)-' ');                     /* Starting from space */
//  if(nm>58) nm-=' ';                        /* to uppercase 58='Z'-' ' */
//  nm*=6;                                    /* 6 bytes per char */
//  for(i=0,l_adr=adr;i<6;i++,l_adr+=BG_ScreenWidth)
//  {
//    cur=BG_Font[nm++];
//    for(j=0;j<8;j++)
//    if(cur&(0x80>>j)) *(l_adr+j)=color;
 // }
//  adr+=8;                                   /* Next word */
//  }
//}



#define FP_PREC 10

#define HW_set_int(dst,lng,val)   asm("movl  %0,%%eax \n"             \
									  "movl  %1,%%edi \n"             \
									  "movl  %2,%%ecx \n"             \
									  "cld \n"                        \
									  "rep \n"                        \
									  "stosl %%eax,(%%edi) \n"        \
									  : :"g" (val),"g" (dst),"g" (lng) \
									  :"eax","edi","ecx"              \
									 )

#define HW_set_char(dst,lng,val)  asm("movb  %0,%%al  \n"             \
									  "movl  %1,%%edi \n"             \
									  "movl  %2,%%ecx \n"             \
									  "cld \n"                        \
									  "rep \n"                        \
									  "stosb %%al,(%%edi) \n"         \
									  : :"g" (val),"g" (dst),"g" (lng) \
									  :"al","edi","ecx"               \
									 )

#define HW_copy_int(src,dst,lng)  asm("movl  %0,%%esi \n"             \
									  "movl  %1,%%edi \n"             \
									  "movl  %2,%%ecx \n"             \
									  "cld \n"                        \
									  "rep \n"                        \
									  "movsl (%%esi),(%%edi) \n"      \
									  : :"g" (src),"g" (dst),"g" (lng) \
									  :"esi","edi","ecx"              \
									 )

#define HW_copy_char(src,dst,lng) asm("movl  %0,%%esi \n"             \
									  "movl  %1,%%edi \n"             \
									  "movl  %2,%%ecx \n"             \
									  "cld \n"                        \
									  "rep \n"                        \
									  "movsb (%%esi),(%%edi) \n"      \
									  : :"g" (src),"g" (dst),"g" (lng) \
									  :"esi","edi","ecx"              \
									 )

int C_2D_clipping;                          /* type of performed clipping */
unsigned char *G_buffer;                    /* the bitmap's bits */

signed_32_bit *G_rest_start[C_MAX_DIMENSIONS]={G_0_start,G_1_start,G_2_start};
signed_32_bit *G_rest_end[C_MAX_DIMENSIONS]={G_0_end,G_1_end,G_2_end};


int C_line_x_clipping(int **vertex1,int **vertex2,int dimension)
{
 register int i;
 register int whereto;
 register int *l,*r,*m,*t;                  /* left right and midle and tmp */
 static int g_store0[C_MAX_DIMENSIONS];     /* static stores for clipped vxes */
 static int g_store1[C_MAX_DIMENSIONS];
 static int g_store2[C_MAX_DIMENSIONS];
 static int g_store3[C_MAX_DIMENSIONS];
 static int g_store4[C_MAX_DIMENSIONS];
 static int g_store5[C_MAX_DIMENSIONS];
 int **vmn,**vmx;                           /* so that *vmn[0] < *vmx[0] */
 int swap;                                  /* were coordinates swaped? */

 C_2D_clipping=0;                           /* default no clipping yet */

 if((*vertex1)[0]<(*vertex2)[0])
 { swap=0; vmn=vertex1; vmx=vertex2; }      /* so that *vmn[0] < *vmx[0] */
 else
 { swap=1; vmn=vertex2; vmx=vertex1; }

 if(((*vmn)[0]>BG_ClipXMax)||((*vmx)[0]<BG_ClipXMin)) return(0);
 else
 {
  if((*vmn)[0]<=BG_ClipXMin)           /* clipping */
  {
   HW_copy_int(*vmn,l=g_store0,dimension);  /* copying old vertices */
   HW_copy_int(*vmx,m=g_store1,dimension);
   r=g_store2;

   whereto=0;
   while(m[0]!=BG_ClipXMin)
   {
	if(whereto==1) { t=l; l=m; m=t; }
	else           { t=r; r=m; m=t; }
	for(i=0;i<dimension;i++) m[i]=(l[i]+r[i])>>1;
	whereto=m[0]<BG_ClipXMin;
   }
   *vmn=m;                                  /* that is why m[] is static */
   C_2D_clipping=swap^1;
  }

  if((*vmx)[0]>=BG_ClipXMax)           /* clipping */
  {
   HW_copy_int(*vmn,l=g_store3,dimension);  /* copying old vertices */
   HW_copy_int(*vmx,m=g_store4,dimension);
   r=g_store5;

   whereto=0;
   while(m[0]!=BG_ClipXMax)
	 {
	if(whereto==1) { t=l; l=m; m=t; }
	else           { t=r; r=m; m=t; }
	for(i=0;i<dimension;i++) m[i]=(l[i]+r[i])>>1;
	whereto=m[0]<BG_ClipXMax;
   }
   *vmx=m;                                  /* that is why m[] is static */
   C_2D_clipping|=swap&1;
  }
 }
 return(1);                                 /* partialy or not clipped */
}


int C_line_y_clipping(int **vertex1,int **vertex2,int dimension)
{
 register int i;
 register int whereto;
 register int *l,*r,*m,*t;                  /* left right and midle and tmp */
 static int g_store0[C_MAX_DIMENSIONS];     /* static stores for clipped vxes */
 static int g_store1[C_MAX_DIMENSIONS];
 static int g_store2[C_MAX_DIMENSIONS];
 static int g_store3[C_MAX_DIMENSIONS];
 static int g_store4[C_MAX_DIMENSIONS];
 static int g_store5[C_MAX_DIMENSIONS];
 int **vmn,**vmx;                           /* so that *vmn[1] < *vmx[1] */
 int swap;                                  /* were coordinates swaped? */

 C_2D_clipping=0;                           /* default no clipping yet */

 if((*vertex1)[1]<(*vertex2)[1])
 { swap=0; vmn=vertex1; vmx=vertex2; }      /* so that *vmn[1] < *vmx[1] */
 else
 { swap=1; vmn=vertex2; vmx=vertex1; }

 if(((*vmn)[1]>BG_ClipYMax)||((*vmx)[1]<BG_ClipYMin)) return(0);
 else
 {
  if((*vmn)[1]<=BG_ClipYMin)           /* clipping */
  {
   HW_copy_int(*vmn,l=g_store0,dimension);  /* copying old vertices */
   HW_copy_int(*vmx,m=g_store1,dimension);
   r=g_store2;

   whereto=0;
   while(m[1]!=BG_ClipYMin)
   {
	if(whereto==1) { t=l; l=m; m=t; }
	else           { t=r; r=m; m=t; }
	for(i=0;i<dimension;i++) m[i]=(l[i]+r[i])>>1;
	whereto=m[1]<BG_ClipYMin;
   }
   *vmn=m;                                  /* that is why m[] is static */
   C_2D_clipping=swap^1;
  }

  if((*vmx)[1]>=BG_ClipYMax)           /* clipping */
  {
   HW_copy_int(*vmn,l=g_store3,dimension);  /* copying old vertices */
	 HW_copy_int(*vmx,m=g_store4,dimension);
   r=g_store5;

   whereto=0;
   while(m[1]!=BG_ClipYMax)
   {
	if(whereto==1) { t=l; l=m; m=t; }
	else           { t=r; r=m; m=t; }
	for(i=0;i<dimension;i++) m[i]=(l[i]+r[i])>>1;
	whereto=m[1]<BG_ClipYMax;
   }
   *vmx=m;                                  /* that is why m[] is static */
   C_2D_clipping|=swap&1;
  }
 }
 return(1);                                 /* partialy or not clipped */
}


int C_polygon_x_clipping(register int *from,register int *to,
						 int dimension,int length
						)
{
 register int i;
 int *v1,*v2,new_lng=0;
 int *first_vrtx=to;                        /* begining of the source */

 for(i=0;i<length;i++)                      /* for all edges */
 {
  v1=from; from+=dimension; v2=from;        /* taking two vertices */

  if(C_line_x_clipping(&v1,&v2,dimension))  /* clipping */
  {
   if(C_2D_clipping)                        /* depends which one was clipped */
   {
	HW_copy_int(v1,to,dimension); to+=dimension;
	HW_copy_int(v2,to,dimension); to+=dimension;
	new_lng+=2;                             /* first point clipped */
   }
   else
   {
	HW_copy_int(v2,to,dimension); to+=dimension;
	new_lng++;                              /* second point clipped */
   }
  }
 }
 HW_copy_int(first_vrtx,to,dimension);      /* looping the polygon vertices */

 return(new_lng);
}


void G_clear(int c)
{
 HW_set_int((int*)G_buffer,BG_ScreenWidth*BG_ScreenHeight/4,(unsigned)c);
}

void G_dot(int *vertex,unsigned char colour)
{
 if( (vertex[0]>=0)&&(vertex[0]<BG_ScreenWidth) &&
     (vertex[1]>=0)&&(vertex[1]<BG_ScreenHeight) )
 {
  G_buffer[vertex[1]*BG_ScreenWidth+vertex[0]]=colour;
 }
}

void G_line(int *vertex1,int *vertex2,unsigned char colour)
{
 register int inc_ah,inc_al;
 register int i;
 register unsigned char *adr=G_buffer;
 int *v1,*v2;
 int dx,dy,long_d,short_d;
 int d,add_dh,add_dl;
 int inc_xh,inc_yh,inc_xl,inc_yl;

 v1=vertex1;
 v2=vertex2;

 if(C_line_x_clipping(&v1,&v2,2))
 {
  if(C_line_y_clipping(&v1,&v2,2))
  {
   dx=v2[0]-v1[0]; dy=v2[1]-v1[1];

   if(dx<0){dx=-dx; inc_xh=-1; inc_xl=-1;}
   else    {        inc_xh=1;  inc_xl=1; }

   if(dy<0){dy=-dy;inc_yh=-BG_ScreenWidth;
				   inc_yl=-BG_ScreenWidth;
		   }
   else    {       inc_yh= BG_ScreenWidth;
				   inc_yl= BG_ScreenWidth;
		   }
   if(dx>dy){long_d=dx;short_d=dy;inc_yl=0;}
   else     {long_d=dy;short_d=dx;inc_xl=0;}

   inc_ah=inc_xh+inc_yh;
   inc_al=inc_xl+inc_yl;
	 adr+=v1[1]*BG_ScreenWidth+v1[0];

   d=2*short_d-long_d;
   add_dl=2*short_d;
   add_dh=2*short_d-2*long_d;

   for(i=0;i<=long_d;i++)
   {
	*adr=colour;
	if(d>=0){adr+=inc_ah; d+=add_dh;}
	else    {adr+=inc_al; d+=add_dl;}
   }
  }
 }
}


// way to slow for any use, use grx's bitblt
void HW_blit(void)
{
	int i,j;
// HW_copy_int((int*)HW_colourmap,(int*)0xd0000000,HW_COLOURMAP_SIZE_INT);
  for(j=0;j<BG_ScreenHeight;j++)
  {
	for(i=0;i<BG_ScreenWidth;i++) GrPlot(i,j,G_buffer[i+j*BG_ScreenWidth]);

  }

}



void GI_scan(int *edges,int dimension,int skip)
{
 signed_32_bit cur_v[C_MAX_DIMENSIONS];     /* initial values for Z+ dims */
 signed_32_bit inc_v[C_MAX_DIMENSIONS];     /* increment for Z+ dimensions */
 signed_32_bit tmp;
 int dx,dy,long_d,short_d;
 register int d,add_dh,add_dl;              
 register int inc_xh,inc_yh,inc_xl,inc_yl;  
 int x,y,i,j;
 int *v1,*v2;                               /* first and second vertices */

 v1=edges; edges+=skip; v2=edges;           /* length ints in each */

 if(C_line_y_clipping(&v1,&v2,dimension))   /* vertical clipping */
 {
  dx=*v2++; dy=*v2++;                       /* extracting 2-D coordinates */
  x=*v1++; y=*v1++;                         /* v2/v1 point remaining dim-2 */
  dimension-=2; 

  if(y<G_miny) G_miny=y;
  if(y>G_maxy) G_maxy=y;
  if(dy<G_miny) G_miny=dy;
  if(dy>G_maxy) G_maxy=dy;                  /* updating vertical size */

	dx-=x; dy-=y;                             /* ranges */

  if(dx<0){dx=-dx; inc_xh=-1; inc_xl=-1;}   /* making sure dx and dy >0 */
  else    {        inc_xh=1;  inc_xl=1; }   /* adjusting increments */
  if(dy<0){dy=-dy; inc_yh=-1; inc_yl=-1;}
  else    {        inc_yh=1;  inc_yl=1; }

  if(dx>dy){long_d=dx;short_d=dy;inc_yl=0;} /* long range,&making sure either */
  else     {long_d=dy;short_d=dx;inc_xl=0;} /* x or y is changed in L case */

  d=2*short_d-long_d;                       /* initial value of d */
  add_dl=2*short_d;                         /* d adjustment for H case */
  add_dh=2*short_d-2*long_d;                /* d adjustment for L case */

  for(i=0;i<dimension;i++)                  /* for all remaining dimensions */
  {
   tmp=v1[i]; tmp<<=G_P; cur_v[i]=tmp;      /* f.p. start value */
   tmp=v2[i]-v1[i]; tmp<<=G_P;              /* f.p. increment */
   if(long_d>0) inc_v[i]=tmp/long_d;        /* if needed (non 0 lines) */
  }

  for(i=0;i<=long_d;i++)                    /* for all points in longer range */
  {
   if(x<G_start[y])                         /* further then rightmost */
   {
    G_start[y]=x;                           /* the begining of scan line */
    for(j=0;j<dimension;j++)
     G_rest_start[j][y]=cur_v[j];            /* all other dimensions */
   }

   if(G_end[y]<x)                           /* further the leftmost */
   {
    G_end[y]=x;                             /* the end of scan line */
    for(j=0;j<dimension;j++)
		 G_rest_end[j][y]=cur_v[j];              /* and for other dimension */
   }

   if(d>=0){x+=inc_xh;y+=inc_yh;d+=add_dh;} /* previous point was H type */
   else    {x+=inc_xl;y+=inc_yl;d+=add_dl;} /* previous point was L type */
   for(j=0;j<dimension;j++) 
    cur_v[j]+=inc_v[j];                     /* for all other dimensions */
  }
 }
}


void GI_boarder_array_init(void)
{
 G_miny=INT_MAX;                            /* polygon starts here */
 G_maxy=INT_MIN;                            /* polygon ends here */
 int i;

 HW_set_int((int *)G_start,BG_ScreenHeight,INT_MAX);
 HW_set_int((int *)G_end,BG_ScreenHeight,INT_MIN);/* limiting values */
}



void G_ambient_polygon(int *edges,int length,unsigned char colour)
{
 int new_edges[G_MAX_TUPLES];               /* verticaly clipped polygon */
 int new_length;                            /* although no edges there yet */
 register unsigned char *l_adr,*adr;
 register int beg,end,i;

 GI_boarder_array_init();                   /* initializing the arrays */

 new_length=C_polygon_x_clipping(edges,new_edges,2,length);

 for(i=0;i<new_length;i++)
  GI_scan(&new_edges[i*2],2,2);             /* Searching polygon boarders */

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
 l_adr=G_buffer+G_miny*BG_ScreenWidth;   /* addr of 1st byte of 1st line */

  for(; G_miny<=G_maxy; G_miny++,
      l_adr+=BG_ScreenWidth)              /* rendering all lines */
  {
   adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
   end=G_end[G_miny]-beg+1;                 /* ends here */
//
   HW_set_char((char*)adr,end,colour);      /* rendering single line */
  }
}
}


void G_shaded_polygon(int *edges,int length)
{
 int new_edges[G_MAX_SHADED_TUPLES];        /* verticaly clipped polygon */
 int new_length;
 register unsigned char *l_adr,*adr;
 register int beg,end,i;
 register signed_32_bit cur_c,inc_c;        /* current colour and it's inc */

 GI_boarder_array_init();                   /* initializing the array */

 new_length=C_polygon_x_clipping(edges,new_edges,3,length);

 for(i=0;i<new_length;i++)
	GI_scan(&new_edges[i*3],3,3);             /* Searching polygon boarders */

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
	l_adr=G_buffer+G_miny*BG_ScreenWidth;   /* addr of 1st byte of 1st line */

	for(; G_miny<=G_maxy; G_miny++,
			l_adr+=BG_ScreenWidth)              /* rendering all lines */
	{
	 adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
	 end=G_end[G_miny];                       /* ends here */

	 cur_c=G_0_start[G_miny];                 /* colour starts with this value */
	 inc_c=G_0_end[G_miny]-cur_c;
	 if(end>beg) inc_c/=end-beg+1;            /* f.p. increment */

	 for(;beg<=end;beg++)                     /* render this lines */
	 {
		*adr++=cur_c>>G_P;                      /* rendering single point */
		cur_c+=inc_c;                           /* incrementing colour */
	 }
	}
 }
}


void G_textured_polygon(int *edges,int length, unsigned char *bitmap)
{
 int new_edges[G_MAX_SHADED_TUPLES];        /* verticaly clipped polygon */
 int new_length;
 register unsigned char *l_adr,*adr;
 register int beg,end,i;
 register signed_32_bit cur_u,inc_u;        /* current colour and it's inc */
 register signed_32_bit cur_v,inc_v;        /* current colour and it's inc */

 GI_boarder_array_init();                   /* initializing the array */

 new_length=C_polygon_x_clipping(edges,new_edges,4,length);

 for(i=0;i<new_length;i++)
	GI_scan(&new_edges[i*4],4,4);             /* Searching polygon boarders */

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
	l_adr=G_buffer+G_miny*BG_ScreenWidth;   /* addr of 1st byte of 1st line */

	for(; G_miny<=G_maxy; G_miny++,
			l_adr+=BG_ScreenWidth)              /* rendering all lines */
	{
	 adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
	 end=G_end[G_miny];                       /* ends here */

	 cur_u=G_0_start[G_miny];                 /* colour starts with this value */
	 inc_u=G_0_end[G_miny]-cur_u;
	 if(end>beg) inc_u/=end-beg+1;            /* f.p. increment */

	 cur_v=G_1_start[G_miny];                 /* colour starts with this value */
	 inc_v=G_1_end[G_miny]-cur_v;
	 if(end>beg) inc_v/=end-beg+1;            /* f.p. increment */

	 for(;beg<=end;beg++)                     /* render this lines */
	 {
		*adr++=bitmap[(cur_u>>G_P)+(cur_v>>G_P)*mdl.bitmapw];                      /* rendering single point */
		cur_u+=inc_u;                           /* incrementing colour */
		cur_v+=inc_v;                           /* incrementing colour */
	 }
	}
 }
}

void G_gtex_poly(int *edges,int length, unsigned char *bitmap)
{
 int new_edges[G_MAX_SHADED_TUPLES];        /* verticaly clipped polygon */
 int new_length;
 register unsigned char *l_adr,*adr;
 register int beg,end,i;
 register signed_32_bit cur_u,inc_u;        /* current colour and it's inc */
 register signed_32_bit cur_v,inc_v;        /* current colour and it's inc */
 register signed_32_bit cur_c,inc_c;        /* current colour and it's inc */

 GI_boarder_array_init();                   /* initializing the array */

 new_length=C_polygon_x_clipping(edges,new_edges,5,length);

 for(i=0;i<new_length;i++)
	GI_scan(&new_edges[i*5],5,5);             /* Searching polygon boarders */

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
	l_adr=G_buffer+G_miny*BG_ScreenWidth;   /* addr of 1st byte of 1st line */

	for(; G_miny<=G_maxy; G_miny++,
			l_adr+=BG_ScreenWidth)              /* rendering all lines */
	{
	 adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
	 end=G_end[G_miny];                       /* ends here */

	 cur_u=G_0_start[G_miny];                 /* colour starts with this value */
	 inc_u=G_0_end[G_miny]-cur_u;
	 if(end>beg) inc_u/=end-beg+1;            /* f.p. increment */

	 cur_v=G_1_start[G_miny];                 /* colour starts with this value */
	 inc_v=G_1_end[G_miny]-cur_v;
	 if(end>beg) inc_v/=end-beg+1;            /* f.p. increment */

	 cur_c=G_2_start[G_miny];                 /* colour starts with this value */
	 inc_c=G_2_end[G_miny]-cur_c;
	 if(end>beg) inc_c/=end-beg+1;            /* f.p. increment */

	 for(;beg<=end;beg++)                     /* render this lines */
	 {
		*adr++=cmap[bitmap[(cur_u>>G_P)+(cur_v>>G_P)*mdl.bitmapw]+256*(cur_c>>G_P)];//+cur_c>>G_P;                      /* rendering single point */
		cur_u+=inc_u;                           /* incrementing colour */
		cur_v+=inc_v;                           /* incrementing colour */
		cur_c+=inc_c;                           /* incrementing colour */
	 }
	}
 }
}


