/*

           - MPATCH LIB SAMPLE -

	(C) Copyright 1995/96 Maurizio Giunti


      For any info please contact me:

        Internet: giunti@kagi.com
                  giunti@abeline.it
                  giunti@statsun.ds.unifi.it
         Fidonet: 2:332/102.3


*/




#include <stdio.h>

#include "mptlib.h"


/* My idle function declaration */
void MyIdle(void);


int main(int argc,char **argv)
{
 struct MDF_header_info mdfinfo;
 unsigned long crc;
 short r;

 puts("MPATCH library - Sample patch program");
 puts("(C) Copyright 1995/96 Maurizio Giunti");

 if(argc!=4 && argc!=5) {
  puts("Usage: sample <mdf_file> <old_file> <new_file> [<password>]");
  return 10;
 }

 /* Read MDF Header Info */
 if((r=MDF_ReadHead(argv[1],&mdfinfo))<1) {
  printf("Error MDF_ReadHead%d\n",r);
  return 1;
 }

 /* Display registration info */
 printf("Registered to: %s\n",mdfinfo.registeredto);
 /* Display comment */
 if(*mdfinfo.comment!='\0') {
  puts("Comment:");
  puts(mdfinfo.comment);
 }

 /* Check old file Crc */
 crc=FileCrc32(argv[2]);
 if(crc!=mdfinfo.oldfilecrc) {
  printf("%s is not the right old file!\n",argv[2]);
  return 2;
 }

 /* Install my idle function */
 r=(short)((mdfinfo.n_chunks)/10)+1; /* Idle called 10 times */
 MDF_SetIdle(MyIdle,r);

 /* Password */
 if(argc==5) {
  if(mdfinfo.password==0) {
   puts("No password required.");
  }
  else {
   MDF_SetPassword(argv[4]);
  }
 }

 /* Patch applying */
 MDF_Patch(argv[1],argv[2],argv[3]);

 /* Display error condition */
 puts("");
 puts(MDF_LastError());

 /* End */
 return 0;
}

/* My Idle function */
void MyIdle()
{
 static short r=0;
 printf(".%d",r++); /* Print an increasing number */
}
