{$M 5120,0,655360}
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

PROGRAM Moving_Clock;
USES CRT, DOS;

VAR
  MaxX, MaxY,
  MidX, MidY : BYTE;
  Ratio : REAL;

PROCEDURE showhelp;
BEGIN
  WriteLn ('MCLK v1.05 - Free DOS thing: moving time display.'                       );
  WriteLn ('March 16, 1996. Copyright (c) 1996 by David Daniel Anderson - Reign Ware');
  WriteLn ('Usage:  MCLK'                                                            );
  Halt;
END;

PROCEDURE Cursor (CONST on : BOOLEAN);
VAR
  r : REGISTERS;
BEGIN
  r. AH := $03;            {----get cursor shape on page 0               }
  r. BH := $00;            {----to be exact use function 2 to obtain page}
  Intr ($10, r);

  IF ((r. CX < $2000) AND NOT (on)) OR
     ((r. CX >= $2000) AND on)
  THEN
  BEGIN
    r. AH := $01;
    r. CX := r. CX XOR $2000;   {----toggle bit if neccesary}
    Intr ($10, r);
  END;
END; {of cursor}

FUNCTION leadingzero (CONST w : WORD) : STRING;
VAR
  s : STRING;
BEGIN
  Str (w: 0, s);
  IF Length (s) = 1 THEN
    s := '0' + s;
  leadingzero := s;
END;

FUNCTION DisplayDate : BOOLEAN;
VAR
  h, mi, s, u : WORD;
  date_time : DATETIME;

  Angle, X, Y : INTEGER;
  QuadAngle : REAL;
  Xofs, Yofs : BYTE;

BEGIN
  GetTime (h, mi, s, u);
  IF ((s MOD 5) = 0) THEN
  BEGIN
    ClrScr;

    Angle := s * 6;
    QuadAngle := (Abs (Angle MOD 90) * Pi / 180.0);
    Xofs := Trunc (MidY * Cos (QuadAngle));
    Yofs := Trunc (MidY * Sin (QuadAngle)) + 1;

    (* Xofs goes from MidY downto 1; Yofs goes from 1 to MidY *)

    IF (Angle >= 270) THEN
    BEGIN
      X := MidX - Trunc (Ratio * Xofs);
      Y := MidY - Yofs;
    END
    ELSE
    IF (Angle >= 180) THEN
    BEGIN
      X := MidX - Trunc (Ratio * Yofs);
      Y := MidY + Xofs;
    END
    ELSE
    IF (Angle >= 90) THEN
    BEGIN
      X := MidX + Trunc (Ratio * Xofs);
      Y := MidY + Yofs;
    END
    ELSE
    IF (Angle >= 0) THEN
    BEGIN
      X := MidX + Trunc (Ratio * Yofs);
      Y := MidY - Xofs;
    END;

    GotoXY (X - 2, Y + 1);

    WITH date_time DO
    BEGIN
      Hour := (h);
      Min  := (mi);
      Write (Hour, ':', leadingzero (Min));
    END;
    DisplayDate := TRUE;
  END
  ELSE
    DisplayDate := FALSE;
END;

VAR
  Paused : INTEGER;
  k : CHAR;
  ta : BYTE;

BEGIN
  CheckBreak := FALSE;
  IF ParamCount <> 0 THEN showhelp;
  Cursor (FALSE);

  WriteLn ('Please wait one moment...');

    MaxX := Lo (WindMax);                     { <                  }
    MaxY := Hi (WindMax);                     { <                  }
    MidX := MaxX DIV 2;                       { < Global variables }
    MidY := MaxY DIV 2;                       { <                  }
    Ratio := Sqrt ((MaxX + 1) / (MaxY + 1));  { <                  }

  ta := 9;
  WHILE NOT KeyPressed DO BEGIN
    ta := (Succ (ta));  { use colors 10 - 15 }
    IF ta = 16 THEN ta := 10;
    TextAttr := ta;

    REPEAT
      Delay (300); { 0.3 seconds }
    UNTIL DisplayDate OR KeyPressed;

    Paused := 0;
    REPEAT
      Inc (Paused, 100);
      Delay (100);
    UNTIL KeyPressed OR (Paused = 4000);
  END;
  Cursor (TRUE);
  NormVideo;
  ClrScr;

  WHILE KeyPressed DO k := ReadKey;  { empty keyboard buffer }
END.
