VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "TIME2WIN : 3D Meter"
   ClientHeight    =   4245
   ClientLeft      =   945
   ClientTop       =   1365
   ClientWidth     =   6045
   Height          =   4590
   Left            =   915
   LinkTopic       =   "Form1"
   ScaleHeight     =   4245
   ScaleWidth      =   6045
   Top             =   1050
   Width           =   6105
   Begin ComboBox Combo1 
      BackColor       =   &H00C0C0C0&
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   2520
      TabIndex        =   15
      Top             =   2250
      Width           =   2265
   End
   Begin CommandButton Command5 
      Caption         =   "&Random value"
      Height          =   465
      Left            =   2520
      TabIndex        =   4
      Top             =   1260
      Width           =   2265
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Form"
      Height          =   1815
      Left            =   90
      TabIndex        =   10
      Top             =   1170
      Width           =   2355
      Begin OptionButton Option1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Bar"
         Height          =   225
         Index           =   4
         Left            =   180
         TabIndex        =   9
         Top             =   1440
         Width           =   1905
      End
      Begin OptionButton Option1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Ellipse"
         Height          =   225
         Index           =   3
         Left            =   180
         TabIndex        =   8
         Top             =   1170
         Width           =   1905
      End
      Begin OptionButton Option1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Trapezium"
         Height          =   225
         Index           =   2
         Left            =   180
         TabIndex        =   7
         Top             =   900
         Width           =   1905
      End
      Begin OptionButton Option1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Triangle"
         Height          =   225
         Index           =   1
         Left            =   180
         TabIndex        =   6
         Top             =   630
         Width           =   1905
      End
      Begin OptionButton Option1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Rectangle"
         Height          =   225
         Index           =   0
         Left            =   180
         TabIndex        =   5
         Top             =   360
         Value           =   -1  'True
         Width           =   1905
      End
   End
   Begin CheckBox Check1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Swap &Border"
      Height          =   285
      Left            =   2520
      TabIndex        =   11
      Top             =   1800
      Width           =   2265
   End
   Begin HScrollBar HScroll1 
      Height          =   285
      LargeChange     =   100
      Left            =   2520
      SmallChange     =   25
      TabIndex        =   12
      Top             =   2700
      Width           =   2265
   End
   Begin PictureBox Picture2 
      BackColor       =   &H00FFFFFF&
      Height          =   4050
      Left            =   4860
      ScaleHeight     =   4020
      ScaleWidth      =   1050
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   90
      Width           =   1080
   End
   Begin PictureBox Picture1 
      BackColor       =   &H00FFFFFF&
      Height          =   1080
      Left            =   180
      ScaleHeight     =   1050
      ScaleWidth      =   4575
      TabIndex        =   13
      TabStop         =   0   'False
      Top             =   3060
      Width           =   4605
   End
   Begin CommandButton Command4 
      Caption         =   "Swap &Horizontal/Vertical"
      Height          =   465
      Left            =   90
      TabIndex        =   1
      Top             =   630
      Width           =   2355
   End
   Begin CommandButton Command3 
      Caption         =   "Automatic &Decrease"
      Height          =   465
      Left            =   2520
      TabIndex        =   3
      Top             =   630
      Width           =   2265
   End
   Begin CommandButton Command2 
      Caption         =   "Automatic &Increase"
      Height          =   465
      Left            =   2520
      TabIndex        =   2
      Top             =   90
      Width           =   2265
   End
   Begin CommandButton Command1 
      Caption         =   "Half of Current &Value"
      Height          =   465
      Left            =   90
      TabIndex        =   0
      Top             =   90
      Width           =   2355
   End
End
Option Explicit

Dim LoadFinish    As Integer

Dim Meter1        As tag3DMeter
Dim Meter2        As tag3DMeter

Sub Check1_Click ()
   
   'swap the border style
   If (Picture1.BorderStyle = 1) Then
      Picture1.BorderStyle = 0
   Else
      Picture1.BorderStyle = 1
   End If
   
   If (Picture2.BorderStyle = 1) Then
      Picture2.BorderStyle = 0
   Else
      Picture2.BorderStyle = 1
   End If
   
   Call Update3DMeter

End Sub

Sub Combo1_Click ()

   If (LoadFinish = True) Then
      ' update the brush style
      Meter1.HatchBrush = Combo1.ListIndex
      Meter2.HatchBrush = Combo1.ListIndex

      Call Update3DMeter
   End If

End Sub

Sub Command1_Click ()

   ' calculate the half value and refresh
   Meter1.CrtValue = Meter1.CrtValue / 2
   
   ' calculate the half value and refresh
   Meter2.CrtValue = Meter2.CrtValue / 2
   
   ' refresh the scroll bar
   HScroll1.Value = Meter1.CrtValue

   Call Update3DMeter

End Sub

Sub Command2_Click ()

   Dim i As Integer

   ' automatic increase
   For i = Meter1.CrtValue To Meter1.MaxValue
      Meter1.CrtValue = i
      Meter2.CrtValue = i
      Call Update3DMeter
   Next i

   ' refresh the scroll bar
   HScroll1.Value = Meter1.CrtValue

End Sub

Sub Command3_Click ()

   Dim i As Integer

   ' automatic decrease
   For i = Meter1.CrtValue To 0 Step -1
      Meter1.CrtValue = i
      Meter2.CrtValue = i
      Call Update3DMeter
   Next i

   ' refresh the scroll bar
   HScroll1.Value = Meter1.CrtValue

End Sub

Sub Command4_Click ()

   ' swap the direction and refresh
   Meter1.Direction = Not Meter1.Direction
   
   ' swap the direction and refresh
   Meter2.Direction = Not Meter2.Direction
   
   ' refresh the scroll bar
   HScroll1.Value = Meter1.CrtValue

   Call Update3DMeter

End Sub

Sub Command5_Click ()

   Dim i As Integer

   Randomize Timer

   ' automatic decrease
   For i = 1 To 50
      Meter1.CrtValue = Meter1.MaxValue * Rnd(1)
      Meter2.CrtValue = Meter2.MaxValue * Rnd(1)
      Call Update3DMeter
   Next i

   ' refresh the scroll bar
   HScroll1.Value = Meter1.CrtValue

End Sub

Sub Form_Load ()

   ' some initialization
   LoadFinish = False

   ' initialize the random generator
   Randomize Timer

   ' initialize the combo box
   Combo1.AddItem "Solid brush"
   Combo1.AddItem "Horizontal"
   Combo1.AddItem "Vertical"
   Combo1.AddItem "Downward diagonal"
   Combo1.AddItem "Upward diagonal"
   Combo1.AddItem "Cross"
   Combo1.AddItem "Diagonal cross"

   Combo1.ListIndex = 0

   ' initialize the first 3D-Meter
   Meter1.MaxValue = 100
   Meter1.CrtValue = Meter1.MaxValue / 2
   Meter1.BackColor = &HC0C0C0
   Meter1.ForeColor = &H808080
   Meter1.Polygon = 0
   Meter1.BarSize = 7      'default = 10
   Meter1.SpaceBars = 0    'default = 2
   Meter1.Direction = 0
   Meter1.Thickness = 0
   Meter1.ThreeD = -1
   Meter1.HatchBrush = Combo1.ListIndex
   
   ' initialize the second 3D-Meter
   Call cTypesCopy(Meter1, Meter2, Len(Meter1))
   Meter2.Direction = Not Meter1.Direction
   Meter1.ThreeD = 1
   
   ' initialize the scroll bar
   HScroll1.LargeChange = Meter1.MaxValue / 10
   HScroll1.SmallChange = Meter1.MaxValue / 20
   HScroll1.Max = Meter1.MaxValue
   HScroll1.Value = Meter1.MaxValue / 2

   ' initialize backcolor of picture
   Picture1.BackColor = Meter1.BackColor
   Picture2.BackColor = Meter2.BackColor

   LoadFinish = True

End Sub

Sub Form_Paint ()

   Call Update3DMeter

   ' refresh some 3D controls
   c3D HScroll1, 0, 0
   c3D Check1, 0, 0

   c3D Option1(0), 0, 0
   c3D Option1(1), 0, 0
   c3D Option1(2), 0, 0
   c3D Option1(3), 0, 0
   c3D Option1(4), 0, 0

End Sub

Sub HScroll1_Change ()

   Call Update3DMeterScrollBar

End Sub

Sub HScroll1_Scroll ()

   Call Update3DMeterScrollBar

End Sub

Sub Option1_Click (Index As Integer)

   ' set the form of the 3D Meter
   Meter1.Polygon = Index
   Meter2.Polygon = Index
   
   Call Update3DMeter

End Sub

Sub Update3DMeter ()

   ' refresh the 3D-Meter
   Call c3DMeter(Picture1, Meter1)
   Call c3DMeter(Picture2, Meter2)

End Sub

Sub Update3DMeterScrollBar ()

   ' update current value
   Meter1.CrtValue = HScroll1.Value
   Meter2.CrtValue = HScroll1.Value

   Call Update3DMeter

End Sub

