/*
Auto:		smake MCalc
*/


/* $Revision Header built automatically *************** (do not edit) ************
**
**  Copyright by GuntherSoft
**
** File             : SnakeSYS:CPrgs/MUICalc/MCalc.h
** Created on       : Saturday, 02.10.93 02:16:34
** Created by       : Kai Iske
** Current revision : V1.3
**
**
** Purpose
** -------
**   - Header-File for MCalc
**
** Revision V1.3
** --------------
** created on Friday, 11.02.94 23:34:08  by  Kai Iske.   LogMessage :
**  -*-  changed on Friday, 11.02.94 23:35:32  by  Kai Iske.   LogMessage :
**   - One couldn`t use 1e3 for scientific notation of 1000. You
**     had to write 1.0e3. Changed
**     (Reported by : Henry Norman)
**   - No more error lines will be copied from History
**     (Requested by : Stefan Stuntz)
**  -*-  created on Friday, 11.02.94 23:34:08  by  Kai Iske.   LogMessage :
**   - "Radiant" was wrong. Changed. Why didn`t anybody tell me.
**     (Reported by : Henry Norman)
**   - Chose wrong case for mathematical "e".
**     (Reported by : Henry Norman)
**
** Revision V1.2
** --------------
** created on Tuesday, 19.10.93 23:41:00  by  Kai Iske.   LogMessage :
**  -*-  changed on Wednesday, 08.12.93 23:48:31  by  Kai Iske.   LogMessage :
**   - Default number of history lines increased
**     (Requested by : Stefan Stuntz)
**  -*-  changed on Sunday, 05.12.93 22:30:41  by  Kai Iske.   LogMessage :
**   - No checks were made on the ENTRY argument to an ARexx
**     function
**  -*-  changed on Sunday, 05.12.93 18:13:56  by  Kai Iske.   LogMessage :
**   - For calculations via ARexx one can set the type, size, sign
**     and angle flags seperately, now
**  -*-  changed on Sunday, 05.12.93 17:50:09  by  Kai Iske.   LogMessage :
**   - Improved error handling from within ARexx commands a bit
**  -*-  changed on Sunday, 05.12.93 17:46:35  by  Kai Iske.   LogMessage :
**   - MUIProCalc may output TeX style mathematical expressions
**     when using the ARexx commands. Additionally there is another
**     option to convert expressions to TeX format.
**     (Requested by : Volker Gth)
**  -*-  changed on Sunday, 05.12.93 16:47:59  by  Kai Iske.   LogMessage :
**   - Added more ARexx functions to the default ones
**     (CALC, GETINPUT, GETOUTPUT)
**     (Requested by : Volker Gth)
**  -*-  changed on Sunday, 05.12.93 01:47:36  by  Kai Iske.   LogMessage :
**   - MUIProCalc didn`t handle extremly small values
**     (Reported by : Volker Gth)
**  -*-  changed on Sunday, 05.12.93 01:38:18  by  Kai Iske.   LogMessage :
**   - Default values weren`t set up
**   - ACLR and CLR gadget have got menu entries too, now
**     (Requested by : Volker Gth)
**   - History entries may be copied to clipboard now
**     (Requested by : Volker Gth)
**  -*-  changed on Saturday, 27.11.93 01:01:25  by  Kai Iske.   LogMessage :
**   - Recompiled using SAS 6.50
**  -*-  changed on Wednesday, 20.10.93 00:24:41  by  Kai Iske.   LogMessage :
**   - Bug in ListView display fixed
**  -*-  created on Tuesday, 19.10.93 23:41:00  by  Kai Iske.   LogMessage :
**   - You may now tell MCalc to clear the input string after
**     hitting RETURN or EXEC.
**
** Revision V1.1
** --------------
** created on Tuesday, 12.10.93 01:50:26  by  Kai Iske.   LogMessage :
**  -*-  changed on Sunday, 17.10.93 15:03:10  by  Kai Iske.   LogMessage :
**   - Save and Use gadgets weren`t arranged as proposed
**     by the AUISG. (Reported by: Stefan Stuntz)
**   - Changed layout of Prefs window a bit
**     (Suggested by: Stefan Stuntz)
**  -*-  changed on Friday, 15.10.93 18:39:50  by  Kai Iske.   LogMessage :
**   - NOT operator didn`t behave as expected ;) It was a simple
**     negate... (Reported by : Top on IRC)
**  -*-  changed on Thursday, 14.10.93 18:01:32  by  Kai Iske.   LogMessage :
**   - Hex-Values may be entered using 'C'-Style now (e.g. 0xff)
**  -*-  changed on Thursday, 14.10.93 00:34:55  by  Kai Iske.   LogMessage :
**   - One can use the faktorian '!' behind numbers now, too.
**     (Suggested by : Top on IRC)
**  -*-  changed on Thursday, 14.10.93 00:28:52  by  Kai Iske.   LogMessage :
**   - One could accidentially change the ordering of the
**     functions and input-gadgets groups by using
**     'No Functions'and 'No Input' (reported by: Top on IRC)
**  -*-  created on Tuesday, 12.10.93 01:50:26  by  Kai Iske.   LogMessage :
**   - Order of Input and Ouput gadgets (String + ListView) may be
**     set now, ie. the input string may show up underneith the
**     ListView and vice versa (Requested by Dirk Federlein)
**
** Revision V1.0
** --------------
** created on Saturday, 02.10.93 02:16:34  by  Kai Iske.   LogMessage :
**     --- Initial release ---
**
*********************************************************************************/
#define REVISION "1.3"
#define REVDATE  "11.02.94"
#define REVTIME  "23:35:32"
#define AUTHOR   "Kai Iske"
#define VERNUM   1
#define REVNUM   3


#ifndef		MCALC_H
#define		MCALC_H



/**********************************************************************/
/*                         Parser-Prototypes                          */
/**********************************************************************/
int		yyparse(void);
int		yyerror(char *s);
ULONG		make_ulong(double OldVal);
double		calc_fak(double Fak);
double		calc_angle(double Value);
BOOL		check_angle(double Value, int Mode);



/**********************************************************************/
/*                         Scanner-Prototypes                         */
/**********************************************************************/
int	yylex(void);
void	count(void);
int	calc_int_value(char *s);
int	calc_hex_value(char *s, int leng);
int	calc_bin_value(char *s);
int	calc_oct_value(char *s);
int	calc_dbl_value(char *s);



/**********************************************************************/
/*                   Error-Codes for Scanner/Parser                   */
/**********************************************************************/
#define	ERR_PARSE	1
#define	ERR_UNKNOWN_CHR	2
#define	ERR_DIVBY0	3
#define	ERR_OVERFLOW	4



/**********************************************************************/
/*                        Assembler-Prototypes                        */
/**********************************************************************/
ULONG	__asm MyASL(register __d0 ULONG In, register __d1 ULONG Out);
ULONG	__asm MyASR(register __d0 ULONG In, register __d1 ULONG Out);
ULONG	__asm MyLSL(register __d0 ULONG In, register __d1 ULONG Out);
ULONG	__asm MyLSR(register __d0 ULONG In, register __d1 ULONG Out);
ULONG	__asm MyROL(register __d0 ULONG In, register __d1 ULONG Out);
ULONG	__asm MyROR(register __d0 ULONG In, register __d1 ULONG Out);
ULONG	__asm MyXOR(register __d0 ULONG In, register __d1 ULONG Out);
ULONG	__asm MyNAND(register __d0 ULONG In, register __d1 ULONG Out);
ULONG	__asm MyNOR(register __d0 ULONG In, register __d1 ULONG Out);
ULONG	__asm MyNXOR(register __d0 ULONG In, register __d1 ULONG Out);
APTR	__asm DoCreatePool(register __d0 ULONG, register __d1 ULONG, register __d2 ULONG);
void	__asm DoDeletePool(register __a0 APTR);
APTR	__asm AllocVecPool(register __a0 APTR, register __d0 ULONG);
void	__asm FreeVecPool(register __a0 APTR, register __a1 APTR);



/**********************************************************************/
/*                   Structure for ListView display                   */
/**********************************************************************/
struct	ListStruct
{
	char	Input[258];
	char	Output[258];
};





/**********************************************************************/
/*                         Some nice defines                          */
/**********************************************************************/

	// This is our Version string

#define	MUIVERS		"$VER:MCalc "REVISION" ("REVDATE")"


	// These are for Button/Menu IDs

#define	ID_QUIT		1			// Quit program
#define	ID_ABOUT	2			// Display About
#define	ID_PREFS	3			// Open Prefs

#define	ID_PICKLEFT	4			// Pick left entry from History
#define	ID_PICKRIGHT	5			// Pick right entry from History
#define	ID_CLIPCUTLEFT	6			// Clip left entry to clipboard
#define	ID_CLIPCUTRIGHT	7			// Clip right entry to clipboard

#define	ID_DECIMAL	8			// Switch to dec display
#define	ID_HEXDECIMAL	9			// Switch to hex display
#define	ID_OCTAL	10			// Switch to oct display
#define	ID_BINARY	11			// Switch to bin display

#define	ID_8BIT		12			// Set 8-Bit Base
#define	ID_16BIT	13			// Set 16-Bit Base
#define	ID_32BIT	14			// Set 32-Bit Base

#define	ID_SIGNED	15			// Switch to signed dec ouput
#define	ID_UNSIGNED	16			// Switch to unsigned dec output

#define	ID_RAD		17			// Radiant angles
#define	ID_DEG		18			// Degree angles

#define	ID_INPUT	19			// Received input from String gadget
#define	ID_LISTVIEW	20			// Double clicked on ListView
#define	ID_EXEC		21			// Translate input
#define	ID_CLEAR	22			// Clear input gadget
#define	ID_ALLCLEAR	23			// Clear input gadget AND memory



#define	ID_PREFS_QUIT	50			// Close Prefs window
#define	ID_PREFS_NEW	51			// New Prefs set





/**********************************************************************/
/*                    Definitions for Online-Help                     */
/**********************************************************************/
#define	HELPFILE		"PROGDIR:MCalc.guide"
#define	NODE_MAIN		"Main"
#define	NODE_INOUTPUT		"InputOutput"
#define	NODE_FUNCTIONS		"FuncTables"
#define	NODE_INPUTS		"Inputs"
#define	NODE_PREFS		"Prefs"
#define	NODE_LAYOUT		"Layout"
#define	NODE_OUTPUT		"Output"
#define	NODE_HISTORY		"History"
#define	NODE_MISC		"Misc"


/**********************************************************************/
/*                   Defines for Clipboard support                    */
/**********************************************************************/
#define ID_FTXT	MAKE_ID('F','T','X','T')
#define ID_CHRS	MAKE_ID('C','H','R','S')


/**********************************************************************/
/*                       Some defines for ARexx                       */
/**********************************************************************/
#define	GET_OUTPUT		1
#define	GET_INPUT		2

#define	NORMAL_OUTPUT		1
#define	TEX_OUTPUT		2

#define	GET_ACTIVE		-1
#define	GET_TOPMOST		-2
#define	GET_BOTTOMMOST		-3

#include	"Protos.h"
#endif
