/*
Auto:		smake MCalc
*/


/* $Revision Header built automatically *************** (do not edit) ************
**
**  Copyright by GuntherSoft
**
** File             : SnakeSYS:CPrgs/MUICalc/MCalc.c
** Created on       : Saturday, 02.10.93 02:12:50
** Created by       : Kai Iske
** Current revision : V1.0
**
**
** Purpose
** -------
**   - This is a quite flexible, powerful Calculator made for all
**     those of you, who like to calc around ;) Even for
**     programmers...
**
** Revision V1.0
** --------------
** created on Saturday, 02.10.93 02:12:50  by  Kai Iske.   LogMessage :
**     --- Initial release ---
**
*********************************************************************************/



/**********************************************************************/
/*                    Externals to Scanner/Parser                     */
/**********************************************************************/
extern	UWORD		PCharRead;
extern	UWORD		PColumn;
extern	UWORD		PError;
extern	UWORD		NonDouble;
extern	int		yynerrs;
extern	int		yychar;
extern	int		yy_init;
extern	int		yy_start;
extern	FILE		*yyin, *yyout;
extern	void		*yy_current_buffer;


extern UWORD		RXIntType;
extern UWORD		RXIntBase;
extern UWORD		RXIntSign;
extern UWORD		RXIntAngle;


/**********************************************************************/
/*    Aehm, SAS 6.50 seams to open up a window just as it likes ;)    */
/**********************************************************************/
char __stdiowin[] = "NIL:";



/**********************************************************************/
/*                 External variables of ARexx module                 */
/**********************************************************************/
extern struct MUI_Command	RXCommands[];




/**********************************************************************/
/*                      Routines for that module                      */
/**********************************************************************/
static BOOL OpenLibs(void);
static void CloseLibs(void);
static void SetMainWinCycle(void);
static BOOL OpenMainWin(void);
static void CloseMainWin(void);
static ULONG	__saveds __asm InsertFunc(register __a0 struct Hook *MyHook, register __a2 APTR Obj, register __a1 APTR *Data);
static ULONG	__saveds __asm DispConstructFunc(register __a0 struct Hook *MyHook, register __a2 APTR MemPool, register __a1 struct ListStruct *Data);
static ULONG	__saveds __asm DispDestructFunc(register __a0 struct Hook *MyHook, register __a2 APTR MemPool, register __a1 struct ListStruct *Data);
static ULONG	__saveds __asm DispViewFunc(register __a0 struct Hook *MyHook, register __a2 char **array, register __a1 struct ListStruct *Data);
static void InsertText(char *NewText);
static void WriteClip(char *Entry);
static void HandleInputs(void);




/**********************************************************************/
/*                           Library-Bases                            */
/**********************************************************************/
extern	struct ExecBase	*SysBase;

struct	IntuitionBase	*IntuitionBase		= NULL;
struct	GfxBase		*GfxBase		= NULL;
struct	Library		*UtilityBase		= NULL;
struct	Library		*IconBase		= NULL;
struct	Library		*MUIMasterBase		= NULL;
struct	Library		*MathIeeeDoubBasBase	= NULL;
struct	Library		*MathIeeeDoubTransBase	= NULL;
struct	Library		*IFFParseBase		= NULL;




/**********************************************************************/
/*                            The Objects                             */
/**********************************************************************/
static	struct	DiskObject	*DObject	= NULL;
APTR		AppObject			= NULL;		// Is referenced through ARexx module
static	APTR	MainWindow;
static	APTR	InOutGroup;
static	APTR	InputGroup;
APTR		InputString;					// Is referenced through ARexx module
static	APTR	OutputGroup;
APTR		OutputBox;					// Is referenced through ARexx module
static	APTR	FunctionCycle;
static	APTR	PageObject;
static	APTR	InGads[61];
static	APTR	ExeObj;
static	APTR	ClrObj;
static	APTR	AllClrObj;

static	APTR	MainGroup;
static	APTR	FuncGroup;
static	APTR	InGroup;

static	APTR	PrefsWindow;
static	APTR	InOutObj;
static	APTR	DFuncObj;
static	APTR	DInObj;
static	APTR	TypeObj;
static	APTR	SizeObj;
static	APTR	SignObj;
static	APTR	AngleObj;
static	APTR	LinesObj;
static	APTR	LookObj;
static	APTR	ClearInObj;
static	APTR	FlushObj;
static	APTR	ClipObj;
static	APTR	OkObj;
static	APTR	SaveObj;
static	APTR	CancelObj;






/**********************************************************************/
/*                 Strings for Functions Cycle-Gadget                 */
/**********************************************************************/
static const char *FunctionEntries[] =
{
	"Mathematical set",
	"Programmer`s set",
	NULL
};






/**********************************************************************/
/*                      Strings for Prefs-Cycles                      */
/**********************************************************************/
static const char *InOutLookEntries[] =
{
	"Input then Output",
	"Output then Input",
	NULL
};

static const char *TypeEntries[] =
{
	"Decimal",
	"HexDecimal",
	"Octal",
	"Binary",
	NULL
};

static const char *SizeEntries[] =
{
	"8-Bit",
	"16-Bit",
	"32-Bit",
	NULL
};

static const char *SignEntries[] =
{
	"Signed",
	"Unsigned",
	NULL
};

static const char *AngleEntries[] =
{
	"Radians",
	"Degree",
	NULL
};

static const char *LookEntries[] =
{
	"Input & Output",
	"Output & Input",
	"Input",
	"Output",
	NULL
};


static const char *LookTemplates[] =
{
	"COL=0 DELTA=12 P=\033r MAW=100 MIW=0, COL=1 DELTA=12 P=\033r MAW=-1 MIW=-1",
	"COL=1 DELTA=12 P=\033r MAW=-1 MIW=-1, COL=0 DELTA=12 P=\033r MAW=100 MIW=0",
	"COL=0 DELTA=12 P=\033r MIW=100",
	"COL=1 DELTA=12 P=\033r MIW=100"
};



/**********************************************************************/
/*                   Chars/String for window title                    */
/**********************************************************************/
static const char TypeChar[] =
{
	'D',
	'H',
	'O',
	'B'
};

static const char *BaseStr[] =
{
	"8",
	"16",
	"32"
};


static const char SignChar[] =
{
	'S',
	'U',
};


static const char *AngleStr[] =
{
	"RAD",
	"DEG",
};




/**********************************************************************/
/*                          Menu-Definition                           */
/**********************************************************************/
static struct	NewMenu MainMenuDef[] =
{
	NM_TITLE, "Project", NULL, 0, NULL, NULL,
	NM_ITEM, "Preferences...", "P", 0, NULL, (APTR)ID_PREFS,
	NM_ITEM, NM_BARLABEL, NULL, 0, NULL, NULL,
	NM_ITEM, "About...", "?", 0, NULL, (APTR)ID_ABOUT,
	NM_ITEM, NM_BARLABEL, NULL, 0, NULL, NULL,
	NM_ITEM, "Quit", "Q", 0, NULL, (APTR)ID_QUIT,

	NM_TITLE, "Edit", NULL, 0, NULL, NULL,
	NM_ITEM, "Clear", "X", 0, NULL, (APTR)ID_CLEAR,
	NM_ITEM, "All Clear", "Y", 0, NULL, (APTR)ID_ALLCLEAR,

	NM_TITLE, "History", NULL, 0, NULL, NULL,
	NM_ITEM, "Pick left entry", "L", 0, NULL, (APTR)ID_PICKLEFT,
	NM_ITEM, "Pick right entry", "R", 0, NULL, (APTR)ID_PICKRIGHT,
	NM_ITEM, NM_BARLABEL, NULL, 0, NULL, NULL,
	NM_ITEM, "Copy left entry", "F", 0, NULL, (APTR)ID_CLIPCUTLEFT,
	NM_ITEM, "Copy right entry", "G", 0, NULL, (APTR)ID_CLIPCUTRIGHT,

	NM_TITLE, "Display Bases", NULL, 0, NULL, NULL,
	NM_ITEM, "Decimal", "D", CHECKIT|MENUTOGGLE, 14, (APTR)ID_DECIMAL,
	NM_ITEM, "Hexadecimal", "H", CHECKIT|MENUTOGGLE, 13, (APTR)ID_HEXDECIMAL,
	NM_ITEM, "Octal", "O", CHECKIT|MENUTOGGLE, 11, (APTR)ID_OCTAL,
	NM_ITEM, "Binary", "B", CHECKIT|MENUTOGGLE, 7, (APTR)ID_BINARY,

	NM_TITLE, "Size", NULL, 0, NULL, NULL,
	NM_ITEM, "8 Bit", "8", CHECKIT|MENUTOGGLE, 6, (APTR)ID_8BIT,
	NM_ITEM, "16 Bit", "16", CHECKIT|MENUTOGGLE, 5, (APTR)ID_16BIT,
	NM_ITEM, "32 Bit", "32", CHECKIT|MENUTOGGLE, 3, (APTR)ID_32BIT,

	NM_TITLE, "Sign", NULL, 0, NULL, NULL,
	NM_ITEM, "Signed", "S", CHECKIT|MENUTOGGLE, 2, (APTR)ID_SIGNED,
	NM_ITEM, "Unsigned", "U", CHECKIT|MENUTOGGLE, 1, (APTR)ID_UNSIGNED,

	NM_TITLE, "Angle", NULL, 0, NULL, NULL,
	NM_ITEM, "Radians", "A", CHECKIT|MENUTOGGLE, 2, (APTR)ID_RAD,
	NM_ITEM, "Degree", "E", CHECKIT|MENUTOGGLE, 1, (APTR)ID_DEG,

	NM_END, NULL, NULL, 0, NULL, NULL
};





/**********************************************************************/
/*                       Some global Variables                        */
/**********************************************************************/
static struct	Hook	InsertHook = 			// This is our hook for the InputGadgets
{
	{NULL},
	(APTR)InsertFunc,
	NULL,
	NULL
};


static struct	Hook	DispConstructHook =		// Hooks for multi-column display
{
	{NULL},
	(APTR)DispConstructFunc,
	NULL,
	NULL
};

static struct Hook	DispDestructHook =
{
	{NULL},
	(APTR)DispDestructFunc,
	NULL,
	NULL
};

static struct Hook	DispViewHook = 
{
	{NULL},
	(APTR)DispViewFunc,
	NULL,
	NULL
};


char	*ParseInput;				// This has to be global, so that the scanner my find it ;)
APTR	ParsePool;				// Pointer to parser`s memory pool
char	Title[80];				// Title of main window


double	Value,					// Value being displayed and memories
	XMem,
	YMem,
	ZMem;


UWORD	InOutLook	= 0;				// How to order the String and ListView gadgets
UWORD	NoFuncs		= FALSE;			// Display function gadgets ???
UWORD	NoInput		= FALSE;			// Display input gadgets ???
UWORD	IntType		= ID_DECIMAL;			// Current output format
UWORD	IntBase		= ID_32BIT;			// Current conversion base
UWORD	IntSign		= ID_SIGNED;			// Current ouput sign-format
UWORD	IntAngle	= ID_RAD;			// Current angle format
UWORD	HistLines	= 32;				// Default number of history lines
UWORD	ListLook	= 0;				// Look of ListView
UWORD	FlushOnExit	= FALSE;			// Flush memory on exit ???
UWORD	ClearInput	= FALSE;			// Clear input string after RETURN/EXEC ???
UWORD	ClipUnit	= 0;				// Number of clipboard to use
UWORD	ContainsUnDec;					// This is to signal the main program,
							// that non-decimal digits have been used





/**********************************************************************/
/*                        Do the wild thing ;)                        */
/**********************************************************************/
void main(void)
{
	APTR	FlushPtr;
	int	i;

		// Try to open libs

	if(OpenLibs())
	{
			// Try to open the main window

		if(OpenMainWin())
		{
				// Display "0" in desired format

			FormatOutput(FALSE);

				// Handle incoming inputs

			HandleInputs();
		}
		CloseMainWin();
	}
	CloseLibs();


		// Should memory be flushed ???

	if(FlushOnExit)
	{
		for(i = 0; i < 10; i++)
		{
			if((FlushPtr = AllocMem(0x1DCD6500, MEMF_PUBLIC)))
				FreeMem(FlushPtr, 0x1DCD6500);
		}
	}

	exit(0);
}




/**********************************************************************/
/*                      Open-Up needed libraries                      */
/**********************************************************************/
static BOOL OpenLibs(void)
{
	if(!(IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library", 37)))
		return(FALSE);

	if(!(GfxBase = (struct GfxBase *)OpenLibrary("graphics.library", 37)))
		return(FALSE);

	if(!(UtilityBase = OpenLibrary("utility.library", 37)))
		return(FALSE);

	if(!(IconBase = OpenLibrary("icon.library", 37)))
		return(FALSE);

	if(!(MathIeeeDoubBasBase = OpenLibrary("mathieeedoubbas.library", 37)))
		return(FALSE);

	if(!(MathIeeeDoubTransBase = OpenLibrary("mathieeedoubtrans.library", 37)))
		return(FALSE);

	if(!(IFFParseBase = OpenLibrary("iffparse.library", 37)))
		return(FALSE);

	if(!(MUIMasterBase = OpenLibrary("muimaster.library", 0)))
		return(FALSE);

	return(TRUE);
}







/**********************************************************************/
/*                          Close used libs                           */
/**********************************************************************/
static void CloseLibs(void)
{
	if(MUIMasterBase)
		CloseLibrary(MUIMasterBase);

	if(IFFParseBase)
		CloseLibrary(IFFParseBase);

	if(MathIeeeDoubTransBase)
		CloseLibrary(MathIeeeDoubTransBase);

	if(MathIeeeDoubBasBase)
		CloseLibrary(MathIeeeDoubBasBase);

	if(IconBase)
		CloseLibrary(IconBase);

	if(UtilityBase)
		CloseLibrary(UtilityBase);

	if(GfxBase)
		CloseLibrary((struct Library *)GfxBase);

	if(IntuitionBase)
		CloseLibrary((struct Library *)IntuitionBase);
}






/**********************************************************************/
/*                  Set Cycle Chain for main window                   */
/**********************************************************************/
static void SetMainWinCycle(void)
{
	APTR	FirstCycle,
		LastCycle;
	int	GadNum;

	if(!InOutLook)
	{
		FirstCycle	= InputString;
		LastCycle	= OutputBox;
	}
	else
	{
		FirstCycle	= OutputBox;
		LastCycle	= InputString;
	}
		// Set Cycle chanin

	GadNum	= 0;
	DoMethod(MainWindow, MUIM_Window_SetCycleChain,
		FirstCycle,
		LastCycle,
		FunctionCycle,
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		InGads[GadNum++],
		ClrObj,
		AllClrObj,
		ExeObj,
	NULL);
}




/**********************************************************************/
/*                    Open the Calculator`s Window                    */
/**********************************************************************/
static BOOL OpenMainWin(void)
{
	ULONG	Dummy, GadNum = 0;


		// The input String Requester

	InputGroup	= VGroup, Child,
		InputString	=	StringObject, StringFrame,
						MUIA_String_Contents,	"0",
						MUIA_String_MaxLen,	256,
						MUIA_String_Format,	MUIV_String_Format_Right,
						MUIA_String_BufferPos,	1,
					End,
	End;


		// The Output Box

	OutputGroup	= VGroup, Child,
		OutputBox	=	ListviewObject,
						MUIA_Listview_Input,		TRUE,
						MUIA_Listview_List,	ListObject, InputListFrame,
							MUIA_Background,		MUII_ListBack,
							MUIA_List_Format,		"COL=0 DELTA=8 P=\033r MAW=50 MIW=10, COL=1 DELTA=8 P=\033r MAW=50 MIW=10",
							MUIA_List_ConstructHook,	&DispConstructHook,
							MUIA_List_DestructHook,		&DispDestructHook,
							MUIA_List_DisplayHook,		&DispViewHook,
						End,
					End,
	End;


		// Create the Application window

	AppObject	= ApplicationObject,
				MUIA_Application_Title,		"MCalc",
				MUIA_Application_Version,	MUIVERS,
				MUIA_Application_Copyright,	"1993 Kai Iske",
				MUIA_Application_Author,	"Kai Iske",
				MUIA_Application_Description,	"Quite powerful calculator, GiftWare",
				MUIA_Application_Base,		"MCalc",
				MUIA_Application_SingleTask,	TRUE,
				MUIA_Application_DiskObject,	DObject = GetDiskObjectNew("PROGDIR:MCalc"),
				MUIA_Application_Commands,	&RXCommands[0],
				MUIA_HelpFile,			"MCalc.guide",

			// Now head for the main window

		SubWindow, MainWindow =	WindowObject,
						MUIA_Window_Title,	"MUIProCalc "REVISION" - "REVDATE,
						MUIA_Window_ID,		'MPCM',
						MUIA_Window_SizeGadget,	TRUE,
						MUIA_Window_Menu,	&MainMenuDef,
						MUIA_HelpNode,		NODE_MAIN,

				// Do the gadgets

			WindowContents,
			MainGroup = VGroup,

					// First of all the Input and Output Group

				Child,
				InOutGroup = VGroup, GroupFrame,
					MUIA_HelpNode,	NODE_INOUTPUT,
				End, // Input Area

					// Now check for the Function Gadgets

				Child,

				FuncGroup = VGroup, GroupFrame,
					MUIA_HelpNode, NODE_FUNCTIONS,

					Child, ColGroup(2),

							// The Cycle Gadget for Function keys

						Child, KeyLabel1("Function:", 'n'),
						Child, FunctionCycle	=	CycleObject, ButtonFrame,
											MUIA_Cycle_Active,	0,
											MUIA_Cycle_Entries,	FunctionEntries,
											MUIA_ControlChar,	'n',
											MUIA_ExportID,		'FPAG',
										End,
					End, // Cycle Gadget

					// Function Buttons

					Child, PageObject = PageGroup,

						Child, ColGroup(6), MUIA_Group_SameWidth, TRUE,

								// First row of Functions

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Sin",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Cos",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Tan",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"ASin",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"ACos",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"ATan",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"SinH",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"CosH",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"TanH",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Log",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Log10",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Exp",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"^",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Pi",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Sqrt",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Abs",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Cot",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"e",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

						End, // First Button Bank

							// Second Button-Bank

						Child, ColGroup(6), MUIA_Group_SameWidth, TRUE,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Mod",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"And",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Or",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"XOr",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Not",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Asl",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Asr",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Lsl",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Lsr",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Rol",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,

							Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
												MUIA_Text_Contents,	"Ror",
												MUIA_Text_PreParse,	"\33c",
												MUIA_Background,	MUII_ButtonBack,
												MUIA_InputMode,		MUIV_InputMode_RelVerify,
											End,
							Child, HSpace(0),
						End, // Second Button Bank
					End, // Page-Group
				End, // Second Area

				Child,
				InGroup = VGroup, GroupFrame,
					MUIA_HelpNode,	NODE_INPUTS,

					Child, ColGroup(7), MUIA_Group_SameWidth, TRUE,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"A",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"B",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"C",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"D",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"E",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"$",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
											MUIA_Text_Contents,	"0x",
											MUIA_Text_PreParse,	"\33c",
											MUIA_Background,	MUII_ButtonBack,
											MUIA_InputMode,		MUIV_InputMode_RelVerify,
										End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"7",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"8",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"9",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"/",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"F",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"\\",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	=	TextObject, ButtonFrame,
											MUIA_Text_Contents,	"!",
											MUIA_Text_PreParse,	"\33c",
											MUIA_Background,	MUII_ButtonBack,
											MUIA_InputMode,		MUIV_InputMode_RelVerify,
										End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"4",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"5",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"6",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"*",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"X",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"%",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, ClrObj		=	TextObject, ButtonFrame,
											MUIA_Text_Contents,	"CLR",
											MUIA_Text_PreParse,	"\33c",
											MUIA_Background,	MUII_ButtonBack,
											MUIA_InputMode,		MUIV_InputMode_RelVerify,
										End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"1",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"2",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"3",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"-",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"Y",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"(",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, AllClrObj	=	TextObject, ButtonFrame,
											MUIA_Text_Contents,	"ACLR",
											MUIA_Text_PreParse,	"\33c",
											MUIA_Background,	MUII_ButtonBack,
											MUIA_InputMode,		MUIV_InputMode_RelVerify,
										End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"0",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	".",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"=",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"+",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]	= TextObject, ButtonFrame,
										MUIA_Text_Contents,	"Z",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, InGads[GadNum++]=	TextObject, ButtonFrame,
										MUIA_Text_Contents,	")",
										MUIA_Text_PreParse,	"\33c",
										MUIA_Background,	MUII_ButtonBack,
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

						Child, ExeObj		=	TextObject, ButtonFrame,
											MUIA_Text_Contents,	"Exec",
											MUIA_Text_PreParse,	"\33c",
											MUIA_Background,	MUII_ButtonBack,
											MUIA_InputMode,		MUIV_InputMode_RelVerify,
										End,
					End, // Input gadgets
				End, // Third input area
			End, // VGroup
		End, // Main window

			// Now generate the Prefs window

		SubWindow, PrefsWindow = WindowObject,
						MUIA_Window_Title,	"MUIProCalc Preferences",
						MUIA_Window_ID,		'MPCP',
						MUIA_Window_SizeGadget,	TRUE,
						MUIA_Window_NoMenus,	TRUE,
						MUIA_HelpNode,		NODE_PREFS,

			WindowContents, VGroup,

				Child, ColGroup(2),
					Child, VGroup, GroupFrameT("Window layout"),
						MUIA_HelpNode,	NODE_LAYOUT,

						Child, VSpace(0),
						Child, HGroup,

								// Display functions gadget

							Child, HGroup,
								Child, TextObject,
									MUIA_Text_PreParse,	"\033r",
									MUIA_Text_Contents,	"No Functions",
									MUIA_Text_HiChar,	'f',
								End,
								Child, HSpace(1),
								Child, DFuncObj	=	ImageObject, ImageButtonFrame,
												MUIA_InputMode,		MUIV_InputMode_Toggle,
												MUIA_Image_Spec,	MUII_CheckMark,
												MUIA_Image_FreeVert,	TRUE,
												MUIA_Selected,		NoFuncs,
												MUIA_Background,	MUII_ButtonBack,
												MUIA_ShowSelState,	FALSE,
												MUIA_ControlChar,	'f',
												MUIA_ExportID,		'FUNC',
											End,
							End,

								// Display Inputs gadget

							Child, HGroup,
								Child, TextObject,
									MUIA_Text_PreParse,	"\033r",
									MUIA_Text_Contents,	"No Input",
									MUIA_Text_HiChar,	'n',
								End,
								Child, HSpace(1),
								Child, DInObj	=	ImageObject, ImageButtonFrame,
												MUIA_InputMode,		MUIV_InputMode_Toggle,
												MUIA_Image_Spec,	MUII_CheckMark,
												MUIA_Image_FreeVert,	TRUE,
												MUIA_Selected,		NoInput,
												MUIA_Background,	MUII_ButtonBack,
												MUIA_ShowSelState,	FALSE,
												MUIA_ControlChar,	'n',
												MUIA_ExportID,		'INPU',
											End,
							End,
						End,

							// Cycle Gadget for default type

						Child, ColGroup(2),
							Child, KeyLabel1("In/Out Order", 'O'),
							Child, InOutObj	=	CycleObject, ButtonFrame,
											MUIA_Cycle_Active,	InOutLook,
											MUIA_Cycle_Entries,	InOutLookEntries,
											MUIA_ControlChar,	'o',
											MUIA_ExportID,		'ORDR',
										End,
						End,

						Child, VSpace(0),

					End, // Layout gadgets

					Child, VGroup, GroupFrameT("Output settings"),
						MUIA_HelpNode,	NODE_OUTPUT,

						Child, VSpace(0),

							// Cycle Gadget for default type

						Child, ColGroup(2),
							Child, KeyLabel1("Base:", 'B'),
							Child, TypeObj	=	CycleObject, ButtonFrame,
											MUIA_Cycle_Active,	IntType - ID_DECIMAL,
											MUIA_Cycle_Entries,	TypeEntries,
											MUIA_ControlChar,	'b',
											MUIA_ExportID,		'TYPE',
										End,

							Child, KeyLabel1("Size:", 'z'),
							Child, SizeObj	=	CycleObject, ButtonFrame,
											MUIA_Cycle_Active,	IntBase - ID_8BIT,
											MUIA_Cycle_Entries,	SizeEntries,
											MUIA_ControlChar,	'z',
											MUIA_ExportID,		'SIZE',
										End,

							Child, KeyLabel1("Sign:", 'i'),
							Child, SignObj	=	CycleObject, ButtonFrame,
											MUIA_Cycle_Active,	IntSign - ID_SIGNED,
											MUIA_Cycle_Entries,	SignEntries,
											MUIA_ControlChar,	'i',
											MUIA_ExportID,		'SIGN',
										End,

							Child, KeyLabel1("Angle:", 'a'),
							Child, AngleObj	=	CycleObject, ButtonFrame,
											MUIA_Cycle_Active,	IntAngle - ID_RAD,
											MUIA_Cycle_Entries,	AngleEntries,
											MUIA_ControlChar,	'a',
											MUIA_ExportID,		'ANGL',
										End,
						End, // Cycle gadgets

						Child, VSpace(0),

					End, // Output settings



					Child, VGroup, GroupFrameT("History settings"),
						MUIA_HelpNode,	NODE_HISTORY,

						Child, VSpace(0),

							// Number of lines to buffer

						Child, ColGroup(2),
							Child, KeyLabel1("Lines:", 'L'),
							Child, LinesObj	=	SliderObject,
											MUIA_Slider_Level,	HistLines,
											MUIA_Slider_Min,	1,
											MUIA_Slider_Max,	512,
											MUIA_ControlChar,	'l',
											MUIA_ExportID,		'LINE',
										End,


							Child, KeyLabel1("Entries:", 'E'),
							Child, LookObj	=	CycleObject, ButtonFrame,
											MUIA_Cycle_Active,	ListLook,
											MUIA_Cycle_Entries,	LookEntries,
											MUIA_ControlChar,	'e',
											MUIA_ExportID,		'LOOK',
										End,
						End, // History col group

						Child, VSpace(0),

					End, // History settings


					Child, VGroup, GroupFrameT("Misc"),
						MUIA_HelpNode,	NODE_MISC,

						Child, VSpace(0),

							// Clear input checkbox

						Child, HGroup,
							Child, TextObject,
								MUIA_Text_PreParse,	"\033r",
								MUIA_Text_Contents,	"Clear input on exec",
								MUIA_Text_HiChar,	'r',
							End,
							Child, HSpace(1),
							Child, ClearInObj =	ImageObject, ImageButtonFrame,
											MUIA_InputMode,		MUIV_InputMode_Toggle,
											MUIA_Image_Spec,	MUII_CheckMark,
											MUIA_Image_FreeVert,	TRUE,
											MUIA_Selected,		ClearInput,
											MUIA_Background,	MUII_ButtonBack,
											MUIA_ShowSelState,	FALSE,
											MUIA_ControlChar,	'r',
											MUIA_ExportID,		'CLRI',
										End,
						End, // Clear checkbox

							// Flush memory gadget

						Child, HGroup,
							Child, TextObject,
								MUIA_Text_PreParse,	"\033r",
								MUIA_Text_Contents,	"Flush memory",
								MUIA_Text_HiChar,	'm',
							End,
							Child, HSpace(1),
							Child, FlushObj	=	ImageObject, ImageButtonFrame,
											MUIA_InputMode,		MUIV_InputMode_Toggle,
											MUIA_Image_Spec,	MUII_CheckMark,
											MUIA_Image_FreeVert,	TRUE,
											MUIA_Selected,		FlushOnExit,
											MUIA_Background,	MUII_ButtonBack,
											MUIA_ShowSelState,	FALSE,
											MUIA_ControlChar,	'm',
											MUIA_ExportID,		'FLUS',
										End,
						End, // Flush CheckBox


							// Number of clipboard to use

						Child, ColGroup(2),
							Child, KeyLabel1("ClipUnit:", 'P'),
							Child, ClipObj	=	SliderObject,
											MUIA_Slider_Level,	ClipUnit,
											MUIA_Slider_Min,	0,
											MUIA_Slider_Max,	255,
											MUIA_ControlChar,	'p',
											MUIA_ExportID,		'CLIP',
										End,
						End, // Clipboard group

						Child, VSpace(0),

					End, // Misc Group
				End, // Horizontal Groups

					// Ok, Cancel, Save gadgets

				Child, VGroup, GroupFrame,
					Child, ColGroup(3), MUIA_Group_SameWidth, TRUE,

							// Save Gadget

						Child, SaveObj	=	TextObject, ButtonFrame,
										MUIA_Background,	MUII_ButtonBack,
										MUIA_Text_PreParse,	"\33c",
										MUIA_Text_Contents,	"Save",
										MUIA_Text_HiChar,	'S',
										MUIA_ControlChar,	's',
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

							// Use Gadget

						Child, OkObj	=	TextObject, ButtonFrame,
										MUIA_Background,	MUII_ButtonBack,
										MUIA_Text_PreParse,	"\33c",
										MUIA_Text_Contents,	"Use",
										MUIA_Text_HiChar,	'U',
										MUIA_ControlChar,	'u',
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,

							// Cancel Gadget

						Child, CancelObj =	TextObject, ButtonFrame,
										MUIA_Background,	MUII_ButtonBack,
										MUIA_Text_PreParse,	"\33c",
										MUIA_Text_Contents,	"Cancel",
										MUIA_Text_HiChar,	'C',
										MUIA_ControlChar,	'c',
										MUIA_InputMode,		MUIV_InputMode_RelVerify,
									End,
					End, // ColGroup
				End, // Use - Cancel gadgets
			End, // Prefs window contents
		End, // Prefs window
	End; // Application

	if(AppObject && InputGroup && OutputGroup)
	{
			// Set cycle chain for Prefs window

		DoMethod(PrefsWindow, MUIM_Window_SetCycleChain,
			DFuncObj,
			DInObj,
			InOutObj,
			TypeObj,
			SizeObj,
			SignObj,
			AngleObj,
			LinesObj,
			LookObj,
			ClearInObj,
			FlushObj,
			ClipObj,
			OkObj,
			SaveObj,
			CancelObj,
		NULL);

			// Set stuff for main window

		DoMethod(MainWindow, MUIM_Notify,
			MUIA_Window_CloseRequest,	TRUE,
			AppObject,			2,
			MUIM_Application_ReturnID,	ID_QUIT);

			//
			// Do the Gadgets
			//

			// Set ID for String-Input

		DoMethod(InputString, MUIM_Notify,
			MUIA_String_Acknowledge,	MUIV_EveryTime,
			AppObject,			2,
			MUIM_Application_ReturnID,	ID_INPUT);

			// Attach Output box to StringGadget

		set(InputString, MUIA_String_AttachedList, OutputBox);

			// Let the Cycle-Gadget talk to the Page-Group

		DoMethod(FunctionCycle, MUIM_Notify,
			MUIA_Cycle_Active, MUIV_EveryTime,
			PageObject, 3,
			MUIM_Set, MUIA_Group_ActivePage, MUIV_TriggerValue);

			// Reactivate input gadget

		DoMethod(FunctionCycle, MUIM_Notify,
			MUIA_Cycle_Active, MUIV_EveryTime,
			MainWindow, 3,
			MUIM_Set, MUIA_Window_ActiveObject, InputString);


			// Set up control gadgets to call Hook

		for(GadNum = 0; GadNum < 61; GadNum++)
		{
				// First call the Hook when released

			DoMethod(InGads[GadNum], MUIM_Notify,
				MUIA_Pressed,		FALSE,
				AppObject,		3,
				MUIM_CallHook,		&InsertHook, InGads[GadNum]);

				// The reactivate the string gadget

			DoMethod(InGads[GadNum], MUIM_Notify,
				MUIA_Pressed,		FALSE,
				MainWindow,		3,
				MUIM_Set,		MUIA_Window_ActiveObject, InputString);
		}


			// Return ID for Exe gadget

		DoMethod(ExeObj, MUIM_Notify,
			MUIA_Pressed,			FALSE,
			AppObject,			2,
			MUIM_Application_ReturnID,	ID_EXEC);

			// Return ID for CLR gadget

		DoMethod(ClrObj, MUIM_Notify,
			MUIA_Pressed,			FALSE,
			AppObject,			2,
			MUIM_Application_ReturnID,	ID_CLEAR);

			// Return ID for ACLR gadget

		DoMethod(AllClrObj, MUIM_Notify,
			MUIA_Pressed,			FALSE,
			AppObject,			2,
			MUIM_Application_ReturnID,	ID_ALLCLEAR);




			// Do the Prefs window

		DoMethod(PrefsWindow, MUIM_Notify,
			MUIA_Window_CloseRequest,	TRUE,
			AppObject,			2,
			MUIM_Application_ReturnID,	ID_PREFS_QUIT);


			// On OK, first save the prefs to env:

		DoMethod(OkObj, MUIM_Notify,
			MUIA_Pressed,			FALSE,
			AppObject,			2,
			MUIM_Application_Save,		MUIV_Application_Save_ENV);

			// Then signal the main program, that new prefs are available

		DoMethod(OkObj, MUIM_Notify,
			MUIA_Pressed,			FALSE,
			AppObject,			2,
			MUIM_Application_ReturnID,	ID_PREFS_NEW);




			// On SAVE, save both to env: and envarc:

		DoMethod(SaveObj, MUIM_Notify,
			MUIA_Pressed,			FALSE,
			AppObject,			2,
			MUIM_Application_Save, MUIV_Application_Save_ENV);

		DoMethod(SaveObj, MUIM_Notify,
			MUIA_Pressed,			FALSE,
			AppObject,			2,
			MUIM_Application_Save, MUIV_Application_Save_ENVARC);

			// New prefs available

		DoMethod(SaveObj, MUIM_Notify,
			MUIA_Pressed,			FALSE,
			AppObject,			2,
			MUIM_Application_ReturnID,	ID_PREFS_NEW);



			// On Cancel, simply close the window

		DoMethod(CancelObj, MUIM_Notify,
			MUIA_Pressed,			FALSE,
			AppObject,			2,
			MUIM_Application_ReturnID,	ID_PREFS_QUIT);





			// Load the settings

		DoMethod(AppObject, MUIM_Application_Load, MUIV_Application_Load_ENV);


			// Load defaults into variables

		get(DFuncObj, MUIA_Selected, &Dummy);
		NoFuncs = Dummy;

		get(DInObj, MUIA_Selected, &Dummy);
		NoInput = Dummy;

		get(InOutObj, MUIA_Cycle_Active, &Dummy);
		InOutLook = Dummy;

		get(TypeObj, MUIA_Cycle_Active, &Dummy);
		IntType	= RXIntType 	= Dummy + ID_DECIMAL;

		get(SizeObj, MUIA_Cycle_Active, &Dummy);
		IntBase	= RXIntBase	= Dummy + ID_8BIT;

		get(SignObj, MUIA_Cycle_Active, &Dummy);
		IntSign	= RXIntSign	= Dummy + ID_SIGNED;

		get(AngleObj, MUIA_Cycle_Active, &Dummy);
		IntAngle = RXIntAngle	= Dummy + ID_RAD;

		get(LinesObj, MUIA_Slider_Level, &Dummy);
		HistLines = Dummy;

		get(LookObj, MUIA_Cycle_Active, &Dummy);
		ListLook = Dummy;

		get(ClearInObj, MUIA_Selected, &Dummy);
		ClearInput = Dummy;

		get(FlushObj, MUIA_Selected, &Dummy);
		FlushOnExit = Dummy;

		get(ClipObj, MUIA_Slider_Level, &Dummy);
		ClipUnit = Dummy;

			// Add in/out gadgets in correct order

		if(!InOutLook)
		{
			DoMethod(InOutGroup, OM_ADDMEMBER, InputGroup);
			DoMethod(InOutGroup, OM_ADDMEMBER, OutputGroup);
		}
		else
		{
			DoMethod(InOutGroup, OM_ADDMEMBER, OutputGroup);
			DoMethod(InOutGroup, OM_ADDMEMBER, InputGroup);
		}

			// Set cycle chain for main window _AFTER_ String and ListView have been added

		SetMainWinCycle();

			// Set listview look

		set(OutputBox, MUIA_List_Format, LookTemplates[ListLook]);


			// Add/Remove groups as requested

		if(NoFuncs)
			DoMethod(MainGroup, OM_REMMEMBER, FuncGroup, TAG_DONE);

		if(NoInput)
			DoMethod(MainGroup, OM_REMMEMBER, InGroup, TAG_DONE);



			// Set InputString to default object

		set(MainWindow, MUIA_Window_DefaultObject, InputString);


			// Open the main window

		set(MainWindow, MUIA_Window_Open, TRUE);

			// Now set Checkmarks

		DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntType, TRUE);
		DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntBase, TRUE);
		DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntSign, TRUE);
		DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntAngle, TRUE);
	}
	else
	{
		if(InputGroup)
			MUI_DisposeObject(InputGroup);

		if(OutputGroup)
			MUI_DisposeObject(OutputGroup);
	}

	return((BOOL)(AppObject && InputGroup && OutputGroup));
}






/**********************************************************************/
/*                    Close the main window again                     */
/**********************************************************************/
static void CloseMainWin(void)
{
		// Dispose all Objects

	if(AppObject)
	{
		set(MainWindow, MUIA_Window_Open, FALSE);
		MUI_DisposeObject(AppObject);
	}

		// Dispose DiskObject

	if(DObject)
		FreeDiskObject(DObject);
}







/**********************************************************************/
/*                      Format the output string                      */
/**********************************************************************/
BOOL FormatOutput(BOOL ReFormat)
{
	struct	ListStruct	NewEntry,
				*NewEntryPtr;
	ULONG	ULong;
	BOOL	RetVal		= FALSE;

		// Set title of window first

	sprintf(Title, "MUIProCalc "REVISION" - "REVDATE" - %c%s%c %s", TypeChar[IntType - ID_DECIMAL], BaseStr[IntBase - ID_8BIT], SignChar[IntSign - ID_SIGNED], AngleStr[IntAngle - ID_RAD]);
	set(MainWindow, MUIA_Window_Title, Title);

		// Reformat entry ???
	if(!ReFormat)
	{
			// Get the Gadgets buffer

		get(InputString, MUIA_String_Contents, &ParseInput);
		strcpy(NewEntry.Input, ParseInput);
	}
	else
	{
		ULONG	NumEntries;

			// Get input from bottom entry within History

		get(OutputBox, MUIA_List_Entries, &NumEntries);
		DoMethod(OutputBox, MUIM_List_GetEntry, NumEntries - 1, &NewEntryPtr);
		NewEntry	= *NewEntryPtr;
		ParseInput	= NewEntry.Input;
	}

	if(strlen(ParseInput))
	{
			// Allocate memory pool for parsing

		if((ParsePool = DoCreatePool(MEMF_CLEAR, 8192, 2048)))
		{
				// Reset scanner

			yychar			= -2;
			yynerrs			= 0;
			yy_init			= 1;
			yy_start		= 0;
			yyin = yyout		= NULL;
			yy_current_buffer	= NULL;
			ContainsUnDec		= FALSE;

				// Do the parse

			yyparse();

				// Delete pool again

			DoDeletePool(ParsePool);

			if(!yynerrs && !PError)
			{
				RetVal	= TRUE;

				switch(IntType)
				{
					case ID_DECIMAL :
					{
						if(!ContainsUnDec)
						{
							if((Value > 4294967295.0) || (Value < -4294967295.0) || ((Value < 1.0) && (Value > -1.0)))
								sprintf(NewEntry.Output, "%g ", Value);
							else
								sprintf(NewEntry.Output, "%f ", Value);
						}
						else
							sprintf(NewEntry.Output, "%f ", Value);
						break;
					}

					case ID_HEXDECIMAL :
					{
						if((Value > 4294967295.0) || (Value < -4294967295.0))
							strcpy(NewEntry.Output, "\0338Hex overflow");
						else
						{
							sprintf(NewEntry.Output, "%f ", Value);

								// Now convert that output to a Long

							stcd_l(NewEntry.Output, (LONG *)&ULong);

								// And reconvert it to hex output ;)

							sprintf(NewEntry.Output, "$%x ", ULong);
						}
						break;
					}
					case ID_OCTAL :
					{
						if((Value > 4294967295.0) || (Value < -4294967295.0))
							strcpy(NewEntry.Output, "\0338Octal overflow");
						else
						{
							sprintf(NewEntry.Output, "%f ", Value);

								// First convert to Long

							stcd_l(NewEntry.Output, (LONG *)&ULong);

								// Now conbert to octal

							sprintf(NewEntry.Output, "\\%o ", ULong);
						}
						break;
					}
					case ID_BINARY :
					{
						char	AddOn[2];
						int	i,
							NumBits;

						if((Value > 4294967295.0) || (Value < -4294967295.0))
							strcpy(NewEntry.Output, "\0338Binary overflow");
						else
						{
							sprintf(NewEntry.Output, "%f ", Value);

							switch(IntBase)
							{
								case ID_8BIT :
								{
									NumBits = 8;
									break;
								}
								case ID_16BIT :
								{
									NumBits = 16;
									break;
								}
								case ID_32BIT :
								{
									NumBits = 32;
									break;
								}
							}
								// First convert to Long

							stcd_l(NewEntry.Output, (LONG *)&ULong);

								// Set type identifier

							strcpy(NewEntry.Output, "%");

								// Now convert to binary output

							AddOn[1] = '\0';
							for(i = NumBits - 1; i >= 0; i--)
							{
								AddOn[0] = ((ULong & (1L << i)) ? (ULong & (1L << i)) - (1L << i) + '1' : '0');
								strcat(NewEntry.Output, AddOn);

									// 4 Bits done -> insert a space ;)

								if(!(i % 4))
									strcat(NewEntry.Output, " ");
							}
						}
						break;
					}
				}
			}
			else
			{
				if(PError == ERR_PARSE)
					sprintf(NewEntry.Output, "\0338Syntax error in column %d", PColumn);
				else if(PError == ERR_UNKNOWN_CHR)
					sprintf(NewEntry.Output, "\0338Unknown char in column %d", PColumn);
				else if(PError == ERR_DIVBY0)
					sprintf(NewEntry.Output, "\0338Division by Zero in column %d", PColumn);
				else
					sprintf(NewEntry.Output, "\0338Overflow error in column %d", PColumn);
			}

				// On "History-Overflow" remove top entry

			get(OutputBox, MUIA_List_Entries, &ULong);
			if(ULong > HistLines)
				DoMethod(OutputBox, MUIM_List_Remove, MUIV_List_Remove_First);

			NewEntryPtr	= &NewEntry;
			DoMethod(OutputBox, MUIM_List_Insert, &NewEntryPtr, 1, MUIV_List_Insert_Bottom);
			set(OutputBox, MUIA_List_Active, MUIV_List_Active_Bottom);

			if(ClearInput)
				set(InputString, MUIA_String_Contents, "");
		}
		else
			MUI_Request(AppObject, MainWindow, NULL, NULL, "*Ok", "Sorry, no memory for parsing");
	}

	set(MainWindow, MUIA_Window_ActiveObject, InputString);

	return(RetVal);
}







/**********************************************************************/
/*                  Insert Hook for function gadgets                  */
/**********************************************************************/
static ULONG	__saveds __asm InsertFunc(register __a0 struct Hook *MyHook, register __a2 APTR Obj, register __a1 APTR *Data)
{
	char	*Text;

		// Get Text of selected gadget

	get(*Data, MUIA_Text_Contents, &Text);

		// Insert text at cursor position

	InsertText(Text);
	return(0);
}






/**********************************************************************/
/*        Hook-Function for generating a new entry for the LV         */
/**********************************************************************/
static ULONG	__saveds __asm DispConstructFunc(register __a0 struct Hook *MyHook, register __a2 APTR MemPool, register __a1 struct ListStruct *Data)
{
	struct	ListStruct	*New;

	if((New = AllocVec(sizeof(struct ListStruct), MEMF_CLEAR)))
	{
		*New	=	*Data;
		return((ULONG)New);
	}

	return(NULL);
}





/**********************************************************************/
/*         Hook-Function for removing a new entry from the LV         */
/**********************************************************************/
static ULONG	__saveds __asm DispDestructFunc(register __a0 struct Hook *MyHook, register __a2 APTR MemPool, register __a1 struct ListStruct *Data)
{
	FreeVec(Data);
	return(0);
}






/**********************************************************************/
/*                      Put pointers into array                       */
/**********************************************************************/
static ULONG	__saveds __asm DispViewFunc(register __a0 struct Hook *MyHook, register __a2 char **array, register __a1 struct ListStruct *Data)
{
	*array++	= Data->Input;
	*array		= Data->Output;

	return(NULL);
}






/**********************************************************************/
/*        Insert a text-string at the current cursor-position         */
/**********************************************************************/
static void InsertText(char *NewText)
{
	char	NewBuff[258],
		*Text;
	ULONG	CursorPos;

		// No Error ?!?

	if(strncmp(NewText, "\0338", 2))
	{
			// Get current cursor Position within Input-String

		get(InputString, MUIA_String_BufferPos, &CursorPos);
		get(InputString, MUIA_String_Contents, &Text);

			// Copy to buffer, because the string`s contents may not be
			// directly altered

		strcpy(NewBuff, Text);


			// insert to cursor position

		if((strlen(NewBuff) + strlen(NewText)) < 256)
			strins(&NewBuff[CursorPos], NewText);
		else
			DisplayBeep(NULL);

			// Set new string for String-Gadget

		set(InputString, MUIA_String_Contents, NewBuff);
	}

	set(MainWindow, MUIA_Window_ActiveObject, InputString);
}





/**********************************************************************/
/*          Write the given entry to the specified clipboard          */
/**********************************************************************/
static void WriteClip(char *Entry)
{
	struct	IFFHandle	*Handle;
	BOOL	Ok = FALSE;

		// Length > 0 ???

	if(strlen(Entry) && strncmp(Entry, "\0338", 2))
	{
			// Try to obtain an IFF Handle

		if((Handle = AllocIFF()))
		{
				// Open needed clipboard unit

			if((Handle->iff_Stream = (ULONG)OpenClipboard(ClipUnit)))
			{
				InitIFFasClip(Handle);

					// Open Handle for write access

				if(!OpenIFF(Handle, IFFF_WRITE))
				{
						// Push first chunk (FORM)

					if(!PushChunk(Handle, ID_FTXT, ID_FORM, IFFSIZE_UNKNOWN))
					{
							// Push chars chunk

						if(!PushChunk(Handle, 0, ID_CHRS, IFFSIZE_UNKNOWN))
						{
								// Write data to clipboard

							if(WriteChunkBytes(Handle, Entry, strlen(Entry)) == strlen(Entry))
							{
									// Pop contents chunk

								if(!PopChunk(Handle))
									Ok = TRUE;
							}
						}

							// Pop FORM chunk

						if(Ok)
							PopChunk(Handle);
					}

						// Close IFF Handle

					CloseIFF(Handle);
				}

					// Close Clipboard again

				CloseClipboard((struct ClipboardHandle *)Handle->iff_Stream);
			}

				// Free IFF Handle

			FreeIFF(Handle);
		}
	}

	set(MainWindow, MUIA_Window_ActiveObject, InputString);
}






/**********************************************************************/
/*                This is the main controlling routine                */
/**********************************************************************/
static void HandleInputs(void)
{
	ULONG	MySig, ReturnID;
	BOOL	GoOn	= TRUE;

	while(GoOn)
	{
		switch(ReturnID = DoMethod(AppObject, MUIM_Application_Input, &MySig))
		{
				// Input done ;)

			case ID_INPUT :
			{
				FormatOutput(FALSE);
				break;
			}

				// Translate input

			case ID_EXEC :
			{
				FormatOutput(FALSE);
				break;
			}

				// Clear input

			case ID_CLEAR :
			{
				set(InputString, MUIA_String_Contents, "");
				FormatOutput(FALSE);
				break;
			}

				// Clear input AND Memory

			case ID_ALLCLEAR :
			{
				XMem = YMem = ZMem = 0.0;
				set(InputString, MUIA_String_Contents, "");
				FormatOutput(FALSE);
				break;
			}

				// Open Prefs window

			case ID_PREFS :
			{
				set(PrefsWindow, MUIA_Window_Open, TRUE);
				break;
			}

				// Display About

			case ID_ABOUT :
			{
				MUI_Request(AppObject, MainWindow, 0, NULL, "*Okay",
					"\033cMUIProCalc v%ld.%ld, written by Kai Iske, GiftWare\n\n"
					"\0338Powerful calculator, also suited for programmers\n\n"
					"\033l\0332To contact me, write to:\n\033c"
					"Kai Iske, Brucknerstrasse 18, 63452 Hanau, Germany\n"
					"Tel.: +49-(0)6181-850181\n\n"
					"\033lor use electronical mail\n\033c"
					"kai@iske.adsp.sub.org\n"
					"iske@informatik.uni-frankfurt.de\n"
					"Kai Iske, 2:244/6302.11\n"
					"KAI@SWEET.ZER\n\n"
					"\033c\0332MUIProCalc is a MUI-Application\n"
					"MUI is  Stefan Stuntz",
					VERNUM, REVNUM, TAG_DONE);
				set(MainWindow, MUIA_Window_ActiveObject, InputString);
				break;
			}
				// Quit the program

			case ID_QUIT :
			case MUIV_Application_ReturnID_Quit :
			{
				set(PrefsWindow, MUIA_Window_Open, FALSE);
				GoOn = FALSE;
				break;
			}

				// Pick left entry from History ???

			case ID_PICKLEFT :
			{
				struct	ListStruct	*LSV;
				ULONG	ClickCol;

				DoMethod(OutputBox, MUIM_List_GetEntry, MUIV_List_GetEntry_Active, &LSV);

				if(LSV)
				{
					if(ListLook == 0 || ListLook == 2)
						ClickCol = 0;
					else if(ListLook == 1 || ListLook == 3)
						ClickCol = 1;

					if(!ClickCol)
						InsertText(LSV->Input);
					else
						InsertText(LSV->Output);
				}
				break;
			}

				// Pick right entry from History ???

			case ID_PICKRIGHT :
			{
				struct	ListStruct	*LSV;
				ULONG	ClickCol;

				DoMethod(OutputBox, MUIM_List_GetEntry, MUIV_List_GetEntry_Active, &LSV);

				if(LSV)
				{
					if(ListLook == 0 || ListLook == 3)
						ClickCol = 1;
					else if(ListLook == 1 || ListLook == 2)
						ClickCol = 0;

					if(!ClickCol)
						InsertText(LSV->Input);
					else
						InsertText(LSV->Output);
				}
				break;
			}

				// Copy left history entry to clipboard

			case ID_CLIPCUTLEFT :
			{
				struct	ListStruct	*LSV;
				ULONG	ClickCol;

				DoMethod(OutputBox, MUIM_List_GetEntry, MUIV_List_GetEntry_Active, &LSV);

				if(LSV)
				{
					if(ListLook == 0 || ListLook == 2)
						ClickCol = 0;
					else if(ListLook == 1 || ListLook == 3)
						ClickCol = 1;

					if(!ClickCol)
						WriteClip(LSV->Input);
					else
						WriteClip(LSV->Output);
				}

				break;
			}

				// Copy left history entry to clipboard

			case ID_CLIPCUTRIGHT :
			{
				struct	ListStruct	*LSV;
				ULONG	ClickCol;

				DoMethod(OutputBox, MUIM_List_GetEntry, MUIV_List_GetEntry_Active, &LSV);

				if(LSV)
				{
					if(ListLook == 0 || ListLook == 3)
						ClickCol = 1;
					else if(ListLook == 1 || ListLook == 2)
						ClickCol = 0;

					if(!ClickCol)
						WriteClip(LSV->Input);
					else
						WriteClip(LSV->Output);
				}

				break;
			}

				// Check Output Type

			case ID_DECIMAL :
			case ID_HEXDECIMAL :
			case ID_OCTAL :
			case ID_BINARY :
			{
				DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntType, FALSE);
				IntType	= ReturnID;
				DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntType, TRUE);
				FormatOutput(TRUE);
				break;
			}

				// Check for Bases

			case ID_8BIT :
			case ID_16BIT :
			case ID_32BIT :
			{
				DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntBase, FALSE);
				IntBase	= ReturnID;
				DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntBase, TRUE);
				FormatOutput(TRUE);
				break;
			}

				// Check for Signs

			case ID_SIGNED :
			case ID_UNSIGNED :
			{
				DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntSign, FALSE);
				IntSign	= ReturnID;
				DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntSign, TRUE);
				FormatOutput(TRUE);
				break;
			}

				// Check angle

			case ID_RAD :
			case ID_DEG :
			{
				DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntAngle, FALSE);
				IntAngle	= ReturnID;
				DoMethod(MainWindow, MUIM_Window_SetMenuCheck, (ULONG)IntAngle, TRUE);
				FormatOutput(TRUE);
				break;
			}




				//
				// This is for the Prefs window
				//

				// Close prefs window

			case ID_PREFS_QUIT :
			{
				set(PrefsWindow, MUIA_Window_Open, FALSE);
				set(MainWindow, MUIA_Window_ActiveObject, InputString);

					// Reset preferences

				set(InOutObj, MUIA_Cycle_Active, InOutLook);
				set(DFuncObj, MUIA_Selected, NoFuncs);
				set(DInObj, MUIA_Selected, NoInput);
				set(TypeObj, MUIA_Cycle_Active, (ULONG)IntType);
				set(SizeObj, MUIA_Cycle_Active, (ULONG)IntBase);
				set(SignObj, MUIA_Cycle_Active, (ULONG)IntSign);
				set(AngleObj, MUIA_Cycle_Active, (ULONG)IntAngle);
				set(LinesObj, MUIA_Slider_Level, (ULONG)HistLines);
				set(LookObj, MUIA_Cycle_Active, (ULONG)ListLook);
				set(ClearInObj, MUIA_Selected, (ULONG)ClearInput);
				set(FlushObj, MUIA_Selected, (ULONG)FlushOnExit);
				set(ClipObj, MUIA_Slider_Level, (ULONG)ClipUnit);
				break;
			}

			case ID_PREFS_NEW :
			{
				ULONG	NewInOut, NewFunc, NewInput, NewLook;

					// Get clear flag

				get(ClearInObj, MUIA_Selected, &NewFunc);
				ClearInput = NewFunc;

					// Get flush flag

				get(FlushObj, MUIA_Selected, &NewFunc);
				FlushOnExit = NewFunc;

					// Get ClipBoard unit

				get(ClipObj, MUIA_Slider_Level, &NewFunc);
				ClipUnit = NewFunc;

				set(PrefsWindow, MUIA_Window_Open, FALSE);
				get(LinesObj, MUIA_Slider_Level, &NewFunc);
				HistLines = NewFunc;

					// Rebuild History

				get(OutputBox, MUIA_List_Entries, &NewInput);
				while(NewInput > HistLines)
				{
					DoMethod(OutputBox, MUIM_List_Remove, MUIV_List_Remove_First);
					NewInput--;
				}

					// Check for changes on layout

				get(InOutObj, MUIA_Cycle_Active, &NewInOut);
				get(DFuncObj, MUIA_Selected, &NewFunc);
				get(DInObj, MUIA_Selected, &NewInput);
				get(LookObj, MUIA_Cycle_Active, &NewLook);

				if((NewInOut != InOutLook) || (NewFunc != NoFuncs) || (NewInput != NoInput))
				{
						// Close main window first

					set(MainWindow, MUIA_Window_Open, FALSE);

						// Rearrange input output order

					if(NewInOut != InOutLook)
					{
						InOutLook = NewInOut;

							// Remove groups first

						DoMethod(InOutGroup, OM_REMMEMBER, InputGroup);
						DoMethod(InOutGroup, OM_REMMEMBER, OutputGroup);

							// Readd groups

						if(!InOutLook)
						{
							DoMethod(InOutGroup, OM_ADDMEMBER, InputGroup);
							DoMethod(InOutGroup, OM_ADDMEMBER, OutputGroup);
						}
						else
						{
							DoMethod(InOutGroup, OM_ADDMEMBER, OutputGroup);
							DoMethod(InOutGroup, OM_ADDMEMBER, InputGroup);
						}

							// Reset cycle order

						SetMainWinCycle();
					}

						// First remove existent groups from main group

					if(!NoFuncs)
						DoMethod(MainGroup, OM_REMMEMBER, FuncGroup);

					if(!NoInput)
						DoMethod(MainGroup, OM_REMMEMBER, InGroup);

						// Add Function group when needed

					NoFuncs = NewFunc;
					if(!NoFuncs)
						DoMethod(MainGroup, OM_ADDMEMBER, FuncGroup);

						// Add Input group when needed

					NoInput = NewInput;
					if(!NoInput)
						DoMethod(MainGroup, OM_ADDMEMBER, InGroup);


						// Reopen window

					set(MainWindow, MUIA_Window_Open, TRUE);
				}

				if(NewLook != ListLook)
				{
							// Set listview look

					ListLook = NewLook;
					set(OutputBox, MUIA_List_Format, LookTemplates[ListLook]);
				}

				set(MainWindow, MUIA_Window_Activate, TRUE);
				set(MainWindow, MUIA_Window_ActiveObject, InputString);
				break;
			}
		}

		if(GoOn && MySig)
			Wait(MySig);
	}
}
