#define RDS_TITLE     "MBPURGE"                 /*  Program Name      */
#ifdef __OS2__
  #undef  RDS_TITLE
  #define RDS_TITLE   "MBPURGEP"                /*  Program Name      */
#endif
#define RDS_DATES     "1995"                    /*  Copyright Date    */
#define RDS_VERSION   "1.00"                    /*  Version Number    */

/******************************************************************************
*******************************************************************************
**
**          Copyright (c) Bob Swift, 1995.  All Rights Reserved.
**
**   This program is used to read the MEXBANK.DAT file generated by MexBank
**   and remove any users not found in the Maximus USER.BBS file.  Both files
**   must be in the current directory.
**
**   The program is used as follows:
**
**                       MBPURGE [?]        for DOS version
**
**                          or
**
**                       MBPURGEP [?]       for OS/2 version
**
**   The program will display a VERY brief set of instructions if it is called
**   with a question mark, or if it encounters an error.  The following is a
**   list of the error codes returned by the program:
**
**             0 - No errors.  Normal termination.
**             1 - Extra command line arguments.
**             2 - Error creating MEXBANK.BAK backup file.
**             3 - Error reading USER.BBS input file.
**             4 - Error reading MEXBANK.DAT input file.
**             5 - Error writing MEXBANK.DAT output file.
**
**   When an error is encountered, the program will exit immediately and will
**   attempt to properly close all files.
**
*******************************************************************************
*******************************************************************************
**
**   Revision History
**   ----------------
**
**   1.00     95/08/29    First release version.
**
*******************************************************************************
******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#ifdef __OS2__
  #include <os2.h>
#endif
#include "max_u.h"


void helpscrn(int ernum, int instruct);

/*******************************************************************/

void main(int argc, char *argv[])
{

FILE *in_max, *in_tb, *out_tb;
static struct _usr user_data;
char inline[128],temp[128],temp1[80];
struct stat buf;
int i;

printf("\n\n%s Version %s\n",RDS_TITLE,RDS_VERSION);
printf("Copyright (c) Bob Swift, %s.  All Rights Reserved.\n\n",RDS_DATES);

if (argc > 1) helpscrn(1,1);

remove("mexbank.bak");

if (rename("mexbank.dat","mexbank.bak") != 0) helpscrn(2,1);

if ((in_max=fopen("user.bbs","rb")) == NULL) helpscrn(3,1);

if ((in_tb=fopen("mexbank.bak","rt")) == NULL) helpscrn(4,1);

if ((out_tb=fopen("mexbank.dat","wt")) == NULL) helpscrn(5,1);

while (fgets(inline,128,in_tb) != NULL)
  {
  strcpy(temp,inline);
  temp[35] = '\0';
  printf("\rChecking:  %s",temp);
  rewind(in_max);
  i = 0;
  while (i == 0)
    {
    if (fread(&user_data,sizeof(struct _usr),1,in_max) != 1)
      {
      i = 1;
      printf("\r%-79s\rPurged:  %s\n"," ",temp);
      }
    strcpy(temp1,user_data.name);
    strcat(temp1,"                                   ");
    temp1[35] = '\0';
    if (i == 0)
      {
      if (strcmpi(temp1,temp) == 0)
        {
        i = 1;
        if (fputs(inline,out_tb) == EOF) helpscrn(5,0);
        }
      }
    }
  }

fclose(in_max);
fclose(in_tb);
fclose(out_tb);

printf("\r%79s"," ");
printf("\nComplete.  Thank-you for using %s.\n\n",RDS_TITLE);
exit(0);
}

/*******************************************************************/

void helpscrn(int ernum, int instruct)
/*  Here are the error messages and VERY brief instructions  */
{
printf("\n");
switch (ernum) {

/* case  1 : printf("Bad or missing command line argument\n\n"); */
/*           break;                                              */

case  2 : printf("ERROR creating MEXBANK.BAK backup file.\n\n");
          break;

case  3 : printf("ERROR reading USER.BBS input file.\n\n");
          break;

case  4 : printf("ERROR reading MEXBANK.DAT input file.\n\n");
          break;

case  5 : printf("ERROR writing MEXBANK.DAT output file.\n\n");
          break;
    }

if (instruct != 0)
  {
  printf("This program is used to read the MEXBANK.DAT file generated by MexBank\n");
  printf("and remove any users not found in the Maximus USER.BBS file.  Both files\n");
  printf("must be in the current directory.\n\nThe program is used as follows:   ");
  printf("%s [?]\n\n",RDS_TITLE);
  }

exit(ernum);
}

