/* Recreate objects script.
 * 
 * Generated via Object Desktop Package File 'MBase'.
 * Modified by Marsiglietti Max 1997.
 */

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
'@cls'

/* Get the boot drive location */
OurPath = Value( 'PATH',,'OS2ENVIRONMENT' )
parse var OurPath .";" BootDrv "\OS2;".
BootDrv = strip(BootDrv)
BootDrv = right(BootDrv, 2)

curdir = directory()
say "MaxBase installation program for OS/2 Warp."
say "------- ------------ ------- --- ---- -----"
say
say "This installation procedure will create the WPS"
say " objects you will need to use MaxBase and its"
say " C/S counterparts, Sportello and RXDBServer."
say "Also, if this is your first MaxBase installation,"
say " your "bootdrv"\config.sys file will be changed."
say
say "Close this window now to abort,"
say "or press ENTER to proceed with"
say "installation."
Parse Upper Pull Answer
'@start e readme.os2'
CreateCollision = 'Replace' 

InnF=BootDrv'\CONFIG.MBS'
OutF=BootDrv'\CONFIG.SYS'
'@copy 'OutF' 'InnF' >nul'
'@del 'OutF

msg.1 = "** No system files changed. **"
msg.2 = "** You can start using MaxBase right now. **"

classpathpresent = 0
do until lines(InnF) = 0

 InStr = linein(InnF)

 if (translate(Left(word(instr, 2), 9)) = "CLASSPATH") then
  classpathpresent = 1

 if (translate(Left(word(instr, 2), 9)) = "CLASSPATH") & (pos(translate(curdir"\client"), translate(instr)) = 0) then
 do
  instr = strip(instr)
  if right(instr, 1)\=";" then
   instr = instr || ";"
  instr = instr || curdir"\NetRexxR.zip;"curdir";"curdir"\taligent.zip;"curdir"\client;"curdir"\server;.\.;"
  msg.1 =  "** "BootDrv"\Config.sys changed. **"
  msg.2 =  "** You must now restart your computer before using MaxBase. **"
 end
 call lineout outf, instr
end
if classpathpresent=0 then
do
 call lineout outf, "SET CLASSPATH=" || curdir"\NetRexxR.zip;"curdir";"curdir"\taligent.zip;"curdir"\client;"curdir"\server;.\.;"
  msg.1 =  "** "BootDrv"\Config.sys changed. **"
  msg.2 =  "** You must now restart your computer before using MaxBase. **"
end

say "Done registering changes to classpath."
say msg.1
say msg.2
say "Press ENTER to proceed with WPS object creation."
Parse Upper Pull Answer

Call CreateObjects
say "Done registering objects on the WPS."
Exit

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateObjects:

dtop = SysIni(SYSTEM, "FolderWorkareaRunningObjects", "ALL:", dtloc)

if dtloc.0 > 0 then dtop = dtloc.1
say "Please enter your desktop location (ENTER="dtop")"
parse pull dtuserloc .
if dtuserloc \= "" then dtop = dtuserloc

rc = CreateObject( 'WPFolder',,
    'MaxBase',,
    '<WP_DESKTOP>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=85,63;'||,
        'ICONVIEWPOS=20 760 58 25;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'ALWAYSSORT=YES;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<MaxBase>',,
    CreateCollision )

rc = CreateObject( 'WPFolder',,
    'Docs',,
    '<MaxBase>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=85,63;'||,
        'ICONVIEWPOS=20 760 58 20;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'ALWAYSSORT=YES;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<MB_DOCS>',,
    CreateCollision )

rc = CreateObject( 'WPShadow',,
    'db_store',,
    '<MaxBase>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=UNKNOWN;'||,
        'HELPPANEL=1277;'||,    
        'SHADOWID=' || curdir || '\db_store;'||,
        'ICONPOS=68,90',,
    CreateCollision )


  rc = CreateObject( 'WPShadow',,
    'Readme.os2',,
    '<MB_DOCS>',,
    'DEFAULTVIEW=UNKNOWN;'||,
        'HELPPANEL=4082;'||,
        'SHADOWID=' || curdir || '\Readme.os2;'||,
        'ICONPOS=87,19',,
    CreateCollision )


  rc = CreateObject( 'WPShadow',,
    'Readme.1st',,
    '<MB_DOCS>',,
    'DEFAULTVIEW=UNKNOWN;'||,
        'HELPPANEL=4082;'||,
        'SHADOWID=' || curdir || '\Readme.1st;'||,
        'ICONPOS=87,19',,
    CreateCollision )


  rc = CreateObject( 'WPShadow',,
    'SportelloApplet.doc',,
    '<MB_DOCS>',,
    'DEFAULTVIEW=UNKNOWN;'||,
        'HELPPANEL=4082;'||,
        'SHADOWID=' || curdir || '\client\SportelloApplet.doc;'||,
        'ICONPOS=87,19',,
    CreateCollision )


  rc = CreateObject( 'WPShadow',,
    'MaxBase.doc',,
    '<MB_DOCS>',,
    'DEFAULTVIEW=UNKNOWN;'||,
        'HELPPANEL=4082;'||,
        'SHADOWID=' || curdir || '\MaxBase.doc;'||,
        'ICONPOS=87,19',,
    CreateCollision )


  rc = CreateObject( 'WPShadow',,
    'RXDbase.doc',,
    '<MB_DOCS>',,
    'DEFAULTVIEW=UNKNOWN;'||,
        'HELPPANEL=4082;'||,
        'SHADOWID=' || curdir || '\RXDbase.doc;'||,
        'ICONPOS=87,19',,
    CreateCollision )


  rc = CreateObject( 'WPShadow',,
    'RXDBclient.doc',,
    '<MB_DOCS>',,
    'DEFAULTVIEW=UNKNOWN;'||,
        'HELPPANEL=4082;'||,
        'SHADOWID=' || curdir || '\Client\RXDBclient.doc;'||,
        'ICONPOS=87,19',,
    CreateCollision )


  rc = CreateObject( 'WPProgram',,
      'Open local DB',,
      '<MaxBase>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=2,6;'||,
          'ASSOCFILTER=*.DAT;'||,
          'EXENAME=' || curdir || '\MAXBASE.CMD;'||,
          'PARAMETERS=%**F;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE=' || curdir || '\ICONS\MaxBase.ICO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Share DB on the network',,
      '<MaxBase>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15684;'||,
          'ICONPOS=88,82;'||,
          'ICONVIEWPOS=36 76 38 16;'||,
          'ASSOCFILTER=*.DAT;'||,
          'EXENAME=' || curdir || '\server\runserver.cmd;'||,
          'PARAMETERS=/d:%**F /p:[Port?] /l:log.txt /a:[Password? ENTER=none];'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES;'||,
          'ICONFILE=' || curdir || '\ICONS\RXDBServer.ICO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Access a remote DB',,
      '<MaxBase>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15684;'||,
          'ICONPOS=16,6;'||,
          'EXENAME=' || curdir || '\client\runclient.cmd;'||,
          'PARAMETERS=[Host?] [Port?] [Password? ENTER=none];'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE=' || curdir || '\ICONS\RXDBClient.ICO',,
      CreateCollision )

rc = CreateObject( 'WPFolder',,
    'NewDB',,
    '<MaxBase>',,
    'TEMPLATE=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=15685;'||,
        'ICONPOS=54,82;'||,
        'SELFCLOSE=1;'||,
        'ICONVIEWPOS=38 73 33 18;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID=<NewDB>',,
    CreateCollision )

'@copy 'curdir'\rxdb.dat 'dtop'\MaxBase\NewDB'

rc = CreateObject( 'WPUrl',,
    'Get the latest Java 1.02 runtime for OS/2!',,
    '<MaxBase>',,
    'DEFAULTVIEW=CONTENTS;'||,
    'URL=ftp://ftp.hursley.ibm.com/pub/java/fixes/os2/102/;'||,
    'ICONPOS=56,47',,
    CreateCollision )


  rc = CreateObject( 'WPShadow',,
    'readme.plugins',,
    '<MB_DOCS>',,
    'DEFAULTVIEW=UNKNOWN;'||,
        'HELPPANEL=4082;'||,
        'SHADOWID=' || curdir || '\readme.plugins;'||,
        'ICONPOS=87,19',,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'SmartGuide to MaxBase',,
      '<MaxBase>',,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=15684;'||,
          'ICONPOS=16,6;'||,
          'STARTUPDIR=' || curdir || ';' ||,
          'EXENAME=sguide.exe;'||,
          'PARAMETERS=' || curdir || '\mbase.sgs;',,
      CreateCollision )
return
