; Assembly code for a disk utility from the book "Peter Norton's Assembly
; Language Book for the IBM PC" suitable for use by MAX assembler.
; See the book if you want the comments. All the INCLUDES were merged into
; this file to reduce disk clutter.
; This program reads or modifies disk sectors in drive A.
;----------------------------------------------------------------------------
; Press F1 for previous sector, F2 for next sector, F10 to exit
;----------------------------------------------------------------------------
disk_patch:CALL CLEAR_SCREEN
CALL WRITE_HEADER
CALL READ_SECTOR
CALL INIT_SEC_DISP
LEA DX,EDITOR_PROMPT
CALL WRITE_PROMPT_LINE
CALL DISPATCHER
INT 20H
SECTOR_OFFSET DW 0
CURRENT_SECTOR_NO DW 0
DISK_DRIVE_NO DB 0
LINES_BEFORE_SECTOR DB 2
HEADER_LINE_NO DB 0
HEADER_PART_1 DB 'Disk ',0
HEADER_PART_2 DB '        Sector ',0
PROMPT_LINE_NO DB 21
EDITOR_PROMPT DB 'PRESS FUNCTION KEY, OR ENTER'
DB ' CHARACTER OR HEX BYTE: ',0
sector db 512 dup (0)
DISPATCHER:PUSH AX
 push bx
 PUSH DX
 DISPATCH_LOOP:CALL READ_BYTE
 OR AH,AH
 JZ NO_CHARS_READ
 JS SOFT_KEY
 MOV DL,AL
 CALL EDIT_BYTE
 JMP DISPATCH_LOOP
 SOFT_KEY:CMP AL,68
 JE END_DISPATCH
 LEA BX,DISPATCH_TABLE
 SPECIAL_LOOP:CMP BYTE PTR [BX],0
 JE NOT_IN_TABLE
 CMP AL,[BX]
 JE DISPATCH
 ADD BX,3
 JMP SPECIAL_LOOP
 DISPATCH:INC BX
 CALL WORD PTR [BX]
 JMP DISPATCH_LOOP
 NOT_IN_TABLE:JMP DISPATCH_LOOP
 NO_CHARS_READ:LEA DX,EDITOR_PROMPT
 CALL WRITE_PROMPT_LINE
 JMP DISPATCH_LOOP
 END_DISPATCH:POP DX
 POP BX
 pop ax
 RET
DISPATCH_TABLE DB 59
 DW OFFSET PREVIOUS_SECTOR
 DB 60
 DW OFFSET NEXT_SECTOR
 DB 72
 DW OFFSET PHANTOM_UP
 DB 80
 DW OFFSET PHANTOM_DOWN
 DB 75
 DW OFFSET PHANTOM_LEFT
 DB 77
 DW OFFSET PHANTOM_RIGHT
 DB 88
 DW OFFSET WRITE_SECTOR
 DB 0
MOV_TO_HEX_POSITION:PUSH AX
 push cx
 push dx
 MOV DH,LINES_BEFORE_SECTOR
 ADD DH,2
 ADD DH,PHANTOM_CURSOR_Y
 MOV DL,8
 MOV CL,3
 MOV AL,PHANTOM_CURSOR_X
 MUL CL
 ADD DL,AL
 CALL GOTO_XY
 pop dx
 pop cx
 pop ax
 RET
MOV_TO_ASCII_POSITION:PUSH AX
 push dx
 MOV DH,LINES_BEFORE_SECTOR
 ADD DH,2
 ADD DH,PHANTOM_CURSOR_Y
 MOV DL,59
 ADD DL,PHANTOM_CURSOR_X
 CALL GOTO_XY
 pop dx
 pop ax
 RET
SAVE_REAL_CURSOR:PUSH AX
 push bx
 push cx
 push dx
 MOV AH,3
 XOR BH,BH
 INT 10H
 MOV REAL_CURSOR_Y,DL
 MOV REAL_CURSOR_X,DH
 POP DX
 pop cx
 pop bx
 pop ax
 RET
RESTORE_REAL_CURSOR:PUSH DX
 MOV DL,REAL_CURSOR_Y
 MOV DH,REAL_CURSOR_X
 CALL GOTO_XY
 POP DX
 RET
WRITE_PHANTOM:PUSH CX
 push dx
 CALL SAVE_REAL_CURSOR
 CALL MOV_TO_HEX_POSITION
 MOV CX,4
 MOV DL,70H
 CALL WRITE_ATTRIBUTE_N_TIMES
 CALL MOV_TO_ASCII_POSITION
 MOV CX,1
 CALL WRITE_ATTRIBUTE_N_TIMES
 CALL RESTORE_REAL_CURSOR
 POP DX
 pop cx
 RET
ERASE_PHANTOM:PUSH CX
 push dx
 CALL SAVE_REAL_CURSOR
 CALL MOV_TO_HEX_POSITION
 MOV CX,4
 MOV DL,7
 CALL WRITE_ATTRIBUTE_N_TIMES
 CALL MOV_TO_ASCII_POSITION
 MOV CX,1
 CALL WRITE_ATTRIBUTE_N_TIMES
 CALL RESTORE_REAL_CURSOR
 POP DX
 pop cx
 RET
REAL_CURSOR_X DB 0
REAL_CURSOR_Y DB 0
PHANTOM_CURSOR_X DB 0
PHANTOM_CURSOR_Y DB 0
PHANTOM_UP:CALL ERASE_PHANTOM
 DECBY PHANTOM_CURSOR_Y
 JNS WASNT_AT_TOP
 CALL SCROLL_DOWN
 WASNT_AT_TOP:CALL WRITE_PHANTOM
 RET
PHANTOM_DOWN:CALL ERASE_PHANTOM
 INCBY PHANTOM_CURSOR_Y
 CMPBY PHANTOM_CURSOR_Y,16
 JB WASNT_AT_BOTTOM
 CALL SCROLL_UP
 WASNT_AT_BOTTOM:CALL WRITE_PHANTOM
 RET
PHANTOM_LEFT:CALL ERASE_PHANTOM
 DECBY PHANTOM_CURSOR_X
 JNS WASNT_AT_LEFT
 MOVBY PHANTOM_CURSOR_X,0
 WASNT_AT_LEFT:CALL WRITE_PHANTOM
 RET
PHANTOM_RIGHT:CALL ERASE_PHANTOM
 INCBY PHANTOM_CURSOR_X
 CMPBY PHANTOM_CURSOR_X,16
 JB WASNT_AT_RIGHT
 MOVBY PHANTOM_CURSOR_X,15
 WASNT_AT_RIGHT:CALL WRITE_PHANTOM
 RET
SCROLL_UP:PUSH DX
 CALL ERASE_PHANTOM
 CALL SAVE_REAL_CURSOR
 XOR DL,DL
 MOV DH,LINES_BEFORE_SECTOR
 ADD DH,2
 CALL GOTO_XY
 MOV DX,256
 MOV SECTOR_OFFSET,DX
 CALL DISP_HALF_SECTOR
 CALL RESTORE_REAL_CURSOR
 MOVBY PHANTOM_CURSOR_Y,0
 CALL WRITE_PHANTOM
 POP DX
 RET
SCROLL_DOWN:PUSH DX
 CALL ERASE_PHANTOM
 CALL SAVE_REAL_CURSOR
 XOR DL,DL
 MOV DH,LINES_BEFORE_SECTOR
 ADD DH,2
 CALL GOTO_XY
 XOR DX,DX
 MOV SECTOR_OFFSET,DX
 CALL DISP_HALF_SECTOR
 CALL RESTORE_REAL_CURSOR
 MOVBY PHANTOM_CURSOR_Y,15
 CALL WRITE_PHANTOM
 POP DX
 RET
write_to_memory:PUSH AX
 PUSH BX
 PUSH CX
 MOV BX,SECTOR_OFFSET
 MOV AL,PHANTOM_CURSOR_Y
 XOR AH,AH
 MOV CL,4
 SHL AX,CL
 ADD BX,AX
 MOV AL,PHANTOM_CURSOR_X
 XOR AH,AH
 ADD BX,AX
 MOV SECTOR[BX],DL
 POP CX
 POP BX
 POP AX
 RET
EDIT_BYTE:PUSH DX
 CALL SAVE_REAL_CURSOR
 CALL MOV_TO_HEX_POSITION
 CALL CURSOR_RIGHT
 CALL WRITE_HEX
 CALL MOV_TO_ASCII_POSITION
 CALL WRITE_CHAR
 CALL RESTORE_REAL_CURSOR
 CALL WRITE_PHANTOM
 CALL WRITE_TO_MEMORY
 LEA DX,EDITOR_PROMPT
 CALL WRITE_PROMPT_LINE
 POP DX
 RET
READ_SECTOR:PUSH AX
 push bx
 push cx
 push dx
 MOV AL,DISK_DRIVE_NO
 MOV CX,1
 MOV DX,CURRENT_SECTOR_NO
 LEA BX,SECTOR
 INT 25h
 POPF
 POP DX
 pop cx
 pop bx
 pop ax
 RET
WRITE_SECTOR:PUSH AX
 push bx
 push cx
 push dx
 MOV AL,DISK_DRIVE_NO
 MOV CX,1
 MOV DX,CURRENT_SECTOR_NO
 LEA BX,SECTOR
 INT 26h
 POPF
 POP DX
 pop cx
 pop bx
 pop ax
 RET
PREVIOUS_SECTOR:PUSH AX
 push dx
 MOV AX,CURRENT_SECTOR_NO
 OR AX,AX
 JZ DONT_DECREMENT_SECTOR
 DEC AX
 MOV CURRENT_SECTOR_NO,AX
 CALL WRITE_HEADER
 CALL READ_SECTOR
 CALL INIT_SEC_DISP
 LEA DX,EDITOR_PROMPT
 CALL WRITE_PROMPT_LINE
 DONT_DECREMENT_SECTOR:POP DX
 pop ax
 RET
NEXT_SECTOR:PUSH AX
 push dx
 MOV AX,CURRENT_SECTOR_NO
 INC AX
 MOV CURRENT_SECTOR_NO,AX
 CALL WRITE_HEADER
 CALL READ_SECTOR
 CALL INIT_SEC_DISP
 LEA DX,EDITOR_PROMPT
 CALL WRITE_PROMPT_LINE
 POP DX
 pop ax
 RET
VERT_BAR EQU 0BAH
HORIZ_BAR EQU 0CDH
UPPER_LEFT EQU 0C9H
UPPER_RIGHT EQU 0BBH
LOWER_LEFT EQU 0C8H
LOWER_RIGHT EQU 0BCH
TOP_T_BAR EQU 0CBH
BOTTOM_T_BAR EQU 0CAH
TOP_TICK EQU 0D1H
BOTTOM_TICK EQU 0CFH
DISP_HALF_SECTOR:PUSH CX
 PUSH DX
 MOV CX,16
 HALF_SECTOR:CALL DISP_LINE
 CALL SEND_CRLF
 ADD DX,16
 LOOP HALF_SECTOR
 POP DX
 POP CX
 RET
DISP_LINE:PUSH BX
 PUSH CX
 PUSH DX
 MOV BX,DX
 MOV DL,' '
 MOV CX,3
 CALL WRITE_CHAR_N_TIMES
 CMP BX,100h
 JB WRITE_ONE
 MOV DL,"1"
 WRITE_ONE:CALL WRITE_CHAR
 MOV DL,BL
 CALL WRITE_HEX
 MOV DL,' '
 CALL WRITE_CHAR
 MOV DL,VERT_BAR
 CALL WRITE_CHAR
 MOV DL,' '
 CALL WRITE_CHAR
 MOV CX,16
 PUSH BX
 HEXLOOP:MOV DL,SECTOR[BX]
 CALL WRITE_HEX
 MOV DL,' '
 CALL WRITE_CHAR
 INC BX
 LOOP HEXLOOP
 MOV DL,VERT_BAR
 CALL WRITE_CHAR
 MOV DL,' '
 CALL WRITE_CHAR
 MOV CX,16
 POP BX
 ASCII_LOOP:MOV DL,SECTOR[BX]
 CALL WRITE_CHAR
 INC BX
 LOOP ASCII_LOOP
 MOV DL,' '
 CALL WRITE_CHAR
 MOV DL,VERT_BAR
 CALL WRITE_CHAR
 POP DX
 POP CX
 POP BX
 RET
TOP_LINE_PATTERN DB ' ',7
DB UPPER_LEFT,1
DB HORIZ_BAR,12
DB TOP_TICK,1
DB HORIZ_BAR,11
DB TOP_TICK,1
DB HORIZ_BAR,11
DB TOP_TICK,1
DB HORIZ_BAR,12
DB TOP_T_BAR,1
DB HORIZ_BAR,18
DB UPPER_RIGHT,1
DB 0
BOTTOM_LINE_PATTERN DB ' ',7
DB LOWER_LEFT,1
DB HORIZ_BAR,12
DB BOTTOM_TICK,1
DB HORIZ_BAR,11
DB BOTTOM_TICK,1
DB HORIZ_BAR,11
DB BOTTOM_TICK,1
DB HORIZ_BAR,12
DB BOTTOM_T_BAR,1
DB HORIZ_BAR,18
DB LOWER_RIGHT,1
DB 0
INIT_SEC_DISP:PUSH DX
 XOR DL,DL
 MOV DH,LINES_BEFORE_SECTOR
 CALL GOTO_XY
 CALL WRITE_TOP_HEX_NUMBERS
 LEA DX,TOP_LINE_PATTERN
 CALL WRITE_PATTERN
 CALL SEND_CRLF
 XOR DX,DX
 MOV SECTOR_OFFSET,DX
 CALL DISP_HALF_SECTOR
 LEA DX,BOTTOM_LINE_PATTERN
 CALL WRITE_PATTERN
 CALL WRITE_PHANTOM
 POP DX
 RET
WRITE_TOP_HEX_NUMBERS:PUSH CX
 PUSH DX
 MOV DL,' '
 MOV CX,9
 CALL WRITE_CHAR_N_TIMES
 XOR DH,DH
 HEX_NUMBER_LOOP:MOV DL,DH
 CALL WRITE_HEX
 MOV DL,' '
 CALL WRITE_CHAR
 INC DH
 CMP DH,10H
 JB HEX_NUMBER_LOOP
 MOV DL,' '
 MOV CX,2
 CALL WRITE_CHAR_N_TIMES
 XOR DL,DL
 HEX_DIGIT_LOOP:CALL WRITE_HEX_DIGIT
 INC DL
 CMP DL,10H
 JB HEX_DIGIT_LOOP
 CALL SEND_CRLF
 POP DX
 pop cx
 RET
WRITE_HEX:PUSH CX
 PUSH DX
 MOV DH,DL
 MOV CX,4
 SHR DL,CL
 CALL WRITE_HEX_DIGIT
 MOV DL,DH
 AND DL,0FH
 CALL WRITE_HEX_DIGIT
 POP DX
 POP CX
 RET
WRITE_HEX_DIGIT:PUSH DX
 CMP DL,10
 JAE HEX_LETTER
 ADD DL,'0'
 JMP WRITE_DIGIT
 HEX_LETTER:ADD DL,'A'-10
 WRITE_DIGIT:CALL WRITE_CHAR
 POP DX
 RET
WRITE_CHAR:PUSH AX
 push bx
 push cx
 push dx
 MOV AH,9
 MOV BH,0
 MOV CX,1
 MOV AL,DL
 MOV BL,7
 INT 10H
 CALL CURSOR_RIGHT
 POP DX
 pop cx
 pop bx
 pop ax
 RET
WRITE_DECIMAL:PUSH AX
 push cx
 push dx
 push si
 MOV AX,DX
 MOV SI,10
 XOR CX,CX
 NON_ZERO:XOR DX,DX
 DIV SI
 PUSH DX
 INC CX
 OR AX,AX
 JNE NON_ZERO
 WRITE_DIGIT_LOOP:POP DX
 CALL WRITE_HEX_DIGIT
 LOOP WRITE_DIGIT_LOOP
 END_DECIMAL:POP SI
 pop dx
 pop cx
 pop ax
 RET
WRITE_CHAR_N_TIMES:PUSH CX
 N_TIMES:CALL WRITE_CHAR
 LOOP N_TIMES
 POP CX
 RET
WRITE_PATTERN:PUSH AX
 PUSH CX
 PUSH DX
 PUSH SI
 PUSHF
 CLD
 MOV SI,DX
 PATTERN_LOOP:LODSB
 OR AL,AL
 JZ END_PATTERN
 MOV DL,AL
 LODSB
 MOV CL,AL
 XOR CH,CH
 CALL WRITE_CHAR_N_TIMES
 JMP PATTERN_LOOP
 END_PATTERN:POPF
 POP SI
 pop dx
 pop cx
 pop ax
 RET
WRITE_HEADER:PUSH DX
 XOR DL,DL
 MOV DH,HEADER_LINE_NO
 CALL GOTO_XY
 LEA DX,HEADER_PART_1
 CALL WRITE_STRING
 MOV DL,DISK_DRIVE_NO
 ADD DL,'A'
 CALL WRITE_CHAR
 LEA DX,HEADER_PART_2
 CALL WRITE_STRING
 MOV DX,CURRENT_SECTOR_NO
 CALL WRITE_DECIMAL
 CALL CLEAR_TO_END_OF_LINE
 POP DX
 RET
WRITE_STRING:PUSH AX
 push dx
 push si
 PUSHF
 CLD
 MOV SI,DX
 STRING_LOOP:LODSB
 OR AL,AL
 JZ END_OF_STRING
 MOV DL,AL
 CALL WRITE_CHAR
 JMP STRING_LOOP
 END_OF_STRING:POPF
 POP SI
 pop dx
 pop ax
 RET
WRITE_PROMPT_LINE:PUSH DX
 XOR DL,DL
 MOV DH,PROMPT_LINE_NO
 CALL GOTO_XY
 POP DX
 CALL WRITE_STRING
 CALL CLEAR_TO_END_OF_LINE
 RET
WRITE_ATTRIBUTE_N_TIMES:PUSH AX
 push bx
 push cx
 push dx
 MOV BL,DL
 XOR BH,BH
 MOV DX,CX
 MOV CX,1
 ATTR_LOOP:MOV AH,8
 INT 10H
 MOV AH,9
 INT 10H
 CALL CURSOR_RIGHT
 DEC DX
 JNZ ATTR_LOOP
 POP DX
 pop cx
 pop bx
 pop ax
 RET
BS EQU 8
ESC EQU 27
STRING_TO_UPPER:PUSH AX
 PUSH BX
 PUSH CX
 MOV BX,DX
 INC BX
 MOV CL,[BX]
 XOR CH,CH
 UPPER_LOOP:INC BX
 MOV AL,[BX]
 CMP AL,'a'
 JB NOT_LOWER
 CMP AL,'z'
 JA NOT_LOWER
 ADD AL,'A'-'a'
 MOV [BX],AL
 NOT_LOWER:LOOP UPPER_LOOP
 POP CX
 POP BX
 POP AX
 RET
CONVERT_HEX_DIGIT:CMP AL,'0'
 JB BAD_DIGIT
 CMP AL,'9'
 JA TRY_HEX
 SUB AL,'0'
 CLC
 RET
 TRY_HEX:CMP AL,'A'
 JB BAD_DIGIT
 CMP AL,'F'
 JA BAD_DIGIT
 SUB AL,'A'-10
 CLC
 RET
 BAD_DIGIT:STC
 RET
HEX_TO_BYTE:PUSH BX
 PUSH CX
 MOV BX,DX
 MOV AL,[BX]
 CALL CONVERT_HEX_DIGIT
 JC BAD_HEX
 MOV CX,4
 SHL AL,CL
 MOV AH,AL
 INC BX
 MOV AL,[BX]
 CALL CONVERT_HEX_DIGIT
 JC BAD_HEX
 OR AL,AH
 CLC
 DONE_HEX:POP CX
 POP BX
 RET
 BAD_HEX:STC
 JMP DONE_HEX
READ_STRING:PUSH AX
 PUSH BX
 PUSH SI
 MOV SI,DX
 START_OVER:MOV BX,2
 MOV AH,7
 INT 21H
 OR AL,AL
 JZ EXTENDED
 NOT_EXTENDED:CMP AL,CR
 JE END_INPUT
 CMP AL,BS
 JNE NOT_BS
 CALL BACK_SPACE
 CMP BL,2
 JE START_OVER
 JMP READ_NEXT_CHAR
 NOT_BS:CMP AL,ESC
 JE PURGE_BUFFER
 CMP BL,[SI]
 JA BUFFER_FULL
 MOV [SI+BX],AL
 INC BX
 PUSH DX
 MOV DL,AL
 CALL WRITE_CHAR
 POP DX
 READ_NEXT_CHAR:MOV AH,7
 INT 21H
 OR AL,AL
 JNE NOT_EXTENDED
 MOV AH,7
 INT 21H
 SIGNAL_ERROR:PUSH DX
 MOV DL,7
 MOV AH,2
 INT 21H
 POP DX
 JMP READ_NEXT_CHAR
 PURGE_BUFFER:PUSH CX
 MOV CL,[SI]
 XOR CH,CH
 PURGE_LOOP:CALL BACK_SPACE
 LOOP PURGE_LOOP
 POP CX
 JMP START_OVER
 BUFFER_FULL:JMP SIGNAL_ERROR
 EXTENDED:MOV AH,7
 INT 21H
 MOV [SI+2],AL
 MOV BL,0FFH
 JMP END_STRING
 END_INPUT:SUB BL,2
 END_STRING:MOV [SI+1],BL
 POP SI
 POP BX
 POP AX
 RET
READ_BYTE:PUSH DX
 MOVBY CHAR_NUM_LIMIT,3
 LEA DX,CHAR_NUM_LIMIT
 CALL READ_STRING
 CMPBY NUM_CHARS_READ,1
 JE ASCII_INPUT
 JB NO_CHARACTERS
 CMPBY NUM_CHARS_READ,0FFH
 JE SPECIAL_KEY
 CALL STRING_TO_UPPER
 LEA DX,CHARS
 CALL HEX_TO_BYTE
 JC NO_CHARACTERS
 MOV AH,1
 DONE_READ:POP DX
 RET
 NO_CHARACTERS:XOR AH,AH
 JMP DONE_READ
 ASCII_INPUT:MOV AL,CHARS
 MOV AH,1
 JMP DONE_READ
 SPECIAL_KEY:MOV AL,CHARS[0]
 MOV AH,0FFH
 JMP DONE_READ
CHAR_NUM_LIMIT DB 0
NUM_CHARS_READ DB 0
CHARS DB 80 DUP (0)
BACK_SPACE:PUSH AX
 PUSH DX
 CMP BX,2
 JE END_BS
 DEC BX
 MOV AH,2
 MOV DL,BS
 INT 21H
 MOV DL,20H
 CALL WRITE_CHAR
 MOV DL,BS
 INT 21H
 END_BS:POP DX
 POP AX
 RET
CR  EQU   13
LF  EQU   10
SEND_CRLF:PUSH AX
 PUSH DX
 MOV AH,2
 MOV DL,CR
 INT 21h
 MOV DL,LF
 INT 21h
 POP DX
 POP AX
 RET
clear_screen:push ax
 PUSH BX
 PUSH CX
 PUSH DX
 XOR AL,AL
 XOR CX,CX
 MOV DH,24
 MOV DL,79
 MOV BH,7
 MOV AH,6
 INT 10H
 POP DX
 pop cx
 pop bx
 pop ax
 RET
GOTO_XY:PUSH AX
 push bx
 MOV BH,0
 MOV AH,2
 INT 10H
 POP BX
 pop ax
 RET
CURSOR_RIGHT:PUSH AX
 push bx
 push cx
 push dx
 MOV AH,3
 MOV BH,0
 INT 10H
 MOV AH,2
 INC DL
 CMP DL,79
 JBE OK
 CALL SEND_CRLF
 JMP DONE
 OK:INT 10H
 DONE:POP DX
 pop cx
 pop bx
 pop ax
 RET
CLEAR_TO_END_OF_LINE:PUSH AX
 push bx
 push cx
 push dx
 MOV AH,3
 XOR BH,BH
 INT 10H
 MOV AH,6
 XOR AL,AL
 MOV CH,DH
 MOV CL,DL
 MOV DL,79
 MOV BH,7
 INT 10H
 POP DX
 pop cx
 pop bx
 pop ax
 RET
