/*  File: MAVFRENT.HPP      Updated: Tue Aug 15 15:55:13 1995
Copyright (c) Fabrizio Aversa
===========================================================*/
#ifndef MAVFRENT_HPP
#define MAVFRENT_HPP

#define INCL_DOSNLS        /* National Language Support values */
#include <os2.h>

#include <ikeyevt.hpp>
#include <ictlevt.hpp>
#include <ikeyhdr.hpp>
#include <ifocshdr.hpp>
#include <idate.hpp>
#include <itime.hpp>
#include <istring.hpp>
#include <ientryfd.hpp>
#include <icmdevt.hpp>
#include <icolor.hpp>
#include <strstrea.h>
#include <imsgbox.hpp>

class _Export FormEntryField: public IEntryField,
public IKeyboardHandler,
public IFocusHandler
{
   public:
   FormEntryField(unsigned long, IWindow *);
   FormEntryField(unsigned long, IWindow *, IWindow *, const IRectangle &);
   virtual IWindow & setFocus();
   COUNTRYINFO  CountryInfo; /* Buffer for country-specific information */
   
   private:
   virtual Boolean characterKeyPress(IKeyboardEvent&)= 0;
   
   protected:
   virtual Boolean gotFocus(IControlEvent&);
   virtual Boolean lostFocus(IControlEvent&);
   IWindow * piwParent;
};

class _Export NumEntryField: public FormEntryField
{
   public:
   NumEntryField(unsigned long, IWindow *, IWindow *,const IRectangle &, 
   Boolean= true, Boolean= false, double = 0.0, double  = 0.0);
   NumEntryField(unsigned long, IWindow *, Boolean= true, Boolean= false,
   double = 0.0, double = 0.0);
   double getDouble();
   NumEntryField & setDouble(double);
   
   private:
   
   double dblMin, dblMax;
   IString strValidChars;
   
   virtual Boolean characterKeyPress(IKeyboardEvent&);
   virtual Boolean lostFocus(IControlEvent&);
   virtual Boolean gotFocus(IControlEvent&);
   
   IString format(double, Boolean);
   Boolean booThous; /* true if user wants thousands separators */
   Boolean booShowZero; /* true if user wants to show '0' when field=0 */
};

class _Export AlphaEntryField: public FormEntryField
{
   public:
   AlphaEntryField(unsigned long, IWindow *, IWindow *,
   const IRectangle &, Boolean= false, Boolean= false, IString="", IString="");
   AlphaEntryField(unsigned long, IWindow *,
   Boolean= false, Boolean= false, IString="", IString="");
   
   private:
   virtual Boolean characterKeyPress(IKeyboardEvent&);
   virtual Boolean lostFocus(IControlEvent&);
   Boolean booCaps, booNoNum;
   IString strAllowed, strRegex;
   
};

class _Export DateEntryField: public FormEntryField
{
   public:
   DateEntryField(unsigned long, IWindow *, IWindow *, 
   const IRectangle &, Boolean= false);
   DateEntryField(unsigned long, IWindow *, Boolean= false);
   IDate getDate();
   DateEntryField & setDate(IDate &);
   
   private:
   virtual Boolean characterKeyPress(IKeyboardEvent&);
   virtual Boolean lostFocus(IControlEvent&);
   Boolean booNoYear;
   
};

class _Export TimeEntryField: public FormEntryField
{
   public:
   TimeEntryField(unsigned long, IWindow *, IWindow *, const IRectangle &);
   TimeEntryField(unsigned long, IWindow *);
   ITime getTime();
   TimeEntryField & setTime(ITime &);
   
   private:
   virtual Boolean characterKeyPress(IKeyboardEvent&);
   virtual Boolean lostFocus(IControlEvent&);
   
};

#endif
