function y=cosw(npoints, f0, df, ph0)
%y=cosw(num_of_points, num_of_cycles, delta_cycles, initial_phase)
%create frequency hopping cosine wave composed of segements of linear
%FM cosine waves
%
%num_of_points - number of points in each segment
%f0            - inital frequency
%df            - frequency deviation
%ph0           - initial phase
%
%Example: cosw(256, 2, 3) generates a linear FM signal

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

if nargin < 1
  error('insufficient arguments')
end
npoints=npoints(:);   % make sure it is a col vector
[mp,np]=size(npoints);

if nargin < 4
   ph0=zeros(mp,np);  % zero initial phase - radians
else
   ph0=ph0(:);
   [m0,n0]=size(ph0);
   if m0 ~= mp | n0 ~= np
      error('initial phase - dimension error')
   end
end

if nargin < 3
   df=zeros(mp,np);   % no frequency deviation
else
   df=df(:);
   [m0,n0]=size(df);
   if m0 ~= mp | n0 ~= np
      error('frequency deviation - dimension error')
   end
end

if nargin < 2
   f0=ones(mp,np);    % single cycle
else
   f0=f0(:);
   [m0,n0]=size(f0);
   if m0 ~= mp | n0 ~= np
      error('cycles - dimension error')
   end
end

y=[];
pi2=atan(1.0)*8;
for i1=1:mp
   n = npoints(i1);
   t = (0:(n-1))/n;                  % time
   ph1 = (f0(i1)+0.5*df(i1)*t).*t;   % phase
   ph1 -= floor(ph1);                % reduce roundoff errors

   y=[y  cos(pi2*ph1+ph0(i1))];
end
