%Demonstartion of MAthViews' AutoAssign technology.
%By changing x and/or n the affected graphics windows updates
%automatically, by the invocation of the appropriate M-file

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

% Let us define the graphics windows for this demo

clear
% Graphics Windows Placement (8 graphics windows)
_xw=[0.59   0   0.2 0.25
    0.79   0        0.2 0.25
    0.59   0.25   0.2 0.25
    0.79   0.25   0.2 0.25
    0.59   0.5     0.2 0.25
    0.79   0.5     0.2 0.25
    0.59   0.75   0.2 0.25
    0.79   0.75   0.2 0.25];

%Graphics Windows Titles
_xt=['G1'
     'G2'
     'G3'
     'G4'
     'G5'
     'G6'
     'G7'
     'G8'];

%define palette colors (RGB values)
_pl=[127   0 127
       0   0   0          % black
     255   0   0          % red
       0 255   0          % green
       0   0 255          % blue
       0 255 255          % light blue
     255   0 255          % magenta
     255 255   0          % yellow
     127 127 127          % dark gray
     127   0   0          % dark red
       0 127   0          % dark green
       0   0 127          % dark blue
       0 127 127          % dark indigo
     127   0 127          % purple
     127 127   0          % dark yellow
     192 192 192          % light gray
      64 127   0
     127  64   0
     127   0  64
     127  64  64
      64   0  64
      64  64 127
     127 255   0
     255 127 255
       0 255 127
     255   0 127
     255 127 127];

gwinit(_xw,_xt,_pl);   % initialize Graphic Windows


% Now the input arguments

x=1:32    % input argument
n=1       % input argument

% autoplot is an M-file which generates x-y plot in a specified
% graphics window. Autoplot forth parameter is the window title.

y1:=autoplt(x,x.^2,1,'x.^2');
y2:=autoplt(x,abs(fft(x)),2,'abs(fft(x))');
y3:=autoplt(x,sin(6*n*x/max(x)),3,'sin(x)');

% automesh is an M-file which generates a mesh plot in a specified
% graphics window. Autoplot third parameter is the window title.

y4:=automsh(x'*x,4,'sin(x)');

disp('now change x and n in the interactive and watch how the related');
disp('plots update automatically');
disp('NOTE: x should be a vector and n a scalar');
disp('');
disp('You may clear the relations with the clear command');
disp('For single graphics window use gwinit(1)');
