#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <string.h>
#include "obuffer.h"
#include "header.h"

#include "playwav.h"


FileObuffer::FileObuffer (uint32 number_of_channels)
{
#ifdef DEBUG
  if (!number_of_channels || number_of_channels > MAXCHANNELS)
  {
    fprintf(stderr,"FileObuffer: number of channels has to be in [1,%d] !\n",MAXCHANNELS);
    exit (1);
  }
#endif

  fop=fopen("testout.raw","wb");

  channels = number_of_channels;
  for (int i = 0; i < number_of_channels; ++i)
    bufferp[i] = buffer + i;

}


void FileObuffer::append (uint32 channel, int16 value)
{
#ifdef DEBUG
  if (channel >= channels)
  {
    fprintf(stderr,"illegal channelnumber in FileObuffer::append()!\n");
    exit (1);
  }
  if (bufferp[channel] - buffer >= OBUFFERSIZE)
  {
    fprintf(stderr,"FileObuffer: buffer overflow!\n");
    exit (1);
  }
#endif

  *bufferp[channel] = value;
  bufferp[channel] += channels;
}


void FileObuffer::write_buffer (int fd)
{
  int length = (int)((char *)bufferp[0] - (char *)buffer), writelength;

  writelength=fwrite ((char *)buffer,1, length,fop);

  for (int i = 0; i < channels; ++i)
    bufferp[i] = buffer + i;
}


#ifdef OS2

#define BUFMULT 10

//int OS2Obuffer::open_audio_device (void)
//{
//}


OS2Obuffer::OS2Obuffer (uint32 number_of_channels, Header *header)
{
#ifdef DEBUG
  if (!number_of_channels || number_of_channels > MAXCHANNELS)
  {
//    cerr << "LinuxObuffer: 0 < number of channels < " << MAXCHANNELS << "!\n";
    exit (1);
  }
#endif
  channels = number_of_channels;

  for (int i = 0; i < number_of_channels; ++i)
    bufferp[i] = buffer + i;

  // configure the device:
  int play_sample_rate = header->frequency ();

  p=new playwav(OBUFFERSIZE*2*BUFMULT,play_sample_rate,channels);
  bpos=0;next=bigbuf;
  //OBUFFERSIZE=2304*2
  memset(buffer,0,sizeof(buffer));
/*
  for(int q=0;q<BUFMULT*(PLSIZE/10)*0;q++) {
    bufferp[0]=&buffer[OBUFFERSIZE];
    write_buffer(0);
  }
*/
}


OS2Obuffer::~OS2Obuffer (void)
{
  int q;

  memset(buffer,0,sizeof(buffer));
//  printf("ending...");
  for(q=0;q<BUFMULT*PLSIZE*(3-channels)+1;q++) {
    bufferp[0]=&buffer[OBUFFERSIZE/(3-channels)];
    write_buffer(0);
  }
  delete p;
}


#ifdef DEBUG
void OS2Obuffer::append (uint32 channel, int16 value)
{
  if (channel >= channels)
  {
    fprintf(stderr,"illegal channelnumber in OS2Obuffer::append()!\n");
    exit (1);
  }
  if (bufferp[channel] - buffer >= OBUFFERSIZE)
  {
    fprintf(stderr,"buffer overflow!\n");
    exit (1);
  }
  *bufferp[channel] = value;
  bufferp[channel] += channels;
}
#endif


void OS2Obuffer::write_buffer (int)
{
  int length = (int)((char *)bufferp[0] - (char *)buffer);
//  printf("W");  
//  p->playdata((char*)buffer, length);
  memcpy(next,buffer,length);
  next+=length;bpos++;

  if(bpos*channels==BUFMULT*2) {
    p->playdata(bigbuf,(int)(next-bigbuf));
    next=bigbuf;bpos=0;
  }

  for (int i = 0; i < channels; ++i)
    bufferp[i] = buffer + i;
}

#endif	/* OS2 */

