#include <os2.h>
#include <stdlib.h>
#include <dlistimp.h>
#include <iostream.h>
#include <stdio.h>
#include <pmbitmap.h>
#include "tile.hh"
#include "playfield.hh"
#include "sprite.hh"
#include "seek.hh"

#include "debug.h"

Path shit;

path_elem::path_elem()
{
    curPos[0] = curPos[1] = 0;
    drctn = next_drctn = move_none;

}

path_elem::path_elem( const path_elem& src )
{
    curPos[0] = src.curPos[0];
    curPos[1] = src.curPos[1];

    drctn      = src.drctn;
    next_drctn = src.next_drctn;
}

path_elem::~path_elem()
{
    // nothing to do
}

void path_elem::operator= ( const path_elem& src)
{
    curPos[0] = src.curPos[0];
    curPos[1] = src.curPos[1];

    drctn      = src.drctn;
    next_drctn = src.next_drctn;
}


const int MAXPLEN = 10;


movement get_next_direction ( movement curDir )
{
    return next_dir[curDir];
}

Path *seekTarget(playfield* myFld, Path *myPath, int *curPos, int* trgPos)
{
  int path_len=0;
  movement drctn;
  int Pos[2];

  Pos[0]=curPos[0];
  Pos[1]=curPos[1];

  drctn = move_up;

  while( 1 )
  {
    drctn = myFld->check_legal ( Pos, move_up);

    while ((drctn == move_none) || (path_len >= MAXPLEN)) /* Dead end or maximum depth?? */
    {
        cout << "Backtrack\n";
        if (myPath->peekHead() == NULL)
        {
          cout << "No Path found\n";
            return NULL;  /* No backtracking possible ? */
        }
        else
        {
            /* Backtrack man... */
            drctn     = myFld->check_legal( Pos, myPath->peekHead()->next_drctn);  /* check alternative */
            Pos[0] = myPath->peekHead()->curPos[0];
            Pos[1] = myPath->peekHead()->curPos[1];
            path_len--;                                                            /* Eject last path entry */
            myPath->detach( myPath->peekHead() );
        }
    }


    // calculate new position
    Pos[directions[drctn]] += signs[drctn];

    path_len++;

    path_elem *newOne = new path_elem;

    newOne->curPos[horizontal] = Pos[horizontal];
    newOne->curPos[vertical]   = Pos[vertical];
    newOne->drctn             = drctn;
    newOne->next_drctn        = get_next_direction ( drctn );

    cout << "path_len=" << path_len << " dir="<< drctn << " altdir=" << newOne->next_drctn <<endl;

    myPath->add ( newOne );

    if ( myFld->check ( Pos, trgPos) == 0 )
        return myPath; /* Ziel gefunden */
  }

}


