//  setupdlg.h  -  setup dialog sample code  -  1.2
//
//  This is a part of the MetaKit library.
//  Copyright (c) 1996 Meta Four Software.
//  All rights reserved.
/////////////////////////////////////////////////////////////////////////////

#include "scandisk.h"

/////////////////////////////////////////////////////////////////////////////
// CSetupDialog dialog

class CSetupDialog : public CDialog, public cStatusHandler
{
// Construction
public:
    CSetupDialog(CWnd* pParent = NULL); // standard constructor

// Dialog Data
    //{{AFX_DATA(CSetupDialog)
    enum { IDD = IDD_SETUP_DIALOG };
    CButton m_okBtn;
    CButton m_browseBtn;
    CButton m_deleteBtn;
    CButton m_addBtn;
    CButton m_updateBtn;
    CStatic m_status;
    CEdit   m_root;
    CString m_name;
    //}}AFX_DATA

private:
    CString m_origRoot;
    BOOL m_exists;
    int m_timer;
    BOOL m_allowScan;
    CMyEdit m_nameEditCtrl;
    
// Implementation
protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

    virtual bool UpdateStatus(const char* text);
    
    void NameChange(BOOL delay);
    void ScanDirectories();
    void InspectCatalog();
    void AdjustButtons(BOOL inScan_ =FALSE);
    
    // Generated message map functions
    //{{AFX_MSG(CSetupDialog)
    afx_msg void OnAddBtn();
    virtual BOOL OnInitDialog();
    afx_msg void OnUpdateBtn();
    afx_msg void OnDelBtn();
    afx_msg void OnBrowseBtn();
    afx_msg void OnChangeName();
    afx_msg void OnChangeRoot();
    afx_msg void OnTimer(UINT nIDEvent);
    afx_msg void OnKillfocusRoot();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
