Program PM_Colors_Manager;

uses crt, dos, strOp, os2def, os2base, os2pmapi, miscUtil, Helpers;

const
    Version    = '1.0.0';
    srcApp     : pChar = 'PM_Colors';
    dstApp     : pChar = 'PM_Default_Colors';
    actNothing = 0;
    actLoad    = 1;
    actSave    = 2;
    actReset   = 3;
    actCurrent = 4;
    actCustom  = 5;
    actView    = 6;

var Action     : Byte;
    AltFile,
    PalFile,
    CustPal    : PathStr;
    UserINI    : hIni;
    appHAB     : Hab;

Procedure TypeHelp;
begin
 Writeln(' Usage: ColMng {ResourceFile} [/?HACLSRVD]');
 Writeln(' /?,H  - Display this help text');
 Writeln(' /A{#} - Set alternative .INI file (for Save & Load operations)');
 Writeln(' /C{#} - Set custom palette (identify by name; empty for help)');
 Writeln(' /L{#} - Load color palette from resource file; empty for default');
 Writeln(' /S{#} - Save color palette into resource file; empty for default');
 Writeln(' /R{#} - Remove specified palette; empty for default');
 Writeln(' /V{#} - View sections in .INI file beginning from # (PM_ to list schemes)');
 Writeln(' /D    - Set PM default colors to current colors');
 Writeln('         Useful if you are using different from WPS shell (i.e. FILEBAR)');
 TextAttr:=$08;
 Writeln('ôExample: ColMng /s MyColors.Ini');
 Writeln('ô         ColMng /lPM_Windows_Colors MyColors.Ini');
 Writeln('ô         ColMng /rPM_Lilac_Colors');
 Writeln('         ColMng /d');
 Halt(1);
end;

Procedure PaletteHelp;
begin
 Writeln(' Scheme names used by PM color setup (case sensitive; add `PM_` before):');
 Writeln(' Windows_Colors      Khaki_Colors      Lilac_Colors       Blush_Colors');
 Writeln(' Boston_Colors       Southwest_Colors  Summer_Days_Colors Clovers_Colors');
 Writeln(' Blue_Jeans_Colors   Lemonade_Colors   Spring_Glen_Colors Lcd_Colors');
 Writeln(' Evening_Rose_Colors Sunshine_Colors   Dusty_Dark_Colors  Mono_Colors');
 Writeln(' Sea_Green_Colors    Mint_Twist_Colors Night_Music_Colors System_Colors');
 Writeln(' Blueberry_Colors    Blue_Sky_Colors   Ocean_Colors       OS2_Default_Colors');
 Writeln(' All mentioned palettes are located in OS2SYS.INI, not in OS2.INI');
 TextAttr:=$08;
 Writeln('Example: ColMng /cPM_Blue_Sky_Colors');
 Halt(1);
end;

Procedure Error(No : Byte);
begin
 TextAttr := $04;
 case No of
  1 : Writeln('Cannot open specified INI file');
  2 : Writeln('Source palette not found in INI file');
  3 : Writeln('Cannot get sections list for specified INI file');
 end;
 Halt(No + 1);
end;

Function MyParmHandler(var S : String) : Byte;
var tempS : String;

Procedure GetCustName;
var I : Longint;
begin
 CustPal := ''; I := 2;
 While (I <= length(S)) and (S[I] > ' ') do
  begin CustPal := CustPal + S[I]; Inc(I); end;
 MyParmHandler := pred(I);
end;

begin
 MyParmHandler := 1;
 case upCase(S[1]) of
  'A' : begin
         tempS := CustPal;
         GetCustName;
         AltFile := CustPal + #0;
         CustPal := tempS;
        end;
  'L' : begin
         Action := actLoad;
         GetCustName;
        end;
  'S' : begin
         Action := actSave;
         GetCustName;
        end;
  'R' : begin
         Action := actReset;
         GetCustName;
        end;
  'V' : begin
         Action := actView;
         GetCustName;
        end;
  'D' : Action := actCurrent;
  'C' : begin
         Action := actCustom;
         GetCustName;
         if CustPal = '' then PaletteHelp;
        end;
  else TypeHelp;
 end;
end;

Function MyNameHandler(var S : String) : Byte;
var I : Longint;
begin
 I := 0; While (S[I + 1] > ' ') do Inc(I);
 MyNameHandler := I;
 PalFile := Copy(S, 1, I);
end;

Procedure KillOSshell;
begin
 textAttr := $0C;
 Writeln(' In order changes to take effect you must reload your RunWorkPlace.');
 Writeln(' If you are running WorkPlaceShell you must reboot, otherwise you can');
 Writeln(' simply kill your shell (Ctrl/Esc, then cursor on FILEBAR, then DEL)');
end;

Procedure OpenProfile(Mode : Byte);
begin
 if (Mode = 1) and (not FileExist(PalFile))
  then Error(1);
 PalFile := PalFile + #0;
 UserINI := prfOpenProfile(appHAB, @PalFile[1]);
 if UserINI = 0 then Error(1);
end;

Procedure CopyApp(srcIni, dstIni : hIni; srcApp, dstApp : pChar);
var dataSize,
    bufSize    : uLong;
    dataBuff,
    keyNames   : pArrOfByte;
    I,KeyCnt   : Longint;
    Key        : pChar;
begin
 if not prfQueryProfileSize(srcIni, srcApp, nil, bufSize)
  then Error(2);
 GetMem(keyNames, bufSize);
 prfQueryProfileData(srcIni, srcApp, nil, keyNames^, bufSize);
 KeyCnt := 0;
 For I := 1 to CountASCIIZ(keyNames^, bufSize) do
  begin
   Key := GetASCIIZptr(keyNames^, I);
   if PrfQueryProfileSize(srcIni, srcApp, Key, dataSize)
    then begin
          GetMem(dataBuff, dataSize);
          prfQueryProfileData(srcIni, srcApp, Key, dataBuff^, dataSize);
          prfWriteProfileData(dstIni, dstApp, Key, dataBuff^, dataSize);
          FreeMem(dataBuff, dataSize);
          Inc(KeyCnt);
         end;
  end;
 FreeMem(keyNames, bufSize);
 if KeyCnt = 0
  then Writeln(' Cannot find selected keyword in INI file')
  else Writeln(' ', KeyCnt, ' total key values copied');
end;

Procedure CheckAltFile(var srcINI : hINI);
begin
 if AltFile <> ''
  then begin
        if Pos('os2.ini', LowStrg(AltFile)) <> 0
         then srcINI := hIni_UserProfile
         else
        if Pos('os2sys.ini', LowStrg(AltFile)) <> 0
         then srcINI := hIni_SystemProfile
         else
        srcINI := prfOpenProfile(appHAB, @AltFile[1]);
        if srcINI = 0 then Error(1);
       end;
end;

Procedure CloseAltFile(var srcINI : hINI);
begin
 if (srcIni <> hIni_SystemProfile) and
    (srcIni <> hIni_UserProfile)
  then prfCloseProfile(srcIni);
end;

Procedure DoLoad;
var dstINI : hINI;
begin
 if custPal <> ''
  then begin
        custPal := custPal + #0;
        dstApp := @custPal[1];
        dstINI := hIni_SystemProfile;
       end
  else dstINI := hIni_UserProfile;
 if PalFile = '' then TypeHelp;
 CheckAltFile(dstINI);
 Writeln(' Loading ', dstApp, ' from ', PalFile);
 OpenProfile(1);
 CopyApp(UserINI, dstINI, dstApp, dstApp);
 KillOSshell;
 CloseAltFile(dstIni);
end;

Procedure DoSave;
var srcINI : hINI;
begin
 if custPal <> ''
  then begin
        custPal := custPal + #0;
        dstApp := @custPal[1];
        srcINI := hIni_SystemProfile;
       end
  else srcINI := hIni_UserProfile;
 if PalFile = '' then TypeHelp;
 CheckAltFile(srcINI);
 Writeln(' Saving ', dstApp, ' to ', PalFile);
 OpenProfile(0);
 CopyApp(srcINI, UserINI, dstApp, dstApp);
 CloseAltFile(srcIni);
end;

Procedure DoReset;
begin
 if custPal <> ''
  then begin
        custPal := custPal + #0;
        dstApp := @custPal[1];
       end;
 Write(' Removing ', dstApp, ' from ');
 if PalFile = ''
  then begin
        Writeln('user INI file');
        UserINI := hIni_UserProfile;
       end
  else begin
        Writeln(PalFile);
        OpenProfile(1);
       end;
 prfWriteProfileData(UserINI, dstApp, nil, dstApp, 0);
 KillOSshell;
end;

Procedure DoCurrent(SrcINI : hIni);
begin
 Writeln(' Setting ', dstApp, ' to ', srcApp);
 CopyApp(SrcINI, hIni_UserProfile, srcApp, dstApp);
 KillOSshell;
end;

Procedure DoCustom;
begin
 CustPal := CustPal + #0;
 srcApp := @CustPal[1];
 DoCurrent(hIni_SystemProfile);
end;

Procedure DoView;
var Buffer  : pChar;
    I,
    bufSize : uLong;
    S       : String;
begin
 Write(' Viewing sections in ');
 if Pos('os2.ini', LowStrg(PalFile)) <> 0
  then begin
        Writeln('user INI file');
        UserINI := hIni_UserProfile;
       end
  else
 if PalFile = ''
  then begin
        Writeln('system INI file');
        UserINI := hIni_SystemProfile;
       end
  else begin
        Writeln(PalFile);
        OpenProfile(1);
       end;
 if not prfQueryProfileSize(UserINI, nil, nil, bufSize)
  then Error(3);
 GetMem(Buffer, bufSize);
 prfQueryProfileData(UserINI, nil, nil, Buffer^, bufSize);
 For I := 1 to CountASCIIZ(Buffer^, bufSize) do
  begin
   S := GetASCIIZ(Buffer^, I);
   if Copy(S, 1, length(CustPal)) = CustPal
    then Writeln(' ', S);
  end;
 FreeMem(Buffer, bufSize);
end;

Procedure MyExitProc;
begin
 if UserINI <> 0
  then prfCloseProfile(UserINI);
 WinTerminate(appHAB);
 Halt(ExitCode);
end;

begin
 appHAB := WinInitialize(0);
 ExitProc := @myExitProc;
 TextAttr := $0F;
 Writeln('[PM colors manager][Version '+Version+']Ŀ');
 Writeln(' Copyright (c) 1995 by FRIENDS software  All Rights Reserved ');
 TextAttr := $07;
 ParseCommandLine(#1, MyParmHandler, MyNameHandler);
 case Action of
  actNothing : TypeHelp;
  actLoad    : DoLoad;
  actSave    : DoSave;
  actReset   : DoReset;
  actCurrent : DoCurrent(hIni_UserProfile);
  actCustom  : DoCustom;
  actView    : DoView;
 end;
 TextAttr := $08;
 Writeln('Done.');
end.

