
/*
    LinuxWare passwords support functions

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef __LWPWD_H__

#define __LWPWD_H__

#include <stdtypes.h>
#include <stdio.h>
#include "ncpcomm.h"

#define LWPASSWORD_LEN (0x10)

typedef
struct
{
	byte passwd[LWPASSWORD_LEN];
} lwpassword;

typedef
struct
{
	int expired;
	struct ncp_object_name name;
	lwpassword passwd;
} lwpwent;

int getlwpwent(FILE* file,lwpwent* pe);
int getlwpwnam(FILE* file,lwpwent* pe,char* name);
int putlwpwent(FILE* file,lwpwent* pe);

#endif /* __LWPWD_H__ */
