
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#include <stdarg.h>
#include <sys/time.h>
#include "logging.h"

void log_set_level(int new_log_lvl)
{
	LOG_ENTRY
	LOG_START(log_level)
	log_printf("New log level: %i\n",new_log_lvl);
	LOG_END
	log_level=new_log_lvl;
}

FILE* log_set_file(FILE* new_log_file)
{
	FILE* old;
	if (log_file!=stderr && log_file!=stdout)
	{
		LOG_ENTRY
		LOG_START(log_level)
		log_printf("new log file\n");
		LOG_END
	}
	old=log_file;
	log_file=new_log_file;
	return old;
}

void log_print_time()
{
	time_t t;
	time(&t);
	log_printf("\n%s",ctime(&t));
}

void log_printf(char* fmt,...)
{
	if (log_file!=NULL)
	{
		va_list vl;
		va_start(vl,fmt);
		vfprintf(log_file,fmt,vl);
		va_end(vl);
	}
}

int log_new_entry=1;
int log_level=0;
FILE* log_file=stderr;
