
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __FSYSTEM_H__

#define __FSYSTEM_H__

#include "config.h"
#include "connect.h"

#define ROOT_VOLUME_ID	MAX_VOLUME
#define ROOT_DIR_ID	0

typedef char vol_name[MAX_VOL_NAME];

typedef struct
{
	int mounted;
	vol_name name;
	char path[MAX_PATH];
} vol_info;

#define DH_PERMANENT	1
#define DH_TEMPORARY	0

typedef struct
{
	int alloc;
	int permanent;
	vol_info* volume;
	char path[MAX_PATH];
} dir_handle;

typedef struct
{
	int alloc;
/*	dir_handle* dir;*/
	char path[MAX_PATH];
} search_handle;

typedef struct
{
	int alloc;
	int fd;
	char path[MAX_PATH];
} file_handle;

vol_info* find_volume(char* name);
vol_info* get_volume(int id);
int get_volume_id(vol_info* vi);

int alloc_dir(connection* c,vol_info* vi,char* path,int mode);
dir_handle* get_dir_handle(connection* c,int ldh);
void free_dir(connection* c,int ldh);

int alloc_search(connection* c,dir_handle* dh,char* path);
search_handle* get_search_handle(connection* c,int lsh);
void free_search(connection*c,int lsh);

int alloc_file(connection* c,int fd,char* path);
file_handle* get_file_handle(connection* c,int lfh);
void free_file(connection* c,int lfh);

char* unix2nw_path(char* dest,vol_info* vi,char* path);
char* nw2unix_path(char* dest,dir_handle* dh,char* path);

void init_fsystem();
void done_fsystem();

void fprint_fs_stat(FILE* file);

#endif /* __FSYSTEM_H__ */

