
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __DIROPS_H__

#define __DIROPS_H__

#include "stdtypes.h"
#include "fsystem.h"

struct ncp_alloc_dir_rq
{
	byte	src_handle		__attribute__ ((packed));
	byte	handle_name		__attribute__ ((packed));
	byte	name_len		__attribute__ ((packed));
	char	name[1]			__attribute__ ((packed));
};

struct ncp_alloc_dir_rpl
{
	byte	handle			__attribute__ ((packed));
	byte	access_rights		__attribute__ ((packed));
};

struct ncp_alloc_short_dir_rq
{
	byte	name_space		__attribute__ ((packed));
	byte	zero			__attribute__ ((packed));
	word	mode			__attribute__ ((packed));
	byte	vol_id			__attribute__ ((packed));
	dword	dir_base		__attribute__ ((packed));
	byte	handle_flag		__attribute__ ((packed));
	byte	path_comp		__attribute__ ((packed));
	struct ncp_string	path	__attribute__ ((packed));
};

struct ncp_alloc_short_dir_rpl
{
	byte	handle			__attribute__ ((packed));
	byte	vol_id			__attribute__ ((packed));
}; 

struct ncp_set_dir_handle
{
	byte	dest_handle		__attribute__ ((packed));
	byte	src_handle		__attribute__ ((packed));
	byte	name_len		__attribute__ ((packed));
	char	name[1]			__attribute__ ((packed));
};

struct ncp_get_volinfo
{
	word		sec_per_cluster	__attribute__ ((packed));
	word		total_clusters	__attribute__ ((packed));
	word		avail_clusters	__attribute__ ((packed));
	word		dir_slots	__attribute__ ((packed));
	word		avail_dir_slots	__attribute__ ((packed));
	vol_name	name		__attribute__ ((packed));
	word		removable	__attribute__ ((packed));
};

struct ncp_get_eff_rights
{
	byte	dir_handle	__attribute__ ((packed));
	byte	path_len	__attribute__ ((packed));
	char	path[1]		__attribute__ ((packed));
};

struct ncp_scandir_dir_rq
{
	byte			dir_handle	__attribute__ ((packed));
	word			context		__attribute__ ((packed));
	struct ncp_string	path		__attribute__ ((packed));
};

struct ncp_scandir_dir_rpl
{
	char		path[16]	__attribute__ ((packed));
	ncp_date	d_creat		__attribute__ ((packed));
	ncp_time	t_creat		__attribute__ ((packed));
	dword		uid		__attribute__ ((packed));
	byte		access		__attribute__ ((packed));
	byte		zero		__attribute__ ((packed));
	word		context		__attribute__ ((packed));
};

struct ncp_create_dir
{
	byte			dir_handle	__attribute__ ((packed));
	byte			acc_mask	__attribute__ ((packed));
	struct ncp_string	path		__attribute__ ((packed));
};

struct ncp_delete_dir
{
	byte			dir_handle	__attribute__ ((packed));
	byte			fill		__attribute__ ((packed));
	struct ncp_string	path		__attribute__ ((packed));
};

#endif /* __DIROPS_H__ */
