
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __BINDOPS_H__

#define __BINDOPS_H__

#include "ncpcomm.h"
#include "bindery.h"
#include "connect.h"

struct ncp_fs_info
{
	struct ncp_object_name name	__attribute__ ((packed));
	byte vers_hi		__attribute__ ((packed));
	byte vers_lo		__attribute__ ((packed));
	word max_con		__attribute__ ((packed));
	word con_used		__attribute__ ((packed));
	word volumes		__attribute__ ((packed));
	byte revis_lvl		__attribute__ ((packed));
	byte SFT_lvl		__attribute__ ((packed));
	byte TTS_lvl		__attribute__ ((packed));
	word max_con_used	__attribute__ ((packed));
	byte acc_ver		__attribute__ ((packed));
	byte vap_ver		__attribute__ ((packed));
	byte que_ver		__attribute__ ((packed));
	byte ps_ver		__attribute__ ((packed));
	byte vc_ver		__attribute__ ((packed));
	byte sec_ver		__attribute__ ((packed));
	byte br_ver		__attribute__ ((packed));
	char reserved[60]	__attribute__ ((packed));
};

struct ncp_get_bind_id_rq
{
	word type		__attribute__ ((packed));		
	byte name_len		__attribute__ ((packed));
	char name[1]		__attribute__ ((packed));
};

struct ncp_get_con_list32
{
	dword last_cid		__attribute__ ((packed));
	word type		__attribute__ ((packed));
	struct ncp_string name	__attribute__ ((packed));
};

struct ncp_key_login_rq
{
	struct ncp_log_key key  __attribute__ ((packed));
	word type		__attribute__ ((packed));		
	byte name_len		__attribute__ ((packed));
	char name[1]		__attribute__ ((packed));
};

struct ncp_bind_acc_lvl_rpl
{
	byte security		__attribute__ ((packed));
	dword id		__attribute__ ((packed));
};

struct ncp_object_name_rpl
{
	dword id			__attribute__ ((packed));
	word type			__attribute__ ((packed));
	struct ncp_object_name name	__attribute__ ((packed));
};

struct ncp_scan_bind_rq
{
	dword last_id		__attribute__ ((packed));
	word type		__attribute__ ((packed));		
	byte name_len		__attribute__ ((packed));
	char name[1]		__attribute__ ((packed));
};

struct ncp_scan_bind_rpl
{
	dword id			__attribute__ ((packed));
	word type			__attribute__ ((packed));
	struct ncp_object_name name	__attribute__ ((packed));
	byte flag			__attribute__ ((packed));
	byte security			__attribute__ ((packed));
	byte has_prop			__attribute__ ((packed));
};

struct ncp_log_info
{
	dword id			__attribute__ ((packed));
	word type			__attribute__ ((packed));
	struct ncp_object_name name	__attribute__ ((packed));
	struct ncp_date_info log_time	__attribute__ ((packed));
	byte reserved			__attribute__ ((packed));
};

struct ncp_read_prop_rq
{
	word			type	__attribute__ ((packed));
	struct ncp_string	obj	__attribute__ ((packed));
	/*and segment number and ncp_string once more*/
};

struct ncp_read_prop_rpl
{
	char	data[0x80]		__attribute__ ((packed));
	byte	more			__attribute__ ((packed));
	byte	flag			__attribute__ ((packed));
};

int bind_type_cmp(word t1,word t2);
int get_name_find(bind_list* bl,void* data);
void get_server_name();
void set_desc_strings();

#endif /* __BINDOPS_H__*/
