
/*

    IPX support library

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef __IPXRIP_H__

#define __IPXRIP_H__

#include <stdio.h>
#include "ipxutil.h"

#define IPX_RIP_PORT		(0x453U)
#define IPX_RIP_PTYPE		(1U)
#define IPX_RIP_OP_REQUEST	(1U)
#define IPX_RIP_GENERAL_RQ	(0xFFFFFFFFU)
#define IPX_RIP_OP_RESPONSE	(2U)
#define IPX_RIP_MAX_ENTRIES	(50U)
#define IPX_RIP_NET_DOWN	(16U)

typedef unsigned short int hop_t;
typedef unsigned short int tick_t;

typedef struct
{
	IPXNet network __attribute__ ((packed));
	hop_t hops __attribute__ ((packed));
	tick_t ticks __attribute__ ((packed));
} RipEntry;

typedef struct
{
	unsigned short int operation __attribute__ ((packed));
	RipEntry rip_entries[1] __attribute__ ((packed));
} RipPacket;

RipPacket* ipx_rip_alloc(int n);
int ipx_rip_size(int n);
void ipx_rip_dump(RipPacket* pkt,int len);
void ipx_rip_fdump(FILE* file,RipPacket* pkt,int len);

typedef struct tagRipOutput
{
	struct sockaddr_ipx dest_addr;
	int entries;
	RipPacket* buffer;
} RipOutput;

int ipx_rip_output_rip_output(RipOutput* out,IPXNet iface);
void ipx_rip_output_flush(RipOutput* out);
void ipx_rip_output_request(RipOutput* out,IPXNet net);
void ipx_rip_output_response(RipOutput* out,IPXNet net,hop_t hops,tick_t ticks,int down_allow);
void ipx_rip_output_set_destination(RipOutput* out,IPXNode node,IPXPort port);

extern void (*ipx_rip_output_func)(void* buffer,int size,struct sockaddr_ipx* daddr);

#endif
